/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXMutableURL {
    private String _protocol;
    private String _host;
    private String _path;
    private String _ref;
    private Integer _port;
    private Map<String, List<String>> _queryParameters = new LinkedHashMap<String, List<String>>();

    public ERXMutableURL() {
    }

    public ERXMutableURL(URL url) throws MalformedURLException {
        this();
        this.setURL(url);
    }

    public ERXMutableURL(String str) throws MalformedURLException {
        this();
        this.setURL(str);
    }

    public synchronized void setURL(URL url) throws MalformedURLException {
        this._protocol = url.getProtocol();
        this._host = url.getHost();
        int port = url.getPort();
        this._port = port == -1 || port == url.getDefaultPort() ? null : Integer.valueOf(port);
        this._path = url.getPath();
        this._ref = url.getRef();
        this.setQueryParameters(url.getQuery());
    }

    public synchronized void setURL(String str) throws MalformedURLException {
        boolean relativeURL = false;
        boolean startsWithSlash = false;
        if (str != null && (str = str.replaceAll("&amp;", "&")).indexOf("://") == -1) {
            String fakeHost;
            relativeURL = true;
            if (str.startsWith("/")) {
                startsWithSlash = true;
                fakeHost = "http://fakehost";
            } else {
                fakeHost = "http://fakehost/";
            }
            str = fakeHost + str;
        }
        this.setURL(new URL(str));
        if (relativeURL) {
            this.setHost(null);
            this.setProtocol(null);
            if (!startsWithSlash && this._path != null && this._path.length() > 0) {
                this.setPath(this._path.substring(1));
            }
        }
    }

    public boolean isFullyQualified() {
        return this._host != null;
    }

    public boolean isAbsolute() {
        return this._path != null && this._path.startsWith("/");
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public String protocol() {
        return this._protocol;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String host() {
        return this._host;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String path() {
        return this._path;
    }

    public ERXMutableURL appendPath(String path) {
        this._path = this._path == null ? path : (this._path.endsWith("/") ? this._path + path : this._path + "/" + path);
        return this;
    }

    public void setPort(Integer port) {
        this._port = port;
    }

    public Integer port() {
        return this._port;
    }

    public void setRef(String ref) {
        this._ref = ref;
    }

    public String ref() {
        return this._ref;
    }

    public synchronized void setQueryParameters(String queryParameters) throws MalformedURLException {
        this.clearQueryParameters();
        this.addQueryParameters(queryParameters);
    }

    public synchronized void addQueryParameters(String queryParameters) throws MalformedURLException {
        if (queryParameters != null) {
            StringTokenizer queryStringTokenizer = new StringTokenizer(queryParameters, "&");
            while (queryStringTokenizer.hasMoreTokens()) {
                String queryStringToken = queryStringTokenizer.nextToken();
                int equalsIndex = queryStringToken.indexOf(61);
                try {
                    String value;
                    String key;
                    if (equalsIndex == -1) {
                        key = queryStringToken.trim();
                        value = null;
                    } else {
                        key = queryStringToken.substring(0, equalsIndex).trim();
                        value = queryStringToken.substring(equalsIndex + 1);
                    }
                    if (key == null || key.length() == 0) {
                        throw new MalformedURLException("The query string parameter '" + queryStringToken + " has an empty key in '" + queryParameters + "'.");
                    }
                    key = URLDecoder.decode(key, "UTF-8");
                    if (value != null) {
                        value = URLDecoder.decode(value, "UTF-8");
                    }
                    this.addQueryParameter(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Every VM is supposed to support UTF-8 encoding.", e);
                }
            }
        }
    }

    public synchronized void setQueryParametersMap(Map<String, List<String>> queryParameters) {
        this._queryParameters = queryParameters;
    }

    public synchronized void clearQueryParameters() {
        this._queryParameters.clear();
    }

    public synchronized void setQueryParameters(NSDictionary<String, ? extends Object> queryParameters) {
        this.clearQueryParameters();
        this.addQueryParameters(queryParameters);
    }

    public synchronized void addQueryParameters(NSDictionary<String, ? extends Object> queryParameters) {
        if (queryParameters != null) {
            Enumeration<String> keyEnum = queryParameters.keyEnumerator();
            while (keyEnum.hasMoreElements()) {
                String key = keyEnum.nextElement();
                Object valueObj = queryParameters.objectForKey(key);
                if (valueObj instanceof NSArray) {
                    NSArray valueArray = (NSArray)valueObj;
                    Enumeration valueArrayEnum = valueArray.objectEnumerator();
                    while (valueArrayEnum.hasMoreElements()) {
                        String value = (String)valueArrayEnum.nextElement();
                        this.addQueryParameter(key, value);
                    }
                    continue;
                }
                this.addQueryParameter(key, valueObj.toString());
            }
        }
    }

    public synchronized void addQueryParametersMap(Map<String, String> queryParameters) {
        if (queryParameters != null) {
            for (Map.Entry<String, String> queryParameter : queryParameters.entrySet()) {
                this.addQueryParameter(queryParameter.getKey(), queryParameter.getValue());
            }
        }
    }

    public synchronized void addQueryParameter(String key, String value) {
        List<String> values = this._queryParameters.get(key);
        if (values == null) {
            values = new LinkedList<String>();
            this._queryParameters.put(key, values);
        }
        if (value != null) {
            values.add(value);
        }
    }

    public synchronized boolean containsQueryParameter(String key) {
        return this._queryParameters.containsKey(key);
    }

    public synchronized void removeQueryParameter(String key) {
        this._queryParameters.remove(key);
    }

    public synchronized void removeQueryParameter(String key, String value) {
        List<String> queryParameters = this.queryParameters(key);
        if (queryParameters != null) {
            queryParameters.remove(value);
        }
    }

    public synchronized Map<String, List<String>> queryParameters() {
        return this._queryParameters;
    }

    public synchronized Map<String, String> uniqueQueryParameters() {
        LinkedHashMap<String, String> uniqueQueryParameters = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> queryParameter : this._queryParameters.entrySet()) {
            String key = queryParameter.getKey();
            for (String value : queryParameter.getValue()) {
                uniqueQueryParameters.put(key, value);
            }
        }
        return uniqueQueryParameters;
    }

    public synchronized List<String> queryParameters(String key) {
        return this._queryParameters.get(key);
    }

    public synchronized String queryParameter(String key) {
        String queryParameter = null;
        List<String> queryParameters = this.queryParameters(key);
        if (queryParameters != null && queryParameters.size() > 0) {
            queryParameter = queryParameters.get(0);
        }
        return queryParameter;
    }

    public synchronized void setQueryParameter(String key, String value) {
        LinkedList<String> queryParameters = new LinkedList<String>();
        if (value != null) {
            queryParameters.add(value);
        }
        this._queryParameters.put(key, queryParameters);
    }

    public synchronized String toExternalForm() {
        StringBuffer sb = new StringBuffer();
        if (this._protocol != null) {
            sb.append(this._protocol);
            sb.append("://");
        }
        if (this._host != null) {
            sb.append(this._host);
        }
        if (this._port != null) {
            boolean includePort = true;
            if ("http".equalsIgnoreCase(this._protocol) && Integer.valueOf(80).equals(this._port)) {
                includePort = false;
            } else if ("https".equalsIgnoreCase(this._protocol) && Integer.valueOf(443).equals(this._port)) {
                includePort = false;
            }
            if (includePort) {
                sb.append(':');
                sb.append(this._port);
            }
        }
        if (this._path != null) {
            if (!this._path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(this._path);
        }
        if (this._queryParameters != null && !this._queryParameters.isEmpty()) {
            if (this._host != null || this._path != null) {
                sb.append('?');
            }
            this.queryParametersAsString(sb);
        }
        if (this._ref != null) {
            sb.append('#');
            sb.append(this._ref);
        }
        return sb.toString();
    }

    public String queryParametersAsString() {
        StringBuffer sb = new StringBuffer();
        this.queryParametersAsString(sb);
        return sb.toString();
    }

    protected void queryParametersAsString(StringBuffer sb) {
        try {
            Iterator<Map.Entry<String, List<String>>> queryParameterIter = this._queryParameters.entrySet().iterator();
            while (queryParameterIter.hasNext()) {
                Map.Entry<String, List<String>> queryParameter = queryParameterIter.next();
                String key = queryParameter.getKey();
                Iterator<String> valuesIter = queryParameter.getValue().iterator();
                if (!valuesIter.hasNext()) {
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                }
                while (valuesIter.hasNext()) {
                    String value = valuesIter.next();
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    if (value != null) {
                        if (key.length() > 0) {
                            sb.append('=');
                        }
                        sb.append(URLEncoder.encode(value, "UTF-8"));
                    }
                    if (!valuesIter.hasNext()) continue;
                    sb.append('&');
                }
                if (!queryParameterIter.hasNext()) continue;
                sb.append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Every VM is supposed to support UTF-8 encoding.", e);
        }
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toExternalForm());
    }

    public String toString() {
        return this.toExternalForm();
    }

    public static void main(String[] args) throws MalformedURLException {
        System.out.println("ERXMutableURL.main: " + new ERXMutableURL("http://java.sun.com:80/docs/books/tutorial/index.html?name=networking#DOWNLOADING"));
        System.out.println("ERXMutableURL.main: " + new ERXMutableURL("https://java.sun.com:443/docs/books/tutorial/index.html?name=networking#DOWNLOADING"));
        System.out.println("ERXMutableURL.main: " + new ERXMutableURL("http://java.sun.com:12/index.html?name=networking#DOWNLOADING"));
        System.out.println("ERXMutableURL.main: " + new ERXMutableURL("http://java.sun.com:80/docs/books/tutorial/index.html?name=networking&amp;name2=networking2#DOWNLOADING"));
        ERXMutableURL mu = new ERXMutableURL("http://java.sun.com:80/docs/books/tutorial/index.html?name=networking&name2=networking2#DOWNLOADING");
        mu.setRef(null);
        mu.removeQueryParameter("name2");
        mu.removeQueryParameter("name");
        System.out.println("ERXMutableURL.main: " + mu);
        System.out.println("ERXMutableURL.main: " + new ERXMutableURL("/docs/books/tutorial/index.html?name=networking&amp;name2=networking2#DOWNLOADING"));
    }
}

