/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOContext;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRuntimeUtilities {
    public static final Logger log = Logger.getLogger(ERXRuntimeUtilities.class);
    private static NSMutableDictionary<Thread, String> flags;

    public static NSBundle createBundleIfNeeded(String name) {
        String dirName;
        File newTempDir;
        File sysTempDir = new File(System.getProperty("java.io.tmpdir", "/tmp"));
        int maxAttempts = 5;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 5) continue;
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 5 attempts."));
        } while ((newTempDir = new File(sysTempDir, dirName = name + UUID.randomUUID().toString())).exists());
        if (newTempDir.mkdirs()) {
            File fwkResourcesDir = new File(new File(newTempDir, name + ".framework"), "Resources");
            File fwkJavaDir = new File(fwkResourcesDir, "Java");
            fwkJavaDir.mkdirs();
            try {
                ERXFileUtilities.stringToFile("{Has_WOComponents=NO;}", new File(fwkResourcesDir, "Info.plist"));
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            return ERXRuntimeUtilities.loadBundleIfNeeded(fwkJavaDir);
        }
        throw NSForwardException._runtimeExceptionForThrowable((Throwable)new IOException("Failed to create temp dir named " + newTempDir.getAbsolutePath()));
    }

    public static NSBundle loadBundleIfNeeded(File bundleFile) {
        try {
            String canonicalPath = bundleFile.getCanonicalPath();
            boolean isJar = bundleFile.isFile() && canonicalPath.endsWith(".jar");
            return NSBundle._bundleWithPathShouldCreateIsJar((String)canonicalPath, (boolean)true, (boolean)isJar);
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static NSMutableDictionary<String, Object> informationForException(Exception e) {
        NSDictionary dict;
        NSMutableDictionary<String, Object> extraInfo = new NSMutableDictionary<String, Object>();
        if (e instanceof EOGeneralAdaptorException && (dict = ((EOGeneralAdaptorException)((Object)e)).userInfo()) != null) {
            Object value = dict.objectForKey("EOFailedDatabaseOperationKey");
            if (value != null) {
                extraInfo.setObjectForKey(value.toString(), "EOFailedDatabaseOperationKey");
            }
            if ((value = dict.objectForKey("EOAdaptorFailureKey")) != null) {
                extraInfo.setObjectForKey(value.toString(), "EOAdaptorFailureKey");
            }
            if ((value = dict.objectForKey("EOFailedAdaptorOperationKey")) != null) {
                extraInfo.setObjectForKey(value.toString(), "EOFailedAdaptorOperationKey");
            }
            if (e instanceof JDBCAdaptorException && (value = ((JDBCAdaptorException)((Object)e)).sqlException()) != null) {
                extraInfo.setObjectForKey(value.toString(), "SQLException");
            }
        }
        return extraInfo;
    }

    public static NSMutableDictionary<String, Object> informationForBundles() {
        NSMutableDictionary<String, Object> extraInfo = new NSMutableDictionary<String, Object>();
        NSMutableDictionary<String, String> bundleVersions = new NSMutableDictionary<String, String>();
        Enumeration bundles = NSBundle._allBundlesReally().objectEnumerator();
        while (bundles.hasMoreElements()) {
            NSBundle bundle = (NSBundle)bundles.nextElement();
            String version = ERXProperties.versionStringForFrameworkNamed(bundle.name());
            if (version == null) {
                version = "No version provided";
            }
            bundleVersions.setObjectForKey(version, bundle.name());
        }
        extraInfo.setObjectForKey(bundleVersions, "Bundles");
        return extraInfo;
    }

    public static NSMutableDictionary<String, Object> informationForContext(WOContext context) {
        NSMutableDictionary<String, Object> extraInfo = new NSMutableDictionary<String, Object>();
        if (context != null) {
            if (context.page() != null) {
                NSSelector d2wSelector;
                extraInfo.setObjectForKey(context.page().name(), "CurrentPage");
                if (context.component() != null) {
                    extraInfo.setObjectForKey(context.component().name(), "CurrentComponent");
                    if (context.component().parent() != null) {
                        extraInfo.setObjectForKey(ERXWOContext.componentPath(context), "CurrentComponentHierarchy");
                    }
                }
                if ((d2wSelector = new NSSelector("d2wContext")).implementedByObject((Object)context.page())) {
                    try {
                        Class<?> erDirectToWebClazz = Class.forName("er.directtoweb.ERDirectToWeb");
                        NSSelector infoSelector = new NSSelector("informationForContext", new Class[]{WOContext.class});
                        NSDictionary d2wExtraInfo = (NSDictionary)infoSelector.invoke(erDirectToWebClazz, (Object)context);
                        extraInfo.addEntriesFromDictionary(d2wExtraInfo);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (context.request() != null) {
                extraInfo.setObjectForKey(context.request().uri(), "URL");
                if (context.request().headers() != null) {
                    NSMutableDictionary<String, String> headers = new NSMutableDictionary<String, String>();
                    for (Object key : context.request().headerKeys()) {
                        String value = context.request().headerForKey(key);
                        if (value == null) continue;
                        headers.setObjectForKey(value, key.toString());
                    }
                    extraInfo.setObjectForKey(headers, "Headers");
                }
            }
            if (context.hasSession()) {
                if (context.session().statistics() != null) {
                    extraInfo.setObjectForKey(context.session().statistics(), "PreviousPageList");
                }
                extraInfo.setObjectForKey(context.session(), "Session");
            }
        }
        return extraInfo;
    }

    public static Throwable originalThrowable(Throwable t) {
        Throwable ex;
        Object throwable = null;
        if (t instanceof InvocationTargetException) {
            return ERXRuntimeUtilities.originalThrowable(((InvocationTargetException)t).getTargetException());
        }
        if (t instanceof NSForwardException) {
            return ERXRuntimeUtilities.originalThrowable(((NSForwardException)t).originalException());
        }
        if (t instanceof JDBCAdaptorException && (ex = (JDBCAdaptorException)t).sqlException() != null) {
            return ERXRuntimeUtilities.originalThrowable(ex.sqlException());
        }
        if (t instanceof SQLException && ((SQLException)(ex = (SQLException)t)).getNextException() != null) {
            return ERXRuntimeUtilities.originalThrowable(((SQLException)ex).getNextException());
        }
        if (t instanceof Exception && (ex = (Exception)t).getCause() != null) {
            return ERXRuntimeUtilities.originalThrowable(ex.getCause());
        }
        return t;
    }

    public static final Result executeCommandLineCommandWithArgumentsWithEnvVarsInWorkingDir(String[] command, String[] envp, File dir) throws IOException {
        try {
            return ERXRuntimeUtilities.execute(command, envp, dir, 0L);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public static final Result[] executeCommandLineCommandsWithEnvVarsInWorkingDir(String[][] commands, String[] envp, File dir) throws IOException {
        Result[] results = new Result[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            try {
                results[i] = ERXRuntimeUtilities.execute(commands[i], envp, dir, 0L);
                continue;
            }
            catch (TimeoutException e) {
                return null;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final Result execute(String[] command, String[] envp, File dir, long timeout) throws IOException, TimeoutException {
        void var11_17;
        StreamReader esr;
        Process p;
        File outputFile;
        block26: {
            outputFile = null;
            int exitValue = -1;
            Runtime rt = Runtime.getRuntime();
            p = null;
            StreamReader isr = null;
            esr = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will execute command " + new NSArray<String>(command).componentsJoinedByString(" ")));
                }
                if (dir == null && envp == null) {
                    p = rt.exec(command);
                } else if (dir == null) {
                    p = rt.exec(command, envp);
                } else {
                    if (envp == null) {
                        throw new IllegalArgumentException("if dir != null then envp must also be != null");
                    }
                    p = rt.exec(command, envp, dir);
                }
                isr = new StreamReader(p.getInputStream());
                esr = new StreamReader(p.getErrorStream());
                if (timeout > 0L) {
                    TimeoutTimerTask task = new TimeoutTimerTask(p);
                    Timer timer = new Timer();
                    timer.schedule((TimerTask)task, timeout);
                    boolean wasStopped = false;
                    try {
                        p.waitFor();
                        exitValue = p.exitValue();
                    }
                    catch (InterruptedException ex) {
                        wasStopped = true;
                    }
                    timer.cancel();
                    if (task.didTimeout() || wasStopped) {
                        throw new TimeoutException("process didn't exit after " + timeout + " milliseconds");
                    }
                } else {
                    try {
                        p.waitFor();
                        exitValue = p.exitValue();
                    }
                    catch (InterruptedException ex) {
                    }
                }
                Object var17_15 = null;
                Result result = isr != null ? (esr != null ? new Result(exitValue, isr.getResult(), esr.getResult()) : new Result(exitValue, isr.getResult(), null)) : (esr != null ? new Result(exitValue, null, esr.getResult()) : new Result(exitValue, null, null));
                if (isr == null || isr.getException() == null) break block26;
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                if (isr != null) {
                    if (esr != null) {
                        Result result = new Result(exitValue, isr.getResult(), esr.getResult());
                    } else {
                        Result result = new Result(exitValue, isr.getResult(), null);
                    }
                } else if (esr != null) {
                    Result result = new Result(exitValue, null, esr.getResult());
                } else {
                    Result result = new Result(exitValue, null, null);
                }
                if (isr != null && isr.getException() != null) {
                    log.error((Object)("input stream reader got exception,\n      command = " + ERXStringUtilities.toString(command, " ") + "result = " + isr.getResultAsString()), (Throwable)isr.getException());
                }
                if (esr != null && esr.getException() != null) {
                    log.error((Object)("error stream reader got exception,\n      command = " + ERXStringUtilities.toString(command, " ") + "result = " + esr.getResultAsString()), (Throwable)esr.getException());
                }
                ERXRuntimeUtilities.freeProcessResources(p);
                if (outputFile != null) {
                    outputFile.delete();
                }
                throw throwable;
            }
            log.error((Object)("input stream reader got exception,\n      command = " + ERXStringUtilities.toString(command, " ") + "result = " + isr.getResultAsString()), (Throwable)isr.getException());
        }
        if (esr != null && esr.getException() != null) {
            log.error((Object)("error stream reader got exception,\n      command = " + ERXStringUtilities.toString(command, " ") + "result = " + esr.getResultAsString()), (Throwable)esr.getException());
        }
        ERXRuntimeUtilities.freeProcessResources(p);
        if (outputFile != null) {
            outputFile.delete();
        }
        return var11_17;
    }

    public static void freeProcessResources(Process p) {
        if (p != null) {
            try {
                if (p.getInputStream() != null) {
                    p.getInputStream().close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (p.getOutputStream() != null) {
                try {
                    p.getOutputStream().close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (p.getErrorStream() != null) {
                try {
                    p.getErrorStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            p.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkThreadInterrupt() {
        if (flags == null) {
            return;
        }
        NSMutableDictionary<Thread, String> nSMutableDictionary = flags;
        synchronized (nSMutableDictionary) {
            Thread currentThread = Thread.currentThread();
            if (flags.containsKey(currentThread)) {
                String message = ERXRuntimeUtilities.clearThreadInterrupt(currentThread);
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)new InterruptedException(message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addThreadInterrupt(Thread thread, String message) {
        if (flags == null) {
            flags = new NSMutableDictionary();
        }
        NSMutableDictionary<Thread, String> nSMutableDictionary = flags;
        synchronized (nSMutableDictionary) {
            if (!flags.containsKey(thread)) {
                log.debug((Object)("Adding thread interrupt request: " + message), (Throwable)new RuntimeException());
                flags.setObjectForKey(message, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String clearThreadInterrupt(Thread thread) {
        if (flags == null) {
            return null;
        }
        NSMutableDictionary<Thread, String> nSMutableDictionary = flags;
        synchronized (nSMutableDictionary) {
            return flags.removeObjectForKey(thread);
        }
    }

    public static class TimeoutTimerTask
    extends TimerTask {
        private Process _p;
        private boolean _didTimeout = false;

        public TimeoutTimerTask(Process p) {
            this._p = p;
        }

        public boolean didTimeout() {
            return this._didTimeout;
        }

        public void run() {
            try {
                this._p.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this._didTimeout = true;
                this._p.destroy();
            }
        }
    }

    public static class TimeoutException
    extends Exception {
        public TimeoutException(String string) {
            super(string);
        }
    }

    public static class Result {
        private byte[] _response;
        private byte[] _error;
        private int _exitValue;

        public Result(int exitValue, byte[] response, byte[] error) {
            this._exitValue = exitValue;
            this._response = response;
            this._error = error;
        }

        public byte[] getResponse() {
            return this._response;
        }

        public byte[] getError() {
            return this._error;
        }

        public int getExitValue() {
            return this._exitValue;
        }

        public String getResponseAsString() {
            return this.getResponse() == null ? null : new String(this.getResponse());
        }

        public String getErrorAsString() {
            return this.getError() == null ? null : new String(this.getError());
        }
    }

    public static class StreamReader {
        private byte[] _result = null;
        private boolean _finished = false;
        private IOException _iox;

        public StreamReader(final InputStream is) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    try {
                        int read = -1;
                        byte[] buf = new byte[51200];
                        while ((read = is.read(buf)) != -1) {
                            bout.write(buf, 0, read);
                        }
                        StreamReader.access$002(StreamReader.this, bout.toByteArray());
                    }
                    catch (IOException e) {
                        StreamReader.this._iox = e;
                        StreamReader.access$002(StreamReader.this, bout.toByteArray());
                    }
                    finally {
                        StreamReader streamReader = StreamReader.this;
                        synchronized (streamReader) {
                            StreamReader.this._finished = true;
                            StreamReader.this.notifyAll();
                        }
                    }
                }
            };
            Thread t = new Thread(r);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getResult() {
            StreamReader streamReader = this;
            synchronized (streamReader) {
                if (!this._finished) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                    }
                }
            }
            return this._result;
        }

        public boolean isFinished() {
            return this._finished;
        }

        public IOException getException() {
            return this._iox;
        }

        public String getResultAsString() {
            return this.getResult() == null ? null : new String(this.getResult());
        }

        static /* synthetic */ byte[] access$002(StreamReader x0, byte[] x1) {
            x0._result = x1;
            return x1;
        }
    }
}

