/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.jdbc;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import er.extensions.foundation.ERXExceptionUtilities;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.log4j.Logger;

public class ERXJDBCConnectionAnalyzer {
    public static final Logger log = Logger.getLogger((String)"er.transaction.adaptor.ConnectionAnalyzer");
    private NSDictionary _connectionDictionary;
    private JDBCAdaptor _targetAdaptor;
    private JDBCPlugIn _targetPlugIn;

    public ERXJDBCConnectionAnalyzer(NSDictionary aConnectionDictionary) {
        this._connectionDictionary = aConnectionDictionary;
        this.analyzeConnection();
    }

    public ERXJDBCConnectionAnalyzer(EOModel aModel) {
        this(aModel.connectionDictionary());
    }

    public ERXJDBCConnectionAnalyzer(String aModelName) {
        this(EOModelGroup.defaultGroup().modelNamed(aModelName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void analyzeConnection() {
        NSMutableDictionary<String, String> mutableConnectionDictionary = this._connectionDictionary.mutableClone();
        mutableConnectionDictionary.setObjectForKey("<password deleted for log>", "password");
        log.info((Object)("Checking JDBC connection with information " + mutableConnectionDictionary));
        EOObjectStoreCoordinator.defaultCoordinator().lock();
        try {
            try {
                this.findAdaptor();
                this.findPlugin();
                this.findJDBCDriver();
                this.testConnection();
            }
            catch (RuntimeException t) {
                log.error((Object)ERXExceptionUtilities.toParagraph(t));
                Object var4_3 = null;
                EOObjectStoreCoordinator.defaultCoordinator().unlock();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            EOObjectStoreCoordinator.defaultCoordinator().unlock();
            throw throwable;
        }
        EOObjectStoreCoordinator.defaultCoordinator().unlock();
    }

    public void findAdaptor() {
        log.info((Object)"Trying to create JDBCAdaptor...");
        try {
            this._targetAdaptor = (JDBCAdaptor)EOAdaptor.adaptorWithName((String)"JDBC");
        }
        catch (IllegalStateException e) {
            log.info((Object)"Error: Failed to load JavaJDBCAdaptor.framework");
            log.info((Object)"This framework needs to be included in your application to make JDBC connections");
            this.dumpClasspath();
            throw new RuntimeException("JDBC Connection Analysis: JavaJDBCAdaptor.framework not on classpath");
        }
        log.info((Object)("Successfully created adaptor " + this.targetAdaptor().getClass().getName()));
    }

    public void findPlugin() {
        log.info((Object)"Trying to create plugin...");
        try {
            this._targetAdaptor.setConnectionDictionary(this.connectionDictionary());
            this._targetPlugIn = this.targetAdaptor().plugIn();
            log.info((Object)("Created plugin " + this.targetPlugIn().getClass().getName()));
        }
        catch (NoClassDefFoundError e) {
            log.info((Object)("Error: Failed to load class " + e.getMessage() + "when creating JDBC plugin."));
            log.info((Object)"This is probably a class which is required by the plugin class and can also indicate that the JDBC driver was not found.");
            log.info((Object)"Either (a) your classpath is wrong or (b) something is missing from the JRE extensions directory/ies.");
            this.dumpClasspath();
            this.dumpExtensionDirectories();
            throw new RuntimeException("JDBC Connection Analysis: Missing class needed by plugin");
        }
        catch (Exception e) {
            Throwable t = ERXExceptionUtilities.getMeaningfulThrowable(e);
            log.info((Object)("Error: Plugin creationg failed with " + t.getMessage()), t);
            throw new RuntimeException("JDBC Connection Analysis: unexpected failure creating plugin");
        }
        if (this.targetPlugIn().getClass().equals(JDBCPlugIn.class)) {
            String driverClassName = (String)this.connectionDictionary().objectForKey("driver");
            if (driverClassName == null || driverClassName.length() == 0) {
                log.info((Object)"Error: Failed to load custom JDBC plugin and connection dictionary does not include the driver class name under the key driver");
                log.info((Object)"Either \n(a) the plugin is missing from your classpath or \n(b) the connection dictionary has a misspelled 'plugin' key or \n(c) the plug-in name specified under the 'plugin' key is incorrect or \n(d) the class name for the JDBC driver under the key 'driver' is missing from the connection dictionary or\n(e)the connection dictionary has a misspelled 'driver' key");
                this.dumpClasspath();
                throw new RuntimeException("JDBC Connection Analysis: Missing plugin or driver");
            }
            log.info((Object)"WARNING: using generic JDBCPlugIn.");
        }
    }

    public void findJDBCDriver() {
        Class<?> targetDriver;
        log.info((Object)("Trying to load JDBC driver " + this.targetAdaptor().driverName() + "..."));
        try {
            targetDriver = Class.forName(this.targetAdaptor().driverName());
        }
        catch (ClassNotFoundException e) {
            log.info((Object)("Error: Failed to load JDBC driver class " + e.getMessage()));
            log.info((Object)"The JDBC driver jar is either missing from  (a) your classpath or (b) the JRE extensions directory/ies.");
            this.dumpClasspath();
            this.dumpExtensionDirectories();
            throw new RuntimeException("JDBC Connection Analysis: Cannot load JDBC driver. " + e.getMessage());
        }
        log.info((Object)("Successfully loaded JDBC driver " + targetDriver.getName()));
    }

    public void testConnection() {
        log.info((Object)"JDBC driver and plugin are loaded, trying to connect...");
        try {
            this.targetAdaptor().assertConnectionDictionaryIsValid();
        }
        catch (RuntimeException t) {
            log.info((Object)"Error: Exception thrown while connecting.\nCheck exception message carefully.");
            throw t;
        }
        catch (Error e) {
            log.info((Object)"Error: Exception thrown while connecting.\nCheck exception message carefully.");
            throw e;
        }
        log.info((Object)"JDBC connection successful!");
    }

    public void dumpClasspath() {
        log.info((Object)"The classpath being used is: ");
        URLClassLoader classLoader = (URLClassLoader)this.getClass().getClassLoader();
        URL[] sourceURLs = classLoader.getURLs();
        for (int i = 0; i < sourceURLs.length; ++i) {
            log.info((Object)sourceURLs[i]);
        }
    }

    public void dumpExtensionDirectories() {
        log.info((Object)"The JRE extension directories being used are: ");
        log.info((Object)System.getProperties().getProperty("java.ext.dirs"));
    }

    public NSDictionary connectionDictionary() {
        return this._connectionDictionary;
    }

    public JDBCAdaptor targetAdaptor() {
        return this._targetAdaptor;
    }

    public JDBCPlugIn targetPlugIn() {
        return this._targetPlugIn;
    }
}

