/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.logging;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.logging.ERXEOFLogEntryInterface;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class ERXEOFAppender
extends AppenderSkeleton {
    protected String loggingEntity;
    protected EOEditingContext ec;
    protected int bufferSize = -1;
    protected boolean conditionsChecked = false;
    protected int currentBufferSize = 1;

    public boolean requiresLayout() {
        return false;
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    public String getLoggingEntity() {
        return this.loggingEntity;
    }

    public void setLoggingEntity(String name) {
        this.loggingEntity = name;
    }

    protected boolean safeToCreateEditingContext() {
        return EOObjectStoreCoordinator.defaultCoordinator().cooperatingObjectStores().count() > 0;
    }

    protected EOEditingContext editingContext() {
        if (this.ec == null && this.safeToCreateEditingContext()) {
            this.ec = ERXEC.newEditingContext();
        }
        return this.ec;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            LogLog.warn((String)("BufferSize must be greater than 0!  Attempted to set bufferSize to: " + bufferSize));
        } else {
            this.bufferSize = bufferSize;
        }
    }

    protected boolean checkConditions() {
        if (this.getLoggingEntity() == null) {
            LogLog.warn((String)"Attempting to log an event with a null LoggingEntity specified.");
        } else if (!this.safeToCreateEditingContext()) {
            LogLog.warn((String)"Attempting to log an event to an EREOFAppender before an ObjectStoreCoordinator has been added.");
        } else {
            this.conditionsChecked = true;
        }
        return this.conditionsChecked;
    }

    public void append(LoggingEvent event) {
        if (this.conditionsChecked || this.checkConditions()) {
            this.subAppend(event);
        } else {
            LogLog.warn((String)("Unable to log event: " + event.getMessage()));
        }
    }

    protected void subAppend(LoggingEvent event) {
        if (this.editingContext() != null) {
            ERXEOFLogEntryInterface logEntry = (ERXEOFLogEntryInterface)ERXEOControlUtilities.createAndInsertObject(this.editingContext(), this.getLoggingEntity());
            logEntry.intializeWithLoggingEvent(event, this.layout);
            if (this.getBufferSize() == -1 || this.currentBufferSize == this.getBufferSize()) {
                this.editingContext().saveChanges();
                this.editingContext().revert();
                this.currentBufferSize = 1;
            } else {
                ++this.currentBufferSize;
            }
        }
    }
}

