/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.logging;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMailDelivery;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXConfigurationManager;
import er.extensions.foundation.ERXUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.util.Enumeration;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class ERXMailAppender
extends AppenderSkeleton {
    protected String fromAddress;
    protected String computedFromAddress;
    protected String replyTo;
    protected String toAddresses;
    protected String ccAddresses;
    protected String bccAddresses;
    protected String domainName;
    protected String qualifier;
    protected EOQualifier realQualifier;
    protected String title;
    protected String exceptionPageName;
    protected String hostName;
    protected String formatAsError;
    protected String titleIncludesPriorityLevel;
    protected String titleIncludesApplicationName;
    protected boolean conditionsChecked = false;

    public ERXMailAppender() {
        this.closed = false;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
        this.closed = true;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
        this.realQualifier = null;
    }

    public EOQualifier realQualifier() {
        if (this.realQualifier == null) {
            if (this.qualifier == null) {
                return null;
            }
            this.realQualifier = EOQualifier.qualifierWithQualifierFormat((String)this.qualifier, null);
        }
        return this.realQualifier;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String computedFromAddress() {
        if (this.computedFromAddress == null) {
            this.computedFromAddress = this.getFromAddress() != null ? this.getFromAddress() : WOApplication.application().name() + "-" + this.getHostName() + "@" + this.getDomainName();
        }
        return this.computedFromAddress;
    }

    public String getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(String toAddresses) {
        this.toAddresses = toAddresses;
    }

    public NSArray toAddressesAsArray() {
        return this.toAddresses != null ? NSArray.componentsSeparatedByString(this.toAddresses, ",") : NSArray.EmptyArray;
    }

    public void setCcAddresses(String ccAddresses) {
        this.ccAddresses = ccAddresses;
    }

    public String ccAddresses() {
        return this.ccAddresses;
    }

    public NSArray ccAddressesAsArray() {
        return this.ccAddresses != null ? NSArray.componentsSeparatedByString(this.ccAddresses, ",") : NSArray.EmptyArray;
    }

    public void setBccAddresses(String bccAddresses) {
        this.bccAddresses = bccAddresses;
    }

    public String bccAddresses() {
        return this.bccAddresses;
    }

    public NSArray bccAddressesAsArray() {
        return this.bccAddresses != null ? NSArray.componentsSeparatedByString(this.bccAddresses, ",") : NSArray.EmptyArray;
    }

    public String getExceptionPageName() {
        return this.exceptionPageName;
    }

    public void setExceptionPageName(String exceptionPageName) {
        this.exceptionPageName = exceptionPageName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHostName() {
        if (this.hostName == null) {
            this.hostName = ERXConfigurationManager.defaultManager().hostName();
        }
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String formatAsError() {
        return this.formatAsError;
    }

    public void setFormatAsError(String value) {
        this.formatAsError = value;
    }

    public boolean formatAsErrorAsBoolean() {
        return ERXValueUtilities.booleanValueWithDefault(this.formatAsError(), false);
    }

    public String titleIncludesPriorityLevel() {
        return this.titleIncludesPriorityLevel;
    }

    public void setTitleIncludesPriorityLevel(String value) {
        this.titleIncludesPriorityLevel = value;
    }

    public boolean titleIncludesPriorityLevelAsBoolean() {
        return ERXValueUtilities.booleanValueWithDefault(this.titleIncludesPriorityLevel(), true);
    }

    public String titleIncludesApplicationName() {
        return this.titleIncludesApplicationName;
    }

    public void setTitleIncludesApplicationName(String value) {
        this.titleIncludesApplicationName = value;
    }

    public boolean titleIncludesApplicationNameAsBoolean() {
        return ERXValueUtilities.booleanValueWithDefault(this.titleIncludesApplicationName(), true);
    }

    protected boolean checkConditions() {
        if (this.getFromAddress() == null && this.getDomainName() == null) {
            LogLog.error((String)"Attempting to log an event with a null domain name and a null from address!");
        } else if (this.toAddressesAsArray().count() == 0) {
            LogLog.error((String)"Attempting to log with an empty array of toAddresses");
        } else if (this.layout == null) {
            LogLog.warn((String)"Attempting to log an event to an ERCMailMessageAppender without a layout specified.");
        } else {
            this.conditionsChecked = true;
        }
        return this.conditionsChecked;
    }

    public void append(LoggingEvent event) {
        if (this.conditionsChecked || this.checkConditions()) {
            EOQualifier q;
            if ((event.getLevel().equals((Object)Level.ERROR) || event.getLevel().equals((Object)Level.FATAL)) && ((q = this.realQualifier()) == null || q.evaluateWithObject((Object)event))) {
                this.subAppend(event);
            }
        } else {
            LogLog.warn((String)("Unable to log event: " + event.getMessage()));
        }
    }

    public String composeTitle(LoggingEvent event) {
        String composeTitle;
        if (this.getTitle() != null) {
            composeTitle = this.getTitle();
        } else {
            StringBuffer temp = new StringBuffer();
            if (this.titleIncludesPriorityLevelAsBoolean()) {
                temp.append(event.getLevel().toString() + ": ");
            }
            if (this.titleIncludesApplicationNameAsBoolean()) {
                temp.append(WOApplication.application().name() + ": ");
            }
            temp.append(event.getRenderedMessage());
            composeTitle = temp.toString();
            int ret = temp.indexOf("\n");
            if (ret > 0) {
                composeTitle = composeTitle.substring(0, ret);
            }
        }
        return composeTitle;
    }

    public NSMutableDictionary composeExceptionPageDictionary(LoggingEvent event) {
        String message;
        String composeTitle;
        NSMutableDictionary<String, Object> result = new NSMutableDictionary<String, Object>();
        WOContext currentContext = ERXWOContext.currentContext();
        NSMutableDictionary extraInformation = null;
        if (currentContext != null) {
            extraInformation = ERXApplication.erxApplication().extraInformationForExceptionInContext(null, currentContext);
            result.setObjectForKey(extraInformation, "extraInfo");
        }
        if ((composeTitle = this.composeTitle(event)) != null) {
            result.setObjectForKey(composeTitle, "errorMessage");
        }
        if ((message = this.layout.format(event)) != null) {
            result.setObjectForKey(message, "formattedMessage");
        }
        if (event.getThrowableInformation() != null && event.getThrowableInformation().getThrowable() != null) {
            result.setObjectForKey(event.getThrowableInformation().getThrowable(), "exception");
        } else {
            String element;
            NSArray<String> parts = NSArray.componentsSeparatedByString(ERXUtilities.stackTrace(), "\n");
            NSMutableArray<String> subParts = new NSMutableArray<String>();
            boolean first = true;
            Enumeration<String> e = parts.reverseObjectEnumerator();
            while (e.hasMoreElements() && (element = e.nextElement()).indexOf("org.apache.log4j") == -1) {
                if (!first) {
                    subParts.insertObjectAtIndex(element, 0);
                    continue;
                }
                first = false;
            }
            result.setObjectForKey(subParts, "reasonLines");
        }
        return result;
    }

    public String composeMessage(LoggingEvent event) {
        String result;
        if (this.getExceptionPageName() != null && ERXValueUtilities.booleanValue(this.formatAsError())) {
            NSMutableDictionary dict = this.composeExceptionPageDictionary(event);
            WOComponent page = ERXApplication.instantiatePage(this.exceptionPageName);
            Enumeration keys = dict.keyEnumerator();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object value = dict.objectForKey(key);
                try {
                    page.takeValueForKey(value, key);
                }
                catch (NSKeyValueCoding.UnknownKeyException e) {}
            }
            try {
                result = page.generateResponse().contentString();
            }
            catch (Exception ex) {
                LogLog.error((String)"Can't create response!", (Throwable)ex);
                result = dict.objectForKey("formattedMessage") + "\n";
                result = dict.objectForKey("extraInfo") + "\n";
                NSArray lines = (NSArray)dict.objectForKey("reasonLines");
                if (lines != null) {
                    result = lines.componentsJoinedByString("\n");
                }
            }
        } else {
            result = this.layout.format(event);
            result = result + "\n" + ERXUtilities.stackTrace();
        }
        return result;
    }

    public void subAppend(LoggingEvent event) {
        WOMailDelivery delivery = WOMailDelivery.sharedInstance();
        String composeTitle = this.composeTitle(event);
        String content = this.composeMessage(event);
        String message = delivery.composePlainTextEmail(this.computedFromAddress(), this.toAddressesAsArray(), this.ccAddressesAsArray(), composeTitle, content, false);
        if (this.getExceptionPageName() != null && ERXValueUtilities.booleanValue(this.formatAsError())) {
            message = "Content-Type: text/html\n" + message;
        }
        if (this.bccAddresses() != null) {
            message = "BCC: " + this.bccAddresses() + "\n" + message;
        }
        delivery.sendEmail(message);
    }
}

