/*
 * Decompiled with CFR 0.152.
 */
package er.testrunner;

import er.testrunner.ERXTestListener;
import er.testrunner.ERXTestResult;
import er.testrunner.ERXTestRunner;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import org.apache.log4j.Logger;

public class ERXBatchTestInterface
implements ERXTestListener {
    public static final Logger log = Logger.getLogger(ERXBatchTestInterface.class);
    public static final boolean SHOW_EXCEPTIONS = true;
    public static final boolean HIDE_EXCEPTIONS = false;
    private Logger _userLog;
    protected String _test;
    protected boolean _showExceptions;
    protected String _errorMessage;
    protected ERXTestRunner aTestRunner;
    protected ERXTestResult testResult;
    protected long runTime;

    public ERXBatchTestInterface(String test) {
        this._test = test;
        this._showExceptions = false;
        this._errorMessage = "";
        this.runTime = 0L;
        this.aTestRunner = null;
        this.testResult = null;
    }

    private void resetInterface() {
        this.runTime = 0L;
        this._errorMessage = "";
        this.aTestRunner = new ERXTestRunner(this);
        this.testResult = new ERXTestResult();
    }

    public void performTest(Logger userLogger, boolean showExceptions) {
        this._showExceptions = showExceptions;
        this._userLog = userLogger;
        this.resetInterface();
        try {
            this.testResult = this.start();
            this.print();
        }
        catch (Exception e) {
            this._errorMessage = e.getMessage();
            this.userLog().error((Object)("[ERROR] " + e.getMessage()));
        }
    }

    protected ERXTestResult start() throws Exception {
        if (this._test.equals("")) {
            throw new Exception("You need to provide the name of a class to use as the TestCase for this run.");
        }
        try {
            Test suite = this.aTestRunner.getTest(this._test);
            return this.doRun(suite);
        }
        catch (Exception e) {
            throw new Exception("Could not create and run test suite: " + e);
        }
    }

    protected ERXTestResult doRun(Test suite) {
        this.testResult.addListener(this);
        long startTime = System.currentTimeMillis();
        suite.run((TestResult)this.testResult);
        long endTime = System.currentTimeMillis();
        this.runTime = endTime - startTime;
        return this.testResult;
    }

    private Logger userLog() {
        if (this._userLog == null) {
            return log;
        }
        return this._userLog;
    }

    public synchronized void print() {
        this.printHeader();
        this.printFailures();
        this.printErrors();
    }

    protected void printErrors() {
        if (this.testResult.errorCount() != 0) {
            if (this.testResult.errorCount() == 1) {
                this.userLog().info((Object)("There was " + this.testResult.errorCount() + " error:"));
            } else {
                this.userLog().info((Object)("There were " + this.testResult.errorCount() + " errors:"));
            }
            int i = 1;
            Enumeration e = this.testResult.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.userLog().info((Object)(i + ") " + failure.failedTest()));
                this.userLog().info((Object)BaseTestRunner.getFilteredTrace((Throwable)failure.thrownException()));
                ++i;
            }
        }
    }

    protected void printFailures() {
        if (this.testResult.failureCount() != 0) {
            if (this.testResult.failureCount() == 1) {
                this.userLog().info((Object)("There was " + this.testResult.failureCount() + " failure:"));
            } else {
                this.userLog().info((Object)("There were " + this.testResult.failureCount() + " failures:"));
            }
            int i = 1;
            Enumeration e = this.testResult.failures();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.userLog().info((Object)(i + ") " + failure.failedTest()));
                this.userLog().info((Object)BaseTestRunner.getFilteredTrace((Throwable)failure.thrownException()));
                ++i;
            }
        }
    }

    protected void printHeader() {
        if (this.testResult.wasSuccessful()) {
            this.userLog().info((Object)("OK (" + this.testResult.runCount() + " tests)"));
        } else {
            this.userLog().info((Object)"FAILURES!!!");
            this.userLog().info((Object)("Tests run: " + this.testResult.runCount() + ", Failures: " + this.testResult.failureCount() + ", Errors: " + this.testResult.errorCount()));
        }
    }

    public ERXTestResult testResult() {
        return this.testResult;
    }

    public String errorMessage() {
        return this._errorMessage;
    }

    public long runTime() {
        return this.runTime;
    }

    public String test() {
        return this._test;
    }

    public boolean showExceptions() {
        return this._showExceptions;
    }

    public synchronized void addError(Test test, Throwable t) {
        this.userLog().info((Object)("[E] " + test.toString() + " : " + t.getMessage()));
    }

    public synchronized void addFailure(Test test, AssertionFailedError t) {
        this.userLog().info((Object)("[F] " + test.toString() + " : " + t.getMessage()));
    }

    public synchronized void startTest(Test test) {
        this.userLog().info((Object)("[START] " + test.toString()));
    }

    public void endTest(Test test) {
        this.userLog().info((Object)("[END] " + test.toString()));
    }

    public void runFailed(String message) {
        this.userLog().info((Object)("[RUN FAILED] " + message));
    }

    public void clearStatus() {
        this.userLog().info((Object)"[CLEAR STATUS]");
    }
}

