/*
 * Decompiled with CFR 0.152.
 */
package er.testrunner;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOValidation;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSValidation;
import er.extensions.eof.ERXEC;
import java.util.Enumeration;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class ERXTestCase
extends TestCase {
    static Logger log = Logger.getLogger(ERXTestCase.class);
    private EOEditingContext editingContext;
    private NSMutableArray persistentRootObjects;

    public ERXTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.persistentRootObjects = new NSMutableArray();
        this.editingContext = ERXEC.newEditingContext();
        this.editingContext().lock();
    }

    protected void registerPersistentRootObjectForDeletion(EOEnterpriseObject anEnterpriseObject) {
        this.persistentRootObjects.addObject(anEnterpriseObject);
    }

    protected void deletePersistentObjects() {
        boolean errorOccured = false;
        if (this.editingContext().hasChanges()) {
            this.editingContext().saveChanges();
        }
        Enumeration persistentObjectEnum = this.persistentRootObjects.reverseObjectEnumerator();
        while (persistentObjectEnum.hasMoreElements()) {
            EOEnterpriseObject eo = (EOEnterpriseObject)persistentObjectEnum.nextElement();
            if (!this.eoHasBeenSaved(eo)) continue;
            try {
                this.editingContext().deleteObject(eo);
                this.editingContext().saveChanges();
            }
            catch (Throwable e) {
                log.error((Object)("tearDown can't delete object because " + e));
                errorOccured = true;
            }
        }
        if (errorOccured) {
            throw new RuntimeException("deletePersistentObjects failed");
        }
    }

    protected boolean eoHasBeenSaved(EOEnterpriseObject anEnterpriseObject) {
        EOGlobalID globalId = this.editingContext().globalIDForObject(anEnterpriseObject);
        return globalId != null && !globalId.isTemporary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        this.editingContext().revert();
        try {
            this.deletePersistentObjects();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.editingContext().unlock();
            throw throwable;
        }
        this.editingContext().unlock();
        this.editingContext().dispose();
        this.editingContext = null;
        super.tearDown();
    }

    public void runBare() throws Throwable {
        this.setUp();
        try {
            this.runTest();
        }
        catch (Throwable e) {
            try {
                this.tearDown();
            }
            catch (Throwable e2) {
                log.error((Object)("WOUT  tearDown failure: " + e2));
            }
            throw e;
        }
        this.tearDown();
    }

    protected void saveChanges(boolean assumeSuccess) {
        Exception exception;
        block4: {
            exception = null;
            try {
                this.editingContext().saveChanges();
            }
            catch (Exception e) {
                exception = e;
                if (!assumeSuccess) break block4;
                e.printStackTrace();
                this.editingContext().revert();
            }
        }
        if (assumeSuccess) {
            ERXTestCase.assertNull((Object)exception);
        } else {
            ERXTestCase.assertNotNull((Object)exception);
        }
    }

    protected EOEditingContext editingContext() {
        return this.editingContext;
    }

    public static void assertValidates(boolean expectsSuccess, EOValidation validationObject) {
        block3: {
            try {
                validationObject.validateForSave();
                if (!expectsSuccess) {
                    ERXTestCase.fail((String)("validation succeeded unexpectedly for: " + validationObject));
                }
            }
            catch (NSValidation.ValidationException exception) {
                if (!expectsSuccess) break block3;
                ERXTestCase.fail((String)("Validation unexpectedly failed: " + exception.getMessage()));
            }
        }
    }
}

