/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eoaccess.EOSchemaGeneration;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eoaccess._EOPrivate;
import com.webobjects.eoaccess._EOStringUtil;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSDelegate;
import com.webobjects.foundation._NSUtilities;
import java.net.URL;

public abstract class EOAdaptor {
    protected String _name;
    protected NSDictionary _connectionDictionary;
    protected NSMutableArray _contexts;
    protected String _expressionClassName;
    protected Class _expressionClass;
    protected _NSDelegate _delegate;
    protected boolean _delegateRespondsTo_processValue;
    protected boolean _delegateRespondsTo_reconDict;
    private static NSMutableDictionary expressionClassNameDictionary = null;
    private static volatile Object _defaultAdaptorDelegate = null;
    private static NSMutableDictionary _prototypesByAdaptorClassName;
    private static final String AdaptorFrameworkPrefix = "Java";
    private static final String AdaptorFrameworkSuffix = "Adaptor";
    private static final String AdaptorClassNameKey = "EOAdaptorClassName";
    private static final NSSelector _defaultDelegateSelector;
    private static final NSSelector _resetPrototypeSelector;
    private static final NSSelector _updateFromPrototypeSelector;
    private static String platform;

    private static String frameworkNameForAdaptorName(String name) {
        return AdaptorFrameworkPrefix + name + AdaptorFrameworkSuffix;
    }

    private static String adaptorNameForFrameworkName(String name) {
        if (name.endsWith(AdaptorFrameworkSuffix) && name.startsWith(AdaptorFrameworkPrefix)) {
            name = name.substring(AdaptorFrameworkPrefix.length(), name.length() - AdaptorFrameworkSuffix.length());
        }
        return name;
    }

    private static NSDictionary infoDictionaryForAdaptorNamed(String name) {
        if (name == null) {
            throw new IllegalArgumentException("infoDictionaryForAdaptorNamed: name argument cannot be null");
        }
        NSBundle bundle = NSBundle.bundleForName((String)EOAdaptor.frameworkNameForAdaptorName(name));
        if (bundle == null) {
            return null;
        }
        return bundle._infoDictionary();
    }

    private static String classNameForAdaptorNamed(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        NSDictionary info = EOAdaptor.infoDictionaryForAdaptorNamed(name);
        if (info == null) {
            return null;
        }
        return (String)info.objectForKey((Object)AdaptorClassNameKey);
    }

    private static Class classForAdaptorNamed(String name) {
        if (name == null) {
            throw new IllegalArgumentException("classForAdaptorNamed: name argument cannot be null");
        }
        String className = EOAdaptor.classNameForAdaptorNamed(name);
        if (className == null) {
            throw new IllegalStateException("Unable to get the name of the class to instantiate for the adaptor framework " + EOAdaptor.frameworkNameForAdaptorName(name) + ". The possible causes for this error are: the adaptor framework is not installed on your system, the adaptor framework is not linked into your application, or the info dictionary for this adaptor is corrupted.");
        }
        Class aClass = _NSUtilities.classWithName((String)className);
        if (aClass == null) {
            throw new IllegalStateException("Unable to load the class for the adaptor named " + name + ".  The adaptor framework " + EOAdaptor.frameworkNameForAdaptorName(name) + " is not linked into your application or your CLASSPATH environment variable does not include the adaptor framework's JAR file.");
        }
        return aClass;
    }

    public static synchronized EOAdaptor adaptorWithName(String name) {
        return (EOAdaptor)_NSUtilities.instantiateObject((Class)EOAdaptor.classForAdaptorNamed(name), (Class[])_NSUtilities._StringClassArray, (Object[])new Object[]{name}, (boolean)true, (boolean)false);
    }

    public static EOAdaptor adaptorWithModel(EOModel model) {
        String adaptorName = model.adaptorName();
        if (adaptorName == null || adaptorName.length() == 0) {
            throw new IllegalArgumentException("adaptorWithModel: No adaptor name specified in the model file named " + model.name());
        }
        EOAdaptor adaptor = EOAdaptor.adaptorWithName(adaptorName);
        if (adaptor == null) {
            throw new IllegalArgumentException("adaptorWithModel: Unable to load the " + adaptorName + " adaptor");
        }
        adaptor.setConnectionDictionary(model.connectionDictionary());
        return adaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExpressionClassName(String sqlExpressionClassName, String adaptorClassName) {
        if (adaptorClassName == null || adaptorClassName.length() == 0) {
            throw new IllegalArgumentException("setExpressionClassName: EOAdaptor: Adaptor class name has null or 0 length value");
        }
        NSMutableDictionary nSMutableDictionary = expressionClassNameDictionary;
        synchronized (nSMutableDictionary) {
            if (sqlExpressionClassName != null) {
                expressionClassNameDictionary.setObjectForKey((Object)sqlExpressionClassName, (Object)adaptorClassName);
            } else {
                expressionClassNameDictionary.removeObjectForKey((Object)adaptorClassName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String expressionClassName(String adaptorClassName) {
        NSMutableDictionary nSMutableDictionary = expressionClassNameDictionary;
        synchronized (nSMutableDictionary) {
            return (String)expressionClassNameDictionary.objectForKey((Object)adaptorClassName);
        }
    }

    public abstract EOSQLExpressionFactory expressionFactory();

    public abstract EOSchemaGeneration synchronizationFactory();

    public static void setDefaultDelegate(Object delegate) {
        _defaultAdaptorDelegate = delegate;
    }

    public static Object defaultDelegate() {
        return _defaultAdaptorDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray prototypeAttributes() {
        NSArray prototypes;
        String adaptorName = this.name();
        String className = this.getClass().getName();
        EOModel prototypesModel = null;
        NSMutableDictionary nSMutableDictionary = _prototypesByAdaptorClassName;
        synchronized (nSMutableDictionary) {
            prototypes = (NSArray)_prototypesByAdaptorClassName.objectForKey((Object)className);
            if (prototypes != null) {
                return prototypes;
            }
            String modelName = "EO" + adaptorName + "Prototypes";
            NSBundle adaptorBundle = NSBundle.bundleForClass(this.getClass());
            if (adaptorBundle == null) {
                return NSArray.EmptyArray;
            }
            String resourcePath = adaptorBundle.resourcePathForLocalizedResourceNamed(modelName + "." + "eomodeld", "Prototypes");
            URL modelURL = adaptorBundle.pathURLForResourcePath(resourcePath);
            try {
                prototypesModel = new EOModel(modelURL);
            }
            catch (RuntimeException e) {
                NSLog._conditionallyLogPrivateException((Throwable)e);
                prototypesModel = null;
            }
            if (prototypesModel != null) {
                prototypes = prototypesModel.entityNamed(modelName).attributes();
            }
            if (prototypes == null) {
                prototypes = NSArray.EmptyArray;
            }
            _prototypesByAdaptorClassName.setObjectForKey((Object)prototypes, (Object)className);
        }
        return prototypes;
    }

    public EOAdaptor(String name) {
        this._name = name;
        this._contexts = new NSMutableArray();
        Object delegate = NSSelector._safeInvokeSelector((NSSelector)_defaultDelegateSelector, this.getClass(), null);
        this._delegate = new _NSDelegate(Delegate.class);
        if (delegate != null) {
            this.setDelegate(delegate);
        }
    }

    public String name() {
        return this._name;
    }

    public abstract EOAdaptorContext createAdaptorContext();

    public NSArray contexts() {
        if (this._contexts == null) {
            return NSArray.EmptyArray;
        }
        return this._contexts.immutableClone();
    }

    public void handleDroppedConnection() {
        NSDictionary reconDict;
        int max = this._contexts.count();
        for (int i = 0; i < max; ++i) {
            EOAdaptorContext context = (EOAdaptorContext)this._contexts.objectAtIndex(i);
            context.transactionDidRollback();
            try {
                context.handleDroppedConnection();
                continue;
            }
            catch (Exception e) {
                NSLog._conditionallyLogPrivateException((Throwable)e);
            }
        }
        this._contexts = new NSMutableArray();
        if (this._delegateRespondsTo_reconDict && (reconDict = (NSDictionary)this._delegate.perform("reconnectionDictionaryForAdaptor", (Object)this)) != null) {
            this.setConnectionDictionary(reconDict);
        }
    }

    public Class expressionClass() {
        String exprClassName = EOAdaptor.expressionClassName(this.getClass().getName());
        if (this._expressionClassName == null || !this._expressionClassName.equals(exprClassName)) {
            this._expressionClassName = null;
            if (exprClassName != null) {
                this._expressionClass = _NSUtilities.classWithName((String)exprClassName);
                if (this._expressionClass == null) {
                    throw new IllegalStateException("Specified expression class '" + this._expressionClassName + "' is not in memory");
                }
            } else {
                this._expressionClass = null;
            }
            this._expressionClassName = exprClassName;
        }
        if (this._expressionClass != null) {
            return this._expressionClass;
        }
        return this.defaultExpressionClass();
    }

    public abstract Class defaultExpressionClass();

    public abstract boolean isValidQualifierType(String var1, EOModel var2);

    public abstract void assertConnectionDictionaryIsValid();

    public boolean hasOpenChannels() {
        for (int i = 0; i < this._contexts.count(); ++i) {
            EOAdaptorContext context = (EOAdaptorContext)this._contexts.objectAtIndex(i);
            if (!context.hasOpenChannels()) continue;
            return true;
        }
        return false;
    }

    public NSDictionary connectionDictionary() {
        return this._connectionDictionary;
    }

    public void setConnectionDictionary(NSDictionary dictionary) {
        if (this.hasOpenChannels()) {
            throw new IllegalArgumentException("setConnectionDictionary: connection dictionary cannot be set while there are open channels");
        }
        this._connectionDictionary = new NSDictionary(dictionary);
    }

    public boolean canServiceModel(EOModel model) {
        return this._connectionDictionary.equals((Object)model.connectionDictionary());
    }

    public Object fetchedValueForValue(Object value, EOAttribute att) {
        if (this._delegateRespondsTo_processValue) {
            return this._delegate.perform("adaptorFetchedValueForValue", (Object)this, value, (Object)att);
        }
        if (value == NSKeyValueCoding.NullValue) {
            return value;
        }
        if (att.valueFactoryMethod() != null) {
            return value;
        }
        if (value instanceof String) {
            return this.fetchedValueForStringValue((String)value, att);
        }
        if (value instanceof Number) {
            return this.fetchedValueForNumberValue((Number)value, att);
        }
        if (value instanceof NSTimestamp) {
            return this.fetchedValueForDateValue((NSTimestamp)value, att);
        }
        if (value instanceof NSData) {
            return this.fetchedValueForDataValue((NSData)value, att);
        }
        return value;
    }

    public String fetchedValueForStringValue(String value, EOAttribute att) {
        return value;
    }

    public Number fetchedValueForNumberValue(Number value, EOAttribute att) {
        return value;
    }

    public NSTimestamp fetchedValueForDateValue(NSTimestamp value, EOAttribute att) {
        return value;
    }

    public NSData fetchedValueForDataValue(NSData value, EOAttribute att) {
        return value;
    }

    public boolean isDroppedConnectionException(Exception exception) {
        return false;
    }

    public Object delegate() {
        return this._delegate.delegate();
    }

    public void setDelegate(Object delegate) {
        boolean b;
        this._delegate.setDelegate(delegate);
        this._delegateRespondsTo_processValue = b = this._delegate.respondsTo("adaptorFetchedValueForValue");
        this._delegateRespondsTo_reconDict = b = this._delegate.respondsTo("reconnectionDictionaryForAdaptor");
    }

    protected void _registerAdaptorContext(EOAdaptorContext context) {
        this._contexts.addObject((Object)context);
    }

    protected void _unregisterAdaptorContext(EOAdaptorContext context) {
        for (int i = this._contexts.count() - 1; i >= 0; --i) {
            if (context != (EOAdaptorContext)this._contexts.objectAtIndex(i)) continue;
            this._contexts.removeObjectAtIndex(i);
        }
    }

    public String internalTypeForExternalType(String extType, EOModel model) {
        return null;
    }

    public NSArray externalTypesWithModel(EOModel model) {
        return NSArray.EmptyArray;
    }

    protected void _assignExternalNameForAttribute(EOAttribute attribute) {
        if (!attribute.isDerived()) {
            attribute.setColumnName(_EOStringUtil.externalNameForInternalNameSeparatorStringUseAllCaps(attribute.name(), "_", true));
        }
    }

    public void assignExternalTypeForAttribute(EOAttribute attribute) {
    }

    public void assignExternalInfoForAttribute(EOAttribute attribute) {
        this._assignExternalNameForAttribute(attribute);
        this.assignExternalTypeForAttribute(attribute);
    }

    public void assignExternalInfoForEntity(EOEntity entity) {
        entity.setExternalName(_EOStringUtil.externalNameForInternalNameSeparatorStringUseAllCaps(entity.name(), "_", true));
    }

    protected void _recursivelyConvertEntity(EOEntity entity) {
        int c;
        boolean assignNames = true;
        NSArray attributes = entity.attributes();
        int i = attributes.count();
        String extName = entity.externalName();
        if (extName == null || extName.length() == 0) {
            while (assignNames && i-- != 0) {
                String colName = ((EOAttribute)attributes.objectAtIndex(i)).columnName();
                if (colName == null || colName.length() <= 0) continue;
                assignNames = false;
            }
            if (assignNames) {
                this.assignExternalInfoForEntity(entity);
                c = attributes.count();
                for (i = 0; i < c; ++i) {
                    this.assignExternalInfoForAttribute((EOAttribute)attributes.objectAtIndex(i));
                }
            }
        }
        c = attributes.count();
        for (i = 0; i < c; ++i) {
            EOAttribute attribute = (EOAttribute)attributes.objectAtIndex(i);
            if (attribute.prototype() != null && !attribute.overridesPrototypeDefinitionForKey("externalType")) continue;
            this.assignExternalTypeForAttribute(attribute);
        }
        attributes.makeObjectsPerformSelector(_resetPrototypeSelector, null);
        attributes.makeObjectsPerformSelector(_updateFromPrototypeSelector, null);
    }

    public void assignExternalInfoForEntireModel(EOModel model) {
        int i;
        NSArray mEntities = model.entities();
        NSMutableArray entities = new NSMutableArray(mEntities);
        for (i = entities.count() - 1; i >= 0; --i) {
            if (!EOModel._isPrototypesEntity((EOEntity)entities.objectAtIndex(i))) continue;
            entities.removeObjectAtIndex(i);
        }
        int iCount = entities.count();
        for (i = 0; i < iCount; ++i) {
            this._recursivelyConvertEntity((EOEntity)entities.objectAtIndex(i));
        }
        NSArray array = model.storedProcedures();
        iCount = array.count();
        for (i = iCount - 1; i >= 0; --i) {
            model.removeStoredProcedure((EOStoredProcedure)array.objectAtIndex(i));
        }
    }

    private static NSDictionary _infoDictionaryForFrameworkAtPath(String path) {
        String infoPath;
        URL infoURL;
        NSBundle bundle;
        NSDictionary returnDict = null;
        if (platform == null) {
            String osName = System.getProperty("os.name");
            platform = osName.startsWith("Windows") ? "winnt" : "nextstep";
        }
        if ((bundle = NSBundle.bundleWithPath((String)NSPathUtilities._standardizedPath((String)path))) != null && (infoURL = bundle.pathURLForResourcePath(infoPath = bundle.resourcePathForLocalizedResourceNamed("Info-" + platform + ".plist", null))) != null) {
            returnDict = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)infoURL);
        }
        return returnDict;
    }

    protected void _createDropDatabase(boolean create, NSDictionary adminDict) {
        if (adminDict == null) {
            throw new EOGeneralAdaptorException("administrative dictionary argument cannot be null");
        }
        NSDictionary connDict = this.connectionDictionary();
        NSArray stmts = create ? this.synchronizationFactory().createDatabaseStatementsForConnectionDictionary(connDict, adminDict) : this.synchronizationFactory().dropDatabaseStatementsForConnectionDictionary(connDict, adminDict);
        int stmtsCount = stmts == null ? 0 : stmts.count();
        EOModel adminModel = new EOModel();
        adminModel.setAdaptorName(this.name());
        adminModel.setConnectionDictionary(adminDict);
        adminModel.setName("_eoAdminModel");
        EOAdaptor adminAdaptor = EOAdaptor.adaptorWithModel(adminModel);
        EOAdaptorContext adminContext = adminAdaptor.createAdaptorContext();
        EOAdaptorChannel adminChannel = adminContext.createAdaptorChannel();
        if (!adminChannel.isOpen()) {
            adminChannel.openChannel();
        }
        for (int i = 0; i < stmtsCount; ++i) {
            EOSQLExpression expr = (EOSQLExpression)stmts.objectAtIndex(i);
            adminChannel.evaluateExpression(expr);
        }
        if (adminChannel.isOpen()) {
            adminChannel.closeChannel();
        }
    }

    public void dropDatabaseWithAdministrativeConnectionDictionary(NSDictionary administrativeConnectionDictionary) {
        if (administrativeConnectionDictionary == null) {
            throw new EOGeneralAdaptorException("dropDatabaseWithAdministrativeConnectionDictionary: administrativeConnectionDictionary argument cannot be null");
        }
        this._createDropDatabase(false, administrativeConnectionDictionary);
    }

    public void createDatabaseWithAdministrativeConnectionDictionary(NSDictionary administrativeConnectionDictionary) {
        if (administrativeConnectionDictionary == null) {
            throw new EOGeneralAdaptorException("createDatabaseWithAdministrativeConnectionDictionary: administrativeConnectionDictionary argument cannot be null");
        }
        this._createDropDatabase(true, administrativeConnectionDictionary);
    }

    public NSDictionary administrativeConnectionDictionaryForAdaptor(EOAdaptor adaptor) {
        return null;
    }

    static {
        Class aClass = _EOPrivate.class;
        expressionClassNameDictionary = new NSMutableDictionary();
        _prototypesByAdaptorClassName = new NSMutableDictionary();
        _defaultDelegateSelector = new NSSelector("defaultDelegate", null);
        _resetPrototypeSelector = new NSSelector("_resetPrototype", null);
        _updateFromPrototypeSelector = new NSSelector("_updateFromPrototype", null);
        platform = null;
    }

    public static interface Delegate {
        public Object adaptorFetchedValueForValue(EOAdaptor var1, Object var2, EOAttribute var3);

        public NSDictionary reconnectionDictionaryForAdaptor(EOAdaptor var1);
    }
}

