/*
 * Decompiled with CFR 0.152.
 */
package er.yui;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import er.ajax.AjaxUtils;
import er.extensions.foundation.ERXProperties;

public class YUIUtils {
    private static String yuiBase;

    private static String yuiBase() {
        if (yuiBase == null) {
            yuiBase = ERXProperties.stringForKeyWithDefault((String)"er.yui.base", (String)"");
        }
        return yuiBase;
    }

    private static String actualFileName(String fileName) {
        if (fileName.startsWith("ext") || fileName.startsWith("wonder")) {
            return fileName;
        }
        return YUIUtils.yuiBase() + fileName;
    }

    public static void addScriptResourceInHead(WOContext context, WOResponse response, String fileName) {
        if (WOApplication.application().isCachingEnabled()) {
            fileName = fileName.replaceFirst("\\.js$", "-min.js");
        }
        AjaxUtils.addScriptResourceInHead((WOContext)context, (WOResponse)response, (String)"YUI", (String)YUIUtils.actualFileName(fileName));
    }

    public static void addStylesheetResourceInHead(WOContext context, WOResponse response, String fileName) {
        AjaxUtils.addStylesheetResourceInHead((WOContext)context, (WOResponse)response, (String)"YUI", (String)YUIUtils.actualFileName(fileName));
    }

    public static String id(String idBindingName, NSDictionary associations, WOContext context) {
        String id = AjaxUtils.stringValueForBinding((String)idBindingName, (NSDictionary)associations, (WOComponent)context.component());
        if (id == null) {
            id = AjaxUtils.toSafeElementID((String)context.elementID());
        }
        return id;
    }

    public static String varName(String name, NSDictionary associations, WOContext context) {
        String namespace = AjaxUtils.stringValueForBinding((String)"namespace", (NSDictionary)associations, (WOComponent)context.component());
        return YUIUtils.varName(name, namespace);
    }

    public static String varName(String name, String namespace) {
        String varName = name;
        if (namespace != null) {
            varName = namespace + "." + name;
        }
        return varName;
    }

    public static void appendAttributeValue(WOResponse response, WOContext context, NSDictionary associations, String name) {
        String value = AjaxUtils.stringValueForBinding((String)name, (NSDictionary)associations, (WOComponent)context.component());
        YUIUtils.appendAttributeValue(response, context, name, value);
    }

    public static void appendAttributeValue(WOResponse response, WOContext context, String name, String value) {
        if (value != null) {
            response._appendTagAttributeAndValue(name, value, true);
        }
    }
}

