/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eoaccess.EOSchemaGeneration;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCChannel;
import com.webobjects.jdbcadaptor.JDBCContext;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCAdaptor
extends EOAdaptor {
    public static final String JDBCInfoKey = "jdbc2Info";
    public static final String DataSourceJndiNameKey = "DataSourceJndiName";
    public static final String TypeInfoKey = "typeInfo";
    public static final String UsernameKey = "username";
    public static final String PasswordKey = "password";
    public static final String DriverKey = "driver";
    public static final String PlugInKey = "plugin";
    public static final String URLKey = "URL";
    protected EOSQLExpressionFactory _expressionFactory;
    protected JDBCPlugIn _plugin;
    protected NSDictionary _jdbcInfo;
    protected JDBCContext _cachedContext;
    protected int _varcharMaxLength;
    private String _driverName;
    private static final String CN_JavaString = "java.lang.String";
    private static final String CN_JavaNumber = "java.lang.Number";
    private static final String CN_JavaBigDecimal = "java.math.BigDecimal";
    private static final String CN_JavaNSTimestamp = "com.webobjects.foundation.NSTimestamp";
    private static final String CN_JavaNSData = "com.webobjects.foundation.NSData";
    private static final String CN_NSString = "NSString";
    private static final String CN_NSNumber = "NSNumber";
    private static final String CN_NSDecimalNumber = "NSDecimalNumber";
    private static final String CN_NSCalendarDate = "NSCalendarDate";
    private static final String CN_NSGregorianDate = "NSGregorianDate";
    private static final String CN_NSData = "NSData";
    static final int OracleRefCursor = -10;
    static final String CN_JavaResultSet = "java.sql.ResultSet";
    static final String OracleRefCursorName = "REF CURSOR";
    private static final String[] _serviceKeys = new String[]{"URL", "username", "password", "driver", "plugin"};

    public JDBCAdaptor(String string) {
        super(string);
    }

    public void setConnectionDictionary(NSDictionary nSDictionary) throws IllegalArgumentException {
        if (this._cachedContext != null) {
            this._cachedContext.disconnect();
            this._cachedContext = null;
            this._varcharMaxLength = 0;
        }
        this._plugin = null;
        this._jdbcInfo = null;
        this._driverName = null;
        super.setConnectionDictionary(nSDictionary);
        if (nSDictionary != null) {
            this._jdbcInfo = (NSDictionary)nSDictionary.objectForKey((Object)JDBCInfoKey);
        }
    }

    protected NSDictionary jdbcInfo() {
        if (this._jdbcInfo == null || this._jdbcInfo.count() == 0) {
            this._jdbcInfo = this.plugIn().jdbcInfo();
        }
        return this._jdbcInfo;
    }

    protected NSDictionary typeInfo() {
        if (this._jdbcInfo == null || this._jdbcInfo.count() == 0) {
            this._jdbcInfo = this.plugIn().jdbcInfo();
        }
        return (NSDictionary)this._jdbcInfo.objectForKey((Object)TypeInfoKey);
    }

    public Properties connectionProperties() {
        return this.plugIn().connectionPropertiesForConnectionDictionary(this.connectionDictionary());
    }

    public boolean canServiceModel(EOModel eOModel) {
        if (eOModel == null) {
            return false;
        }
        NSDictionary nSDictionary = this.connectionDictionary();
        NSDictionary nSDictionary2 = eOModel.connectionDictionary();
        if (nSDictionary2 == null || nSDictionary == null) {
            return false;
        }
        for (int i = 0; i < _serviceKeys.length; ++i) {
            String string = _serviceKeys[i];
            String string2 = (String)nSDictionary.objectForKey((Object)string);
            String string3 = (String)nSDictionary2.objectForKey((Object)string);
            if (!(string2 == null ? string3 != null : !string2.equals(string3))) continue;
            return false;
        }
        return true;
    }

    protected int varcharMaxLength() {
        if (this._varcharMaxLength == 0) {
            String string = this._externalTypeForJDBCType(12);
            if (string != null) {
                NSDictionary nSDictionary = (NSDictionary)this.typeInfo().objectForKey((Object)string);
                this._varcharMaxLength = JDBCAdaptor._intForKey(nSDictionary, "precision");
            }
            if (this._varcharMaxLength == 0) {
                this._varcharMaxLength = 254;
            }
        }
        return this._varcharMaxLength;
    }

    public void assertConnectionDictionaryIsValid() {
        if (!this.hasOpenChannels()) {
            JDBCContext jDBCContext = this._cachedAdaptorContext();
            JDBCChannel jDBCChannel = jDBCContext._cachedAdaptorChannel();
            jDBCChannel.openChannel();
        }
    }

    private JDBCPlugIn _createPlugIn() {
        String string;
        JDBCPlugIn jDBCPlugIn = null;
        Class clazz = null;
        NSDictionary nSDictionary = this.connectionDictionary();
        String string2 = (String)nSDictionary.objectForKey((Object)PlugInKey);
        boolean bl = string2 != null && string2.length() > 0;
        boolean bl2 = NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L);
        if (!bl) {
            string = (String)nSDictionary.objectForKey((Object)URLKey);
            String string3 = string2 = string == null ? null : JDBCPlugIn.plugInNameForURL(string);
            if (string2 == null) {
                string2 = "com.webobjects.jdbcadaptor.JDBCPlugIn";
            }
        }
        if ((clazz = _NSUtilities.classWithName((String)string2)) == null) {
            if (!string2.endsWith("PlugIn")) {
                string2 = string2 + "PlugIn";
            }
            if (string2.indexOf(46) == -1) {
                string2 = "com.webobjects.jdbcadaptor." + string2;
            }
            clazz = _NSUtilities.classWithName((String)string2);
        }
        if (clazz != null) {
            jDBCPlugIn = (JDBCPlugIn)_NSUtilities.instantiateObject((Class)clazz, (Class[])new Class[]{JDBCAdaptor.class}, (Object[])new Object[]{this}, (boolean)true, (boolean)false);
        } else {
            if (bl) {
                string = (String)nSDictionary.objectForKey((Object)PlugInKey);
                throw new IllegalStateException("Unable to load JDBCPlugIn '" + string + "' for " + _NSUtilities.shortClassName((Object)((Object)this)) + "@" + System.identityHashCode((Object)this) + ".  Check your connection dictionary and make sure the specified JDBCPlugIn subclass is in your classpath.");
            }
            jDBCPlugIn = new JDBCPlugIn(this);
        }
        if (bl2) {
            NSLog.debug.appendln((Object)("Using JDBCPlugIn '" + string2 + "' for " + _NSUtilities.shortClassName((Object)((Object)this)) + "@" + System.identityHashCode((Object)this)));
        }
        return jDBCPlugIn;
    }

    protected JDBCContext _cachedAdaptorContext() {
        if (this._cachedContext == null) {
            this._cachedContext = new JDBCContext(this);
        }
        return this._cachedContext;
    }

    public EOAdaptorContext createAdaptorContext() {
        if (this._cachedContext != null) {
            JDBCContext jDBCContext = this._cachedContext;
            this._cachedContext = null;
            return jDBCContext;
        }
        return new JDBCContext(this);
    }

    public void handleDroppedConnection() {
        super.handleDroppedConnection();
        this._cachedContext = null;
    }

    public JDBCPlugIn plugIn() {
        if (this._plugin == null) {
            this._plugin = this._createPlugIn();
        }
        return this._plugin;
    }

    public Class defaultExpressionClass() {
        return this.plugIn().defaultExpressionClass();
    }

    public EOSQLExpressionFactory expressionFactory() {
        return this.plugIn().expressionFactory();
    }

    public EOSchemaGeneration synchronizationFactory() {
        return this.plugIn().synchronizationFactory();
    }

    public Object fetchedValueForValue(Object object, EOAttribute eOAttribute) {
        Object object2 = this.plugIn().plugInValueForValue(object, eOAttribute);
        return super.fetchedValueForValue(object2, eOAttribute);
    }

    public NSArray externalTypesWithModel(EOModel eOModel) {
        NSDictionary nSDictionary;
        if (eOModel == null) {
            return NSArray.EmptyArray;
        }
        try {
            nSDictionary = JDBCAdaptor.typeInfoForModel(eOModel);
        }
        catch (JDBCAdaptorException jDBCAdaptorException) {
            nSDictionary = null;
        }
        if (nSDictionary == null) {
            return NSArray.EmptyArray;
        }
        return nSDictionary.allKeys();
    }

    public String externalTypeForJDBCType(int n) {
        String string = JDBCAdaptor.stringRepresentationForJDBCType(n);
        NSDictionary nSDictionary = this.typeInfo();
        if (nSDictionary == null) {
            return null;
        }
        NSArray nSArray = nSDictionary.allKeys();
        int n2 = nSArray.count();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)nSArray.objectAtIndex(i);
            NSDictionary nSDictionary2 = (NSDictionary)nSDictionary.objectForKey((Object)string2);
            NSArray nSArray2 = (NSArray)nSDictionary2.objectForKey((Object)"defaultJDBCType");
            int n3 = nSArray2.count();
            for (int j = 0; j < n3; ++j) {
                String string3 = (String)nSArray2.objectAtIndex(j);
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    public boolean isValidQualifierType(String string, EOModel eOModel) {
        NSDictionary nSDictionary = this.typeInfo();
        if (nSDictionary == null) {
            return false;
        }
        NSDictionary nSDictionary2 = (NSDictionary)nSDictionary.objectForKey((Object)string);
        if (nSDictionary2 == null) {
            nSDictionary2 = (NSDictionary)nSDictionary.objectForKey((Object)string.toUpperCase());
        }
        if (nSDictionary2 == null) {
            return false;
        }
        String string2 = (String)nSDictionary2.objectForKey((Object)"isSearchable");
        if (string2 == null) {
            return false;
        }
        return string2.equals("T");
    }

    protected String connectionDictionaryURL() {
        return (String)this.connectionDictionary().objectForKey((Object)URLKey);
    }

    public String connectionURL() {
        return this.plugIn().connectionURL();
    }

    public String username() {
        String string = (String)this.connectionDictionary().objectForKey((Object)UsernameKey);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String password() {
        String string = (String)this.connectionDictionary().objectForKey((Object)PasswordKey);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String driverName() {
        if (this._driverName == null) {
            this._driverName = (String)this.connectionDictionary().objectForKey((Object)DriverKey);
        }
        if (this._driverName == null || this._driverName.length() == 0) {
            this._driverName = this.plugIn().defaultDriverName();
        }
        return this._driverName;
    }

    private static String _objcClassNameForType(int n, int n2, int n3) {
        String string = null;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                string = CN_NSNumber;
                break;
            }
            case 2: 
            case 3: {
                string = n3 > 0 ? CN_NSDecimalNumber : CN_NSNumber;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = CN_NSNumber;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2004: {
                string = CN_NSData;
                break;
            }
            case -7: {
                string = CN_NSNumber;
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                string = CN_NSString;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                string = CN_NSCalendarDate;
                break;
            }
            case 11: {
                string = CN_NSCalendarDate;
                break;
            }
            case -10: {
                string = CN_JavaResultSet;
            }
        }
        return string;
    }

    private static String _javaClassNameForType(int n, int n2, int n3) {
        String string = null;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                string = CN_JavaNumber;
                break;
            }
            case 2: 
            case 3: {
                string = n3 > 0 ? CN_JavaBigDecimal : CN_JavaNumber;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = CN_JavaNumber;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2004: {
                string = CN_JavaNSData;
                break;
            }
            case -7: {
                string = CN_JavaNumber;
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                string = CN_JavaString;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                string = CN_JavaNSTimestamp;
                break;
            }
            case 11: {
                string = CN_JavaNSTimestamp;
                break;
            }
            case -10: {
                string = CN_JavaResultSet;
            }
        }
        return string;
    }

    private static String _valueType(int n, int n2, int n3) {
        int n4 = 0;
        switch (n) {
            case 1: {
                n4 = 99;
                break;
            }
            case 12: {
                n4 = 83;
                break;
            }
            case -1: {
                n4 = 67;
                break;
            }
            case -7: {
                n4 = 99;
                break;
            }
            case -6: 
            case 5: {
                n4 = 115;
                break;
            }
            case 4: {
                if (n2 <= 9) {
                    n4 = 105;
                    break;
                }
                if (n2 <= 18) {
                    n4 = 108;
                    break;
                }
                n4 = 66;
                break;
            }
            case -5: {
                if (n2 <= 18) {
                    n4 = 108;
                    break;
                }
                n4 = 66;
                break;
            }
            case 6: {
                n4 = 102;
                break;
            }
            case 7: 
            case 8: {
                n4 = 100;
                break;
            }
            case 2: 
            case 3: {
                n4 = n3 == 0 && n2 <= 18 ? 108 : 66;
                break;
            }
            case 91: {
                n4 = 68;
                break;
            }
            case 92: {
                n4 = 116;
                break;
            }
            case 93: {
                n4 = 84;
            }
        }
        return n4 != 0 ? String.valueOf((char)n4) : null;
    }

    protected static char _valueTypeCharForAttribute(EOAttribute eOAttribute) {
        String string = eOAttribute.valueType();
        if (string != null && string.length() > 0) {
            return string.charAt(0);
        }
        return ' ';
    }

    public EOAttribute createAttribute(String string, String string2, int n, String string3, int n2, int n3, int n4) {
        EOAttribute eOAttribute = new EOAttribute();
        eOAttribute.setName(string);
        eOAttribute.setColumnName(string2);
        if (string3 != null && string3.length() > 0) {
            int n5 = string3.indexOf(40);
            if (n5 >= 0) {
                string3 = string3.substring(0, n5);
            }
            eOAttribute.setExternalType(string3);
        }
        Object var9_10 = null;
        if (n == 1111) {
            n = this.plugIn().jdbcTypeForUnknownExternalType(string3, n2, n3);
        }
        eOAttribute.setClassName(JDBCAdaptor._javaClassNameForType(n, n2, n3));
        eOAttribute.setValueType(JDBCAdaptor._valueType(n, n2, n3));
        switch (eOAttribute.adaptorValueType()) {
            case 0: {
                eOAttribute.setPrecision(n2);
                eOAttribute.setScale(n3);
                eOAttribute.setWidth(0);
                break;
            }
            case 3: {
                eOAttribute.setWidth(0);
                break;
            }
            case 1: 
            case 2: {
                eOAttribute.setWidth(n2);
            }
        }
        eOAttribute.setAllowsNull(n4 != 0);
        this.plugIn().assignTypeForAttribute(eOAttribute);
        return eOAttribute;
    }

    protected static NSDictionary typeInfoForModel(EOModel eOModel) {
        NSDictionary nSDictionary = (NSDictionary)eOModel.connectionDictionary().objectForKey((Object)JDBCInfoKey);
        if (nSDictionary == null) {
            eOModel.setConnectionDictionary(JDBCAdaptor.getJDBCInfoWithConnectionDictionary(eOModel.connectionDictionary()));
            nSDictionary = (NSDictionary)eOModel.connectionDictionary().objectForKey((Object)JDBCInfoKey);
        }
        if (nSDictionary == null) {
            return null;
        }
        return (NSDictionary)nSDictionary.objectForKey((Object)TypeInfoKey);
    }

    protected static NSDictionary getJDBCInfoWithConnectionDictionary(NSDictionary nSDictionary) throws JDBCAdaptorException {
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary(nSDictionary);
        JDBCAdaptor jDBCAdaptor = new JDBCAdaptor("JDBC");
        jDBCAdaptor.setConnectionDictionary(nSDictionary);
        NSDictionary nSDictionary2 = jDBCAdaptor.jdbcInfo();
        nSMutableDictionary.setObjectForKey((Object)nSDictionary2, (Object)JDBCInfoKey);
        JDBCContext jDBCContext = jDBCAdaptor._cachedAdaptorContext();
        if (jDBCContext != null) {
            jDBCContext.disconnect();
        }
        return nSMutableDictionary;
    }

    public static String stringRepresentationForJDBCType(int n) {
        switch (n) {
            case -5: {
                return "BIGINT";
            }
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "SMALLINT";
            }
            case -6: {
                return "TINYINT";
            }
            case 3: {
                return "DECIMAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case -2: {
                return "BINARY";
            }
            case -4: {
                return "LONG VARBINARY";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 1111: {
                return "OTHER";
            }
            case -3: {
                return "VARBINARY";
            }
            case -7: {
                return "BIT";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 11: {
                return "DATE";
            }
        }
        return String.valueOf(n);
    }

    public boolean isDroppedConnectionException(Exception exception) {
        if (exception instanceof JDBCAdaptorException) {
            for (SQLException sQLException = ((JDBCAdaptorException)((Object)exception)).sqlException(); sQLException != null; sQLException = sQLException.getNextException()) {
                String string = sQLException.getSQLState();
                if (string == null) {
                    return true;
                }
                if (string.startsWith("08")) {
                    return true;
                }
                if (string.equals("61000")) {
                    return true;
                }
                if (string.equals("HY000")) {
                    return true;
                }
                if (string.equals("72000")) {
                    return true;
                }
                if (!string.equals("40001")) continue;
                return true;
            }
        }
        return false;
    }

    private String _externalTypeForJDBCType(int n) {
        String string = null;
        int n2 = 0;
        String string2 = null;
        int n3 = Integer.MAX_VALUE;
        string = JDBCAdaptor.stringRepresentationForJDBCType(n);
        if (string == null) {
            return null;
        }
        NSDictionary nSDictionary = this.typeInfo();
        NSArray nSArray = nSDictionary.allKeys();
        int n4 = nSArray.count();
        block0: for (n2 = 0; n2 < n4; ++n2) {
            String string3 = (String)nSArray.objectAtIndex(n2);
            NSDictionary nSDictionary2 = (NSDictionary)nSDictionary.objectForKey((Object)string3);
            NSArray nSArray2 = (NSArray)nSDictionary2.objectForKey((Object)"defaultJDBCType");
            int n5 = nSArray2.count();
            if (n5 > n3) {
                n5 = n3 + 1;
            }
            for (int i = 0; i < n5; ++i) {
                String string4 = (String)nSArray2.objectAtIndex(i);
                if (!string4.equals(string)) continue;
                string2 = string3;
                n3 = i;
                continue block0;
            }
        }
        return string2;
    }

    private static int _intForKey(NSDictionary nSDictionary, String string) {
        int n;
        String string2 = (String)nSDictionary.objectForKey((Object)string);
        if (string2 == null) {
            return 0;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    private static int _prependPreferredSQLTypes(int[] nArray, EOAttribute eOAttribute) {
        char c = JDBCAdaptor._valueTypeCharForAttribute(eOAttribute);
        int n = 0;
        block0 : switch (eOAttribute.adaptorValueType()) {
            case 0: {
                switch (c) {
                    case 'c': {
                        break block0;
                    }
                    case 's': {
                        break block0;
                    }
                    case 'i': {
                        nArray[n++] = 4;
                        break block0;
                    }
                    case 'l': {
                        nArray[n++] = 4;
                        nArray[n++] = -5;
                        nArray[n++] = 2;
                        nArray[n++] = 3;
                        break block0;
                    }
                    case 'B': {
                        nArray[n++] = 4;
                        nArray[n++] = -5;
                        nArray[n++] = 2;
                        nArray[n++] = 3;
                        break block0;
                    }
                    case 'f': {
                        nArray[n++] = 6;
                        nArray[n++] = 7;
                        nArray[n++] = 8;
                        break block0;
                    }
                    case 'd': {
                        nArray[n++] = 8;
                        nArray[n++] = 7;
                        nArray[n++] = 6;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (c) {
                    case 'D': {
                        nArray[n++] = 91;
                        break block0;
                    }
                    case 't': {
                        nArray[n++] = 92;
                        break block0;
                    }
                    case 'T': {
                        nArray[n++] = 93;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                switch (c) {
                    case 'c': {
                        nArray[n++] = 1;
                        break block0;
                    }
                    case 'S': {
                        nArray[n++] = 12;
                        break block0;
                    }
                    case 'C': {
                        nArray[n++] = -1;
                        break block0;
                    }
                }
                break;
            }
        }
        return n;
    }

    public void assignExternalTypeForAttribute(EOAttribute eOAttribute) {
        int[] nArray = new int[20];
        int n = JDBCAdaptor._prependPreferredSQLTypes(nArray, eOAttribute);
        String string = null;
        switch (eOAttribute.adaptorValueType()) {
            case 0: {
                if (eOAttribute.scale() != 0) {
                    nArray[n++] = 3;
                    nArray[n++] = 2;
                    nArray[n++] = 7;
                    nArray[n++] = 6;
                    nArray[n++] = 8;
                    break;
                }
                nArray[n++] = 4;
                nArray[n++] = -5;
                nArray[n++] = 3;
                nArray[n++] = 2;
                nArray[n++] = 7;
                nArray[n++] = 6;
                nArray[n++] = 8;
                break;
            }
            case 3: {
                nArray[n++] = 93;
                nArray[n++] = 92;
                nArray[n++] = 91;
                break;
            }
            case 2: {
                if (eOAttribute.width() > 0) {
                    nArray[n++] = -2;
                    nArray[n++] = -3;
                    nArray[n++] = -4;
                    break;
                }
                nArray[n++] = -4;
                nArray[n++] = -3;
                nArray[n++] = -2;
                break;
            }
            case 1: {
                if (eOAttribute.width() > 0) {
                    nArray[n++] = 12;
                    nArray[n++] = 1;
                    nArray[n++] = -1;
                    break;
                }
                nArray[n++] = -1;
            }
        }
        nArray[n++] = 12;
        nArray[n++] = 1;
        nArray[n++] = -1;
        nArray[n++] = 1111;
        n = 0;
        NSDictionary nSDictionary = this.typeInfo();
        NSDictionary nSDictionary2 = null;
        int n2 = 0;
        while (nArray[n] != 1111) {
            n2 = 0;
            string = this._externalTypeForJDBCType(nArray[n]);
            nSDictionary2 = (NSDictionary)nSDictionary.objectForKey((Object)string);
            if (string != null && nSDictionary2 != null) {
                boolean bl = false;
                n2 = JDBCAdaptor._intForKey(nSDictionary2, "precision");
                int n3 = JDBCAdaptor._intForKey(nSDictionary2, "maxScale");
                int n4 = JDBCAdaptor._intForKey(nSDictionary2, "minScale");
                if (n2 == 0) {
                    bl = true;
                } else {
                    switch (eOAttribute.adaptorValueType()) {
                        case 0: {
                            int n5 = eOAttribute.precision();
                            if (n5 > n2) break;
                            if (n4 == 0 || n3 == 0) {
                                bl = true;
                                break;
                            }
                            int n6 = eOAttribute.scale();
                            if (n6 <= n3 && n6 >= n4) {
                                bl = true;
                            }
                            if (n6 > n3 || n5 + n4 - n6 > n2) break;
                            bl = true;
                            break;
                        }
                        case 1: 
                        case 2: {
                            int n5 = eOAttribute.width();
                            if (n5 > n2) break;
                            bl = true;
                            break;
                        }
                        case 3: {
                            bl = true;
                        }
                    }
                }
                if (bl) break;
            }
            ++n;
        }
        eOAttribute.setExternalType(string);
        eOAttribute.setValueType(JDBCAdaptor._valueType(nArray[n], eOAttribute.precision(), eOAttribute.scale()));
        this.plugIn().assignTypeForAttribute(eOAttribute);
    }
}

