/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCChannel;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

class JDBCColumn {
    EOAttribute _attribute;
    int _column;
    ResultSet _rs;
    PreparedStatement _statement;
    JDBCChannel _channel;
    int _adaptorValueType;
    char _valueType;
    boolean _customType;
    int _width;
    protected static final NSDictionary _jdbcTypeDictionary = new NSDictionary(new Object[]{new Integer(-7), new Integer(-6), new Integer(5), new Integer(4), new Integer(-5), new Integer(6), new Integer(6), new Integer(7), new Integer(8), new Integer(2), new Integer(3), new Integer(1), new Integer(12), new Integer(-1), new Integer(91), new Integer(92), new Integer(93), new Integer(-2), new Integer(-3), new Integer(-4), new Integer(0), new Integer(1111)}, new Object[]{"BIT", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "FLOAT", "FLOAT", "REAL", "DOUBLE", "NUMERIC", "DECIMAL", "CHAR", "VARCHAR", "LONG VARCHAR", "DATE", "TIME", "TIMESTAMP", "BINARY", "VARBINARY", "LONG VARBINARY", "NULL", "OTHER"});
    private static Integer OracleRefCursorInteger = new Integer(-10);

    public JDBCColumn(JDBCChannel jDBCChannel) {
        this._channel = jDBCChannel;
        this._column = -1;
        this._rs = null;
    }

    public JDBCColumn(EOAttribute eOAttribute, JDBCChannel jDBCChannel) {
        this(jDBCChannel);
        this.setAttribute(eOAttribute);
    }

    public JDBCColumn(EOAttribute eOAttribute, JDBCChannel jDBCChannel, int n, ResultSet resultSet) {
        this.setAttribute(eOAttribute);
        this._channel = jDBCChannel;
        this._column = n;
        this._rs = resultSet;
    }

    public void setStatement(PreparedStatement preparedStatement) {
        this._statement = preparedStatement;
    }

    private JDBCPlugIn _plugIn() {
        return ((JDBCAdaptor)this._channel.adaptorContext().adaptor()).plugIn();
    }

    protected void setAttribute(EOAttribute eOAttribute) {
        this._attribute = eOAttribute;
        this._adaptorValueType = this._attribute.adaptorValueType();
        this._customType = eOAttribute.valueFactoryMethod() != null;
        this._width = eOAttribute.width();
        String string = this._attribute.valueType();
        this._valueType = this._adaptorValueType == 0 ? (string == null ? this._valueTypeWhenNull() : string.charAt(0)) : (string == null || string.length() != 1 ? (char)32 : string.charAt(0));
    }

    private boolean _attributeIsBigDecimal(EOAttribute eOAttribute) {
        return eOAttribute.className().equals("java.math.BigDecimal");
    }

    private static BigDecimal _setScaleUpForAttribute(BigDecimal bigDecimal, EOAttribute eOAttribute) {
        int n = eOAttribute.scale();
        if (bigDecimal != null && bigDecimal.scale() < n) {
            bigDecimal = bigDecimal.setScale(n);
        }
        return bigDecimal;
    }

    private static BigDecimal _setScaleDownForAttribute(BigDecimal bigDecimal, EOAttribute eOAttribute) {
        int n = eOAttribute.scale();
        if (bigDecimal != null && bigDecimal.scale() > n) {
            try {
                bigDecimal = bigDecimal.setScale(n);
            }
            catch (ArithmeticException arithmeticException) {
                throw new JDBCAdaptorException("The attribute " + eOAttribute.name() + " has a scale of " + n + ", but the value " + bigDecimal + " has a scale of " + bigDecimal.scale() + ": " + arithmeticException.getMessage(), null);
            }
        }
        return bigDecimal;
    }

    private char _valueTypeWhenNull() {
        if (this._attribute.precision() > 0) {
            if (this._attribute.scale() > 0) {
                return 'B';
            }
            return 'l';
        }
        if (this._attributeIsBigDecimal(this._attribute)) {
            return 'B';
        }
        return 'i';
    }

    private Object _getStoredProcedureValue(CallableStatement callableStatement) throws SQLException {
        if (this._adaptorValueType == 1 && !this._customType) {
            return callableStatement.getString(this._column);
        }
        if (this._adaptorValueType == 3) {
            return callableStatement.getObject(this._column);
        }
        if (this._adaptorValueType == 0) {
            switch (this._valueType) {
                case 'c': {
                    return callableStatement.getBoolean(this._column) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 's': {
                    return new Short(callableStatement.getShort(this._column));
                }
                case 'i': {
                    return new Integer(callableStatement.getInt(this._column));
                }
                case 'l': {
                    return new Long(callableStatement.getLong(this._column));
                }
                case 'f': {
                    return new Float(callableStatement.getFloat(this._column));
                }
                case 'd': {
                    return new Double(callableStatement.getDouble(this._column));
                }
                case 'B': {
                    BigDecimal bigDecimal = callableStatement.getBigDecimal(this._column);
                    return JDBCColumn._setScaleUpForAttribute(bigDecimal, this._attribute);
                }
            }
            throw new IllegalStateException("value type " + this._valueType + " of attribute " + this._attribute.name() + " of stored procedure " + ((EOStoredProcedure)this._attribute.parent()).name() + " is invalid.");
        }
        if (this._adaptorValueType == 2) {
            byte[] byArray = callableStatement.getBytes(this._column);
            if (byArray == null) {
                return null;
            }
            return this._newValueForImmutableBytes(byArray);
        }
        if (this._customType) {
            String string = callableStatement.getString(this._column);
            if (string == null) {
                return null;
            }
            return string;
        }
        return callableStatement.getObject(this._column);
    }

    protected Object getStoredProcedureValue(EOAttribute eOAttribute, int n, CallableStatement callableStatement) {
        Object object;
        this.setAttribute(eOAttribute);
        this._column = n;
        try {
            object = this._getStoredProcedureValue(callableStatement);
            object = callableStatement.wasNull() || object == null ? NSKeyValueCoding.NullValue : this._processValueIfNeeded(object);
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        return object;
    }

    private Object _fetchText() throws SQLException {
        if (this._valueType == 'E') {
            byte[] byArray = this._rs.getBytes(this._column);
            return _NSStringUtilities.stringForBytes((byte[])byArray, (String)"UTF-8");
        }
        return this._rs.getString(this._column);
    }

    private Object _fetchCorrectObject(boolean bl) throws SQLException {
        if (this._adaptorValueType == 2 && this._attribute.externalType() != null && this._attribute.externalType().equals("BLOB")) {
            return this._plugIn().fetchBLOB(this._rs, this._column, this._attribute, bl);
        }
        if (this._adaptorValueType == 1 && this._attribute.externalType() != null && this._attribute.externalType().equals("CLOB")) {
            return this._plugIn().fetchCLOB(this._rs, this._column, this._attribute, bl);
        }
        if (this._adaptorValueType == 1 && !this._customType) {
            return this._fetchText();
        }
        if (this._adaptorValueType == 3) {
            switch (this._valueType) {
                case 'D': 
                case 'M': {
                    return this._rs.getDate(this._column);
                }
                case 't': {
                    return this._rs.getTime(this._column);
                }
                case 'T': {
                    return this._rs.getTimestamp(this._column);
                }
            }
            return this._rs.getObject(this._column);
        }
        if (this._adaptorValueType == 0) {
            switch (this._valueType) {
                case 'c': {
                    return this._rs.getBoolean(this._column) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 's': {
                    return new Short(this._rs.getShort(this._column));
                }
                case 'i': {
                    return new Integer(this._rs.getInt(this._column));
                }
                case 'l': {
                    return new Long(this._rs.getLong(this._column));
                }
                case 'f': {
                    return new Float(this._rs.getFloat(this._column));
                }
                case 'd': {
                    return new Double(this._rs.getDouble(this._column));
                }
                case 'b': {
                    return new Byte(this._rs.getByte(this._column));
                }
                case 'B': {
                    BigDecimal bigDecimal = this._rs.getBigDecimal(this._column);
                    return JDBCColumn._setScaleUpForAttribute(bigDecimal, this._attribute);
                }
            }
            throw new IllegalStateException("value type " + this._valueType + " of attribute " + this._attribute.name() + " of entity " + ((EOEntity)this._attribute.parent()).name() + " is invalid.");
        }
        if (this._adaptorValueType == 2) {
            byte[] byArray = this._rs.getBytes(this._column);
            if (byArray != null) {
                return this._newValueForImmutableBytes(byArray);
            }
            return null;
        }
        if (this._customType) {
            String string = (String)this._fetchText();
            if (string != null) {
                return this._newValueForString(string);
            }
            return null;
        }
        return this._rs.getObject(this._column);
    }

    private Object _processValueIfNeeded(Object object) {
        if (this._adaptorValueType == 3) {
            if (object instanceof Timestamp) {
                return new NSTimestamp((Timestamp)object);
            }
            if (object instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)object;
                return new NSTimestamp(date.getTime());
            }
            throw new JDBCAdaptorException(object + " of type " + object.getClass().getName() + " is not a valid Date type.  You must use java.sql.Timestamp, java.sql.Date, or java.sql.Time", null);
        }
        if (this._adaptorValueType != 0 || this._valueType == 'c') {
            // empty if block
        }
        return object;
    }

    public Object fetchValue() {
        return this._fetchValue(true);
    }

    Object _fetchValue(boolean bl) {
        Object object;
        if (this._rs == null || this._column < 1) {
            throw new JDBCAdaptorException(" *** JDBCColumn : trying to fetchValue on a null ResultSet [" + this._rs + "] or unknow col [" + this._column + "]!!", null);
        }
        try {
            object = this._fetchCorrectObject(bl);
            object = this._rs.wasNull() || object == null ? NSKeyValueCoding.NullValue : this._processValueIfNeeded(object);
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        return object;
    }

    public void connectToColumn(int n, ResultSet resultSet) {
        this._column = n;
        this._rs = resultSet;
    }

    private Integer _computeJdbcTypeForAttribute() {
        String string;
        Integer n;
        NSDictionary nSDictionary = (NSDictionary)((JDBCAdaptor)this._channel.adaptorContext().adaptor()).typeInfo().objectForKey((Object)this._attribute.externalType());
        if (nSDictionary == null) {
            return null;
        }
        NSArray nSArray = (NSArray)nSDictionary.objectForKey((Object)"defaultJDBCType");
        if (nSArray != null && nSArray.count() > 0 && (n = (Integer)_jdbcTypeDictionary.objectForKey((Object)(string = (String)nSArray.objectAtIndex(0)))) != null) {
            NSDictionary nSDictionary2 = this._attribute.userInfo();
            NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
            if (nSDictionary2 != null) {
                nSMutableDictionary.addEntriesFromDictionary((NSDictionary)nSMutableDictionary);
            }
            nSMutableDictionary.setObjectForKey((Object)n, (Object)"defaultJDBCType");
            this._attribute.setUserInfo((NSDictionary)nSMutableDictionary);
            return n;
        }
        return null;
    }

    private Integer _jdbcTypeValue() {
        Integer n = null;
        NSDictionary nSDictionary = this._attribute.userInfo();
        if (nSDictionary == null || (n = (Integer)nSDictionary.objectForKey((Object)"defaultJDBCType")) == null) {
            n = this._computeJdbcTypeForAttribute();
        }
        if (n == null && this._attribute.externalType().equalsIgnoreCase("REF CURSOR")) {
            n = OracleRefCursorInteger;
        }
        return n;
    }

    protected void registerAttributeForStoredProcedure() {
        switch (this._attribute.parameterDirection()) {
            case 2: 
            case 3: {
                Integer n = this._jdbcTypeValue();
                if (n != null) {
                    int n2 = n;
                    try {
                        if (n2 == 2 || n2 == 3) {
                            ((CallableStatement)this._statement).registerOutParameter(this._column, n2, this._attribute.scale());
                        }
                        ((CallableStatement)this._statement).registerOutParameter(this._column, n2);
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new JDBCAdaptorException(sQLException);
                    }
                }
                throw new JDBCAdaptorException("Unable to determine JDBC type for attribute '" + this._attribute.name() + "' when preparing ouput paramater for stored procedure.", null);
            }
        }
    }

    public void bindAttributeForColumn(int n, PreparedStatement preparedStatement) {
        this._column = n;
        this._statement = preparedStatement;
    }

    private int _varcharMaxLength() {
        JDBCAdaptor jDBCAdaptor = (JDBCAdaptor)this._channel.adaptorContext().adaptor();
        return jDBCAdaptor.varcharMaxLength();
    }

    public void takeInputValue(Object object, int n, boolean bl) {
        block46: {
            this._column = n;
            if (bl) {
                this.registerAttributeForStoredProcedure();
            }
            try {
                if (object == NSKeyValueCoding.NullValue || object == null) {
                    Integer n2 = this._jdbcTypeValue();
                    if (n2 == null) {
                        throw new JDBCAdaptorException("Unable to determine JDBC type for sending a null value for attribute " + this._attribute.name(), null);
                    }
                    this._statement.setNull(this._column, n2);
                    return;
                }
                if (this._customType) {
                    object = this._attribute.adaptorValueByConvertingAttributeValue(object);
                }
                if (this._adaptorValueType == 1) {
                    if (object instanceof String) {
                        String string = (String)object;
                        int n3 = string.length();
                        switch (this._valueType) {
                            case 'S': {
                                this._statement.setString(this._column, string);
                                break;
                            }
                            case 'E': {
                                byte[] byArray = _NSStringUtilities.bytesForString((String)string, (String)"UTF-8");
                                this._statement.setBinaryStream(this._column, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                                break;
                            }
                            case 'C': {
                                this._statement.setCharacterStream(this._column, (Reader)new StringReader(string), n3);
                                break;
                            }
                            default: {
                                if (n3 <= this._varcharMaxLength()) {
                                    this._statement.setString(this._column, string);
                                    break;
                                }
                                this._statement.setCharacterStream(this._column, (Reader)new StringReader(string), n3);
                                break;
                            }
                        }
                    } else {
                        throw new IllegalArgumentException("Object value '" + object + "' for column " + this._column + " is not an instanceof String.");
                    }
                    return;
                }
                if (this._adaptorValueType == 3) {
                    Timestamp timestamp = null;
                    if (object instanceof Timestamp) {
                        timestamp = (Timestamp)object;
                    } else if (object instanceof java.util.Date) {
                        timestamp = new Timestamp(((java.util.Date)object).getTime());
                    } else {
                        throw new JDBCAdaptorException(" ** Error JDBCColumn for setting date type for " + object + "- class = " + object.getClass(), null);
                    }
                    switch (this._valueType) {
                        case 'M': {
                            this._statement.setDate(this._column, new Date(timestamp.getTime()));
                            break;
                        }
                        case 'D': {
                            this._statement.setObject(this._column, (Object)timestamp, 91);
                            break;
                        }
                        case 't': {
                            this._statement.setObject(this._column, (Object)timestamp, 92);
                            break;
                        }
                        case 'T': {
                            this._statement.setObject(this._column, (Object)timestamp, 93);
                            break;
                        }
                        default: {
                            this._statement.setObject(this._column, timestamp);
                        }
                    }
                    return;
                }
                if (this._adaptorValueType == 0) {
                    if (object instanceof Number) {
                        switch (this._valueType) {
                            case 'l': {
                                this._statement.setLong(this._column, ((Number)object).longValue());
                                break;
                            }
                            case 'i': {
                                this._statement.setInt(this._column, ((Number)object).intValue());
                                break;
                            }
                            case 's': {
                                this._statement.setShort(this._column, ((Number)object).shortValue());
                                break;
                            }
                            case 'f': {
                                this._statement.setFloat(this._column, ((Number)object).floatValue());
                                break;
                            }
                            case 'd': {
                                this._statement.setDouble(this._column, ((Number)object).doubleValue());
                                break;
                            }
                            case 'c': {
                                this._statement.setBoolean(this._column, ((Number)object).intValue() == 1);
                                break;
                            }
                            case 'b': {
                                this._statement.setByte(this._column, ((Number)object).byteValue());
                                break;
                            }
                            case 'B': {
                                BigDecimal bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : (BigDecimal)_NSUtilities.convertNumberIntoCompatibleValue((Number)((Number)object), (Class)_NSUtilities._BigDecimalClass);
                                this._statement.setBigDecimal(this._column, JDBCColumn._setScaleDownForAttribute(bigDecimal, this._attribute));
                                break;
                            }
                            default: {
                                throw new JDBCAdaptorException("Unable to determine the valueType for attribute " + this._attribute.name(), null);
                            }
                        }
                        return;
                    }
                    if (object instanceof Boolean) {
                        this._statement.setBoolean(this._column, (Boolean)object);
                        return;
                    }
                    if (object instanceof String) {
                        throw new JDBCAdaptorException("The attribute " + this._attribute.name() + " should be assigned a Number, but the value was the String " + '\"' + object + '\"', null);
                    }
                    break block46;
                }
                if (this._adaptorValueType == 2) {
                    if (!this._customType) {
                        object = this._attribute.adaptorValueByConvertingAttributeValue(object);
                    }
                    byte[] byArray = null;
                    if (object instanceof String) {
                        byArray = _NSStringUtilities.bytesForString((String)((String)object));
                    } else {
                        if (!(object instanceof NSData)) {
                            throw new JDBCAdaptorException("Unable to create a byte representation for class \"" + object.getClass().getName() + "\"", null);
                        }
                        NSData nSData = (NSData)object;
                        byArray = nSData.bytes(0, nSData.length());
                    }
                    if (this._width > 0 && byArray.length > this._width) {
                        throw new JDBCAdaptorException("Unable to take the input value: " + object + " for attribute \"" + this._attribute.name() + "\" because the length of the value (" + byArray.length + ") exceeds the externalSize of the attribute (" + this._width + ")", null);
                    }
                    this._statement.setBinaryStream(this._column, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                    return;
                }
                throw new JDBCAdaptorException("Unable to determine JDBC setXXX method for attribute : " + this._attribute.name(), null);
            }
            catch (SQLException sQLException) {
                throw new JDBCAdaptorException(sQLException);
            }
        }
    }

    private Object _newValueForBytes(byte[] byArray, int n) {
        return this._newValueForImmutableBytes(byArray);
    }

    private Object _newValueForBytesString(byte[] byArray, int n) {
        String string = _NSStringUtilities.stringForBytes((byte[])byArray);
        return this._newValueForString(string);
    }

    private Object _newValueForImmutableBytes(byte[] byArray) {
        return this._attribute.newValueForImmutableBytes(byArray);
    }

    private Object _newValueForString(String string) {
        return this._attribute.newValueForString(string);
    }
}

