/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCChannel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCContext
extends EOAdaptorContext {
    public static final String DBMSNameKey = "DBMS_NAME";
    public static final String DriverNameKey = "DRIVER_NAME";
    public static final String DriverVersionKey = "DRIVER_VER";
    public static final String StringFunctionsKey = "STRING_FUNCTIONS";
    public static final String IdentifierQuoteStringKey = "IDENTIFIER_QUOTE_STRING";
    public static final String NonNullableColumnsKey = "NON_NULLABLE_COLUMNS";
    public static final String ANSI92ConformanceKey = "ANSI92_CONFORMANCE";
    public static final String ANSIFullConformance = "ANSI92Full";
    public static final String ANSIIntermediateConformance = "ANSI92Intermediate";
    public static final String ANSIEntryConformance = "ANSI92EntryLevel";
    public static final String DefaultJDBCTypeKey = "defaultJDBCType";
    public static final String PrecisionKey = "precision";
    public static final String MinScaleKey = "minScale";
    public static final String MaxScaleKey = "maxScale";
    public static final String NullableKey = "isNullable";
    public static final String SearchableKey = "isSearchable";
    public static final String CreateParamsKey = "createParams";
    public static final String InternalTypeKey = "internalType";
    static final String _DBAccess = "ACCESS";
    static final String _DBMSSQLserver = "Microsoft SQL Server";
    static final String _DBJDBC_ODBC_Bridge = "JDBC-ODBC Bridge (odbcjt32.dll)";
    protected Connection _jdbcConnection;
    protected JDBCChannel _cachedChannel;
    private int _fetchesInProgress = 0;
    private int _openChannelCount = 0;
    private NSArray _statementsToExecute;
    protected boolean _connectionSupportTransaction;
    private String _dataSourceJndiName;

    private void _appendSQLExceptionToBuffer(StringBuffer stringBuffer, SQLException sQLException) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append("\n    Next exception:");
        }
        if (sQLException instanceof SQLWarning) {
            stringBuffer.append("SQL Warning:");
        } else {
            stringBuffer.append("SQL State:");
        }
        stringBuffer.append(sQLException.getSQLState());
        stringBuffer.append(" -- error code: " + sQLException.getErrorCode());
        stringBuffer.append(" -- msg: " + sQLException.getMessage());
    }

    void _jdbcErrorWithChannel(JDBCChannel jDBCChannel, SQLException sQLException, boolean bl, String string) {
        SQLException sQLException2;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string);
        stringBuffer.append(':');
        if (sQLException != null) {
            this._appendSQLExceptionToBuffer(stringBuffer, sQLException);
            for (sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
                this._appendSQLExceptionToBuffer(stringBuffer, sQLException2);
            }
        }
        try {
            sQLException2 = this._jdbcConnection != null ? this._jdbcConnection.getWarnings() : null;
        }
        catch (SQLException sQLException3) {
            sQLException2 = null;
        }
        while (sQLException2 != null) {
            this._appendSQLExceptionToBuffer(stringBuffer, sQLException2);
            sQLException2 = ((SQLWarning)sQLException2).getNextWarning();
        }
        if (bl) {
            throw new JDBCAdaptorException(new String(stringBuffer), sQLException);
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
            NSLog.debug.appendln((Object)new String(stringBuffer));
        }
    }

    public JDBCContext(EOAdaptor eOAdaptor) {
        super(eOAdaptor);
    }

    protected void _setAutoCommit(boolean bl) {
        if (this._connectionSupportTransaction) {
            try {
                if (!this._jdbcConnection.getAutoCommit()) {
                    this._jdbcConnection.rollback();
                }
                this._jdbcConnection.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                throw new JDBCAdaptorException(sQLException);
            }
        }
    }

    public boolean connect() throws JDBCAdaptorException {
        JDBCAdaptor jDBCAdaptor = (JDBCAdaptor)this.adaptor();
        this.setupJndiConfiguration();
        try {
            Object object;
            Object object2;
            Object object3;
            if (this._dataSourceJndiName != null) {
                object3 = (DataSource)new InitialContext().lookup(this._dataSourceJndiName);
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                    NSLog.debug.appendln((Object)(" connecting to data source " + object3 + " at " + this._dataSourceJndiName));
                }
                this._jdbcConnection = object3.getConnection();
            } else {
                object3 = jDBCAdaptor.driverName();
                if (object3 != null && ((String)object3).length() > 0 && (object2 = _NSUtilities.classWithName((String)object3)) == null) {
                    throw new JDBCAdaptorException("JDBC connection failed for driver :'" + jDBCAdaptor.driverName() + "'. Driver not found in Java Runtime! Please verify your CLASSPATH environment variable. The current CLASSPATH for your application is : " + System.getProperty("java.class.path"), null);
                }
                object2 = jDBCAdaptor.connectionURL();
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                    object = new NSMutableDictionary(jDBCAdaptor.connectionDictionary());
                    object.setObjectForKey(object2, (Object)"URL");
                    object.setObjectForKey((Object)"<password deleted for log>", (Object)"password");
                    object.removeObjectForKey((Object)"jdbc2Info");
                    NSLog.debug.appendln((Object)(" connecting with dictionary: " + object));
                }
                object = jDBCAdaptor.connectionProperties();
                this._jdbcConnection = DriverManager.getConnection((String)object2, (Properties)object);
            }
            this._connectionSupportTransaction = this._jdbcConnection.getTransactionIsolation() != 0;
            this._setAutoCommit(false);
            if (this._statementsToExecute != null) {
                ResultSet resultSet;
                object = this._jdbcConnection.createStatement();
                object3 = this._statementsToExecute.objectEnumerator();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                        NSLog.debug.appendln((Object)("configure JDBC connection with statement <\"" + (String)object2 + "\">"));
                    }
                    if ((resultSet = object.executeQuery((String)object2)) != null) {
                        while (resultSet.next()) {
                        }
                        resultSet.close();
                    }
                    object.clearWarnings();
                }
                object.close();
                object = null;
                resultSet = null;
                if (this._connectionSupportTransaction) {
                    this._jdbcConnection.commit();
                }
                this._jdbcConnection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            if (!jDBCAdaptor.plugIn()._couldIgnoreException(sQLException)) {
                throw new JDBCAdaptorException(sQLException);
            }
        }
        catch (NamingException namingException) {
            throw new JDBCAdaptorException("Data source getConnection() failed for " + this._dataSourceJndiName + ":" + namingException.getMessage(), null);
        }
        return true;
    }

    public void setupJndiConfiguration() throws JDBCAdaptorException {
        JDBCAdaptor jDBCAdaptor = (JDBCAdaptor)this.adaptor();
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            initialContext.lookup("java:comp");
        }
        catch (NamingException namingException) {
            initialContext = null;
        }
        if (initialContext != null) {
            try {
                String string = (String)jDBCAdaptor.connectionDictionary().objectForKey((Object)"DataSourceJndiName");
                string = "java:comp/env/wo/dsmapping/" + string;
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                    NSLog.debug.appendln((Object)("Trying mapping at " + string));
                }
                this._dataSourceJndiName = (String)initialContext.lookup(string);
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                    NSLog.debug.appendln((Object)("Using data source at " + this._dataSourceJndiName));
                }
            }
            catch (NamingException namingException) {
                try {
                    NamingEnumeration<NameClassPair> namingEnumeration = initialContext.list("java:comp/env/jdbc");
                    while (namingEnumeration.hasMore()) {
                        NameClassPair nameClassPair = namingEnumeration.next();
                        String string = nameClassPair.isRelative() ? "java:comp/env/jdbc/" + nameClassPair.getName() : nameClassPair.getName();
                        Object object = initialContext.lookup(string);
                        if (!(object instanceof DataSource)) continue;
                        if (this._dataSourceJndiName != null && !initialContext.lookup(string).equals(initialContext.lookup(this._dataSourceJndiName))) {
                            NSLog.debug.appendln((Object)"Found multiple data sources. Please map the EOModels to a data source explicitly!");
                            throw new JDBCAdaptorException("Found multiple data sources. Please map the EOModels to a data source explicitly!", null);
                        }
                        this._dataSourceJndiName = string;
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) continue;
                        NSLog.debug.appendln((Object)("Found data source " + this._dataSourceJndiName));
                    }
                }
                catch (NamingException namingException2) {
                    NSLog.debug.appendln((Throwable)namingException2);
                }
            }
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)65536L)) {
            if (this._dataSourceJndiName == null) {
                NSLog.debug.appendln((Object)"Didn't find any JNDI data source.");
            } else {
                NSLog.debug.appendln((Object)("Setting JNDI DS to " + this._dataSourceJndiName));
            }
        }
    }

    void _tryConnect() throws JDBCAdaptorException {
        try {
            if (this._jdbcConnection != null && !this._jdbcConnection.isClosed()) {
                return;
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        if (this._delegateRespondsTo_shouldConnect && !this._delegate.booleanPerform("adaptorContextShouldConnect", (Object)this)) {
            return;
        }
        this.connect();
    }

    public void disconnect() throws JDBCAdaptorException {
        try {
            if (this._jdbcConnection == null || this._jdbcConnection.isClosed()) {
                return;
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        try {
            this._jdbcConnection.close();
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        finally {
            this._jdbcConnection = null;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
            NSLog.debug.appendln((Object)"connection disconnected.");
        }
    }

    protected JDBCChannel _cachedAdaptorChannel() {
        if (this._cachedChannel == null) {
            this._cachedChannel = new JDBCChannel(this);
        }
        return this._cachedChannel;
    }

    public EOAdaptorChannel createAdaptorChannel() {
        if (this._cachedChannel != null) {
            JDBCChannel jDBCChannel = this._cachedChannel;
            this._cachedChannel = null;
            return jDBCChannel;
        }
        return new JDBCChannel(this);
    }

    public void beginTransaction() {
        try {
            if (this._jdbcConnection != null && this._jdbcConnection.isClosed()) {
                throw new JDBCAdaptorException(new SQLException("Apparent disconnection", "08003"));
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        if (this.hasOpenTransaction()) {
            return;
        }
        if (this._delegateRespondsTo_shouldBegin && !this._delegate.booleanPerform("adaptorContextShouldBegin", (Object)this)) {
            return;
        }
        this.transactionDidBegin();
        if (this._delegateRespondsTo_didBegin) {
            this._delegate.perform("adaptorContextDidBegin", (Object)this);
        }
    }

    public void commitTransaction() {
        block7: {
            if (!this.hasOpenTransaction()) {
                return;
            }
            if (this._fetchesInProgress > 0) {
                throw new JDBCAdaptorException("Attempted to commit a transaction while a fetch was in progress", null);
            }
            if (this._delegateRespondsTo_shouldCommit && !this._delegate.booleanPerform("adaptorContextShouldCommit", (Object)this)) {
                return;
            }
            try {
                if (this._connectionSupportTransaction) {
                    this._jdbcConnection.commit();
                }
            }
            catch (SQLException sQLException) {
                if (((JDBCAdaptor)this.adaptor()).plugIn()._couldIgnoreException(sQLException)) break block7;
                throw new JDBCAdaptorException(sQLException);
            }
        }
        this.transactionDidCommit();
        if (this._delegateRespondsTo_didCommit) {
            this._delegate.perform("adaptorContextDidCommit", (Object)this);
        }
    }

    public void rollbackTransaction() {
        if (!this.hasOpenTransaction()) {
            return;
        }
        if (this._fetchesInProgress > 0) {
            throw new JDBCAdaptorException("Cannot rollbackTransaction() while a fetch is in progress", null);
        }
        if (this._delegateRespondsTo_shouldRollback && !this._delegate.booleanPerform("adaptorContextShouldRollback", (Object)this)) {
            return;
        }
        try {
            if (this._connectionSupportTransaction) {
                this._jdbcConnection.rollback();
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        this.transactionDidRollback();
        if (this._delegateRespondsTo_didRollback) {
            this._delegate.perform("adaptorContextDidRollback", (Object)this);
        }
    }

    void _channelWillOpen() {
        if (this._openChannelCount == 0) {
            this._tryConnect();
        }
        ++this._openChannelCount;
    }

    void _channelDidClose() {
        if (this._openChannelCount > 0) {
            --this._openChannelCount;
        }
        if (this._openChannelCount == 0) {
            this.disconnect();
        }
    }

    void _channelWillBeginFetching() {
        ++this._fetchesInProgress;
    }

    void _channelDidEndFetching() {
        --this._fetchesInProgress;
    }

    public Connection connection() {
        return this._jdbcConnection;
    }

    void _setJdbcConnection(Connection connection) {
        this._jdbcConnection = connection;
    }

    String _externalTypeInModel(int n) {
        String string = null;
        String string2 = JDBCAdaptor.stringRepresentationForJDBCType(n);
        NSDictionary nSDictionary = ((JDBCAdaptor)this.adaptor()).typeInfo();
        if (nSDictionary != null) {
            NSArray nSArray = nSDictionary.allKeys();
            int n2 = nSArray.count();
            block2: for (int i = 0; i < n2; ++i) {
                String string3 = (String)nSArray.objectAtIndex(i);
                NSDictionary nSDictionary2 = (NSDictionary)nSDictionary.objectForKey((Object)string3);
                NSArray nSArray2 = (NSArray)nSDictionary2.objectForKey((Object)DefaultJDBCTypeKey);
                int n3 = nSArray2.count();
                for (int j = 0; j < n3; ++j) {
                    String string4 = (String)nSArray2.objectAtIndex(j);
                    if (!string4.equals(string2)) continue;
                    string = string3;
                    continue block2;
                }
            }
        }
        if (string == null) {
            try {
                ResultSet resultSet = this._jdbcConnection.getMetaData().getTypeInfo();
                while (string == null && resultSet.next()) {
                    int n4 = resultSet.getInt(2);
                    if (n4 != n) continue;
                    string = resultSet.getString(1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string;
    }

    NSDictionary _fetchJDBCInfo() throws JDBCAdaptorException {
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        NSMutableDictionary nSMutableDictionary2 = new NSMutableDictionary();
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
            NSLog.debug.appendln((Object)("fetching JDBC Info with " + _NSUtilities.shortClassName((Object)((Object)this)) + "@" + System.identityHashCode((Object)this)));
        }
        this._tryConnect();
        try {
            DatabaseMetaData databaseMetaData = this._jdbcConnection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            if (string != null) {
                nSMutableDictionary.setObjectForKey((Object)string, (Object)DBMSNameKey);
            }
            if ((string = databaseMetaData.getDriverName()) != null) {
                nSMutableDictionary.setObjectForKey((Object)string, (Object)DriverNameKey);
            }
            if ((string = databaseMetaData.getDriverVersion()) != null) {
                nSMutableDictionary.setObjectForKey((Object)string, (Object)DriverVersionKey);
            }
            if (databaseMetaData.supportsANSI92FullSQL()) {
                nSMutableDictionary.setObjectForKey((Object)ANSIFullConformance, (Object)ANSI92ConformanceKey);
            } else if (databaseMetaData.supportsANSI92IntermediateSQL()) {
                nSMutableDictionary.setObjectForKey((Object)ANSIIntermediateConformance, (Object)ANSI92ConformanceKey);
            } else {
                nSMutableDictionary.setObjectForKey((Object)ANSIEntryConformance, (Object)ANSI92ConformanceKey);
            }
            string = databaseMetaData.getIdentifierQuoteString();
            if (string != null) {
                nSMutableDictionary.setObjectForKey((Object)string, (Object)IdentifierQuoteStringKey);
            }
            if ((string = databaseMetaData.getStringFunctions()) != null) {
                nSMutableDictionary.setObjectForKey((Object)string, (Object)StringFunctionsKey);
            }
            if (databaseMetaData.supportsNonNullableColumns()) {
                nSMutableDictionary.setObjectForKey((Object)"T", (Object)NonNullableColumnsKey);
            }
            ResultSet resultSet = databaseMetaData.getTypeInfo();
            while (resultSet.next()) {
                int n;
                int n2;
                String string2;
                String string3 = resultSet.getString(1).trim();
                NSMutableDictionary nSMutableDictionary3 = new NSMutableDictionary();
                short s = resultSet.getShort(2);
                String string4 = JDBCAdaptor.stringRepresentationForJDBCType(s);
                nSMutableDictionary3.setObjectForKey((Object)new NSMutableArray((Object)string4), (Object)DefaultJDBCTypeKey);
                long l = resultSet.getLong(3);
                if (!resultSet.wasNull()) {
                    if (l > Integer.MAX_VALUE) {
                        l = Integer.MAX_VALUE;
                    }
                    nSMutableDictionary3.setObjectForKey((Object)String.valueOf(l), (Object)PrecisionKey);
                }
                short s2 = resultSet.getShort(14);
                if (!resultSet.wasNull()) {
                    nSMutableDictionary3.setObjectForKey((Object)String.valueOf(s2), (Object)MinScaleKey);
                }
                short s3 = resultSet.getShort(15);
                if (!resultSet.wasNull()) {
                    nSMutableDictionary3.setObjectForKey((Object)String.valueOf(s3), (Object)MaxScaleKey);
                }
                int n3 = resultSet.getInt(7);
                if (!resultSet.wasNull()) {
                    nSMutableDictionary3.setObjectForKey((Object)(n3 == 1 ? "T" : "F"), (Object)NullableKey);
                }
                short s4 = resultSet.getShort(9);
                if (!resultSet.wasNull()) {
                    nSMutableDictionary3.setObjectForKey((Object)(s4 == 3 || s4 == 2 ? "T" : "F"), (Object)SearchableKey);
                }
                int n4 = (string2 = resultSet.getString(6)) == null ? 0 : NSArray.componentsSeparatedByString((String)string2, (String)",").count();
                switch (s) {
                    case 1: 
                    case 12: {
                        if (n4 == 1) break;
                        n4 = 1;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (n4 == 2) break;
                        n4 = 2;
                        break;
                    }
                }
                nSMutableDictionary3.setObjectForKey((Object)String.valueOf(n4), (Object)CreateParamsKey);
                NSMutableDictionary nSMutableDictionary4 = (NSMutableDictionary)nSMutableDictionary2.objectForKey((Object)string3);
                if (nSMutableDictionary4 == null) {
                    nSMutableDictionary2.setObjectForKey((Object)nSMutableDictionary3, (Object)string3);
                    continue;
                }
                ((NSMutableArray)nSMutableDictionary4.objectForKey((Object)DefaultJDBCTypeKey)).addObject((Object)string4);
                try {
                    n2 = Integer.parseInt((String)nSMutableDictionary4.objectForKey((Object)CreateParamsKey));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                if (n4 > n2) {
                    nSMutableDictionary4.setObjectForKey((Object)String.valueOf(n4), (Object)CreateParamsKey);
                }
                try {
                    n = Integer.parseInt((String)nSMutableDictionary4.objectForKey((Object)PrecisionKey));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (l <= (long)n) continue;
                nSMutableDictionary4.setObjectForKey((Object)String.valueOf(l), (Object)PrecisionKey);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        nSMutableDictionary.setObjectForKey((Object)nSMutableDictionary2, (Object)"typeInfo");
        return nSMutableDictionary;
    }

    public void handleDroppedConnection() {
        try {
            this.disconnect();
        }
        catch (JDBCAdaptorException jDBCAdaptorException) {
            // empty catch block
        }
        this._jdbcConnection = null;
    }

    static {
        block6: {
            boolean bl = NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)65536L);
            try {
                if (bl) {
                    if (NSLog.debug instanceof NSLog.PrintStreamLogger) {
                        NSLog.PrintStreamLogger printStreamLogger = (NSLog.PrintStreamLogger)NSLog.debug;
                        DriverManager.setLogStream(printStreamLogger.printStream());
                    } else {
                        DriverManager.setLogStream(System.out);
                    }
                } else {
                    DriverManager.setLogStream(null);
                }
            }
            catch (Throwable throwable) {
                if (!bl) break block6;
                NSLog.err.appendln((Object)"JDBCContext: unable to set log stream of driver");
                NSLog.err.appendln(throwable);
            }
        }
    }
}

