/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCPlugIn;

public class SybasePlugIn
extends JDBCPlugIn {
    private static final String DriverClassName = "com.sybase.jdbc2.jdbc.SybDriver";
    private static final String DriverProductName = "Sybase";

    public SybasePlugIn(JDBCAdaptor jDBCAdaptor) {
        super(jDBCAdaptor);
    }

    public String defaultDriverName() {
        return DriverClassName;
    }

    public String databaseProductName() {
        return DriverProductName;
    }

    public Class defaultExpressionClass() {
        return SybaseExpression.class;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new SybaseSynchronizationFactory(this._adaptor);
    }

    public NSDictionary jdbcInfo() {
        boolean bl = NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L);
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary(super.jdbcInfo());
        NSMutableDictionary nSMutableDictionary2 = new NSMutableDictionary((NSDictionary)nSMutableDictionary.objectForKey((Object)"typeInfo"));
        nSMutableDictionary2.removeObjectForKey((Object)"bigint identity");
        nSMutableDictionary2.removeObjectForKey((Object)"decimal() identity");
        nSMutableDictionary2.removeObjectForKey((Object)"int identity");
        nSMutableDictionary2.removeObjectForKey((Object)"numeric() identity");
        nSMutableDictionary2.removeObjectForKey((Object)"nchar");
        nSMutableDictionary2.removeObjectForKey((Object)"ntext");
        nSMutableDictionary2.removeObjectForKey((Object)"nvarchar");
        nSMutableDictionary2.removeObjectForKey((Object)"smallint identity");
        nSMutableDictionary2.removeObjectForKey((Object)"tinyint identity");
        nSMutableDictionary.setObjectForKey((Object)nSMutableDictionary2, (Object)"typeInfo");
        if (bl) {
            NSLog.debug.appendln((Object)("fetched Sybase (" + this.databaseProductName() + ") JDBC Info = " + nSMutableDictionary));
        }
        return nSMutableDictionary;
    }

    public String newPrimaryKeySelectString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SELECT PK FROM ");
        stringBuffer.append(string);
        stringBuffer.append(" HOLDLOCK WHERE NAME = '");
        stringBuffer.append(string2);
        stringBuffer.append("'");
        return new String(stringBuffer);
    }

    public String primaryKeyLockString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("UPDATE ");
        stringBuffer.append(string);
        stringBuffer.append(" SET PK = PK WHERE NAME = '");
        stringBuffer.append(string2);
        stringBuffer.append("'");
        return new String(stringBuffer);
    }

    public static class SybaseExpression
    extends JDBCExpression {
        public SybaseExpression(EOEntity eOEntity) {
            super(eOEntity);
        }

        public String allowsNullClauseForConstraint(boolean bl) {
            String string = super.allowsNullClauseForConstraint(bl);
            if (string.equals("")) {
                return "NULL";
            }
            return string;
        }

        public String lockClause() {
            return "HOLDLOCK";
        }

        public String assembleSelectStatementWithAttributes(NSArray nSArray, boolean bl, EOQualifier eOQualifier, NSArray nSArray2, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            int n = string.length() + string2.length() + string3.length() + 7;
            if (string7 != null && string7.length() != 0) {
                n += string7.length() + 1;
            }
            if (string4 != null && string4.length() != 0) {
                n += string4.length() + 7;
            }
            if (string5 != null && string5.length() != 0) {
                n += string5.length() + 7;
            }
            if (string6 != null && string6.length() != 0) {
                n += string6.length() + 10;
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(" FROM ");
            stringBuffer.append(string3);
            if (string7 != null && string7.length() != 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string7);
            }
            if (string4 != null && string4.length() != 0) {
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string4);
            }
            if (string5 != null && string5.length() != 0) {
                if (string4 != null && string4.length() != 0) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" WHERE ");
                }
                stringBuffer.append(string5);
            }
            if (string6 != null && string6.length() != 0) {
                stringBuffer.append(" ORDER BY ");
                stringBuffer.append(string6);
            }
            return new String(stringBuffer);
        }
    }

    public static class SybaseSynchronizationFactory
    extends EOSynchronizationFactory {
        public SybaseSynchronizationFactory(EOAdaptor eOAdaptor) {
            super(eOAdaptor);
        }

        public NSArray primaryKeySupportStatementsForEntityGroups(NSArray nSArray) {
            String string = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            NSMutableArray nSMutableArray = new NSMutableArray();
            nSMutableArray.addObject((Object)this._expressionForString("CREATE TABLE " + string + " (NAME CHAR(40) NOT NULL PRIMARY KEY, PK INT)"));
            return nSMutableArray;
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray nSArray) {
            return new NSArray((Object)this._expressionForString("DROP TABLE " + ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName()));
        }

        public NSArray _statementsToDeleteTableNamedOptions(String string, NSDictionary nSDictionary) {
            return new NSArray((Object)this._expressionForString("DROP TABLE " + string));
        }

        public NSArray dropTableStatementsForEntityGroup(NSArray nSArray) {
            if (nSArray == null) {
                return NSArray.EmptyArray;
            }
            EOSQLExpression eOSQLExpression = this._expressionForString("DROP TABLE " + ((EOEntity)nSArray.objectAtIndex(0)).externalName());
            return new NSArray((Object)eOSQLExpression);
        }

        public boolean supportsSchemaSynchronization() {
            return false;
        }

        public NSArray _statementsToDropPrimaryKeyConstraintsOnTableNamed(String string) {
            return NSArray.EmptyArray;
        }

        public NSArray statementsToRenameTableNamed(String string, String string2, NSDictionary nSDictionary) {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if ((n = string2.lastIndexOf(46)) != -1) {
                string2 = string2.substring(n + 1);
            }
            return new NSArray((Object)this._expressionForString("execute sp_rename " + string + ", " + string2));
        }
    }
}

