/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.util.ArrayList;
import org.walluck.oscar.AIMUtil;

public class AIMFingerPrintInfo {
    private static ArrayList fingerprints = new ArrayList(5);
    private int clientId;
    private byte[] data;

    public AIMFingerPrintInfo() {
    }

    public AIMFingerPrintInfo(int clientId, byte[] data) {
        this.clientId = clientId;
        this.data = data;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean equals(Object obj) {
        AIMFingerPrintInfo fp = (AIMFingerPrintInfo)obj;
        byte[] data1 = this.data;
        byte[] data2 = fp.getData();
        if (data1 != null && data2 == null || data1 == null && data2 != null) {
            return false;
        }
        int length1 = data1.length;
        int length2 = data2.length;
        if (length1 != length2) {
            return false;
        }
        for (int i = 0; i < length1; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return AIMUtil.byteArrayToHexString(this.data).hashCode();
    }

    public static byte[] getFingerPrintData(int clientId) {
        int size = fingerprints.size();
        if (clientId < 1 || clientId > size) {
            throw new IllegalArgumentException("invalid clientId=" + clientId);
        }
        return ((AIMFingerPrintInfo)fingerprints.get(clientId - 1)).getData();
    }

    public static int getFingerPrintId(byte[] data) {
        AIMFingerPrintInfo fp = new AIMFingerPrintInfo();
        fp.setData(data);
        int size = fingerprints.size();
        for (int i = 0; i < size; ++i) {
            AIMFingerPrintInfo fp2 = (AIMFingerPrintInfo)fingerprints.get(i);
            if (!fp.equals(fp2)) continue;
            return fp2.getClientId();
        }
        return 0;
    }

    static {
        fingerprints.add(new AIMFingerPrintInfo(1, new byte[]{1, 1, 1}));
        fingerprints.add(new AIMFingerPrintInfo(2, new byte[]{1, 1, 2}));
        fingerprints.add(new AIMFingerPrintInfo(3, new byte[]{1, 1, 1, 2}));
        fingerprints.add(new AIMFingerPrintInfo(4, new byte[]{1}));
        fingerprints.add(new AIMFingerPrintInfo(5, new byte[]{1, 6}));
    }
}

