/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.channel.rendezvous;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.Chat;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.rendezvous.Rendezvous;
import org.walluck.oscar.handlers.SNACHandler;

public class ChatRendezvous
extends Rendezvous {
    private static final Logger LOG = Logger.getLogger((String)ChatRendezvous.class.getName());
    private Chat chat;
    private String charset;
    private String language;
    private String msg;

    public ChatRendezvous() {
        this.setService(8);
    }

    public Chat getChat() {
        return this.chat;
    }

    public void setChat(Chat chat) {
        this.chat = chat;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setRequest() throws IOException {
        TLVChain tlvchain = new TLVChain(6);
        if (this.charset != null) {
            tlvchain.addString(13, this.charset);
        }
        if (this.language != null) {
            tlvchain.addString(14, this.language);
        }
        tlvchain.addShort(10, 1);
        tlvchain.addNull(15);
        if (this.msg != null) {
            tlvchain.addString(12, this.msg);
        }
        tlvchain.addChatRoom(10001, this.chat);
        this.setType(0);
        this.setServiceData(tlvchain);
    }

    public void handleServiceData(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, UserInfo userinfo, IncomingIMCH2 args, AIMInputStream buffer) throws IOException {
        LOG.debug((Object)(userinfo.getSN() + " has asked us to join a chat with them"));
        args.getInfo().getChat().setRoomInfo(buffer.readRoomInfo());
    }
}

