/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.channel.rendezvous;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.rendezvous.Rendezvous;
import org.walluck.oscar.handlers.SNACHandler;

public class TrillianSecureIMRendezvous
extends Rendezvous {
    private static final Logger LOG = Logger.getLogger((String)TrillianSecureIMRendezvous.class.getName());
    public static final int VERSION = 1;
    public static final int TLV_TYPE_VERSION = 999;
    public static final int TLV_TYPE_CMDTYPE = 1000;
    public static final int TLV_TYPE_PRIME = 1001;
    public static final int TLV_TYPE_PUBLICVALUE_REQUEST = 1002;
    public static final int TLV_TYPE_PUBLICVALUE_ACCEPT = 1003;
    public static final int TLV_TYPE_MESSAGE = 1010;
    public static final int CMDTYPE_REQUEST = 0;
    public static final int CMDTYPE_ACCEPT = 1;
    public static final int CMDTYPE_BEGIN = 2;
    public static final int CMDTYPE_MESSAGE = 3;
    public static final int CMDTYPE_CLOSE = 4;
    private int version = 1;
    private int cmdType;
    private BigInteger prime;
    private BigInteger publicValue;
    private byte[] msg;

    public TrillianSecureIMRendezvous() {
        this.setService(65536);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCmdType() {
        return this.cmdType;
    }

    public void setCmdType(int cmdType) {
        this.cmdType = cmdType;
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public void setPrime(BigInteger prime) {
        this.prime = prime;
    }

    public BigInteger getPublicValue() {
        return this.publicValue;
    }

    public void setPublicValue(BigInteger publicValue) {
        this.publicValue = publicValue;
    }

    public byte[] getMsg() {
        return this.msg;
    }

    public void setMsg(byte[] msg) {
        this.msg = msg;
    }

    private BigInteger readBigInteger(byte[] hex) throws IOException {
        AIMInputStream buffer = new AIMInputStream(new ByteArrayInputStream(hex));
        return new BigInteger(buffer.readString0((short)hex.length), 16);
    }

    private static byte[] writeBigInteger(BigInteger bi) throws IOException {
        byte[] hex = bi.toString(16).getBytes("US-ASCII");
        AIMOutputStream buffer = new AIMOutputStream(33);
        byte[] asciiZero = new String("0").getBytes("US-ASCII");
        buffer.writeBytes(hex);
        buffer.writeByte(0);
        return buffer.getBytes();
    }

    public void setRequest() throws IOException {
        TLVChain tlvchain = new TLVChain(4);
        tlvchain.addShort(999, this.version);
        tlvchain.addShort(1000, 0);
        tlvchain.addBytes(1001, TrillianSecureIMRendezvous.writeBigInteger(this.prime));
        tlvchain.addBytes(1002, TrillianSecureIMRendezvous.writeBigInteger(this.publicValue));
        this.setType(0);
        this.setServiceData(tlvchain);
    }

    public void setAccept() throws IOException {
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addShort(999, this.version);
        tlvchain.addShort(1000, 1);
        tlvchain.addBytes(1003, TrillianSecureIMRendezvous.writeBigInteger(this.publicValue));
        this.setType(2);
        this.setServiceData(tlvchain);
    }

    public void setBegin() throws IOException {
        TLVChain tlvchain = new TLVChain(2);
        tlvchain.addShort(999, this.version);
        tlvchain.addShort(1000, 2);
        this.setType(0);
        this.setServiceData(tlvchain);
    }

    public void setClose() throws IOException {
        TLVChain tlvchain = new TLVChain(2);
        tlvchain.addShort(999, this.version);
        tlvchain.addShort(1000, 4);
        this.setType(0);
        this.setServiceData(tlvchain);
    }

    public void setMsg() throws IOException {
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addShort(999, this.version);
        tlvchain.addShort(1000, 3);
        tlvchain.addBytes(1010, this.msg);
        this.setType(0);
        this.setServiceData(tlvchain);
    }

    public void handleServiceData(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, UserInfo userinfo, IncomingIMCH2 args, AIMInputStream buffer) throws IOException {
        TLVChain tlvchain = args.getTLVChain();
        TLV tlv = null;
        tlv = tlvchain.getTLV(999, 1);
        if (tlv != null) {
            short version = tlv.getValueShort();
            args.getTrillianEncryption().setVersion(version);
        }
        if ((tlv = tlvchain.getTLV(1000, 1)) != null) {
            short cmdType = tlv.getValueShort();
            args.getTrillianEncryption().setCmdType(cmdType);
        }
        LOG.debug((Object)("Trillian RV status=0x" + Integer.toHexString(args.getStatus()) + ", cmdType=0x" + args.getTrillianEncryption().getCmdType()));
        switch (args.getTrillianEncryption().getCmdType()) {
            case 0: {
                tlv = tlvchain.getTLV(1002, 1);
                if (tlv != null) {
                    args.getTrillianEncryption().setPublicValue(this.readBigInteger(tlv.getValue()));
                }
                if ((tlv = tlvchain.getTLV(1001, 1)) == null) break;
                BigInteger prime = this.readBigInteger(tlv.getValue());
                args.getTrillianEncryption().setPrime(prime);
                break;
            }
            case 1: {
                tlv = tlvchain.getTLV(1003, 1);
                if (tlv == null) break;
                args.getTrillianEncryption().setPublicValue(this.readBigInteger(tlv.getValue()));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                tlv = tlvchain.getTLV(1010, 1);
                if (tlv != null) {
                    byte[] msg = tlv.getValue();
                    args.getTrillianEncryption().setMsg(msg);
                }
                LOG.debug((Object)("Trillian message TLV chain=" + tlvchain));
                break;
            }
            case 4: {
                break;
            }
            default: {
                LOG.warn((Object)("Unknown Trillian SecureIM command type=0x" + Integer.toHexString(args.getTrillianEncryption().getCmdType())));
            }
        }
    }
}

