/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.handlers.MiscListener;
import org.walluck.oscar.handlers.SNACHandler;

public class MiscHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)MiscHandler.class.getName());

    public MiscHandler() {
        this.setFamily(65535);
        this.setVersion(1);
    }

    public void genericReqNull(AIMSession sess, AIMConnection conn, int family, int subtype, boolean wantResponse) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(family, subtype, 0, null, wantResponse);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, null));
    }

    public void genericReqNull(AIMSession sess, AIMConnection conn, int family, int subtype) throws IOException {
        this.genericReqNull(sess, conn, family, subtype, false);
    }

    public void genericReqNullSnacID(AIMSession sess, AIMConnection conn, int family, int subtype) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(family, subtype, 0, null, true);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, null));
    }

    public void genericReqInt(AIMSession sess, AIMConnection conn, int family, int subtype, int data, boolean wantResponse) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(family, subtype, 0, null, wantResponse);
        AIMOutputStream buffer = new AIMOutputStream(4);
        buffer.writeInt(data);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void genericReqInt(AIMSession sess, AIMConnection conn, int family, int subtype, int data) throws IOException {
        this.genericReqInt(sess, conn, family, subtype, data, true);
    }

    public void genericReqShort(AIMSession sess, AIMConnection conn, int family, int subtype, int data) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(family, subtype, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(2);
        buffer.writeShort(data);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void snacError(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        AIMConnection conn = frame.getConn();
        SNAC snac2 = conn.remSNAC(snac.getId());
        short error = 0;
        if (!buffer.isEmpty()) {
            error = buffer.readShort();
        }
        Object data = null;
        if (snac2 != null) {
            data = snac2.getData();
        }
        Iterator i = conn.getListeners(snac.getFamily(), snac.getSubtype());
        while (i.hasNext()) {
            ((MiscListener)i.next()).snacError(sess, frame, error, data);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 1) {
            this.snacError(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

