/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.ODirInfo;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.ODirListener;
import org.walluck.oscar.handlers.SNACHandler;

public class ODirHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)ODirHandler.class.getName());

    public ODirHandler() {
        this.setFamily(15);
        this.setVersion(1);
    }

    public void searchEmail(AIMSession sess, String region, String email) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 15)) == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(15, 2, 0, null, true);
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addString(28, region);
        tlvchain.addShort(10, 1);
        tlvchain.addString(5, email);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void searchDirectoryInfo(AIMSession sess, String region, ODirInfo info) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 15)) == null) {
            throw new NullPointerException();
        }
        TLVChain tlvchain = new TLVChain(10);
        tlvchain.addString(28, region);
        tlvchain.addShort(10, 0);
        if (info.getFirst() != null) {
            tlvchain.addString(1, info.getFirst());
        }
        if (info.getLast() != null) {
            tlvchain.addString(2, info.getLast());
        }
        if (info.getMiddle() != null) {
            tlvchain.addString(3, info.getMiddle());
        }
        if (info.getMaiden() != null) {
            tlvchain.addString(4, info.getMaiden());
        }
        if (info.getState() != null) {
            tlvchain.addString(7, info.getState());
        }
        if (info.getCity() != null) {
            tlvchain.addString(8, info.getCity());
        }
        if (info.getNickname() != null) {
            tlvchain.addString(12, info.getNickname());
        }
        if (info.getZip() != null) {
            tlvchain.addString(13, info.getZip());
        }
        if (info.getStreet() != null) {
            tlvchain.addString(33, info.getStreet());
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(15, 2, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void searchInterests(AIMSession sess, String region, ArrayList interests) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 15)) == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(15, 2, 0, null, true);
        int size = interests.size();
        TLVChain tlvchain = new TLVChain(size + 2);
        tlvchain.addString(28, region);
        tlvchain.addShort(10, 0);
        for (int i = 0; i < size; ++i) {
            tlvchain.addString(11, (String)interests.get(i));
        }
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void searchReply(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        buffer.readShort();
        buffer.readShort();
        int count = buffer.readShort();
        ArrayList<ODirInfo> matches = new ArrayList<ODirInfo>(count);
        for (int i = 0; i < count; ++i) {
            ODirInfo info = buffer.readODirInfo();
            matches.add(info);
        }
        Iterator i = frame.getConn().getListeners(15, 3);
        while (i.hasNext()) {
            ((ODirListener)i.next()).searchReply(sess, frame, matches);
        }
    }

    public void reqInterests(AIMSession sess) throws IOException {
        AIMConnection conn;
        if (sess == null || (conn = AIMConnection.findByGroup(sess, 15)) == null) {
            throw new NullPointerException();
        }
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 15, 4);
    }

    private void interestsReply(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        LOG.debug((Object)"interestsReply: How do we cause this to happen?");
        buffer.readShort();
        int count = buffer.readShort();
        ArrayList<String> interests = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            byte a = buffer.readByte();
            byte b = buffer.readByte();
            byte c = buffer.readByte();
            String interest = buffer.readStringL();
            LOG.debug((Object)("(" + a + ", " + b + " , " + c + "), interest=" + interest));
            interests.add(interest);
        }
        Iterator i = frame.getConn().getListeners(15, 5);
        while (i.hasNext()) {
            ((ODirListener)i.next()).interestsReply(sess, frame, interests);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3) {
            this.searchReply(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 5) {
            this.interestsReply(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }
}

