/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.filetransfer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.handlers.filetransfer.FTTLV;
import org.walluck.oscar.handlers.filetransfer.FileHeader;
import org.walluck.oscar.handlers.filetransfer.FileTransfer;
import org.walluck.oscar.handlers.filetransfer.FileTransferListener;
import org.walluck.oscar.handlers.filetransfer.GetFileEntry;
import org.walluck.oscar.handlers.filetransfer.GetFileList;

public class FileTransferHandler
extends Thread {
    private static final Logger LOG = Logger.getLogger((String)FileTransferHandler.class.getName());
    private AIMSession sess;
    private FileTransfer ft;
    private byte[] cookie;
    private byte[] rCookie;
    private String screenname;
    private FTTLV fttlv;
    private String host;
    private int port;
    private String shareDir = "C:\\temp\\share";
    private boolean listener = false;
    private boolean sender = false;
    private boolean getFile = false;
    private boolean sendFile = false;
    private boolean wantResume = false;
    private Socket socket;
    private volatile Thread thread = this;
    private boolean threadSuspended;
    private static final int SOCKET_TIMEOUT = 300000;

    public FileTransferHandler(AIMSession sess, FileTransfer ft, byte[] cookie, byte[] rCookie, String screenname, FTTLV fttlv, String host, int port) {
        this.sess = sess;
        this.ft = ft;
        this.cookie = cookie;
        this.rCookie = rCookie;
        this.screenname = screenname;
        this.fttlv = fttlv;
        this.host = host;
        this.port = port;
    }

    private void cleanup() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        this.ft.removeTransfer(this.rCookie);
        this.thread = null;
    }

    private void setupListener() {
        Iterator i;
        LOG.debug((Object)("Waiting on " + this.host + ":" + this.port));
        ServerSocket ssocket = null;
        try {
            ssocket = new ServerSocket(this.port);
            ssocket.setSoTimeout(300000);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
            this.cleanup();
        }
        try {
            LOG.debug((Object)"Waiting for connection...");
            this.socket = ssocket.accept();
            this.socket.setSoTimeout(300000);
            LOG.debug((Object)("Connection received from " + this.host + ":" + this.port));
            Iterator i2 = this.sess.getListeners(254, 144);
            while (i2.hasNext()) {
                ((FileTransferListener)i2.next()).ftEstablished(this.sess);
            }
        }
        catch (InterruptedIOException iioe) {
            LOG.error((Object)"InterruptedIOException", (Throwable)iioe);
            i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
            this.cleanup();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
            this.cleanup();
        }
    }

    private void setupSender() {
        LOG.debug((Object)("Connecting to " + this.host + ":" + this.port));
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(300000);
            Iterator i = this.sess.getListeners(254, 144);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftEstablished(this.sess);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            Iterator i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
            this.cleanup();
        }
        LOG.debug((Object)("Connected to " + this.host + ":" + this.port));
    }

    private void sendFileReceiveData() {
        LOG.debug((Object)"Receiving file...");
        try {
            OutputStream os = this.socket.getOutputStream();
            AIMOutputStream outbuffer = new AIMOutputStream(os);
            InputStream is = this.socket.getInputStream();
            AIMInputStream inbuffer = new AIMInputStream(is);
            LOG.debug((Object)"Trying to read file header...");
            FileHeader fh = inbuffer.readFileHeader();
            LOG.debug((Object)"Reading in remote's header...");
            AIMOutputStream tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            String name = AIMUtil.dirAOLToSys(fh.getName());
            long size = fh.getFileSize();
            if (this.wantResume) {
                fh.setType(517);
                File file = new File("./" + name);
                fh.setNumRecvd(file.length());
                fh.setRecvdChecksum(FileTransfer.calculateChecksum(name, 0L, file.length()));
            } else {
                fh.setType(514);
            }
            fh.setTotalNumParts(1);
            fh.setCookie(this.rCookie);
            LOG.debug((Object)"Trying to write file header (1)...");
            tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            outbuffer.writeFileHeader(fh);
            LOG.debug((Object)("Trying to receive file " + name + " (" + size + " bytes)..."));
            long numRecvd = this.receiveFile(name, size, this.socket.getInputStream());
            fh.setType(516);
            fh.setNumRecvd(numRecvd);
            fh.setRecvdChecksum(FileTransfer.calculateChecksum(name, 0L, numRecvd));
            LOG.debug((Object)"Trying to write file header (2)...");
            tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            outbuffer.writeFileHeader(fh);
            inbuffer.close();
            outbuffer.close();
        }
        catch (IOException ioe) {
            Iterator i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
        }
        this.cleanup();
    }

    private void sendFileSendData() {
        File file = new File(this.fttlv.getName());
        if (!file.canRead()) {
            LOG.error((Object)("Cannot read file=" + this.fttlv.getName()));
            Iterator i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
            this.cleanup();
            return;
        }
        LOG.debug((Object)("Ready to send file=" + this.fttlv.getName()));
        String name = file.getName();
        long lastModified = file.lastModified();
        long length = file.length();
        long totalLength = 256L;
        if (name.length() > 64) {
            totalLength += (long)(name.length() - 64 + 1);
        }
        try {
            long sum = FileTransfer.calculateChecksum(name, 0L, length);
            OutputStream os = this.socket.getOutputStream();
            AIMOutputStream outbuffer = new AIMOutputStream(os);
            InputStream is = this.socket.getInputStream();
            AIMInputStream inbuffer = new AIMInputStream(is);
            FileHeader fh = new FileHeader();
            fh.setSend(1, 1, 1, 1, length, length, lastModified, sum, name);
            fh.setRecv(0L, 0L);
            fh.setComm((int)totalLength, 257);
            fh.setRes(1L, lastModified, sum);
            AIMOutputStream tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            outbuffer.writeFileHeader(fh);
            LOG.debug((Object)("We say checksum is 0x" + Integer.toHexString((int)fh.getChecksum())));
            fh = inbuffer.readFileHeader();
            if (fh.getType() == 517) {
                LOG.debug((Object)("Want resume, will start at " + fh.getNumRecvd()));
                fh.setType(519);
                outbuffer.writeFileHeader(fh);
            }
            this.sendFile(this.fttlv.getName(), length, outbuffer, fh.getNumRecvd());
            tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            LOG.debug((Object)("Remote says checksum is 0x" + Integer.toHexString((int)fh.getChecksum())));
            outbuffer.close();
            inbuffer.close();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            Iterator i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
            this.cleanup();
        }
        this.cleanup();
    }

    private void getFileReceiveData() {
        try {
            AIMOutputStream tmpbuffer = new AIMOutputStream(256);
            InputStream is = this.socket.getInputStream();
            AIMInputStream inbuffer = new AIMInputStream(is);
            OutputStream os = this.socket.getOutputStream();
            AIMOutputStream outbuffer = new AIMOutputStream(os);
            FileHeader fh = inbuffer.readFileHeader();
            LOG.debug((Object)"Got first header...");
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            fh.setType(4617);
            LOG.debug((Object)"Sending ack header...");
            tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            outbuffer.writeFileHeader(fh);
            LOG.debug((Object)"Reading in GFL...");
            GetFileList gfl = inbuffer.readGetFileList();
            int size = gfl.getFiles().size();
            LOG.debug((Object)("Got a GetFile list, version=" + gfl.getVersion() + ", size=" + size));
            LOG.debug((Object)"*** BEGIN GETFILE LIST ***");
            for (int i = 0; i < size; ++i) {
                LOG.debug((Object)((GetFileEntry)gfl.getFiles().get(i)).toString());
            }
            LOG.debug((Object)"*** END GETFILE LIST ***");
            LOG.debug((Object)"Sending footer...");
            fh.setType(4619);
            fh.setFlag((byte)33);
            tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            outbuffer.writeFileHeader(fh);
            fh.setType(4622);
            fh.setName("share\\README");
            fh.setTotalNumParts(0);
            LOG.debug((Object)("Requesting file " + fh.getName() + "..."));
            tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            outbuffer.writeFileHeader(fh);
            fh = inbuffer.readFileHeader();
            LOG.debug((Object)"Got ack...");
            tmpbuffer = new AIMOutputStream(256);
            tmpbuffer.writeFileHeader(fh);
            LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
            LOG.debug((Object)"GetFile request finished");
            inbuffer.close();
            outbuffer.close();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    private void sendDirList(String filename) throws IOException {
        File[] files = new File(this.shareDir).listFiles();
        ArrayList<GetFileEntry> list = new ArrayList<GetFileEntry>(files.length);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            GetFileEntry gfe = new GetFileEntry();
            gfe.setFilename(file.getName());
            gfe.setFilesize(file.length());
            gfe.setLastmod(file.lastModified());
            LOG.debug((Object)("Adding " + file.getName() + " to the GetFile list..."));
            list.add(gfe);
        }
        LOG.debug((Object)"Done adding.");
        GetFileList gfl = new GetFileList();
        gfl.setFiles(list);
        File listFile = new File(this.shareDir + "\\listing.txt");
        LOG.debug((Object)("Writing list out to " + listFile + "..."));
        AIMOutputStream listout = new AIMOutputStream(new FileOutputStream(listFile));
        listout.writeGetFileList(gfl);
        listout.close();
        LOG.debug((Object)("Done writing " + listFile + "."));
        long listSize = listFile.length();
        long lastModified = listFile.lastModified();
        long sum = FileTransfer.calculateChecksum(listFile.getName(), 0L, listSize);
        LOG.debug((Object)("Statistics for listFile: size=" + listSize + " bytes" + ", lastModified=" + new Date(lastModified) + ", sum=0x" + Integer.toHexString((int)sum)));
        listFile.delete();
        FileHeader fh = new FileHeader();
        fh.setSend(list.size(), 1, 1, 1, listSize, listSize, lastModified, sum, this.shareDir + "\\listing.txt");
        fh.setType(4360);
        fh.setFlag((byte)48);
        fh.setResChecksum(0xFFFF0000L);
        fh.setResRecvdChecksum(0xFFFF0000L);
        fh.setRecvdChecksum(0xFFFF0000L);
        OutputStream os = this.socket.getOutputStream();
        AIMOutputStream outbuffer = new AIMOutputStream(os);
        InputStream is = this.socket.getInputStream();
        AIMInputStream inbuffer = new AIMInputStream(is);
        LOG.debug((Object)"Sending file header...");
        AIMOutputStream tmpbuffer = new AIMOutputStream(256);
        tmpbuffer.writeFileHeader(fh);
        LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
        outbuffer.writeFileHeader(fh);
        fh = inbuffer.readFileHeader();
        tmpbuffer = new AIMOutputStream(256);
        tmpbuffer.writeFileHeader(fh);
        LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
        LOG.debug((Object)"Got file ack, so sending list...");
        outbuffer.writeGetFileList(gfl);
        fh = inbuffer.readFileHeader();
        tmpbuffer = new AIMOutputStream(256);
        tmpbuffer.writeFileHeader(fh);
        LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
        LOG.debug((Object)("sendDirList finished, checksum=" + fh.getChecksum()));
    }

    private void getFileSendData() {
        AIMOutputStream tmpbuffer = null;
        LOG.debug((Object)"getFileRecvData: handling File Sharing request...");
        try {
            LOG.debug((Object)"We should have sent an accept prior to this line!");
            this.sendDirList(null);
            InputStream is = this.socket.getInputStream();
            AIMInputStream inbuffer = new AIMInputStream(is);
            int i = 0;
            while (true) {
                LOG.debug((Object)("getFileRecvData: trying to read file header " + ++i));
                FileHeader fh = inbuffer.readFileHeader();
                tmpbuffer = new AIMOutputStream(256);
                tmpbuffer.writeFileHeader(fh);
                LOG.debug((Object)AIMUtil.hexdump(tmpbuffer.getBytes()));
                if (fh.getType() == 4622) {
                    this.sendDirList(fh.getName());
                    continue;
                }
                LOG.warn((Object)("Unhandled header type=0x" + Integer.toHexString(fh.getType())));
            }
        }
        catch (IOException ioe) {
            Iterator i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
            this.cleanup();
            return;
        }
    }

    private void sendFile(String fname, long flength, AIMOutputStream buffer, long start) throws FileNotFoundException {
        if (fname == null || buffer == null) {
            throw new NullPointerException();
        }
        if (start > flength) {
            throw new IllegalArgumentException();
        }
        byte[] b = new byte[1024];
        long totalBytesSent = 0L;
        DataInputStream dis = new DataInputStream(new FileInputStream(fname));
        if (start > 0L) {
            try {
                byte[] tmp = new byte[(int)start];
                dis.read(tmp, 0, (int)start);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
        LOG.debug((Object)("Sending file=" + fname + ", length=" + flength + " bytes"));
        block4: while (true) {
            try {
                block5: while (true) {
                    int i;
                    if ((i = dis.read(b, 0, 1024)) == -1) {
                        dis.close();
                        break block4;
                    }
                    LOG.debug((Object)("sending file ==> i=" + i + ", total bytes sent=" + (totalBytesSent += (long)i)));
                    buffer.write(b, 0, i);
                    LOG.debug((Object)("sending file ==> bytes sent: " + totalBytesSent));
                    Iterator i2 = this.sess.getListeners(254, 112);
                    while (true) {
                        if (!i2.hasNext()) continue block5;
                        ((FileTransferListener)i2.next()).ftSent(totalBytesSent, flength);
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
                Iterator i = this.sess.getListeners(254, 32);
                while (true) {
                    if (!i.hasNext()) continue block4;
                    ((FileTransferListener)i.next()).ftDisconnect(this.sess);
                }
            }
            break;
        }
    }

    private long receiveFile(String fname, long flength, InputStream is) {
        if (fname == null || is == null) {
            throw new NullPointerException();
        }
        int slash = fname.lastIndexOf(System.getProperty("file.separator"));
        if (slash != -1) {
            fname = fname.substring(slash, fname.length());
        }
        File file = new File("./" + fname);
        DataOutputStream dos = null;
        try {
            if (this.wantResume) {
                LOG.warn((Object)"FIXME: resume support");
            }
            dos = new DataOutputStream(new FileOutputStream(file));
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
            Iterator i = this.sess.getListeners(254, 32);
            while (i.hasNext()) {
                ((FileTransferListener)i.next()).ftDisconnect(this.sess);
            }
            return 0L;
        }
        byte[] b = new byte[1024];
        long totalBytesRead = 0L;
        int j = (int)Math.min(1024L, flength);
        block5: while (true) {
            try {
                do {
                    int i = is.read(b, 0, j);
                    LOG.debug((Object)("Read " + i + " bytes"));
                    if (i >= 0) {
                        dos.write(b, 0, i);
                        j = (int)Math.min(1024L, flength - (totalBytesRead += (long)i));
                        Iterator i2 = this.sess.getListeners(254, 128);
                        while (i2.hasNext()) {
                            ((FileTransferListener)i2.next()).ftReceived(totalBytesRead, flength);
                        }
                    } else {
                        dos.close();
                        break block5;
                    }
                } while (totalBytesRead < flength);
                dos.close();
            }
            catch (IOException ioe2) {
                LOG.error((Object)"IOException", (Throwable)ioe2);
                Iterator i = this.sess.getListeners(254, 32);
                while (true) {
                    if (!i.hasNext()) continue block5;
                    ((FileTransferListener)i.next()).ftDisconnect(this.sess);
                }
            }
            break;
        }
        return totalBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thisThread = Thread.currentThread();
        if (this.thread != thisThread) {
            return;
        }
        FileTransferHandler fileTransferHandler = this;
        synchronized (fileTransferHandler) {
            while (this.threadSuspended && this.thread == thisThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)"InterruptedException", (Throwable)ie);
                    this.thread = null;
                    Iterator i = this.sess.getListeners(254, 32);
                    while (i.hasNext()) {
                        ((FileTransferListener)i.next()).ftDisconnect(this.sess);
                    }
                }
            }
        }
        if (this.listener) {
            this.setupListener();
        } else {
            this.setupSender();
        }
        if (this.sendFile) {
            if (this.sender) {
                this.sendFileSendData();
            } else {
                this.sendFileReceiveData();
            }
        } else if (this.getFile) {
            if (this.listener) {
                LOG.debug((Object)"listener (we sent GetFile request)");
                this.getFileReceiveData();
            } else {
                LOG.debug((Object)"not listener (they sent GetFile request)");
                this.getFileSendData();
            }
        }
    }

    public boolean isListener() {
        return this.listener;
    }

    public void setListener(boolean listener) {
        this.listener = listener;
    }

    public boolean isSender() {
        return this.sender;
    }

    public void setSender(boolean sender) {
        this.sender = sender;
    }

    public boolean isGetFile() {
        return this.getFile;
    }

    public void setGetFile(boolean getFile) {
        this.getFile = getFile;
    }

    public boolean isSendFile() {
        return this.sendFile;
    }

    public void setSendFile(boolean sendFile) {
        this.sendFile = sendFile;
    }

    public boolean getWantResume() {
        return this.wantResume;
    }

    public void setWantResume(boolean wantResume) {
        this.wantResume = wantResume;
    }

    public String getShareDir() {
        return this.shareDir;
    }

    public void setShareDir(String shareDir) {
        this.shareDir = shareDir;
    }
}

