/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.icq.tcp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Random;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.handlers.icq.ICQColor;
import org.walluck.oscar.handlers.icq.tcp.DirectClientListener;

public class DirectClient
extends Thread {
    private static final Logger LOG = Logger.getLogger((String)DirectClient.class.getName());
    private AIMSession sess;
    private static final String CLIENT_CHECK_DATA_STRING = "As part of this software beta version Mirabilis is granting a limited access to the ICQ network, servers, directories, listings, information and databases (\"ICQ Services and Information\"). The ICQ Service and Information may databases (\"ICQ Services and Information\"). The ICQ Service and Information may\u0000";
    private static final byte[] CLIENT_CHECK_DATA = "As part of this software beta version Mirabilis is granting a limited access to the ICQ network, servers, directories, listings, information and databases (\"ICQ Services and Information\"). The ICQ Service and Information may databases (\"ICQ Services and Information\"). The ICQ Service and Information may\u0000".getBytes();
    private int state;
    private int remoteUIN;
    private int localServerPort = 6886;
    private int myUIN;
    private byte[] localExtIP;
    private byte[] localIP;
    private int sessionID;
    private boolean incoming;
    private int effTcpVersion;
    private Socket socket;
    private ServerSocket ssocket;
    private static final int MAX_MSG_ID_NO = Short.MAX_VALUE;
    private short lastMsgId = (short)-1;
    private volatile Thread thread = this;
    private String host;
    private int port;
    public static final int WAITING_FOR_INIT_ACK = 1;
    public static final int WAITING_FOR_INIT = 2;
    public static final int WAITING_FOR_INIT2 = 3;
    public static final int CONNECTED = 4;

    public DirectClient(AIMSession sess, int uin, String host, int port, boolean incoming) {
        this.sess = sess;
        try {
            this.localIP = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"UnknownHostException", (Throwable)uhe);
        }
        this.state = 2;
        this.incoming = incoming;
        this.myUIN = uin;
        try {
            if (incoming) {
                this.ssocket = new ServerSocket(0);
                this.localServerPort = this.ssocket.getLocalPort();
                LOG.debug((Object)("Creating listening socket on port=" + this.localServerPort));
            } else {
                LOG.debug((Object)("Connecting direct to " + host + ":" + port));
                this.socket = new Socket(host, port);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public int getLocalPort() {
        return this.localServerPort;
    }

    public void confirmUIN() throws IOException {
    }

    public void sendInitPacket() throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(48);
        buffer.writeByte(255);
        buffer.writeShortLE(6);
        buffer.writeShortLE(43);
        buffer.writeIntLE(this.remoteUIN);
        buffer.writeShortLE(0);
        buffer.writeIntLE(this.localServerPort);
        buffer.writeIntLE(this.myUIN);
        buffer.writeBytes(this.localExtIP);
        buffer.writeBytes(this.localIP);
        buffer.writeByte(4);
        buffer.writeIntLE(this.localServerPort);
        buffer.writeIntLE(this.sessionID);
        buffer.writeIntLE(80);
        buffer.writeIntLE(3);
        this.sendDirect(buffer, false);
    }

    public void sendInitAck() throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(4);
        buffer.writeShortLE(1);
        buffer.writeShortLE(0);
        this.sendDirect(buffer, false);
    }

    public void sendInit2() throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(33);
        buffer.writeByte(3);
        buffer.writeIntLE(10);
        buffer.writeIntLE(1);
        buffer.writeIntLE(this.incoming ? 1 : 0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(262145);
        buffer.writeIntLE(0);
        buffer.writeIntLE(262145);
        this.sendDirect(buffer, false);
    }

    public void sendAck(int seq, int subcmd, boolean accept) throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(27);
        buffer.writeByte(2);
        buffer.writeIntLE(0);
        buffer.writeShortLE(2010);
        buffer.writeShortLE(14);
        buffer.writeShortLE(seq);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeShortLE(subcmd);
        buffer.writeShortLE(accept ? 0 : 1);
        this.sendDirect(buffer, true);
    }

    public void sendMessage(int uin, String msg, short subcmd, int lstatus, ICQColor foregroundColor, ICQColor backgroundColor) throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(38 + msg.length());
        buffer.writeShortLE(2);
        buffer.writeIntLE(0);
        buffer.writeShortLE(2030);
        buffer.writeShortLE(14);
        buffer.writeShortLE(this.nextMsgId());
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        buffer.writeShortLE(subcmd);
        int status = (lstatus & 0x100) != 0 ? 128 : ((lstatus & 0x13) != 0 ? 4096 : ((lstatus & 0x11) != 0 ? 512 : ((lstatus & 5) != 0 ? 2048 : ((lstatus & 1) != 0 ? 256 : 0))));
        buffer.writeShortLE(0);
        buffer.writeShortLE(status);
        buffer.writeStringLLLE0(msg);
        buffer.writeICQColor(foregroundColor);
        buffer.writeICQColor(backgroundColor);
        this.sendDirect(buffer, true);
    }

    public void parseInitPacket(AIMInputStream buffer) throws IOException {
        LOG.debug((Object)"Parse init packet");
        byte startByte = buffer.readByte();
        if (startByte != -1) {
            throw new IOException("Init packet does not start with 0xff, it starts with " + startByte);
        }
        short effTcpVersion = buffer.readShortLE();
        LOG.debug((Object)("Remote wants TCP version=" + effTcpVersion));
        buffer.readShortLE();
        if (this.incoming) {
            this.effTcpVersion = effTcpVersion;
            if (effTcpVersion < 6) {
                throw new IOException("Client too old");
            }
        } else if (effTcpVersion != this.effTcpVersion) {
            throw new IOException("Client claims different TCP versions from our own");
        }
        int ourUIN = buffer.readIntLE();
        buffer.readShortLE();
        short port = buffer.readShortLE();
        buffer.readShortLE();
        int remoteUIN = buffer.readIntLE();
        if (this.incoming) {
            this.remoteUIN = remoteUIN;
        } else if (this.remoteUIN != remoteUIN) {
            throw new IOException("Invalid remote UIN");
        }
        byte[] extIP = buffer.readBytes(4);
        this.localExtIP = extIP;
        byte[] lanIP = buffer.readBytes(4);
        this.localIP = lanIP;
        byte tcpFlags = buffer.readByte();
        buffer.readShortLE();
        buffer.readShortLE();
        int sessionID = buffer.readIntLE();
        if (this.incoming) {
            this.sessionID = sessionID;
        } else if (this.sessionID != sessionID) {
            throw new IOException("Session ID from remote client does not match what we sent");
        }
        int x1 = buffer.readIntLE();
        int x2 = buffer.readIntLE();
        if (effTcpVersion == 7) {
            buffer.readIntLE();
        }
    }

    public void parseInitAck(AIMInputStream buffer) throws IOException {
        LOG.debug((Object)"Parse init ack");
        int one = buffer.readIntLE();
        if (one != 1) {
            throw new IOException("Unexpected value " + one + " != 1");
        }
    }

    public void parseInit2(AIMInputStream buffer) throws IOException {
        byte type = buffer.readByte();
        if (type != 3) {
            throw new IOException("Unexpected type" + type);
        }
        int ten = buffer.readIntLE();
        if (ten != 10) {
            throw new IOException("Unexpected value");
        }
        int one = buffer.readIntLE();
        if (one != 1) {
            throw new IOException("Unknown connection type");
        }
    }

    public void parsePacket(AIMInputStream buffer) throws IOException {
        LOG.debug((Object)"Parse packet");
        AIMOutputStream c = new AIMOutputStream(buffer.getEmpty());
        if (!this.decrypt(buffer, c)) {
            throw new IOException("Decryption failed!");
        }
        this.parsePacketInt(new AIMInputStream(new ByteArrayInputStream(c.getBytes())));
    }

    public void parsePacketInt(AIMInputStream buffer) throws IOException {
        byte startByte;
        if (this.effTcpVersion >= 7 && (startByte = buffer.readByte()) != 2) {
            throw new IOException("Message packet did not start with 0x02");
        }
        int checksum = buffer.readIntLE();
        short command = buffer.readShortLE();
        short unknown = buffer.readShortLE();
        short seqnum = buffer.readShortLE();
        buffer.readIntLE();
        buffer.readIntLE();
        buffer.readIntLE();
        short type = buffer.readShortLE();
        buffer.readShortLE();
        short status = buffer.readShortLE();
        String tmp = buffer.readStringLLLE();
        int fg = buffer.readIntLE();
        int bg = buffer.readIntLE();
        switch (command) {
            case 2030: {
                break;
            }
            case 2010: {
                if (type == 0) {
                    LOG.debug((Object)"Do something here");
                    break;
                }
                if ((type & 0x3E0) == 0) break;
                LOG.debug((Object)"Do something here");
                break;
            }
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1005: {
                this.sendAck(seqnum, type, true);
                break;
            }
            case 2: 
            case 3: {
                this.sendAck(seqnum, type, false);
                break;
            }
            default: {
                LOG.warn((Object)("Unknown TCP command=" + Integer.toHexString(command)));
            }
        }
        byte junk = buffer.readByte();
        int version = buffer.readIntLE();
    }

    public boolean decrypt(AIMInputStream in, AIMOutputStream out) throws IOException {
        char x3;
        LOG.debug((Object)"Trying to decrypt packet...");
        if (this.effTcpVersion < 6) {
            return false;
        }
        int correction = this.effTcpVersion == 7 ? 3 : 2;
        LOG.debug((Object)("correction=" + correction));
        long size = in.available() - correction;
        LOG.debug((Object)("size=" + size));
        out.writeShortLE(in.available());
        if (this.effTcpVersion == 7) {
            char startByte = (char)in.readByte();
            out.writeByte(startByte);
        }
        int check = in.readIntLE();
        LOG.debug((Object)("check=" + check));
        out.writeIntLE(check);
        long key = 1734701672L * size + (long)check;
        LOG.debug((Object)("key=" + key));
        int i = 4;
        while ((long)i < (size + 3L) / 4L) {
            long hex = key + (long)CLIENT_CHECK_DATA[i];
            out.writeByte(in.readByte() ^ (byte)(hex & 0xFFL));
            out.writeByte(in.readByte() ^ (byte)(hex >> 8 & 0xFFL));
            out.writeByte(in.readByte() ^ (byte)(hex >> 16 & 0xFFL));
            out.writeByte(in.readByte() ^ (byte)(hex >> 24 & 0xFFL));
            i += 4;
        }
        while (!in.isEmpty()) {
            char c = (char)in.readByte();
            out.writeByte(c);
        }
        byte[] outb = out.getBytes();
        long b1 = outb[4 + correction] << 24 | outb[6 + correction] << 16 | outb[4 + correction] << 8 | outb[6 + correction] << 0;
        long m1 = (b1 ^= (long)check) >> 24 & 0xFFL;
        if (m1 < 10L || m1 >= size) {
            LOG.error((Object)("ERROR: m1=" + m1));
            return false;
        }
        char x1 = (char)(outb[(int)(m1 + (long)correction)] ^ 0xFF);
        LOG.debug((Object)("x1=" + (byte)x1 + ", b1=" + (byte)b1));
        if ((b1 >> 16 & 0xFFL) != (long)x1) {
            LOG.error((Object)("ERROR b1 != x1: " + (byte)(b1 >> 16 & 0xFFL) + " != " + (byte)x1));
            return false;
        }
        char x2 = (char)(b1 >> 8 & 0xFFL);
        LOG.debug((Object)("x2=" + x2));
        if (x2 < '\u00dc' && (b1 & 0xFFL) != (long)(x3 = (char)(CLIENT_CHECK_DATA[x2] ^ 0xFF))) {
            LOG.error((Object)("ERROR b1 != x3: " + (b1 & 0xFFL) + " != " + x3));
            return false;
        }
        LOG.debug((Object)"Successfully decrypted packet!");
        return true;
    }

    public void encrypt(AIMInputStream in, AIMOutputStream out) throws IOException {
        if (this.effTcpVersion < 6 || this.effTcpVersion > 8) {
            return;
        }
        int size = in.getEmpty();
        if (this.effTcpVersion >= 7) {
            out.writeShortLE(size + 1);
            out.writeByte(2);
        } else {
            out.writeShortLE(size);
        }
        byte[] inb = in.readBytes(in.getEmpty());
        long m1 = new Random().nextInt() % ((size < 255 ? size : 255) - 10) + 10;
        char x1 = (char)(inb[(int)m1] ^ 0xFF);
        char x2 = (char)(new Random().nextInt() % 220);
        char x3 = (char)(CLIENT_CHECK_DATA[x2] ^ 0xFF);
        long b1 = inb[4] << 24 | inb[6] << 16 | inb[4] << 8 | inb[6] << 0;
        int check = (int)(m1 << 24 | (long)(x1 << 16) | (long)(x2 << 8) | (long)(x3 << 0));
        check = (int)((long)check ^ b1);
        out.writeIntLE(check);
        long key = 1734701672 * size + check;
        AIMInputStream in2 = new AIMInputStream(new ByteArrayInputStream(inb));
        in2.readBytes(4);
        for (int i = 4; i < (size + 3) / 4; i += 4) {
            long hex = key + (long)CLIENT_CHECK_DATA[i & 0xFF];
            out.writeByte(in2.readByte() ^ (byte)(hex & 0xFFL));
            out.writeByte(in2.readByte() ^ (byte)(hex >> 8 & 0xFFL));
            out.writeByte(in2.readByte() ^ (byte)(hex >> 16 & 0xFFL));
            out.writeByte(in2.readByte() ^ (byte)(hex >> 24 & 0xFFL));
        }
        while (in2.getEmpty() > 0) {
            out.writeByte(in2.readByte());
        }
    }

    public void sendDirect(AIMOutputStream b, boolean encrypt) throws IOException {
        byte[] data = b.getBytes();
        AIMOutputStream c = new AIMOutputStream(2 + data.length);
        if (encrypt) {
            this.encrypt(new AIMInputStream(new ByteArrayInputStream(data)), c);
        } else {
            c.writeShortLE(data.length);
            c.writeBytes(data);
        }
        byte[] d = c.getBytes();
        LOG.debug((Object)"Sending TCP packet...");
        LOG.debug((Object)AIMUtil.hexdump(d));
        this.socket.getOutputStream().write(d);
    }

    public int nextMsgId() {
        if (this.lastMsgId == -1) {
            this.lastMsgId = Short.MAX_VALUE;
        }
        short s = this.lastMsgId;
        this.lastMsgId = (short)(s - 1);
        return s;
    }

    private void sendConnected() {
        Iterator i = this.sess.getListeners(251, 1);
        while (i.hasNext()) {
            ((DirectClientListener)((Object)i)).dcConnected(this.sess);
        }
    }

    public void run() {
        LOG.debug((Object)"Direct client waiting for connection...");
        try {
            if (this.incoming) {
                LOG.debug((Object)"Waiting for incoming TCP connection...");
                this.socket = this.ssocket.accept();
                this.host = this.socket.getInetAddress().getHostAddress();
                this.port = this.socket.getPort();
                LOG.debug((Object)("Connection received from " + this.host + ":" + this.port));
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        Thread thisThread = Thread.currentThread();
        while (this.thread == thisThread) {
            try {
                AIMInputStream buffer = new AIMInputStream(this.socket.getInputStream());
                short length = buffer.readShortLE();
                LOG.debug((Object)("Received TCP packet of length=" + length + " bytes"));
                byte[] b = buffer.readBytes(length);
                LOG.debug((Object)AIMUtil.hexdump(b));
                AIMInputStream sb = new AIMInputStream(new ByteArrayInputStream(b));
                if (this.state == 2) {
                    this.parseInitPacket(sb);
                    if (this.incoming) {
                        this.sendInitAck();
                        this.sendInitPacket();
                        this.state = 1;
                        continue;
                    }
                    this.sendInitAck();
                    if (this.effTcpVersion >= 7) {
                        this.sendInit2();
                        this.state = 3;
                        continue;
                    }
                    this.state = 4;
                    this.sendConnected();
                    continue;
                }
                if (this.state == 1) {
                    this.parseInitAck(sb);
                    if (this.incoming) {
                        if (this.effTcpVersion == 7) {
                            this.state = 3;
                            continue;
                        }
                        this.confirmUIN();
                        this.state = 4;
                        this.sendConnected();
                        continue;
                    }
                    this.state = 2;
                    continue;
                }
                if (this.state == 3) {
                    this.parseInit2(sb);
                    if (this.incoming) {
                        this.sendInit2();
                        this.confirmUIN();
                    }
                    this.state = 4;
                    this.sendConnected();
                    continue;
                }
                if (this.state != 4) continue;
                this.parsePacket(sb);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
        LOG.debug((Object)"Direct client stopping...");
    }
}

