/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.script;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.client.Oscar;
import org.walluck.oscar.script.Script;

public class ScriptInterpreter {
    private static final Logger LOG = Logger.getLogger((String)Script.class.getName());
    private ArrayList scripts = new ArrayList();
    private BSFManager manager = new BSFManager();
    private Timer timer = new Timer();

    public ScriptInterpreter(AIMSession sess, AIMConnection conn, Oscar oscar) {
        if (System.getProperty("python.home") == null) {
            System.setProperty("python.home", "/usr/share/jython");
        }
        try {
            this.manager.declareBean("session", (Object)sess, AIMSession.class);
            this.manager.declareBean("bos", (Object)conn, AIMConnection.class);
            this.manager.declareBean("oscar", (Object)oscar, Oscar.class);
            this.manager.declareBean("daim", (Object)this, ScriptInterpreter.class);
            this.manager.declareBean("manager", (Object)this.manager, BSFManager.class);
        }
        catch (BSFException bsfe) {
            LOG.error((Object)"BSFExeception", (Throwable)bsfe);
        }
    }

    public void executeScriptFile(String filename) {
        try {
            this.manager.exec(BSFManager.getLangFromFilename((String)filename), filename, 0, 0, (Object)IOUtils.getStringFromReader((Reader)new FileReader(filename)));
        }
        catch (BSFException bsfe) {
            LOG.error((Object)"BSFExeception", (Throwable)bsfe);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void addTimeoutHandler(final Script script, int time, boolean forever, final String code) {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                try {
                    ScriptInterpreter.this.manager.eval(BSFManager.getLangFromFilename((String)script.getFilename()), script.getFilename(), 0, 0, (Object)code);
                }
                catch (BSFException bsfe) {
                    LOG.error((Object)"BSFExeception", (Throwable)bsfe);
                }
            }
        };
        if (!forever) {
            this.timer.schedule(timerTask, time);
        } else {
            this.timer.schedule(timerTask, 0L, (long)time);
        }
    }

    public void addScript(Script script) {
        this.scripts.add(script);
    }

    public ArrayList getScripts() {
        return this.scripts;
    }
}

