/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.ExchangeInfo;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.Redir;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.ChatHandler;
import org.walluck.oscar.handlers.ChatNavHandler;
import org.walluck.oscar.handlers.ChatNavListener;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.tools.Tool;

public class ChatNavTool
extends Tool
implements ChatNavListener,
ServiceListener {
    private static final Logger LOG = Logger.getLogger((String)ChatNavTool.class.getName());

    public ChatNavTool() {
        this.setFamily(13);
        this.setId(16);
        this.setVersion(1849);
    }

    public void parseInfoPerms(AIMSession sess, AIMFrame frame, int subtype, int maxrooms, int curexchange, ArrayList exchanges) {
        if (subtype == 2) {
            LOG.debug((Object)"chat info: Chat Rights:\n");
            LOG.debug((Object)("chat info: \tMax Concurrent Rooms: " + maxrooms));
            LOG.debug((Object)("chat info: \tExchange List: (" + exchanges.size() + " total)"));
            for (int i = 0; i < exchanges.size(); ++i) {
                ExchangeInfo ei = (ExchangeInfo)exchanges.get(i);
                LOG.debug((Object)("chat info: Exchange #" + ei.getNumber() + ":\tExchange name:\t" + (ei.getName() != null ? ei.getName() : "(none)")));
            }
        } else {
            LOG.warn((Object)("Unknown permissions=" + Integer.toHexString(subtype)));
        }
    }

    public void parseInfoCreate(AIMSession sess, AIMFrame frame, int subtype, String fqcn, int instance, int exchange, int flags, int createtime, int maxmsglen, int maxoccupancy, int createperms, int unknown, String name, String ck) {
        if (subtype == 8) {
            LOG.debug((Object)("created room: " + fqcn + " " + exchange + " " + instance + " " + flags + " " + createtime + " " + maxmsglen + " " + maxoccupancy + " " + createperms + " " + unknown + " " + name + " " + ck));
            ChatHandler chat = (ChatHandler)sess.getHandler(14);
            try {
                chat.join(sess, this.getToolData().getBosconn(), exchange, ck, instance);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        } else {
            LOG.warn((Object)("chatnav info: unknown type " + Integer.toHexString(subtype)));
        }
    }

    private void registerChatNavListeners(AIMConnection tstconn) {
        tstconn.registerListener(13, 9, this);
        tstconn.registerListener(1, 7, this);
        tstconn.registerListener(1, 5, this);
    }

    public void rateResp(AIMSession sess, AIMFrame frame) {
        if (frame.getConn().getType() == 13) {
            AIMConnection tstconn = frame.getConn();
            this.registerChatNavListeners(tstconn);
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            try {
                service.clientReady(sess, tstconn);
                ChatNavHandler chatNav = (ChatNavHandler)sess.getHandler(13);
                chatNav.reqRights(sess, tstconn);
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
    }

    public void redirect(AIMSession sess, AIMFrame frame, Redir redir) {
        if (redir.getGroup() == 13) {
            AIMConnection exist = AIMConnection.findByType(sess, 13);
            if (exist != null) {
                exist.close();
            }
            AIMConnection tstconn = new AIMConnection(sess, 13, redir.getIp());
            try {
                this.registerChatNavListeners(tstconn);
                tstconn.connect();
                LoginHandler login = (LoginHandler)sess.getHandler(23);
                login.sendCookie(sess, tstconn, redir.getCookie());
            }
            catch (IOException ioe) {
                tstconn.close();
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void rateChange(AIMSession sess, AIMFrame frame, int code, RateClass rc) {
    }

    public void serverPause(AIMSession sess, AIMFrame frame) {
    }

    public void serverResume(AIMSession sess, AIMFrame frame) {
    }

    public void selfInfo(AIMSession sess, AIMFrame frame, UserInfo userinfo) {
    }

    public void evilNotify(AIMSession sess, AIMFrame frame, int newEvil, UserInfo userinfo) {
    }

    public void migrate(AIMSession sess, AIMFrame frame, String ip, byte[] cookie) {
    }

    public void motd(AIMSession sess, AIMFrame frame, int id, String msg) {
    }

    public void memRequest(AIMSession sess, AIMFrame frame, int offset, int len, String modname) {
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(1, 7, this);
        bosconn.registerListener(1, 5, this);
    }
}

