/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.Chat;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.Redir;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.ChatHandler;
import org.walluck.oscar.handlers.ChatListener;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.ServiceListener;
import org.walluck.oscar.requests.JoinRoomRequest;
import org.walluck.oscar.tools.Tool;

public class ChatTool
extends Tool
implements ChatListener,
ServiceListener {
    private static final Logger LOG = Logger.getLogger((String)ChatTool.class.getName());

    public ChatTool() {
        this.setFamily(14);
        this.setId(16);
        this.setVersion(1849);
    }

    public void joinRoom(JoinRoomRequest jrr) {
        ChatHandler chat = (ChatHandler)this.getSession().getHandler(14);
        try {
            chat.join(this.getSession(), this.getToolData().getBosconn(), jrr.getExchange(), jrr.getName(), jrr.getInstance());
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void infoUpdate(AIMSession sess, AIMFrame frame, Chat roominfo, String roomName, int userCount, ArrayList occupants, String roomdesc, int flags, int creationTime, int maxmsglen, int maxOccupancy, int creationPerms, int maxvisiblemsglen) {
    }

    public void userlistChange(AIMSession sess, AIMFrame frame, int curcount, ArrayList userinfo) {
        int type = frame.getSNAC().getSubtype();
        if (type == 3) {
            LOG.debug((Object)"user joined room");
        } else if (type == 4) {
            LOG.debug((Object)"user left room");
        }
    }

    public void incomingChatMsg(AIMSession sess, AIMFrame frame, UserInfo userinfo, String msg) {
        LOG.debug((Object)("<" + userinfo.getSN() + "> " + msg + "[[CHAT MSG]]"));
    }

    private void registerChatListeners(AIMConnection tstconn) {
        tstconn.registerListener(14, 3, this);
        tstconn.registerListener(14, 4, this);
        tstconn.registerListener(14, 2, this);
        tstconn.registerListener(14, 6, this);
        tstconn.registerListener(1, 7, this);
        tstconn.registerListener(1, 5, this);
    }

    public void rateResp(AIMSession sess, AIMFrame frame) {
        if (frame.getConn().getType() == 14) {
            AIMConnection tstconn = frame.getConn();
            this.registerChatListeners(tstconn);
            ServiceHandler service = (ServiceHandler)sess.getHandler(1);
            try {
                service.clientReady(sess, tstconn);
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", (Throwable)e);
            }
        }
    }

    public void redirect(AIMSession sess, AIMFrame frame, Redir redir) {
        if (redir.getGroup() == 14) {
            AIMConnection exist = AIMConnection.findByType(sess, 14);
            if (exist != null) {
                exist.close();
            }
            AIMConnection tstconn = new AIMConnection(sess, 14, redir.getIp());
            try {
                this.registerChatListeners(tstconn);
                tstconn.connect();
                LoginHandler login = (LoginHandler)sess.getHandler(23);
                login.sendCookie(sess, tstconn, redir.getCookie());
            }
            catch (IOException ioe) {
                tstconn.close();
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        }
    }

    public void rateChange(AIMSession sess, AIMFrame frame, int code, RateClass rc) {
    }

    public void serverPause(AIMSession sess, AIMFrame frame) {
    }

    public void serverResume(AIMSession sess, AIMFrame frame) {
    }

    public void selfInfo(AIMSession sess, AIMFrame frame, UserInfo userinfo) {
    }

    public void evilNotify(AIMSession sess, AIMFrame frame, int newEvil, UserInfo userinfo) {
    }

    public void migrate(AIMSession sess, AIMFrame frame, String ip, byte[] cookie) {
    }

    public void motd(AIMSession sess, AIMFrame frame, int id, String msg) {
    }

    public void memRequest(AIMSession sess, AIMFrame frame, int offset, int len, String modname) {
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(1, 7, this);
        bosconn.registerListener(1, 5, this);
    }
}

