/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFingerPrintInfo;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.Chat;
import org.walluck.oscar.ICBMParams;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.MsgCookie;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.aolim.AOLIM;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.client.DaimMsgListener;
import org.walluck.oscar.handlers.ICBMHandler;
import org.walluck.oscar.handlers.ICBMListener;
import org.walluck.oscar.handlers.filetransfer.FileTransfer;
import org.walluck.oscar.handlers.icq.ICQSMSMessage;
import org.walluck.oscar.handlers.icq.IncomingIMCH4;
import org.walluck.oscar.handlers.trilliansecureim.TrillianSecureIM;
import org.walluck.oscar.requests.JoinRoomRequest;
import org.walluck.oscar.tools.BuddyListTool;
import org.walluck.oscar.tools.IconTool;
import org.walluck.oscar.tools.Tool;

public class ICBMTool
extends Tool
implements ICBMListener {
    private static final Logger LOG = Logger.getLogger((String)ICBMTool.class.getName());

    public ICBMTool() {
        this.setFamily(4);
        this.setId(272);
        this.setVersion(1849);
    }

    public void sendIM(String name, String message, int imflags) throws IOException {
        AOLIM args = new AOLIM();
        args.setFlags(args.getFlags() | 2);
        if (this.getSession().isICQ()) {
            args.setFlags(args.getFlags() | 0x800);
        } else if ((imflags & 1) != 0) {
            args.setFlags(args.getFlags() | 1);
        }
        args.setDestSN(name);
        if ((args.getFlags() & 4) != 0) {
            args.setCharset(2);
            args.setCharSubset(0);
        } else if ((args.getFlags() & 8) != 0) {
            args.setCharset(3);
            args.setCharSubset(0);
        } else {
            args.setCharset(0);
            args.setCharSubset(0);
        }
        args.setMsg(message);
        ICBMHandler im = (ICBMHandler)this.getSession().getHandler(4);
        im.sendCH1Ext(this.getSession(), args);
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(4, 7, this);
        bosconn.registerListener(4, 10, this);
        bosconn.registerListener(4, 11, this);
        bosconn.registerListener(4, 12, this);
        bosconn.registerListener(4, 5, this);
        bosconn.registerListener(4, 20, this);
    }

    public void outgoingIM(AIMSession sess, AIMFrame frame, int channel, String sn, String msg, int icbmflags, short flag1, short flag2) {
    }

    public void incomingIMCH1(AIMSession sess, AIMFrame frame, int channel, UserInfo userinfo, AOLIM args) {
        String client = "unknown client";
        if (args.getFeatures() != null) {
            int id = AIMFingerPrintInfo.getFingerPrintId(args.getFeatures());
            switch (id) {
                case 1: {
                    client = "AOL Mobile Communicator";
                    break;
                }
                case 2: {
                    client = "WinAIM";
                    break;
                }
                case 3: {
                    client = "WinAIM 4.1";
                    break;
                }
                case 4: {
                    client = "AOL, CompuServe, TOC, or iChat";
                    break;
                }
                case 5: {
                    client = "ICQ";
                }
            }
        }
        LOG.debug((Object)(userinfo.getSN() + " (using " + client + "): " + args.getMsg()));
        BuddyListTool blt = (BuddyListTool)this.getSession().getTool(3);
        Buddy buddy = blt.findBuddy(userinfo.getSN());
        DaimMsgListener[] ls = (DaimMsgListener[])this.listeners.getListeners(DaimMsgListener.class);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].incomingIM(buddy, userinfo, args);
        }
    }

    public void incomingIMCH2(AIMSession sess, AIMFrame frame, int channel, UserInfo userinfo, IncomingIMCH2 args) {
        LOG.debug((Object)(userinfo.getSN() + " sent us the message=" + args.getMsg()));
        if ((args.getReqClass() & 4) != 0) {
            LOG.debug((Object)(sess.getSN() + " received direct im request from " + userinfo.getSN() + " (" + args.getVerifiedIP() + ")"));
            LOG.debug((Object)(args.getClientIP1() + ":" + args.getClientIP2()));
            return;
        }
        if ((args.getReqClass() & 8) != 0) {
            Chat chat2 = args.getInfo().getChat().getRoomInfo();
            LOG.debug((Object)("Want to join room: " + AIMUtil.extractRoomName(chat2.getName()) + ", " + chat2.getExchange() + ", " + chat2.getInstance()));
            LOG.debug((Object)("Invite message: " + args.getMsg()));
            JoinRoomRequest jrr = new JoinRoomRequest();
            jrr.setExchange(chat2.getExchange());
            jrr.setName(chat2.getName());
            jrr.setInstance(chat2.getInstance());
            jrr.setMessage(args.getMsg());
            jrr.setSender(userinfo.getSN());
            DaimMsgListener[] ls = (DaimMsgListener[])this.listeners.getListeners(DaimMsgListener.class);
            for (int i = 0; i < ls.length; ++i) {
                ls[i].joinRoomRequest(jrr);
            }
            return;
        }
        if ((args.getReqClass() & 1) != 0) {
            byte[] icon = args.getInfo().getIcon().getIcon();
            int iconcsum = args.getInfo().getIcon().getChecksum();
            LOG.debug((Object)("Received icon for " + userinfo.getSN()));
            IconTool it = (IconTool)this.getSession().getTool(16);
            if (!it.checkIcon(this.getSession().getSN(), iconcsum)) {
                it.writeIcon(this.getSession().getSN(), icon);
            }
            return;
        }
        if ((args.getReqClass() & 0x20) != 0) {
            LOG.debug((Object)"DOCUMENT ME! (ICBMTool-1)");
            String ip = null;
            String ip1 = args.getClientIP1();
            String ip2 = args.getClientIP2();
            String ip3 = args.getVerifiedIP();
            LOG.debug((Object)(ip3 + "/" + ip2 + "/" + ip1));
            if (args.isProxied() && ip1 != null) {
                ip = ip1;
            } else if (ip3 != null) {
                ip = ip3;
            } else if (ip1 != null) {
                ip = ip1;
            } else if (ip2 != null) {
                ip = ip2;
            } else if (ip == null) {
                return;
            }
            MsgCookie cookie = new MsgCookie(frame.getConn(), null, 17, null);
            FileTransfer ftrans = new FileTransfer(sess);
            ftrans.sendFileAccept(cookie.getCookie(), args.getCookie(), userinfo.getSN(), ip, args.getPort());
            return;
        }
        if ((args.getReqClass() & 0x10) != 0) {
            LOG.debug((Object)"DOCUMENT ME! (ICBMTool-2)");
            String ip = null;
            String ip1 = args.getClientIP1();
            String ip2 = args.getClientIP2();
            String ip3 = args.getVerifiedIP();
            LOG.debug((Object)(ip3 + "/" + ip2 + "/" + ip1));
            if (args.isProxied() && ip1 != null) {
                ip = ip1;
            } else if (ip3 != null) {
                ip = ip3;
            } else if (ip1 != null) {
                ip = ip1;
            } else if (ip2 != null) {
                ip = ip2;
            } else if (ip == null) {
                return;
            }
            MsgCookie cookie = new MsgCookie(frame.getConn(), null, 17, null);
            FileTransfer ftrans = new FileTransfer(sess);
            ftrans.getFileAccept(cookie.getCookie(), args.getCookie(), userinfo.getSN(), ip, args.getPort());
            return;
        }
        if ((args.getReqClass() & 0x40) != 0 || (args.getReqClass() & 0x200) != 0 || (args.getReqClass() & 0x80) != 0) {
            LOG.debug((Object)("Game requested: game=" + args.getInfo().getGame() + ", computer=" + args.getInfo().getComputer()));
            return;
        }
        if ((args.getReqClass() & 0x10000) != 0) {
            TrillianSecureIM tsi;
            Hashtable trillianSessions = this.getToolData().getTrillianSessions();
            if (args.getStatus() == 1 || args.getTrillianEncryption().getCmdType() == 4) {
                tsi = (TrillianSecureIM)trillianSessions.remove(AIMUtil.normalize(userinfo.getSN()));
                String present = "not present";
                if (tsi != null) {
                    present = "present";
                }
                if (args.getStatus() == 1) {
                    LOG.debug((Object)(userinfo.getSN() + " cancelled Tril SecureIM and tsi=" + present));
                }
                if (args.getTrillianEncryption().getCmdType() == 4) {
                    LOG.debug((Object)(userinfo.getSN() + " closed Tril SecureIM and tsi=" + present));
                }
            }
            if ((tsi = (TrillianSecureIM)trillianSessions.get(AIMUtil.normalize(userinfo.getSN()))) != null) {
                LOG.debug((Object)("Found existing Trillian SecureIM session with " + userinfo.getSN()));
                tsi.handleSecureIM(args);
            } else {
                LOG.debug((Object)("No previous Trillian SecureIM session with " + userinfo.getSN() + " found. Creating..."));
                tsi = new TrillianSecureIM(sess, userinfo.getSN());
                trillianSessions.put(AIMUtil.normalize(userinfo.getSN()), tsi);
                tsi.handleSecureIM(args);
            }
            return;
        }
        LOG.warn((Object)"Unhandled incomingIMCH2 !!!");
    }

    public void incomingIMCH4(AIMSession sess, AIMFrame frame, int channel, UserInfo userinfo, IncomingIMCH4 args) {
        String icqSep = "";
        LOG.debug((Object)(userinfo.getSN() + ": " + args.getMsg() + " (" + ICBMTool.getIMCH4TypeString(args.getType()) + ")"));
        try {
            icqSep = new String(new byte[]{-2}, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.error((Object)"UnsupportedEncodingException", (Throwable)uee);
        }
        switch (args.getType() & Short.MAX_VALUE) {
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                DaimMsgListener[] ls = (DaimMsgListener[])this.listeners.getListeners(DaimMsgListener.class);
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].incomingICQ(userinfo, args.getUIN(), args.getType(), args.getMsg());
                }
                break;
            }
            case 4: {
                StringTokenizer st = new StringTokenizer(args.getMsg(), icqSep);
                String url = st.nextToken();
                String desc = st.nextToken();
                LOG.debug((Object)("URL=" + url + (desc != null ? " (" + desc + ")" : "")));
                DaimMsgListener[] ls = (DaimMsgListener[])this.listeners.getListeners(DaimMsgListener.class);
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].receivedURL(userinfo, args.getUIN(), url, desc, (args.getType() & 0x8000) != 0);
                }
                break;
            }
            case 19: {
                StringTokenizer st2 = new StringTokenizer(args.getMsg(), icqSep);
                int buddyCount = Integer.parseInt(st2.nextToken());
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < buddyCount; ++i) {
                    String uin = st2.nextToken();
                    String nick = st2.nextToken();
                    map.put(uin, nick);
                    LOG.debug((Object)("UIN=" + uin + ", nick=" + nick));
                }
                DaimMsgListener[] ls = (DaimMsgListener[])this.listeners.getListeners(DaimMsgListener.class);
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].receivedContacts(userinfo, args.getUIN(), map, (args.getType() & 0x8000) != 0);
                }
                break;
            }
            case 26: {
                ICQSMSMessage ism = new ICQSMSMessage(args.getMsg());
                LOG.debug((Object)ism.toString());
                DaimMsgListener[] ls = (DaimMsgListener[])this.listeners.getListeners(DaimMsgListener.class);
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].receivedICQSMS(userinfo, args.getUIN(), ism, (args.getType() & 0x8000) != 0);
                }
                break;
            }
            default: {
                LOG.error((Object)"Unknown IMCH4 message!");
            }
        }
    }

    public static String getIMCH4TypeString(int type) {
        String typeString;
        switch (type & Short.MAX_VALUE) {
            case 1: {
                typeString = "Normal message";
                break;
            }
            case 4: {
                typeString = "URL";
                break;
            }
            case 6: {
                typeString = "Requesting authorization from you";
                break;
            }
            case 7: {
                typeString = "User has denied your authorization request";
                break;
            }
            case 8: {
                typeString = "User has granted your authorization request";
                break;
            }
            case 12: {
                typeString = "User has added you to their contact list";
                break;
            }
            case 13: {
                typeString = "User has sent you this message via the web";
                break;
            }
            case 14: {
                typeString = "User has sent you this message via email";
                break;
            }
            case 18: {
                typeString = "Acknowledgement";
                break;
            }
            case 19: {
                typeString = "Contacts";
                break;
            }
            case 26: {
                typeString = "User sent you this message via SMS";
                break;
            }
            default: {
                typeString = "Unknown message type=" + Integer.toHexString(type);
            }
        }
        if ((type & 0x8000) != 0) {
            typeString = typeString + " [Mass message]";
        }
        return typeString;
    }

    public void paramInfo(AIMSession sess, AIMFrame frame, ICBMParams params) {
        params.setMaxChan(0);
        params.setFlags(sess.isICQ() ? 3 : 11);
        params.setMaxMsgLen(8000);
        params.setMaxSenderWarn(999);
        params.setMaxReceiverWarn(999);
        params.setMinMsgInterval(0);
        try {
            ICBMHandler im = (ICBMHandler)sess.getHandler(4);
            im.setICBMParams(sess, params);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void missedCall(AIMSession sess, AIMFrame frame, int channel, UserInfo userinfo, int numMissed, int reason) {
        String s = "unknown reason";
        switch (reason) {
            case 0: {
                s = "invalid";
                break;
            }
            case 1: {
                s = "too large";
                break;
            }
            case 2: {
                s = "rate exceeded";
                break;
            }
            case 3: {
                s = "sender too evil";
                break;
            }
            case 4: {
                s = "receiver too evil";
                break;
            }
        }
        LOG.debug((Object)("You missed " + numMissed + " message(s) from " + userinfo.getSN() + " because " + s));
    }

    public void clientAutoresp(AIMSession sess, AIMFrame frame, int channel, String sn, int reason) {
    }

    public void clientAutoresp(AIMSession sess, AIMFrame frame, int channel, String sn, int reason, int state, String msg) {
        LOG.debug((Object)("screenname=" + sn + ", status=" + ICBMTool.icqStatus(state) + ", msg=" + msg));
    }

    private static String icqStatus(int state) {
        if ((state & 0x20) != 0) {
            return "Free For Chat";
        }
        if ((state & 0x13) != 0) {
            return "Do Not Disturb";
        }
        if ((state & 5) != 0) {
            return "Not Available";
        }
        if ((state & 0x11) != 0) {
            return "Occupied";
        }
        if ((state & 1) != 0) {
            return "Away";
        }
        if ((state & 0x30000) != 0) {
            return "Web Aware";
        }
        if ((state & 0x100) != 0) {
            return "Invisible";
        }
        return "Online";
    }

    public void msgAck(AIMSession sess, AIMFrame frame, int type, String sn) {
        LOG.debug((Object)("Sent message to " + sn));
    }

    public void typingNotification(AIMSession sess, AIMFrame frame, byte[] ck, short type, String sn, short typing) {
        LOG.debug((Object)("Got typing code=" + Integer.toHexString(typing)));
        DaimMsgListener[] ls = (DaimMsgListener[])this.listeners.getListeners(DaimMsgListener.class);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].typingNotification(sn, typing);
        }
    }

    public void addListener(DaimMsgListener l) {
        this.listeners.add(DaimMsgListener.class, l);
    }

    public void removeListener(DaimMsgListener l) {
        this.listeners.remove(DaimMsgListener.class, l);
    }
}

