/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.handlers.ICQListener;
import org.walluck.oscar.handlers.icq.ICQMetaFound;
import org.walluck.oscar.handlers.icq.ICQMetaGeneral;
import org.walluck.oscar.handlers.icq.ICQMetaMore;
import org.walluck.oscar.handlers.icq.ICQMetaWork;
import org.walluck.oscar.handlers.icq.ICQOfflineMsg;
import org.walluck.oscar.handlers.icq.ICQPacket;
import org.walluck.oscar.tools.Tool;

public class ICQTool
extends Tool
implements ICQListener {
    private static final Logger LOG = Logger.getLogger((String)ICQTool.class.getName());

    public ICQTool() {
        this.setFamily(21);
        this.setId(272);
        this.setVersion(1849);
    }

    public void shutdown(AIMSession sess) {
    }

    public void bosConnectionAvailable() {
        AIMConnection bosconn = this.getToolData().getBosconn();
        bosconn.registerListener(21, 3, this);
    }

    public void srvOfflineMsgDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaGeneralDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaMoreDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaAboutDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaPassDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvMetaGeneral(AIMSession sess, AIMFrame frame, ICQMetaGeneral img) {
    }

    public void srvMetaWork(AIMSession sess, AIMFrame frame, ICQMetaWork imw) {
    }

    public void srvMetaMore(AIMSession sess, AIMFrame frame, ICQMetaMore imm) {
    }

    public void srvMetaAbout(AIMSession sess, AIMFrame frame, String about) {
    }

    public void srvMetaMoreEmail(AIMSession sess, AIMFrame frame, byte country, byte flags, String email) {
    }

    public void srvMetaInterest(AIMSession sess, AIMFrame frame, byte interestCount, ArrayList interestAreas, ArrayList interestDescriptions) {
    }

    public void srvMetaBackground(AIMSession sess, AIMFrame frame, byte pastCount, ArrayList pastAreas, ArrayList pastDescriptions, byte affiliationCount, ArrayList affiliationAreas, ArrayList affiliationDescriptions) {
    }

    public void srvMetaInfo(AIMSession sess, AIMFrame frame, ICQMetaGeneral img) {
        ICQPacket icqPacket = this.getICQPacket(frame);
        if (icqPacket == null) {
            return;
        }
        byte[] data = icqPacket.getData();
        AIMInputStream buffer = new AIMInputStream(new ByteArrayInputStream(data));
        String uin = "invalid";
        try {
            uin = "" + buffer.readIntLE();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        LOG.debug((Object)("Got info for " + uin + "/" + img.getNick() + "/" + img.getFirst() + "/" + img.getLast() + "/" + img.getEmail()));
    }

    public void srvMeta10E(AIMSession sess, AIMFrame frame, int unknown) {
    }

    public void srvMetaFound(AIMSession sess, AIMFrame frame, ICQMetaFound imf) {
    }

    public void srvMetaLast(AIMSession sess, AIMFrame frame, ICQMetaFound imf, int missed) {
    }

    public void srvMetaRandom(AIMSession sess, AIMFrame frame, int uin, short group, byte[] externalIP, int port, byte[] internalIP, byte tcpFlags, short tcpVersion, byte[] unknown) {
    }

    public void srvMetaRandomDone(AIMSession sess, AIMFrame frame) {
    }

    public void srvOfflineMsg(AIMSession sess, AIMFrame frame, ICQOfflineMsg msg) {
        LOG.debug((Object)("Received offline message from " + msg.getSender() + ", type=" + Integer.toHexString(msg.getType()) + ", msg=" + msg.getMsg()));
    }

    private ICQPacket getICQPacket(AIMFrame frame) {
        ICQPacket recvicqPacket = frame.getICQPacket();
        int pid = recvicqPacket.getId();
        ICQPacket sendicqPacket = (ICQPacket)frame.getConn().getICQHashtable().remove(new Integer(pid));
        if (sendicqPacket == null) {
            LOG.warn((Object)("No ICQ packet found for recvdpid=0x" + Integer.toHexString(pid)));
            return null;
        }
        return sendicqPacket;
    }
}

