/*
 * Decompiled with CFR 0.152.
 */
package er.workerchannel;

import er.extensions.logging.ERXLogger;
import er.workerchannel.ERFutureResult;
import er.workerchannel.ERResultUnit;
import er.workerchannel.ERWorkUnit;
import er.workerchannel.ERWorkerChannel;
import er.workerchannel.ERWorkerThread;

public class ERLocalWorkerChannel
implements ERWorkerChannel {
    public static final ERXLogger log = ERXLogger.getERXLogger(ERLocalWorkerChannel.class);
    private final int _queueSize;
    private ERWorkUnit[] _workUnitQueue;
    private int _head;
    private int _tail;
    private int _count;
    private boolean _isSuspended;
    private final ERWorkerThread[] _threadPool;

    public ERLocalWorkerChannel(int numberOfThreads, int queueSize) {
        this._queueSize = queueSize;
        this._initalizeWorkUnitQueue();
        this._isSuspended = false;
        this._threadPool = new ERWorkerThread[numberOfThreads];
        for (int i = 0; i < this._threadPool.length; ++i) {
            this._threadPool[i] = new ERWorkerThread("Worker-" + i, this);
        }
    }

    public void startWorkers() {
        for (int i = 0; i < this._threadPool.length; ++i) {
            this._threadPool[i].start();
        }
    }

    public synchronized void shutdownWorkers() {
        int i;
        log.info((Object)("shutdownWorkers() - count = " + this._count));
        while (this._count > 0) {
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        for (i = 0; i < this._threadPool.length; ++i) {
            this._threadPool[i].shutdown();
        }
        for (i = 0; i < this._threadPool.length; ++i) {
            this.notifyAll();
            try {
                this._threadPool[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void suspendWorkers() {
        this._isSuspended = true;
    }

    public void resumeWorkers() {
        this._isSuspended = false;
        this.notifyAll();
    }

    public synchronized ERResultUnit scheduleWorkUnit(ERWorkUnit workUnit) {
        while (this._count >= this._workUnitQueue.length) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        ERFutureResult futureResult = new ERFutureResult();
        workUnit.setFutureResult(futureResult);
        this._workUnitQueue[this._tail] = workUnit;
        this._tail = (this._tail + 1) % this._workUnitQueue.length;
        ++this._count;
        if ((double)this._count >= (double)this._queueSize * 0.15) {
            this.notifyAll();
        }
        return futureResult;
    }

    public synchronized ERWorkUnit dispatchWorkUnit() {
        while (this._count <= 0 || this._isSuspended) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        ERWorkUnit workUnit = this._workUnitQueue[this._head];
        this._head = (this._head + 1) % this._workUnitQueue.length;
        --this._count;
        if ((double)this._count <= (double)this._queueSize * 0.85) {
            this.notifyAll();
        }
        return workUnit;
    }

    public synchronized void cancelScheduledWorkUnits() {
        this._initalizeWorkUnitQueue();
        this._isSuspended = false;
    }

    public int currentQueueSize() {
        return this._count;
    }

    private void _initalizeWorkUnitQueue() {
        this._workUnitQueue = new ERWorkUnit[this._queueSize];
        this._head = 0;
        this._tail = 0;
        this._count = 0;
    }
}

