/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jabsorb.ExceptionTransformer;
import org.jabsorb.JSONRPCBridgeState;
import org.jabsorb.JSONRPCResult;
import org.jabsorb.JSONSerializer;
import org.jabsorb.callback.CallbackController;
import org.jabsorb.callback.InvocationCallback;
import org.jabsorb.localarg.LocalArgController;
import org.jabsorb.localarg.LocalArgResolver;
import org.jabsorb.reflect.ClassAnalyzer;
import org.jabsorb.reflect.ClassData;
import org.jabsorb.reflect.MethodKey;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.Serializer;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRPCBridge
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final ExceptionTransformer IDENTITY_EXCEPTION_TRANSFORMER = new ExceptionTransformer(){
        private static final long serialVersionUID = 2L;

        public Object transform(Throwable t) {
            return t;
        }
    };
    private static final Logger log = LoggerFactory.getLogger((Class)JSONRPCBridge.class);
    private static final JSONRPCBridge globalBridge = new JSONRPCBridge();
    private static JSONSerializer ser = new JSONSerializer();
    private ExceptionTransformer exceptionTransformer = IDENTITY_EXCEPTION_TRANSFORMER;
    private JSONRPCBridgeState state = new JSONRPCBridgeState(this);
    private CallbackController cbc = null;

    public static JSONRPCBridge getGlobalBridge() {
        return globalBridge;
    }

    public static JSONSerializer getSerializer() {
        return ser;
    }

    public static void registerLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        LocalArgController.registerLocalArgResolver(argClazz, contextInterface, argResolver);
    }

    public static void setSerializer(JSONSerializer ser) {
        JSONRPCBridge.ser = ser;
    }

    public static void unregisterLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        LocalArgController.unregisterLocalArgResolver(argClazz, contextInterface, argResolver);
    }

    private static String argSignature(JSONArray arguments) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arguments.length(); ++i) {
            Object jso;
            if (i > 0) {
                buf.append(",");
            }
            try {
                jso = arguments.get(i);
            }
            catch (JSONException e) {
                throw (NoSuchElementException)new NoSuchElementException(e.getMessage()).initCause(e);
            }
            if (jso == null) {
                buf.append("java.lang.Object");
                continue;
            }
            if (jso instanceof String) {
                buf.append("java.lang.String");
                continue;
            }
            if (jso instanceof Number) {
                buf.append("java.lang.Number");
                continue;
            }
            if (jso instanceof JSONArray) {
                buf.append("java.lang.Object[]");
                continue;
            }
            buf.append("java.lang.Object");
        }
        return buf.toString();
    }

    private static String argSignature(Method method) {
        Class<?>[] param = method.getParameterTypes();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < param.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(param[i].getName());
        }
        return buf.toString();
    }

    private static void uniqueMethods(HashSet m, String prefix, HashMap methodMap) {
        Iterator i = methodMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry mentry = i.next();
            MethodKey mk = (MethodKey)mentry.getKey();
            m.add(prefix + mk.getMethodName());
        }
    }

    public JSONRPCResult call(Object[] context, JSONObject jsonReq) {
        JSONRPCResult result;
        JSONArray fixups;
        Object requestId;
        JSONArray arguments;
        String encodedMethod;
        try {
            encodedMethod = jsonReq.getString("method");
            arguments = jsonReq.getJSONArray("params");
            requestId = jsonReq.opt("id");
            fixups = jsonReq.optJSONArray("fixups");
        }
        catch (JSONException e) {
            log.error("no method or parameters in request");
            return new JSONRPCResult(591, null, "method not found (session may have timed out)");
        }
        if (log.isDebugEnabled()) {
            if (fixups != null) {
                log.debug("call " + encodedMethod + "(" + arguments + ")" + ", requestId=" + requestId);
            } else {
                log.debug("call " + encodedMethod + "(" + arguments + ")" + ", fixups=" + fixups + ", requestId=" + requestId);
            }
        }
        if (fixups != null) {
            try {
                for (int i = 0; i < fixups.length(); ++i) {
                    JSONArray assignment = fixups.getJSONArray(i);
                    JSONArray fixup = assignment.getJSONArray(0);
                    JSONArray original = assignment.getJSONArray(1);
                    this.applyFixup(arguments, fixup, original);
                }
            }
            catch (JSONException e) {
                log.error("error applying fixups", (Throwable)e);
                return new JSONRPCResult(594, requestId, "invalid or unexpected data in fixups: " + e.getMessage());
            }
        }
        String className = null;
        String methodName = null;
        int objectID = 0;
        StringTokenizer t = new StringTokenizer(encodedMethod, ".");
        if (t.hasMoreElements()) {
            className = t.nextToken();
        }
        if (t.hasMoreElements()) {
            methodName = t.nextToken();
        }
        if (encodedMethod.startsWith(".obj#")) {
            t = new StringTokenizer(className, "#");
            t.nextToken();
            objectID = Integer.parseInt(t.nextToken());
        }
        ObjectInstance oi = null;
        ClassData cd = null;
        HashMap methodMap = null;
        Method method = null;
        Object itsThis = null;
        if (objectID == 0) {
            if (encodedMethod.equals("system.listMethods")) {
                HashSet m = new HashSet();
                globalBridge.allInstanceMethods(m);
                if (globalBridge != this) {
                    globalBridge.allStaticMethods(m);
                    globalBridge.allInstanceMethods(m);
                }
                this.allStaticMethods(m);
                this.allInstanceMethods(m);
                JSONArray methods = new JSONArray();
                Iterator i = m.iterator();
                while (i.hasNext()) {
                    methods.put(i.next());
                }
                return new JSONRPCResult(0, requestId, methods);
            }
            if (className == null || methodName == null || (oi = this.resolveObject(className)) == null && (cd = this.resolveClass(className)) == null) {
                return new JSONRPCResult(591, requestId, "method not found (session may have timed out)");
            }
            if (oi != null) {
                itsThis = oi.o;
                cd = ClassAnalyzer.getClassData(oi.clazz);
                methodMap = cd.getMethodMap();
            } else if (cd != null) {
                methodMap = cd.getStaticMethodMap();
            }
        } else {
            oi = this.resolveObject(new Integer(objectID));
            if (oi == null) {
                return new JSONRPCResult(591, requestId, "method not found (session may have timed out)");
            }
            itsThis = oi.o;
            cd = ClassAnalyzer.getClassData(oi.clazz);
            methodMap = cd.getMethodMap();
            if (methodName != null && methodName.equals("listMethods")) {
                HashSet m = new HashSet();
                JSONRPCBridge.uniqueMethods(m, "", cd.getStaticMethodMap());
                JSONRPCBridge.uniqueMethods(m, "", cd.getMethodMap());
                JSONArray methods = new JSONArray();
                Iterator i = m.iterator();
                while (i.hasNext()) {
                    methods.put(i.next());
                }
                return new JSONRPCResult(0, requestId, methods);
            }
        }
        method = this.resolveMethod(methodMap, methodName, arguments);
        if (method == null) {
            return new JSONRPCResult(591, requestId, "method not found (session may have timed out)");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("invoking " + method.getReturnType().getName() + " " + method.getName() + "(" + JSONRPCBridge.argSignature(method) + ")");
            }
            Object[] javaArgs = this.unmarshallArgs(context, method, arguments);
            if (this.cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    this.cbc.preInvokeCallback(context[i], itsThis, method, javaArgs);
                }
            }
            Object returnObj = method.invoke(itsThis, javaArgs);
            if (this.cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    this.cbc.postInvokeCallback(context[i], itsThis, method, returnObj);
                }
            }
            SerializerState serializerState = new SerializerState();
            Object json = ser.marshall(serializerState, null, returnObj, "r");
            result = new JSONRPCResult(0, requestId, json, serializerState.getFixUps());
        }
        catch (UnmarshallException e) {
            if (this.cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    this.cbc.errorCallback(context[i], itsThis, method, e);
                }
            }
            log.error("exception occured", (Throwable)e);
            result = new JSONRPCResult(592, requestId, e.getMessage());
        }
        catch (MarshallException e) {
            if (this.cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    this.cbc.errorCallback(context[i], itsThis, method, e);
                }
            }
            log.error("exception occured", (Throwable)e);
            result = new JSONRPCResult(593, requestId, e.getMessage());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (this.cbc != null) {
                for (int i = 0; i < context.length; ++i) {
                    this.cbc.errorCallback(context[i], itsThis, method, e);
                }
            }
            log.error("exception occured", e);
            result = new JSONRPCResult(490, requestId, this.exceptionTransformer.transform(e));
        }
        return result;
    }

    public JSONRPCBridgeState getBridgeState() {
        return this.state;
    }

    public CallbackController getCallbackController() {
        return this.cbc;
    }

    public HashMap getReferenceMap() {
        return this.state.getReferenceMap();
    }

    public boolean isCallableReference(Class clazz) {
        if (this == globalBridge) {
            return false;
        }
        HashSet callableReferenceSet = this.state.getCallableReferenceSet();
        if (callableReferenceSet == null) {
            return false;
        }
        if (callableReferenceSet.contains(clazz)) {
            return true;
        }
        return globalBridge.isCallableReference(clazz);
    }

    public boolean isReference(Class clazz) {
        if (this == globalBridge) {
            return false;
        }
        HashSet referenceSet = this.state.getReferenceSet();
        if (referenceSet == null) {
            return false;
        }
        if (referenceSet.contains(clazz)) {
            return true;
        }
        return globalBridge.isReference(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class lookupClass(String name) {
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap classMap = this.state.getClassMap();
            return (Class)classMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupObject(Object key) {
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap objectMap = this.state.getObjectMap();
            ObjectInstance oi = (ObjectInstance)objectMap.get(key);
            if (oi != null) {
                return oi.o;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallableReference(Class clazz) throws Exception {
        if (this == globalBridge) {
            throw new Exception("Can't register callable reference on global bridge");
        }
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            if (this.state.getReferenceSerializer() == null) {
                this.state.enableReferences();
            }
            this.state.getCallableReferenceSet().add(clazz);
        }
        if (log.isDebugEnabled()) {
            log.debug("registered callable reference " + clazz.getName());
        }
    }

    public void registerCallback(InvocationCallback callback, Class contextInterface) {
        if (this.cbc == null) {
            this.cbc = new CallbackController();
        }
        this.cbc.registerCallback(callback, contextInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClass(String name, Class clazz) throws Exception {
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap classMap = this.state.getClassMap();
            Class exists = (Class)classMap.get(name);
            if (exists != null && exists != clazz) {
                throw new Exception("different class registered as " + name);
            }
            if (exists == null) {
                classMap.put(name, clazz);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("registered class " + clazz.getName() + " as " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object key, Object o) {
        ObjectInstance oi = new ObjectInstance(o);
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap objectMap = this.state.getObjectMap();
            objectMap.put(key, oi);
        }
        if (log.isDebugEnabled()) {
            log.debug("registered object " + o.hashCode() + " of class " + o.getClass().getName() + " as " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object key, Object o, Class interfaceClass) {
        ObjectInstance oi = new ObjectInstance(o, interfaceClass);
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap objectMap = this.state.getObjectMap();
            objectMap.put(key, oi);
        }
        if (log.isDebugEnabled()) {
            log.debug("registered object " + o.hashCode() + " of class " + interfaceClass.getName() + " as " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReference(Class clazz) throws Exception {
        if (this == globalBridge) {
            throw new Exception("Can't register reference on global bridge");
        }
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            if (this.state.getReferenceSerializer() == null) {
                this.state.enableReferences();
            }
            this.state.getReferenceSet().add(clazz);
        }
        if (log.isDebugEnabled()) {
            log.debug("registered reference " + clazz.getName());
        }
    }

    public void registerSerializer(Serializer serializer) throws Exception {
        ser.registerSerializer(serializer);
    }

    public void setBridgeState(JSONRPCBridgeState state) {
        this.state = state;
    }

    public void setCallbackController(CallbackController cbc) {
        this.cbc = cbc;
    }

    public void setExceptionTransformer(ExceptionTransformer exceptionTransformer) {
        this.exceptionTransformer = exceptionTransformer;
    }

    public void unregisterCallback(InvocationCallback callback, Class contextInterface) {
        if (this.cbc == null) {
            return;
        }
        this.cbc.unregisterCallback(callback, contextInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClass(String name) {
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap classMap = this.state.getClassMap();
            Class clazz = (Class)classMap.get(name);
            if (clazz != null) {
                classMap.remove(name);
                if (log.isDebugEnabled()) {
                    log.debug("unregistered class " + clazz.getName() + " from " + name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObject(Object key) {
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap objectMap = this.state.getObjectMap();
            ObjectInstance oi = (ObjectInstance)objectMap.get(key);
            if (oi.o != null) {
                objectMap.remove(key);
                if (log.isDebugEnabled()) {
                    log.debug("unregistered object " + oi.o.hashCode() + " of class " + oi.clazz.getName() + " from " + key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allInstanceMethods(HashSet m) {
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap objectMap = this.state.getObjectMap();
            Iterator i = objectMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry oientry = i.next();
                Object key = oientry.getKey();
                if (!(key instanceof String)) continue;
                String name = (String)key;
                ObjectInstance oi = (ObjectInstance)oientry.getValue();
                ClassData cd = ClassAnalyzer.getClassData(oi.clazz);
                JSONRPCBridge.uniqueMethods(m, name + ".", cd.getMethodMap());
                JSONRPCBridge.uniqueMethods(m, name + ".", cd.getStaticMethodMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allStaticMethods(HashSet m) {
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap classMap = this.state.getClassMap();
            Iterator i = classMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry cdentry = i.next();
                String name = (String)cdentry.getKey();
                Class clazz = (Class)cdentry.getValue();
                ClassData cd = ClassAnalyzer.getClassData(clazz);
                JSONRPCBridge.uniqueMethods(m, name + ".", cd.getStaticMethodMap());
            }
        }
    }

    private void applyFixup(JSONArray arguments, JSONArray fixup, JSONArray original) throws JSONException {
        int last = fixup.length() - 1;
        if (last < 0) {
            throw new JSONException("fixup path must contain at least 1 reference");
        }
        Object originalObject = this.traverse(arguments, original, false);
        Object fixupParent = this.traverse(arguments, fixup, true);
        if (fixupParent instanceof JSONObject) {
            String objRef = fixup.optString(last, null);
            if (objRef == null) {
                throw new JSONException("last fixup reference not a string");
            }
            ((JSONObject)fixupParent).put(objRef, originalObject);
        } else {
            int arrRef = fixup.optInt(last, -1);
            if (arrRef == -1) {
                throw new JSONException("last fixup reference not a valid array index");
            }
            ((JSONArray)fixupParent).put(arrRef, originalObject);
        }
    }

    private Object traverse(JSONArray origin, JSONArray refs, boolean fixup) throws JSONException {
        try {
            JSONArray arr = origin;
            JSONObject obj = null;
            int stop = refs.length();
            if (fixup) {
                --stop;
            }
            for (int i = 0; i < stop; ++i) {
                Object next = arr == null ? this.next(obj, refs.optString(i, null)) : this.next((Object)arr, refs.optInt(i, -1));
                if (next instanceof JSONObject) {
                    obj = (JSONObject)next;
                    arr = null;
                    continue;
                }
                obj = null;
                arr = (JSONArray)next;
            }
            if (arr == null) {
                return obj;
            }
            return arr;
        }
        catch (Exception e) {
            log.error("unexpected exception", (Throwable)e);
            throw new JSONException("unexpected exception");
        }
    }

    private Object next(Object prev, int idx) throws JSONException {
        if (prev == null) {
            throw new JSONException("cannot traverse- missing object encountered");
        }
        if (prev instanceof JSONArray) {
            return ((JSONArray)prev).get(idx);
        }
        throw new JSONException("not an array");
    }

    private Object next(Object prev, String ref) throws JSONException {
        if (prev == null) {
            throw new JSONException("cannot traverse- missing object encountered");
        }
        if (prev instanceof JSONObject) {
            return ((JSONObject)prev).get(ref);
        }
        throw new JSONException("not an object");
    }

    private MethodCandidate betterSignature(MethodCandidate methodCandidate, MethodCandidate methodCandidate1) {
        Method method = methodCandidate.method;
        Method method1 = methodCandidate1.method;
        Class<?>[] parameters = method.getParameterTypes();
        Class<?>[] parameters1 = method1.getParameterTypes();
        int c = 0;
        int c1 = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> parameterClass = parameters[i];
            Class<?> parameterClass1 = parameters1[i];
            if (parameterClass == parameterClass1) continue;
            if (parameterClass.isAssignableFrom(parameterClass1)) {
                ++c1;
                continue;
            }
            ++c;
        }
        if (c1 > c) {
            return methodCandidate1;
        }
        return methodCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassData resolveClass(String className) {
        Class clazz;
        ClassData cd = null;
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap classMap = this.state.getClassMap();
            clazz = (Class)classMap.get(className);
        }
        if (clazz != null) {
            cd = ClassAnalyzer.getClassData(clazz);
        }
        if (cd != null) {
            if (log.isDebugEnabled()) {
                log.debug("found class " + cd.getClazz().getName() + " named " + className);
            }
            return cd;
        }
        if (this != globalBridge) {
            return globalBridge.resolveClass(className);
        }
        return null;
    }

    private Method resolveMethod(HashMap methodMap, String methodName, JSONArray arguments) {
        MethodKey mk = new MethodKey(methodName, arguments.length());
        Object o = methodMap.get(mk);
        if (o instanceof Method) {
            Method m = (Method)o;
            if (log.isDebugEnabled()) {
                log.debug("found method " + methodName + "(" + JSONRPCBridge.argSignature(m) + ")");
            }
            return m;
        }
        if (!(o instanceof Method[])) {
            return null;
        }
        Method[] method = (Method[])o;
        ArrayList<MethodCandidate> candidate = new ArrayList<MethodCandidate>();
        if (log.isDebugEnabled()) {
            log.debug("looking for method " + methodName + "(" + JSONRPCBridge.argSignature(arguments) + ")");
        }
        for (int i = 0; i < method.length; ++i) {
            try {
                candidate.add(this.tryUnmarshallArgs(method[i], arguments));
                if (!log.isDebugEnabled()) continue;
                log.debug("+++ possible match with method " + methodName + "(" + JSONRPCBridge.argSignature(method[i]) + ")");
                continue;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("xxx " + e.getMessage() + " in " + methodName + "(" + JSONRPCBridge.argSignature(method[i]) + ")");
            }
        }
        MethodCandidate best = null;
        for (int i = 0; i < candidate.size(); ++i) {
            MethodCandidate c = (MethodCandidate)candidate.get(i);
            if (best == null) {
                best = c;
                continue;
            }
            ObjectMatch bestMatch = best.getMatch();
            ObjectMatch cMatch = c.getMatch();
            if (bestMatch.getMismatch() > cMatch.getMismatch()) {
                best = c;
                continue;
            }
            if (bestMatch.getMismatch() != cMatch.getMismatch()) continue;
            best = this.betterSignature(best, c);
        }
        if (best != null) {
            Method m = best.method;
            if (log.isDebugEnabled()) {
                log.debug("found method " + methodName + "(" + JSONRPCBridge.argSignature(m) + ")");
            }
            return m;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectInstance resolveObject(Object key) {
        ObjectInstance oi;
        JSONRPCBridgeState jSONRPCBridgeState = this.state;
        synchronized (jSONRPCBridgeState) {
            HashMap objectMap = this.state.getObjectMap();
            oi = (ObjectInstance)objectMap.get(key);
        }
        if (log.isDebugEnabled() && oi != null) {
            log.debug("found object " + oi.o.hashCode() + " of class " + oi.clazz.getName() + " with key " + key);
        }
        if (oi == null && this != globalBridge) {
            return globalBridge.resolveObject(key);
        }
        return oi;
    }

    private MethodCandidate tryUnmarshallArgs(Method method, JSONArray arguments) throws UnmarshallException {
        int i;
        MethodCandidate candidate = new MethodCandidate(method);
        Class<?>[] param = method.getParameterTypes();
        int j = 0;
        try {
            for (i = 0; i < param.length; ++i) {
                SerializerState serialiserState = new SerializerState();
                candidate.match[i] = LocalArgController.isLocalArg(param[i]) ? ObjectMatch.OKAY : ser.tryUnmarshall(serialiserState, param[i], arguments.get(j++));
            }
        }
        catch (JSONException e) {
            throw (NoSuchElementException)new NoSuchElementException(e.getMessage()).initCause(e);
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("arg " + (i + 1) + " " + e.getMessage(), e);
        }
        return candidate;
    }

    private Object[] unmarshallArgs(Object[] context, Method method, JSONArray arguments) throws UnmarshallException {
        int i;
        Class<?>[] param = method.getParameterTypes();
        Object[] javaArgs = new Object[param.length];
        int j = 0;
        try {
            for (i = 0; i < param.length; ++i) {
                SerializerState serializerState = new SerializerState();
                javaArgs[i] = LocalArgController.isLocalArg(param[i]) ? LocalArgController.resolveLocalArg(context, param[i]) : ser.unmarshall(serializerState, param[i], arguments.get(j++));
            }
        }
        catch (JSONException e) {
            throw (NoSuchElementException)new NoSuchElementException(e.getMessage()).initCause(e);
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("arg " + (i + 1) + " could not unmarshall", e);
        }
        return javaArgs;
    }

    static {
        try {
            ser.registerDefaultSerializers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static class ObjectInstance
    implements Serializable {
        private static final long serialVersionUID = 2L;
        protected Object o;
        protected Class clazz;

        public ObjectInstance(Object o) {
            this.o = o;
            this.clazz = o.getClass();
        }

        public ObjectInstance(Object o, Class clazz) {
            if (!clazz.isInstance(o)) {
                throw new ClassCastException("Attempt to register jsonrpc object with invalid class.");
            }
            this.o = o;
            this.clazz = clazz;
        }
    }

    protected static class MethodCandidate {
        Method method;
        ObjectMatch[] match;

        public MethodCandidate(Method method) {
            this.method = method;
            this.match = new ObjectMatch[method.getParameterTypes().length];
        }

        public ObjectMatch getMatch() {
            int mismatch = -1;
            for (int i = 0; i < this.match.length; ++i) {
                mismatch = Math.max(mismatch, this.match[i].getMismatch());
            }
            if (mismatch == -1) {
                return ObjectMatch.OKAY;
            }
            return new ObjectMatch(mismatch);
        }
    }
}

