/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jabsorb.localarg.LocalArgController;
import org.jabsorb.reflect.ClassData;
import org.jabsorb.reflect.MethodKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassAnalyzer {
    private static final Logger log = LoggerFactory.getLogger((Class)ClassAnalyzer.class);
    private static HashMap classCache = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassData getClassData(Class clazz) {
        ClassData cd;
        HashMap hashMap = classCache;
        synchronized (hashMap) {
            cd = (ClassData)classCache.get(clazz);
            if (cd == null) {
                cd = ClassAnalyzer.analyzeClass(clazz);
                classCache.put(clazz, cd);
            }
        }
        return cd;
    }

    public static void invalidateCache() {
        classCache = new HashMap();
    }

    private static ClassData analyzeClass(Class clazz) {
        ArrayList marr;
        Map.Entry entry;
        log.info("analyzing " + clazz.getName());
        Method[] methods = clazz.getMethods();
        ClassData cd = new ClassData();
        cd.clazz = clazz;
        HashMap<MethodKey, ArrayList<Method>> staticMethodMap = new HashMap<MethodKey, ArrayList<Method>>();
        HashMap<MethodKey, ArrayList<Method>> methodMap = new HashMap<MethodKey, ArrayList<Method>>();
        for (int i = 0; i < methods.length; ++i) {
            int mod;
            Method method = methods[i];
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? ClassAnalyzer.class$("java.lang.Object") : class$java$lang$Object) || !Modifier.isPublic(mod = methods[i].getModifiers())) continue;
            Class<?>[] param = method.getParameterTypes();
            int argCount = 0;
            for (int n = 0; n < param.length; ++n) {
                if (LocalArgController.isLocalArg(param[n])) continue;
                ++argCount;
            }
            MethodKey mk = new MethodKey(method.getName(), argCount);
            ArrayList<Method> marr2 = (ArrayList<Method>)methodMap.get(mk);
            if (marr2 == null) {
                marr2 = new ArrayList<Method>();
                methodMap.put(mk, marr2);
            }
            marr2.add(method);
            if (!Modifier.isStatic(mod)) continue;
            marr2 = (ArrayList<Method>)staticMethodMap.get(mk);
            if (marr2 == null) {
                marr2 = new ArrayList<Method>();
                staticMethodMap.put(mk, marr2);
            }
            marr2.add(method);
        }
        cd.methodMap = new HashMap();
        cd.staticMethodMap = new HashMap();
        Iterator i = methodMap.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            MethodKey mk = (MethodKey)entry.getKey();
            marr = (ArrayList)entry.getValue();
            if (marr.size() == 1) {
                cd.methodMap.put(mk, marr.get(0));
                continue;
            }
            cd.methodMap.put(mk, marr.toArray(new Method[0]));
        }
        i = staticMethodMap.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            MethodKey mk = (MethodKey)entry.getKey();
            marr = (ArrayList)entry.getValue();
            if (marr.size() == 1) {
                cd.staticMethodMap.put(mk, marr.get(0));
                continue;
            }
            cd.staticMethodMap.put(mk, marr.toArray(new Method[0]));
        }
        return cd;
    }
}

