/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{List.class, ArrayList.class, LinkedList.class, Vector.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && List.class.isAssignableFrom(clazz);
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        List list = (List)o;
        JSONObject obj = new JSONObject();
        JSONArray arr = new JSONArray();
        if (this.ser.getMarshallClassHints()) {
            try {
                obj.put("javaClass", o.getClass().getName());
            }
            catch (JSONException e) {
                throw new MarshallException("javaClass not found!");
            }
        }
        try {
            obj.put("list", arr);
            state.push(o, arr, "list");
        }
        catch (JSONException e) {
            throw new MarshallException("Error setting list: " + e);
        }
        int index = 0;
        try {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object json = this.ser.marshall(state, arr, i.next(), new Integer(index));
                if (JSONSerializer.CIRC_REF_OR_DUPLICATE != json) {
                    arr.put(json);
                } else {
                    arr.put(JSONObject.NULL);
                }
                ++index;
            }
        }
        catch (MarshallException e) {
            throw (MarshallException)new MarshallException("element " + index).initCause(e);
        }
        finally {
            state.pop();
        }
        return obj;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONArray jsonlist;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!(java_class.equals("java.util.List") || java_class.equals("java.util.AbstractList") || java_class.equals("java.util.LinkedList") || java_class.equals("java.util.ArrayList") || java_class.equals("java.util.Vector"))) {
            throw new UnmarshallException("not a List");
        }
        try {
            jsonlist = jso.getJSONArray("list");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read list: " + e.getMessage(), e);
        }
        if (jsonlist == null) {
            throw new UnmarshallException("list missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        state.setSerialized(o, m);
        try {
            for (i = 0; i < jsonlist.length(); ++i) {
                m.setMismatch(this.ser.tryUnmarshall(state, null, jsonlist.get(i)).max(m).getMismatch());
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), e);
        }
        return m;
    }

    /*
     * WARNING - void declaration
     */
    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        void var6_7;
        JSONArray jsonlist;
        AbstractList al;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (java_class.equals("java.util.List") || java_class.equals("java.util.AbstractList") || java_class.equals("java.util.ArrayList")) {
            al = new ArrayList();
        } else if (java_class.equals("java.util.LinkedList")) {
            al = new LinkedList();
        } else if (java_class.equals("java.util.Vector")) {
            al = new Vector();
        } else {
            throw new UnmarshallException("not a List");
        }
        try {
            jsonlist = jso.getJSONArray("list");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read list: " + e.getMessage(), e);
        }
        if (jsonlist == null) {
            throw new UnmarshallException("list missing");
        }
        state.setSerialized(o, var6_7);
        try {
            for (i = 0; i < jsonlist.length(); ++i) {
                var6_7.add(this.ser.unmarshall(state, null, jsonlist.get(i)));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), e);
        }
        return var6_7;
    }
}

