/*
 * Decompiled with CFR 0.152.
 */
package ognl.helperfunction;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import java.lang.reflect.Method;
import ognl.helperfunction.WOHelperFunctionParser;
import org.apache.log4j.Logger;

public class WOHelperFunctionDebugUtilities {
    public static Logger log = Logger.getLogger(WOHelperFunctionDebugUtilities.class);
    private static boolean _resolvedMethods;
    private static Method _debugEnabledForComponentMethod;

    protected static void resolveMethods() {
        if (!_resolvedMethods) {
            _resolvedMethods = true;
            try {
                _debugEnabledForComponentMethod = WOApplication.application().getClass().getMethod("debugEnabledForComponent", String.class);
            }
            catch (Throwable e) {
                log.error((Object)"Binding debugging is not available because your application does not implement debugEnabledForComponent(WOComponent).", e);
            }
        }
    }

    public static boolean debugEnabledForComponent(WOComponent component) {
        try {
            WOHelperFunctionDebugUtilities.resolveMethods();
            Boolean debugEnabled = Boolean.FALSE;
            if (_debugEnabledForComponentMethod != null) {
                debugEnabled = (Boolean)_debugEnabledForComponentMethod.invoke((Object)WOApplication.application(), component.name());
            }
            return debugEnabled;
        }
        catch (Exception e) {
            log.warn((Object)"Binding debugging is not available because debugEnabledForComponent(WOComponent) failed.", (Throwable)e);
            return false;
        }
    }

    public static void setDebugEnabled(WOAssociation association, WOComponent component) {
        if (WOHelperFunctionParser._debugSupport) {
            boolean debugEnabled = WOHelperFunctionDebugUtilities.debugEnabledForComponent(component) || WOHelperFunctionDebugUtilities.debugEnabledForComponent(component.context().component());
            association._setDebuggingEnabled(debugEnabled);
        }
    }
}

