/*
 * Decompiled with CFR 0.152.
 */
package ognl.helperfunction;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODeclaration;
import com.webobjects.appserver._private.WOShared;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSStringUtilities;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import ognl.helperfunction.WOHelperFunctionAssociation;
import ognl.helperfunction.WOHelperFunctionDeclarationFormatException;
import ognl.helperfunction.WOHelperFunctionParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class WOHelperFunctionDeclarationParser {
    public static Logger log = Logger.getLogger(WOHelperFunctionDeclarationParser.class);
    private NSMutableDictionary _quotedStrings = new NSMutableDictionary();
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSIDE_COMMENT = 2;
    private static final String ESCAPED_QUOTE_STRING = "_WO_ESCAPED_QUOTE_";
    private static final String QUOTED_STRING_KEY = "_WODP_";

    public static NSMutableDictionary declarationsWithString(String declarationStr) throws WOHelperFunctionDeclarationFormatException {
        WOHelperFunctionDeclarationParser declarationParser = new WOHelperFunctionDeclarationParser();
        NSMutableDictionary declarations = declarationParser.parseDeclarations(declarationStr);
        return declarations;
    }

    public String toString() {
        return "<WOHelperFunctionDeclarationParser quotedStrings = " + this._quotedStrings.toString() + ">";
    }

    public NSMutableDictionary parseDeclarations(String declarationStr) throws WOHelperFunctionDeclarationFormatException {
        String strWithoutComments = this._removeOldStyleCommentsFromString(declarationStr);
        strWithoutComments = this._removeNewStyleCommentsAndQuotedStringsFromString(strWithoutComments);
        NSMutableDictionary declarations = this.parseDeclarationsWithoutComments(strWithoutComments);
        return declarations;
    }

    private String _removeOldStyleCommentsFromString(String str) {
        StringBuffer stringbuffer = new StringBuffer(100);
        StringBuffer stringbuffer1 = new StringBuffer(100);
        StringTokenizer tokenizer = new StringTokenizer(str, "/", true);
        int state = 0;
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                switch (state) {
                    case 0: {
                        if (token.equals("/")) {
                            token = tokenizer.nextToken();
                            if (token.startsWith("*")) {
                                state = 2;
                                stringbuffer1.append('/');
                                stringbuffer1.append(token);
                                break;
                            }
                            stringbuffer.append('/');
                            stringbuffer.append(token);
                            break;
                        }
                        stringbuffer.append(token);
                        break;
                    }
                    case 2: {
                        stringbuffer1.append(token);
                        String s2 = new String(stringbuffer1);
                        if (!s2.endsWith("*/") || s2.equals("/*/")) break;
                        state = 0;
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"Parsing failed.", (Throwable)e);
        }
        return _NSStringUtilities.stringFromBuffer((StringBuffer)stringbuffer);
    }

    private String _removeNewStyleCommentsAndQuotedStringsFromString(String declarationsStr) {
        String escapedQuoteStr = _NSStringUtilities.replaceAllInstancesOfString((String)declarationsStr, (String)"\\\"", (String)ESCAPED_QUOTE_STRING);
        StringBuffer declarationWithoutCommentsBuffer = new StringBuffer(100);
        StringTokenizer tokenizer = new StringTokenizer(escapedQuoteStr, "/\"", true);
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken("/\"");
                if (token.equals("/")) {
                    token = tokenizer.nextToken("\n");
                    if (token.startsWith("/")) {
                        token = _NSStringUtilities.replaceAllInstancesOfString((String)token, (String)ESCAPED_QUOTE_STRING, (String)"\\\"");
                        declarationWithoutCommentsBuffer.append('\n');
                        tokenizer.nextToken();
                        continue;
                    }
                    declarationWithoutCommentsBuffer.append('/');
                    declarationWithoutCommentsBuffer.append(token);
                    continue;
                }
                if (token.equals("\"")) {
                    token = tokenizer.nextToken("\"");
                    if (token.equals("\"")) {
                        token = "";
                    } else {
                        tokenizer.nextToken();
                    }
                    String quotedStringKey = QUOTED_STRING_KEY + this._quotedStrings.count();
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0L)) {
                        NSLog.debug.appendln((Object)("Found a quoted string: " + quotedStringKey + "='" + token + "';"));
                    }
                    token = _NSStringUtilities.replaceAllInstancesOfString((String)token, (String)ESCAPED_QUOTE_STRING, (String)"\"");
                    this._quotedStrings.setObjectForKey((Object)token, (Object)quotedStringKey);
                    declarationWithoutCommentsBuffer.append(quotedStringKey);
                    continue;
                }
                declarationWithoutCommentsBuffer.append(token);
            }
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"Parsing failed.", (Throwable)e);
        }
        return _NSStringUtilities.stringFromBuffer((StringBuffer)declarationWithoutCommentsBuffer);
    }

    private NSMutableDictionary parseDeclarationsWithoutComments(String declarationWithoutComment) throws WOHelperFunctionDeclarationFormatException {
        NSMutableDictionary declarations = new NSMutableDictionary();
        NSMutableDictionary rawDeclarations = this._rawDeclarationsWithoutComment(declarationWithoutComment);
        Enumeration rawDeclarationHeaderEnum = rawDeclarations.keyEnumerator();
        while (rawDeclarationHeaderEnum.hasMoreElements()) {
            String declarationHeader = (String)rawDeclarationHeaderEnum.nextElement();
            String declarationBody = (String)rawDeclarations.objectForKey((Object)declarationHeader);
            int colonIndex = declarationHeader.indexOf(58);
            if (colonIndex < 0) {
                throw new WOHelperFunctionDeclarationFormatException("<WOHelperFunctionDeclarationParser> Missing ':' for declaration:\n" + declarationHeader + " " + declarationBody);
            }
            String tagName = declarationHeader.substring(0, colonIndex).trim();
            if (tagName.length() == 0) {
                throw new WOHelperFunctionDeclarationFormatException("<WOHelperFunctionDeclarationParser> Missing tag name for declaration:\n" + declarationHeader + " " + declarationBody);
            }
            if (declarations.objectForKey((Object)tagName) != null) {
                throw new WOHelperFunctionDeclarationFormatException("<WOHelperFunctionDeclarationParser> Duplicate tag name '" + tagName + "' in declaration:\n" + declarationBody);
            }
            String type = declarationHeader.substring(colonIndex + 1).trim();
            if (type.length() == 0) {
                throw new WOHelperFunctionDeclarationFormatException("<WOHelperFunctionDeclarationParser> Missing element name for declaration:\n" + declarationHeader + " " + declarationBody);
            }
            NSMutableDictionary associations = this._associationsForDictionaryString(declarationHeader, declarationBody);
            WODeclaration declaration = WOHelperFunctionParser.createDeclaration(tagName, type, associations);
            declarations.setObjectForKey((Object)declaration, (Object)tagName);
        }
        return declarations;
    }

    private NSMutableDictionary _associationsForDictionaryString(String declarationHeader, String declarationBody) throws WOHelperFunctionDeclarationFormatException {
        NSMutableDictionary associations = new NSMutableDictionary();
        String trimmedDeclarationBody = declarationBody.trim();
        if (!trimmedDeclarationBody.startsWith("{") && !trimmedDeclarationBody.endsWith("}")) {
            throw new WOHelperFunctionDeclarationFormatException("<WOHelperFunctionDeclarationParser> Internal inconsistency : invalid dictionary for declaration:\n" + declarationHeader + " " + declarationBody);
        }
        int declarationBodyLength = trimmedDeclarationBody.length();
        if (declarationBodyLength <= 2) {
            return associations;
        }
        trimmedDeclarationBody = trimmedDeclarationBody.substring(1, declarationBodyLength - 1).trim();
        NSArray bindings = NSArray.componentsSeparatedByString((String)trimmedDeclarationBody, (String)";");
        Enumeration bindingsEnum = bindings.objectEnumerator();
        while (bindingsEnum.hasMoreElements()) {
            String binding = ((String)bindingsEnum.nextElement()).trim();
            if (binding.length() == 0) continue;
            int equalsIndex = binding.indexOf(61);
            if (equalsIndex < 0) {
                throw new WOHelperFunctionDeclarationFormatException("<WOHelperFunctionDeclarationParser> Invalid line. No equal in line:\n" + binding + "\nfor declaration:\n" + declarationHeader + " " + declarationBody);
            }
            String key = binding.substring(0, equalsIndex).trim();
            if (key.length() == 0) {
                throw new WOHelperFunctionDeclarationFormatException("<WOHelperFunctionDeclarationParser> Missing binding in line:\n" + binding + "\nfor declaration:\n" + declarationHeader + " " + declarationBody);
            }
            String value = binding.substring(equalsIndex + 1).trim();
            if (value.length() == 0) {
                throw new WOHelperFunctionDeclarationFormatException("<WOHelperFunctionDeclarationParser> Missing value in line:\n" + binding + "\nfor declaration:\n" + declarationHeader + " " + declarationBody);
            }
            WOAssociation association = WOHelperFunctionDeclarationParser._associationWithKey(value, (NSDictionary)this._quotedStrings);
            Object quotedString = this._quotedStrings.objectForKey((Object)key);
            if (quotedString != null) {
                associations.setObjectForKey((Object)association, quotedString);
                continue;
            }
            associations.setObjectForKey((Object)association, (Object)key);
        }
        return associations;
    }

    public static WOAssociation _associationWithKey(String associationValue, NSDictionary quotedStrings) {
        Object association = null;
        if (associationValue != null && associationValue.startsWith("~")) {
            int associationValueLength = associationValue.length();
            StringBuffer ognlValue = new StringBuffer();
            int lastIndex = 0;
            int index = 0;
            while ((index = associationValue.indexOf(QUOTED_STRING_KEY, lastIndex)) != -1) {
                int wodpValueStartIndex;
                int wodpValueEndIndex;
                ognlValue.append(associationValue.substring(lastIndex, index));
                for (wodpValueEndIndex = wodpValueStartIndex = index + QUOTED_STRING_KEY.length(); wodpValueEndIndex < associationValueLength && Character.isDigit(associationValue.charAt(wodpValueEndIndex)); ++wodpValueEndIndex) {
                }
                String wodpKey = QUOTED_STRING_KEY + associationValue.substring(wodpValueStartIndex, wodpValueEndIndex);
                String quotedString = (String)quotedStrings.objectForKey((Object)wodpKey);
                if (quotedString != null) {
                    quotedString = quotedString.replaceAll("\\\"", "\\\\\"");
                    ognlValue.append("\"");
                    ognlValue.append(quotedString);
                    ognlValue.append("\"");
                }
                lastIndex = wodpValueEndIndex;
            }
            ognlValue.append(associationValue.substring(lastIndex));
            associationValue = ognlValue.toString();
            association = WOHelperFunctionAssociation.associationWithValue(associationValue);
        } else {
            String quotedString = (String)quotedStrings.objectForKey((Object)associationValue);
            if (quotedString != null) {
                int backslashIndex = quotedString.indexOf(92);
                if (backslashIndex != -1) {
                    StringBuilder sb = new StringBuilder(quotedString);
                    int length = sb.length();
                    for (int i = backslashIndex; i < length; ++i) {
                        char ch = sb.charAt(i);
                        if (ch != '\\' || i >= length) continue;
                        char nextCh = sb.charAt(i + 1);
                        if (nextCh == 'n') {
                            sb.replace(i, i + 2, "\n");
                        } else if (nextCh == 'r') {
                            sb.replace(i, i + 2, "\r");
                        } else if (nextCh == 't') {
                            sb.replace(i, i + 2, "\t");
                        } else {
                            sb.replace(i, i + 2, String.valueOf(nextCh));
                        }
                        --length;
                    }
                    quotedString = sb.toString();
                }
                association = WOHelperFunctionAssociation.associationWithValue(quotedString);
            } else if (_NSStringUtilities.isNumber((String)associationValue)) {
                Integer integer = WOShared.unsignedIntNumber((int)Integer.parseInt(associationValue));
                association = WOHelperFunctionAssociation.associationWithValue(integer);
            } else {
                association = "true".equalsIgnoreCase(associationValue) || "yes".equalsIgnoreCase(associationValue) ? WOConstantValueAssociation.TRUE : ("false".equalsIgnoreCase(associationValue) || "no".equalsIgnoreCase(associationValue) || "nil".equalsIgnoreCase(associationValue) || "null".equalsIgnoreCase(associationValue) ? WOConstantValueAssociation.FALSE : WOHelperFunctionAssociation.associationWithKeyPath(associationValue));
            }
        }
        return association;
    }

    private NSMutableDictionary _rawDeclarationsWithoutComment(String declarationStr) {
        NSMutableDictionary declarations = new NSMutableDictionary();
        StringBuffer declarationWithoutCommentBuffer = new StringBuffer(100);
        StringTokenizer tokenizer = new StringTokenizer(declarationStr, "{", true);
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken("{");
                if (token.equals("{")) {
                    token = tokenizer.nextToken("}");
                    if (token.equals("}")) {
                        token = "";
                    } else {
                        tokenizer.nextToken();
                    }
                    String declarationWithoutComment = _NSStringUtilities.stringFromBuffer((StringBuffer)declarationWithoutCommentBuffer);
                    if (declarationWithoutComment.startsWith(";")) {
                        declarationWithoutComment = declarationWithoutComment.substring(1);
                    }
                    declarations.setObjectForKey((Object)("{" + token + "}"), (Object)declarationWithoutComment.trim());
                    declarationWithoutCommentBuffer.setLength(0);
                    continue;
                }
                declarationWithoutCommentBuffer.append(token);
            }
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"Failed to parse.", (Throwable)e);
        }
        return declarations;
    }

    static {
        log.setLevel(Level.WARN);
    }
}

