/*
 * Decompiled with CFR 0.152.
 */
package er.coolcomponents;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation._NSUtilities;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXNextPageForResultWOAction;
import er.extensions.appserver.ERXWOContext;
import er.extensions.appserver.IERXPerformWOAction;
import er.extensions.appserver.IERXPerformWOActionForResult;
import er.extensions.concurrency.ERXExecutorService;
import er.extensions.concurrency.ERXFutureTask;
import er.extensions.concurrency.IERXStoppable;
import er.extensions.foundation.ERXAssert;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRuntimeUtilities;
import er.extensions.foundation.ERXStopWatch;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCAjaxLongResponsePage
extends WOComponent {
    static final Logger log = Logger.getLogger(CCAjaxLongResponsePage.class);
    private static final String STYLESHEET_FRAMEWORK = ERXProperties.stringForKeyWithDefault((String)"er.coolcomponents.CCAjaxLongResponsePage.stylesheet.framework", (String)"ERCoolComponents");
    private static final String STYLESHEET_FILENAME = ERXProperties.stringForKeyWithDefault((String)"er.coolcomponents.CCAjaxLongResponsePage.stylesheet.filename", (String)"CCAjaxLongResponsePage.css");
    private static final boolean CSS_STYLE_SHEET_DEVELOPMENT_MODE = ERXApplication.isDevelopmentModeSafe() && ERXProperties.booleanForKeyWithDefault((String)"er.coolcomponents.CCAjaxLongResponsePage.stayOnLongResponsePageIndefinitely", (boolean)false);
    private boolean _wasStoppedByUser = false;
    private final WOComponent _referringPage;
    private IERXPerformWOActionForResult _nextPageForResultController;
    private IERXPerformWOAction _nextPageForCancelController;
    private IERXPerformWOActionForResult _nextPageForErrorController;
    private Object _task;
    private String _defaultStatus;
    private Integer _refreshInterval;
    private ERXFutureTask<?> _future;
    private Object _result;
    private boolean isStopWatchRunning = false;
    private ERXStopWatch _stopWatch;

    public CCAjaxLongResponsePage(WOContext context) {
        super(context);
        this._referringPage = context.page();
    }

    public IERXPerformWOActionForResult nextPageForResultController() {
        if (this._nextPageForResultController == null) {
            this._nextPageForResultController = new ERXNextPageForResultWOAction(this._referringPage);
        }
        return this._nextPageForResultController;
    }

    public void setNextPageForResultController(IERXPerformWOActionForResult nextPageForResultController) {
        this._nextPageForResultController = nextPageForResultController;
    }

    public IERXPerformWOAction nextPageForCancelController() {
        if (this._nextPageForCancelController == null) {
            this._nextPageForCancelController = new ERXNextPageForResultWOAction(this._referringPage);
        }
        return this._nextPageForCancelController;
    }

    public void setNextPageForCancelController(IERXPerformWOAction nextPageForCancelController) {
        this._nextPageForCancelController = nextPageForCancelController;
    }

    public IERXPerformWOActionForResult nextPageForErrorController() {
        if (this._nextPageForErrorController == null) {
            try {
                this._nextPageForErrorController = DEFAULT_CONTROLLER.CONSTRUCTOR_FOR_ERROR_RESULT != null ? DEFAULT_CONTROLLER.CONSTRUCTOR_FOR_ERROR_RESULT.newInstance(this._referringPage) : DEFAULT_CONTROLLER.FOR_ERROR_RESULT.newInstance();
            }
            catch (InstantiationException e1) {
                throw new RuntimeException("Failed to instantiate an instance of " + DEFAULT_CONTROLLER.FOR_ERROR_RESULT.getName(), e1);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException("Failed to instantiate an instance of " + DEFAULT_CONTROLLER.FOR_ERROR_RESULT.getName(), e2);
            }
            catch (InvocationTargetException e3) {
                throw new RuntimeException("Failed to instantiate an instance of " + DEFAULT_CONTROLLER.FOR_ERROR_RESULT.getName() + " using the WOComponent argument constructor", e3);
            }
        }
        return this._nextPageForErrorController;
    }

    public void setNextPageForErrorController(IERXPerformWOActionForResult nextPageForErrorController) {
        this._nextPageForErrorController = nextPageForErrorController;
    }

    public Object task() {
        return this._task;
    }

    public void setTask(Object task) {
        if (!(task instanceof Runnable) && !(task instanceof Callable)) {
            throw new IllegalArgumentException("The task must implement the Runnable or the Callable interface!");
        }
        this._task = task;
    }

    public String defaultStatus() {
        if (this._defaultStatus == null) {
            this._defaultStatus = ERXProperties.stringForKeyWithDefault((String)"er.coolcomponents.CCAjaxLongResponsePage.defaultStatus", (String)"Please wait...");
        }
        return this._defaultStatus;
    }

    public void setDefaultStatus(String defaultStatus) {
        this._defaultStatus = defaultStatus;
    }

    public Integer refreshInterval() {
        if (this._refreshInterval == null) {
            this._refreshInterval = ERXProperties.intForKeyWithDefault((String)"er.coolcomponents.CCAjaxLongResponsePage.refreshInterval", (int)2);
        }
        return this._refreshInterval;
    }

    public void setRefreshInterval(Integer refreshInterval) {
        this._refreshInterval = refreshInterval;
    }

    public ERXFutureTask<?> future() {
        if (this._future == null) {
            Object task = this.task();
            this._future = task instanceof Callable ? new ERXFutureTask((Callable)task) : new ERXFutureTask((Runnable)task, null);
            ERXExecutorService.executorService().execute((Runnable)this._future);
        }
        return this._future;
    }

    public WOActionResults nextPage() {
        Object taskResult = this.result();
        if (log.isDebugEnabled()) {
            log.debug((Object)("nextPage action fired. task result is " + taskResult));
        }
        WOActionResults nextPageResponse = null;
        if (this._wasStoppedByUser) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The task was canceled by the user, so now calling " + this.nextPageForCancelController()));
            }
            nextPageResponse = this.nextPageForCancelController().performAction();
        } else if (taskResult instanceof Exception) {
            IERXPerformWOActionForResult errorController = this.nextPageForErrorController();
            errorController.setResult(this._result);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The task had an error, so now calling " + errorController));
            }
            nextPageResponse = errorController.performAction();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The task completed normally. Now setting the result, " + taskResult + ", and calling " + this.nextPageForResultController()));
            }
            this.nextPageForResultController().setResult(taskResult);
            nextPageResponse = this.nextPageForResultController().performAction();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("results = " + (nextPageResponse == null ? "null" : nextPageResponse.toString())));
        }
        return nextPageResponse;
    }

    public Object result() {
        ERXAssert.POST.isTrue(this.future().isDone());
        if (this._result == null) {
            try {
                this._result = this.future().get();
            }
            catch (CancellationException cancellationException) {
                this._result = cancellationException;
            }
            catch (InterruptedException interruptedException) {
                this._result = interruptedException;
            }
            catch (ExecutionException executionException) {
                log.error((Object)("Long Response Error:\n" + ERXRuntimeUtilities.informationForException((Exception)executionException)), (Throwable)executionException);
                this._result = executionException;
            }
        }
        return this._result;
    }

    public String elapsedTime() {
        if (this.future().isDone() && this.isStopWatchRunning) {
            this.stopWatch().stop();
            this.isStopWatchRunning = false;
        }
        return this.stopWatch().toString();
    }

    public ERXStopWatch stopWatch() {
        if (this._stopWatch == null) {
            this._stopWatch = new ERXStopWatch();
            this._stopWatch.start();
            this.isStopWatchRunning = true;
        }
        return this._stopWatch;
    }

    public String controlScriptContent() {
        String result = ";";
        if (this.future().isDone() && !CSS_STYLE_SHEET_DEVELOPMENT_MODE) {
            int delay = Math.min(this.refreshInterval() * 1000 + 900, 2900);
            result = "window.setTimeout(performNextPageAction, " + delay + ");";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("controlScriptContent on refresh = " + result));
        }
        return result;
    }

    public String finishedPercentage() {
        String result = "1%";
        Double percentComplete = this.future().percentComplete();
        if (percentComplete != null) {
            long userPercentComplete = Math.round(percentComplete * 100.0);
            if (userPercentComplete < 1L) {
                userPercentComplete = 1L;
            }
            if (userPercentComplete > 100L) {
                userPercentComplete = 100L;
            }
            result = userPercentComplete + "%";
        }
        return result;
    }

    public boolean hideUnfinishedProgressTableCell() {
        return this.future().isDone() && !this.wasStoppedByUser();
    }

    public boolean isDebugMode() {
        return log.isDebugEnabled();
    }

    public String styleSheetFramework() {
        return STYLESHEET_FRAMEWORK;
    }

    public String styleSheetFilename() {
        return STYLESHEET_FILENAME;
    }

    public WOActionResults stopTask() {
        Object task = this.future().task();
        if (task instanceof IERXStoppable) {
            IERXStoppable stoppable = (IERXStoppable)task;
            stoppable.stop();
            this._wasStoppedByUser = true;
        }
        return null;
    }

    public boolean wasStoppedByUser() {
        return this._wasStoppedByUser;
    }

    public boolean stayOnLongResponsePageIndefinitely() {
        return CSS_STYLE_SHEET_DEVELOPMENT_MODE;
    }

    static class ErrorResultController
    implements IERXPerformWOActionForResult {
        private Exception _result;

        ErrorResultController() {
        }

        public WOActionResults performAction() {
            return WOApplication.application().handleException(this._result, ERXWOContext.currentContext());
        }

        public void setResult(Object result) {
            this._result = (Exception)result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DEFAULT_CONTROLLER {
        static final String KEY_FOR_CLASSNAME = "er.coolcomponents.CCAjaxLongResponsePage.nextPageForErrorResultControllerClassName";
        static final Class<? extends IERXPerformWOActionForResult> FOR_ERROR_RESULT = DEFAULT_CONTROLLER.defaultErrorController();
        static final Constructor<? extends IERXPerformWOActionForResult> CONSTRUCTOR_FOR_ERROR_RESULT = DEFAULT_CONTROLLER.preferredConstructor();

        private DEFAULT_CONTROLLER() {
        }

        private static Class<? extends IERXPerformWOActionForResult> defaultErrorController() {
            Class clazz = null;
            String className = ERXProperties.stringForKey((String)KEY_FOR_CLASSNAME);
            clazz = className != null ? _NSUtilities.classWithName((String)className) : ErrorResultController.class;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Default error controller class = " + clazz));
            }
            return clazz;
        }

        private static Constructor<? extends IERXPerformWOActionForResult> preferredConstructor() {
            Constructor<? extends IERXPerformWOActionForResult> result = null;
            if (!FOR_ERROR_RESULT.getClass().equals(ErrorResultController.class)) {
                try {
                    result = FOR_ERROR_RESULT.getConstructor(WOComponent.class);
                }
                catch (NoSuchMethodException e) {
                    result = null;
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Unexpected exception when trying to get Constructor for " + FOR_ERROR_RESULT.getClass().getName());
                }
            }
            return result;
        }
    }
}

