/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.woextensions._WOJExtensionsUtil;
import java.text.DecimalFormat;

public class WOCompletionBar
extends WOComponent {
    protected int _cachedPercentValue;
    public int value;
    public int showedValue;
    public int valueMin;
    public int valueMax;
    public String width;
    public String barColor;
    public String backgroundColor;
    public String border;
    public DecimalFormat numberformat = null;
    public String align;

    public WOCompletionBar(WOContext aContext) {
        super(aContext);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    protected int _intValue(String bindingName, int defaultValue) {
        Object binding = this.valueForBinding(bindingName);
        int result = defaultValue;
        if (binding != null) {
            try {
                result = Integer.parseInt(binding.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("WOCompletionBar - problem parsing int from " + bindingName + " binding " + e);
            }
        }
        return result;
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        Object v = this.valueForBinding("value");
        this.valueMin = this._intValue("valueMin", 0);
        this.valueMax = this._intValue("valueMax", 100);
        this.backgroundColor = (String)_WOJExtensionsUtil.valueForBindingOrNull("backgroundColor", this);
        this.barColor = (String)_WOJExtensionsUtil.valueForBindingOrNull("barColor", this);
        this.width = (String)_WOJExtensionsUtil.valueForBindingOrNull("width", this);
        this.align = (String)_WOJExtensionsUtil.valueForBindingOrNull("align", this);
        if (this.backgroundColor == null) {
            this.backgroundColor = "#2020af";
        }
        if (this.barColor == null) {
            this.barColor = "#22aaff";
        }
        if (this.width == null) {
            this.width = "100%";
        }
        if (this.align == null) {
            this.align = "CENTER";
        }
        this.showedValue = this.value = this._intValue("value", this.valueMin);
        if (this.valueMax < this.valueMin || this.valueMax == this.valueMin) {
            throw new RuntimeException("<" + ((Object)((Object)this)).getClass().getName() + "> valueMax is smaller than or equal to valueMin !");
        }
        if (this.value > this.valueMax) {
            this.value = this.valueMax;
        }
        if (this.value < this.valueMin) {
            this.value = this.valueMin;
        }
        super.appendToResponse(aResponse, aContext);
    }

    public int percentValue() {
        int number = (int)(100.0 * (double)(this.value - this.valueMin) / (double)(this.valueMax - this.valueMin));
        if (number < 1) {
            number = 1;
        }
        this._cachedPercentValue = number;
        return this._cachedPercentValue;
    }

    public int percentNotValue() {
        return 100 - this._cachedPercentValue;
    }

    public boolean inProgress() {
        return this.value < this.valueMax && this.value > this.valueMin;
    }

    public String notInProgressBackgroundColor() {
        if (this.value == this.valueMin) {
            return this.backgroundColor;
        }
        return this.barColor;
    }

    public String notInProgressColor() {
        if (this.value == this.valueMax) {
            return this.backgroundColor;
        }
        return this.barColor;
    }
}

