/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.woextensions.WOParsedErrorLine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;

public class WOExceptionParser {
    protected NSMutableArray _stackTrace = new NSMutableArray();
    protected Throwable _exception;
    protected String _message;
    protected String _typeException;

    public WOExceptionParser(Throwable exception) {
        this._exception = NSForwardException._originalThrowable((Throwable)exception);
        this._message = this._exception.getMessage();
        this._typeException = this._exception.getClass().getName();
        this._parseException();
    }

    protected NSArray _ignoredPackages() {
        NSMutableArray allBundles = new NSMutableArray(NSBundle.frameworkBundles());
        NSMutableArray ignored = new NSMutableArray();
        Enumeration enumerator = allBundles.objectEnumerator();
        while (enumerator.hasMoreElements()) {
            String content;
            NSDictionary dic;
            NSArray tmpArray;
            NSBundle bundle = (NSBundle)enumerator.nextElement();
            String path = WOApplication.application().resourceManager().pathForResourceNamed("WOIgnoredPackage.plist", bundle.name(), null);
            if (path == null || (tmpArray = (NSArray)(dic = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)(content = WOExceptionParser._stringFromFile(path)))).objectForKey((Object)"ignoredPackages")) == null || tmpArray.count() <= 0) continue;
            ignored.addObjectsFromArray(tmpArray);
        }
        return ignored;
    }

    protected void _verifyPackageForLine(WOParsedErrorLine line, NSArray packages) {
        String linePackageName = line.packageName();
        Enumeration enumerator = packages.objectEnumerator();
        while (enumerator.hasMoreElements()) {
            String ignoredPackageName = (String)enumerator.nextElement();
            if (!linePackageName.startsWith(ignoredPackageName)) continue;
            line.setIgnorePackage(true);
            break;
        }
    }

    protected void _parseException() {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter((Writer)sWriter, false);
        try {
            this._exception.printStackTrace(pWriter);
            pWriter.close();
            sWriter.close();
            String string = sWriter.toString();
            int i = this._exception.toString().length();
            if (string.length() > i + 2) {
                string = string.substring(i + 2);
                NSArray lines = NSArray.componentsSeparatedByString((String)string, (String)"\n");
                NSArray ignoredPackage = this._ignoredPackages();
                int size = lines.count();
                this._stackTrace = new NSMutableArray(size);
                for (i = 0; i < size; ++i) {
                    String line = ((String)lines.objectAtIndex(i)).trim();
                    if (!line.startsWith("at ")) continue;
                    WOParsedErrorLine aLine = new WOParsedErrorLine(line);
                    this._verifyPackageForLine(aLine, ignoredPackage);
                    this._stackTrace.addObject((Object)aLine);
                }
            }
        }
        catch (Throwable e) {
            NSLog.err.appendln((Object)("WOExceptionParser - exception collecting backtrace data " + e + " - Empty backtrace."));
            NSLog.err.appendln(e);
        }
        if (this._stackTrace == null) {
            this._stackTrace = new NSMutableArray();
        }
    }

    public NSArray stackTrace() {
        return this._stackTrace;
    }

    public String typeException() {
        return this._typeException;
    }

    public String message() {
        return this._message;
    }

    protected static String _stringFromFile(String path) {
        File f = new File(path);
        FileInputStream fis = null;
        byte[] data = null;
        if (!f.exists()) {
            return null;
        }
        try {
            int size = (int)f.length();
            fis = new FileInputStream(f);
            data = new byte[size];
            for (int bytesRead = 0; bytesRead < size; bytesRead += fis.read(data, bytesRead, size - bytesRead)) {
            }
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        finally {
            if (f != null) {
                block13: {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8192L)) break block13;
                        NSLog.debug.appendln((Object)("Exception while closing file input stream: " + e.getMessage()));
                        NSLog.debug.appendln((Throwable)e);
                    }
                }
                f = null;
            }
        }
        return new String(data);
    }
}

