/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import com.webobjects.woextensions._WOJExtensionsUtil;
import java.util.Enumeration;

public class WOSortOrder
extends WOComponent {
    protected String _key;
    protected String _displayKey;
    protected WODisplayGroup _displayGroup;

    public WOSortOrder(WOContext aContext) {
        super(aContext);
    }

    public boolean isStateless() {
        return true;
    }

    public void reset() {
        this._invalidateCaches();
    }

    public WODisplayGroup displayGroup() {
        if (null == this._displayGroup) {
            this._displayGroup = (WODisplayGroup)_WOJExtensionsUtil.valueForBindingOrNull("displayGroup", this);
        }
        return this._displayGroup;
    }

    public String key() {
        if (null == this._key) {
            this._key = (String)_WOJExtensionsUtil.valueForBindingOrNull("key", this);
        }
        return this._key;
    }

    public String displayKey() {
        if (null == this._displayKey) {
            this._displayKey = (String)_WOJExtensionsUtil.valueForBindingOrNull("displayKey", this);
        }
        return this._displayKey;
    }

    protected EOSortOrdering _primarySortOrdering() {
        NSArray anArray = this.displayGroup().sortOrderings();
        if (anArray != null && anArray.count() > 0) {
            EOSortOrdering anOrdering = (EOSortOrdering)anArray.objectAtIndex(0);
            return anOrdering;
        }
        return null;
    }

    protected boolean _isCurrentKeyPrimary() {
        EOSortOrdering anOrdering = this._primarySortOrdering();
        return anOrdering != null && anOrdering.key().equals(this.key());
    }

    protected NSSelector _primaryKeySortOrderingSelector() {
        EOSortOrdering anOrdering = this._primarySortOrdering();
        NSSelector anOrderingSelector = null;
        if (anOrdering != null) {
            anOrderingSelector = anOrdering.selector();
        }
        return anOrderingSelector;
    }

    public String imageName() {
        String anImageName = "Unsorted.gif";
        if (this._isCurrentKeyPrimary()) {
            NSSelector aCurrentState = this._primaryKeySortOrderingSelector();
            if (aCurrentState == EOSortOrdering.CompareAscending) {
                anImageName = "Ascending.gif";
            } else if (aCurrentState == EOSortOrdering.CompareDescending) {
                anImageName = "Descending.gif";
            }
        }
        return anImageName;
    }

    protected void _removeSortOrderingWithKey(String aKey) {
        int anIndex = 0;
        EOSortOrdering aSortOrdering = null;
        WODisplayGroup aDisplayGroup = this.displayGroup();
        NSArray sortOrderings = aDisplayGroup.sortOrderings();
        if (sortOrderings != null) {
            NSMutableArray aSortOrderingArray = sortOrderings.mutableClone();
            Enumeration anEnumerator = aSortOrderingArray.objectEnumerator();
            while (anEnumerator.hasMoreElements()) {
                aSortOrdering = (EOSortOrdering)anEnumerator.nextElement();
                if (aKey.equals(aSortOrdering.key())) {
                    aSortOrderingArray.removeObjectAtIndex(anIndex);
                    break;
                }
                ++anIndex;
            }
            aDisplayGroup.setSortOrderings((NSArray)aSortOrderingArray);
        }
    }

    protected void _makePrimarySortOrderingWithSelector(NSSelector aSelector) {
        String aKey = this.key();
        WODisplayGroup aDisplayGroup = this.displayGroup();
        NSArray sortOrderings = aDisplayGroup.sortOrderings();
        NSMutableArray aSortOrderingArray = sortOrderings != null ? new NSMutableArray(sortOrderings) : new NSMutableArray();
        EOSortOrdering aNewSortOrdering = EOSortOrdering.sortOrderingWithKey((String)aKey, (NSSelector)aSelector);
        aSortOrderingArray.insertObjectAtIndex((Object)aNewSortOrdering, 0);
        if (aSortOrderingArray.count() > 3) {
            aSortOrderingArray.removeLastObject();
        }
        aDisplayGroup.setSortOrderings((NSArray)aSortOrderingArray);
    }

    public String helpString() {
        return "Push to toggle sorting order according to " + this.displayKey();
    }

    public WOComponent toggleClicked() {
        String aKey = this.key();
        if (this._isCurrentKeyPrimary()) {
            NSSelector aCurrentState = this._primaryKeySortOrderingSelector();
            if (aCurrentState == EOSortOrdering.CompareAscending) {
                this._removeSortOrderingWithKey(aKey);
                this._makePrimarySortOrderingWithSelector(EOSortOrdering.CompareDescending);
            } else if (aCurrentState == EOSortOrdering.CompareDescending) {
                this._removeSortOrderingWithKey(aKey);
            } else {
                this._removeSortOrderingWithKey(aKey);
                this._makePrimarySortOrderingWithSelector(EOSortOrdering.CompareAscending);
            }
        } else {
            this._removeSortOrderingWithKey(aKey);
            this._makePrimarySortOrderingWithSelector(EOSortOrdering.CompareAscending);
        }
        this.displayGroup().updateDisplayedObjects();
        return null;
    }

    protected void _invalidateCaches() {
        this._key = null;
        this._displayKey = null;
        this._displayGroup = null;
    }
}

