/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;

public class WOStatsPage
extends WOComponent {
    public NSDictionary detailsDict;
    public NSDictionary pagesDict;
    public NSDictionary directActionsDict;
    public NSDictionary sessionMemoryDict;
    public NSDictionary transactions;
    public NSDictionary statsDict;
    public NSDictionary memoryDict;
    public NSArray sessionStats;
    public NSMutableDictionary sessionsDict;
    public long maxPageCount;
    public long maxActionCount;
    public NSTimestamp maxSessionsDate;
    public String userName;
    public Object currentKey;
    public Object currentItem;
    public String password;

    public WOStatsPage(WOContext aContext) {
        super(aContext);
    }

    public WOComponent submit() {
        this.session().validateStatisticsLogin(this.password, this.userName);
        return this;
    }

    public String host() throws UnknownHostException {
        if (WOApplication.application().host() != null) {
            return WOApplication.application().host();
        }
        return InetAddress.getLocalHost().getHostName();
    }

    public String instance() {
        int instance = this.context().request().applicationNumber();
        return "" + instance;
    }

    protected long _maxServedForDictionary(NSDictionary aDictionary) {
        long aMaxServedCount = 0L;
        NSDictionary aPage = null;
        Enumeration aPageEnumerator = aDictionary.objectEnumerator();
        while (aPageEnumerator.hasMoreElements()) {
            aPage = (NSDictionary)aPageEnumerator.nextElement();
            long newCount = (Long)aPage.objectForKey((Object)"Served");
            aMaxServedCount += newCount;
        }
        return aMaxServedCount;
    }

    public void _initIvars() {
        this.statsDict = WOApplication.application().statistics();
        this.pagesDict = (NSDictionary)this.statsDict.objectForKey((Object)"Pages");
        this.directActionsDict = (NSDictionary)this.statsDict.objectForKey((Object)"DirectActions");
        this.detailsDict = (NSDictionary)this.statsDict.objectForKey((Object)"Details");
        this.transactions = (NSDictionary)this.statsDict.objectForKey((Object)"Transactions");
        this.memoryDict = (NSDictionary)this.statsDict.objectForKey((Object)"Memory");
        this.sessionsDict = ((NSDictionary)this.statsDict.objectForKey((Object)"Sessions")).mutableClone();
        this.sessionMemoryDict = new NSDictionary((Map)this.sessionsDict.removeObjectForKey((Object)"Avg. Memory Per Session"), true);
        this.sessionStats = (NSArray)this.sessionsDict.removeObjectForKey((Object)"Last Session's Statistics");
        this.maxSessionsDate = (NSTimestamp)this.sessionsDict.removeObjectForKey((Object)"Peak Active Sessions Date");
        this.maxPageCount = 0L;
        this.maxActionCount = 0L;
        this.maxPageCount = this._maxServedForDictionary(this.pagesDict);
        this.maxActionCount = this._maxServedForDictionary(this.directActionsDict);
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        this._initIvars();
        super.appendToResponse(aResponse, aContext);
    }

    public long pageCount() {
        return (Long)((NSDictionary)this.currentItem).objectForKey((Object)"Served");
    }

    public double pageAvg() {
        return (Double)((NSDictionary)this.currentItem).objectForKey((Object)"Avg Resp. Time");
    }

    public double pageMin() {
        return (Double)((NSDictionary)this.currentItem).objectForKey((Object)"Min Resp. Time");
    }

    public double pageMax() {
        return (Double)((NSDictionary)this.currentItem).objectForKey((Object)"Max Resp. Time");
    }

    public long detailCount() {
        return (Long)this.detailsDict.objectForKey(this.currentKey);
    }

    public void setDetailPercent(String aValue) {
    }

    public long detailPercent() {
        double aTransactionsCount = ((Number)this.transactions.objectForKey((Object)"Transactions")).doubleValue();
        double aDetailCount = this.detailCount();
        if (aTransactionsCount > 0.0) {
            return (long)(aDetailCount / aTransactionsCount * 100.0);
        }
        return 0L;
    }

    public Long componentActionTransactions() {
        return (Long)this.transactions.objectForKey((Object)"Component Action Transactions");
    }

    public Long directActionTransactions() {
        return (Long)this.transactions.objectForKey((Object)"Direct Action Transactions");
    }

    public Double avgComponentActionTransactions() {
        return (Double)this.transactions.objectForKey((Object)"Component Action  Avg. Transaction Time");
    }

    public Double avgDirectActionTransactions() {
        return (Double)this.transactions.objectForKey((Object)"Direct Action Avg. Transaction Time");
    }

    public Double avgTransactionTime() {
        return (Double)this.transactions.objectForKey((Object)"Avg. Transaction Time");
    }

    public Double avgIdleTime() {
        return (Double)this.transactions.objectForKey((Object)"Avg. Idle Time");
    }

    public Double movingAvgTransactionTime() {
        return (Double)this.transactions.objectForKey((Object)"Moving Avg. Transaction Time");
    }

    public Double movingAvgIdleTime() {
        return (Double)this.transactions.objectForKey((Object)"Moving Avg. Idle Time");
    }

    public Long movingAvgSampleSize() {
        return (Long)this.transactions.objectForKey((Object)"Sample Size For Moving Avg.");
    }

    public String runningTime() {
        long aRunningTime = System.currentTimeMillis() - ((NSTimestamp)this.statsDict.objectForKey((Object)"StartedAt")).getTime();
        String aRunningTimeString = WOStatsPage._timeIntervalDescription(aRunningTime);
        return aRunningTimeString;
    }

    public boolean isLogPath() {
        return this.statsDict.objectForKey((Object)"LogFile") != null;
    }

    public boolean isLastUser() {
        return this.sessionStats != null && this.sessionStats.count() != 0;
    }

    public long actionCount() {
        return (Long)((NSDictionary)this.currentItem).objectForKey((Object)"Served");
    }

    public double actionAvg() {
        return (Double)((NSDictionary)this.currentItem).objectForKey((Object)"Avg Resp. Time");
    }

    public double actionMin() {
        return (Double)((NSDictionary)this.currentItem).objectForKey((Object)"Min Resp. Time");
    }

    public double actionMax() {
        return (Double)((NSDictionary)this.currentItem).objectForKey((Object)"Max Resp. Time");
    }

    protected static String _timeIntervalDescription(long aTimeInterval) {
        long timeInterval = aTimeInterval / 1000L;
        long days = timeInterval / 86400L;
        long hours = (timeInterval -= days * 86400L) / 3600L;
        long minutes = (timeInterval -= hours * 3600L) / 60L;
        long seconds = timeInterval -= minutes * 60L;
        String aTimeIntervalString = days + " days, " + hours + " hours, " + minutes + " minutes, " + seconds + " seconds";
        return aTimeIntervalString;
    }

    public String vendorDescription() {
        return System.getProperty("java.vendor");
    }

    public String vendorURL() {
        return System.getProperty("java.vendor.url");
    }

    public boolean vendorURLdisabled() {
        String url = this.vendorURL();
        return url == null || url.length() == 0;
    }

    public String jdkVersion() {
        return System.getProperty("java.version");
    }

    public String operatingSystem() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
    }
}

