/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSRange;
import com.webobjects.woextensions._WOJExtensionsUtil;

public class WXOutlineEntry
extends WOComponent {
    protected int _nestingLevel;

    public WXOutlineEntry(WOContext aContext) {
        super(aContext);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void awake() {
        super.awake();
        Object nestLevelBinding = _WOJExtensionsUtil.valueForBindingOrNull("nestingLevel", this);
        if (nestLevelBinding instanceof Number) {
            this._nestingLevel = ((Number)nestLevelBinding).intValue();
            return;
        }
        if (nestLevelBinding == null || nestLevelBinding.equals("")) {
            this._nestingLevel = 0;
            return;
        }
        try {
            this._nestingLevel = Integer.parseInt(nestLevelBinding.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("WXOutLineEntry - problem parsing int from nestingLevel binding " + e);
        }
    }

    public int nestingLevel() {
        return this._nestingLevel;
    }

    public boolean isExpanded() {
        Object currentItem = this.valueForBinding("item");
        NSArray selectionPath = (NSArray)_WOJExtensionsUtil.valueForBindingOrNull("selectionPath", this);
        return this._nestingLevel < selectionPath.count() && selectionPath.objectAtIndex(this._nestingLevel).equals(currentItem);
    }

    public int nestingLevelForChildren() {
        return this._nestingLevel + 1;
    }

    public WOComponent toggleExpansion() {
        NSArray selectionPath = (NSArray)_WOJExtensionsUtil.valueForBindingOrNull("selectionPath", this);
        selectionPath = selectionPath.subarrayWithRange(new NSRange(0, this._nestingLevel));
        if (!this.isExpanded()) {
            Object currentItem = this.valueForBinding("item");
            selectionPath = selectionPath.arrayByAddingObject(currentItem);
        }
        this.setValueForBinding(selectionPath, "selectionPath");
        return null;
    }

    public boolean hasChildren() {
        return (Boolean)this.valueForBinding("hasChildren");
    }

    public void takeValuesFromRequest(WORequest aRequest, WOContext aContext) {
        this.session().setObjectForKey((Object)this, "_outlineEntry");
        super.takeValuesFromRequest(aRequest, aContext);
    }

    public WOActionResults invokeAction(WORequest aRequest, WOContext aContext) {
        this.session().setObjectForKey((Object)this, "_outlineEntry");
        WOActionResults returnElement = super.invokeAction(aRequest, aContext);
        return returnElement;
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        this.session().setObjectForKey((Object)this, "_outlineEntry");
        super.appendToResponse(aResponse, aContext);
    }
}

