/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSJavaArrayEnumerator;
import com.webobjects.foundation._NSJavaArrayListIterator;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class NSArray
implements Cloneable,
Serializable,
NSCoding,
NSKeyValueCoding,
NSKeyValueCodingAdditions,
_NSFoundationCollection,
List {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation.NSArray");
    public static final int NotFound = -1;
    public static final NSArray EmptyArray = new NSArray();
    private static final char _OperatorIndicatorChar = '@';
    public static final String CountOperatorName = "count";
    public static final String MaximumOperatorName = "max";
    public static final String MinimumOperatorName = "min";
    public static final String SumOperatorName = "sum";
    public static final String AverageOperatorName = "avg";
    static final long serialVersionUID = -3789592578296478260L;
    private static final String SerializationValuesFieldKey = "objects";
    private static NSMutableDictionary _operators = new NSMutableDictionary(8);
    protected static int _NSArrayClassHashCode;
    protected transient int _capacity;
    protected transient int _count;
    protected Object[] _objects;
    protected transient Object[] _objectsCache;
    protected transient int _hashCache;
    private transient boolean _recomputeHashCode = true;
    private static final ObjectStreamField[] serialPersistentFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray operatorNames() {
        NSArray operatorNames;
        NSMutableDictionary nSMutableDictionary = _operators;
        synchronized (nSMutableDictionary) {
            operatorNames = _operators.allKeys();
        }
        return operatorNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOperatorForKey(String operatorName, Operator arrayOperator) {
        if (operatorName == null) {
            throw new IllegalArgumentException("Operator key cannot be null");
        }
        if (arrayOperator == null) {
            throw new IllegalArgumentException("Operator cannot be null for " + operatorName);
        }
        NSMutableDictionary nSMutableDictionary = _operators;
        synchronized (nSMutableDictionary) {
            _operators.setObjectForKey(arrayOperator, operatorName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Operator operatorForKey(String operatorName) {
        Operator arrayOperator;
        NSMutableDictionary nSMutableDictionary = _operators;
        synchronized (nSMutableDictionary) {
            arrayOperator = (Operator)_operators.objectForKey(operatorName);
        }
        return arrayOperator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOperatorForKey(String operatorName) {
        if (operatorName != null) {
            NSMutableDictionary nSMutableDictionary = _operators;
            synchronized (nSMutableDictionary) {
                _operators.removeObjectForKey(operatorName);
            }
        }
    }

    protected void _initializeWithCapacity(int capacity) {
        this._capacity = capacity;
        this._count = 0;
        this._objects = capacity > 0 ? new Object[capacity] : null;
        this._objectsCache = null;
        this._setMustRecomputeHash(true);
    }

    protected void _ensureCapacity(int capacity) {
        if (capacity > this._capacity) {
            if (capacity == 0) {
                this._objects = null;
            } else {
                if (capacity < 4) {
                    capacity = 4;
                } else {
                    int testCapacity = 2 * this._capacity;
                    if (testCapacity > capacity) {
                        capacity = testCapacity;
                    }
                }
                this._objects = this._objects == null ? new Object[capacity] : _NSCollectionPrimitives.copyArray(this._objects, capacity);
            }
            this._capacity = capacity;
        }
    }

    public NSArray() {
        this(null, 0, 0, false);
    }

    public NSArray(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an NSArray");
        }
        this._initializeWithCapacity(1);
        this._objects[0] = object;
        this._count = 1;
    }

    private void initFromObjects(Object[] objects, int rangeLocation, int rangeLength, boolean checkForNull) {
        if (checkForNull) {
            int maxRange = rangeLocation + rangeLength;
            for (int i = rangeLocation; i < maxRange; ++i) {
                if (objects[i] != null) continue;
                throw new IllegalArgumentException("Attempt to insert null into an " + this.getClass().getName() + ".");
            }
        }
        this._initializeWithCapacity(rangeLength);
        if (rangeLength > 0) {
            System.arraycopy(objects, rangeLocation, this._objects, 0, rangeLength);
        }
        this._count = rangeLength;
    }

    private NSArray(Object[] objects, int rangeLocation, int rangeLength, boolean checkForNull) {
        this.initFromObjects(objects, rangeLocation, rangeLength, checkForNull);
    }

    public NSArray(Object[] objects) {
        this(objects, 0, objects != null ? objects.length : 0, true);
    }

    public NSArray(Object[] objects, NSRange range) {
        this(objects, range != null ? range.location() : 0, range != null ? range.length() : 0, true);
    }

    public NSArray(NSArray otherArray) {
        this(otherArray != null ? otherArray.objectsNoCopy() : null, 0, otherArray != null ? otherArray.count() : 0, false);
    }

    public NSArray(List list, boolean checkForNull) {
        if (list == null) {
            throw new IllegalArgumentException("List cannot be null");
        }
        Object[] aList = list.toArray();
        this.initFromObjects(aList, 0, aList.length, checkForNull);
    }

    public NSArray(Vector vector, NSRange range, boolean ignoreNull) {
        if (range != null) {
            if (vector == null) {
                throw new IllegalArgumentException("Vector cannot be null");
            }
            int count = vector.size();
            int rangeLocation = range.location();
            int rangeLength = range.length();
            this._initializeWithCapacity(count);
            for (int i = 0; i < rangeLength; ++i) {
                Object object = vector.elementAt(i + rangeLocation);
                if (object != null) {
                    this._objects[this._count++] = object;
                    continue;
                }
                if (ignoreNull) continue;
                throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
            }
        }
    }

    protected Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            this._objectsCache = this._count == 0 ? _NSCollectionPrimitives.EmptyArray : (this._count == this._capacity ? this._objects : _NSCollectionPrimitives.copyArray(this._objects, this._count));
        }
        return this._objectsCache;
    }

    public int count() {
        return this._count;
    }

    public Object objectAtIndex(int index) {
        if (index >= 0 && index < this._count) {
            return this._objects[index];
        }
        if (this._count == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this._count - 1) + "]");
    }

    public NSArray arrayByAddingObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        int count = this.count();
        Object[] objects = new Object[count + 1];
        System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        objects[count] = object;
        return new NSArray(objects, 0, count + 1, false);
    }

    public NSArray arrayByAddingObjectsFromArray(NSArray otherArray) {
        if (otherArray != null) {
            int count = this.count();
            int otherCount = otherArray.count();
            if (count == 0) {
                return new NSArray(otherArray);
            }
            if (otherCount == 0) {
                return (NSArray)this.clone();
            }
            Object[] objects = new Object[count + otherCount];
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
            System.arraycopy(otherArray.objectsNoCopy(), 0, objects, count, otherCount);
            return new NSArray(objects, 0, count + otherCount, false);
        }
        return new NSArray(this);
    }

    public Object[] objects() {
        int count = this.count();
        Object[] objects = new Object[count];
        if (count > 0) {
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        }
        return objects;
    }

    public Object[] objects(NSRange range) {
        if (range == null) {
            return _NSCollectionPrimitives.EmptyArray;
        }
        int count = this.count();
        int rangeLength = range.length();
        Object[] objects = new Object[rangeLength];
        System.arraycopy(this.objectsNoCopy(), range.location(), objects, 0, rangeLength);
        return objects;
    }

    public Vector vector() {
        Vector<Object> vector = new Vector<Object>();
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            vector.addElement(objects[i]);
        }
        return vector;
    }

    public ArrayList arrayList() {
        Object[] objects = this.objectsNoCopy();
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    public boolean containsObject(Object object) {
        if (object == null) {
            return false;
        }
        return this._findObjectInArray(0, this.count(), object, false) != -1;
    }

    public Object firstObjectCommonWithArray(NSArray otherArray) {
        if (otherArray == null) {
            return null;
        }
        int otherCount = otherArray.count();
        if (otherCount > 0) {
            Object[] objects = this.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                if (!otherArray.containsObject(objects[i])) continue;
                return objects[i];
            }
        }
        return null;
    }

    public void getObjects(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Object buffer cannot be null");
        }
        System.arraycopy(this.objectsNoCopy(), 0, objects, 0, this.count());
    }

    public void getObjects(Object[] objects, NSRange range) {
        if (objects == null) {
            throw new IllegalArgumentException("Object buffer cannot be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Range cannot be null");
        }
        System.arraycopy(this.objectsNoCopy(), range.location(), objects, 0, range.length());
    }

    private final int _findObjectInArray(int index, int length, Object object, boolean identical) {
        if (this.count() > 0) {
            int i;
            Object[] objects = this.objectsNoCopy();
            int maxIndex = index + length - 1;
            for (i = index; i <= maxIndex; ++i) {
                if (objects[i] != object) continue;
                return i;
            }
            if (!identical) {
                for (i = index; i <= maxIndex; ++i) {
                    if (!object.equals(objects[i])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public int indexOfObject(Object object) {
        if (object == null) {
            return -1;
        }
        return this._findObjectInArray(0, this.count(), object, false);
    }

    public int indexOfObject(Object object, NSRange range) {
        int rangeLength;
        if (object == null || range == null) {
            return -1;
        }
        int count = this.count();
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
            throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count - 1) + "]");
        }
        return this._findObjectInArray(rangeLocation, rangeLength, object, false);
    }

    public int indexOfIdenticalObject(Object object) {
        if (object == null) {
            return -1;
        }
        return this._findObjectInArray(0, this.count(), object, true);
    }

    public int indexOfIdenticalObject(Object object, NSRange range) {
        int rangeLength;
        if (object == null || range == null) {
            return -1;
        }
        int count = this.count();
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
            throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count - 1) + "]");
        }
        return this._findObjectInArray(rangeLocation, rangeLength, object, true);
    }

    public NSArray subarrayWithRange(NSRange range) {
        if (range == null) {
            return EmptyArray;
        }
        return new NSArray(this.objectsNoCopy(), range.location(), range.length(), false);
    }

    public Object lastObject() {
        int count = this.count();
        return count == 0 ? null : this.objectAtIndex(count - 1);
    }

    private boolean _equalsArray(NSArray otherArray) {
        int count = this.count();
        if (count != otherArray.count()) {
            return false;
        }
        if (!this._mustRecomputeHash() && !otherArray._mustRecomputeHash() && this.hashCode() != otherArray.hashCode()) {
            return false;
        }
        Object[] objects = this.objectsNoCopy();
        Object[] otherObjects = otherArray.objectsNoCopy();
        for (int i = 0; i < count; ++i) {
            if (objects[i].equals(otherObjects[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualToArray(NSArray otherArray) {
        if (otherArray == this) {
            return true;
        }
        if (otherArray == null) {
            return false;
        }
        return this._equalsArray(otherArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NSArray) {
            return this._equalsArray((NSArray)object);
        }
        return false;
    }

    public Enumeration objectEnumerator() {
        return new _NSJavaArrayEnumerator(this._objects, this._count, false);
    }

    public Enumeration reverseObjectEnumerator() {
        return new _NSJavaArrayEnumerator(this._objects, this._count, true);
    }

    public NSArray sortedArrayUsingSelector(NSSelector selector) throws NSComparator.ComparisonException {
        NSMutableArray array = new NSMutableArray(this);
        NSComparator._NSSelectorComparator comparator = new NSComparator._NSSelectorComparator(selector);
        array.sortUsingComparator(comparator);
        return array;
    }

    public NSArray sortedArrayUsingComparator(NSComparator comparator) throws NSComparator.ComparisonException {
        NSMutableArray array = new NSMutableArray(this);
        array.sortUsingComparator(comparator);
        return array;
    }

    public String componentsJoinedByString(String separator) {
        Object[] objects = this.objectsNoCopy();
        StringBuffer buffer = new StringBuffer(objects.length * 32);
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0 && separator != null) {
                buffer.append(separator);
            }
            buffer.append(objects[i].toString());
        }
        return new String(buffer);
    }

    public static NSArray componentsSeparatedByString(String string, String separator) {
        NSMutableArray objects;
        int separatorLength;
        if (string == null) {
            return EmptyArray;
        }
        int stringLength = string.length();
        int n = separatorLength = separator != null ? separator.length() : 0;
        if (stringLength == 0) {
            return EmptyArray;
        }
        if (separatorLength == 0) {
            return new NSArray(string);
        }
        int start = 0;
        int index = 0;
        int count = 0;
        if (separatorLength == 1 && stringLength < 256) {
            char[] parseData = string.toCharArray();
            char charSeparator = separator.charAt(0);
            for (int i = 0; i < stringLength; ++i) {
                if (parseData[i] != charSeparator) continue;
                ++count;
            }
            if (count == 0) {
                return new NSMutableArray(string);
            }
            objects = new NSMutableArray(count + 1);
            int end = stringLength - 1;
            for (index = 0; index <= end; ++index) {
                if (parseData[index] != charSeparator) continue;
                if (start == index) {
                    objects.addObject("");
                } else {
                    objects.addObject(string.substring(start, index));
                }
                start = index + 1;
            }
            if (parseData[end] == charSeparator) {
                if (start < end) {
                    objects.addObject(string.substring(start, end));
                }
                objects.addObject("");
            } else {
                objects.addObject(string.substring(start, stringLength));
            }
        } else {
            objects = new NSMutableArray(4);
            int end = stringLength - separatorLength;
            while (start < stringLength) {
                index = string.indexOf(separator, start);
                if (index < 0) {
                    index = stringLength;
                }
                if (index != end) {
                    objects.addObject(string.substring(start, index));
                    start = index + separatorLength;
                    continue;
                }
                if (start < index) {
                    objects.addObject(string.substring(start, index));
                }
                objects.addObject("");
                break;
            }
        }
        return objects;
    }

    public static NSMutableArray _mutableComponentsSeparatedByString(String string, String separator) {
        return (NSMutableArray)NSArray.componentsSeparatedByString(string, separator);
    }

    private Object _valueForKeyPathWithOperator(String keyPath) {
        String operatorPath;
        String operatorName;
        int index = keyPath.indexOf(46);
        if (index < 0) {
            operatorName = keyPath.substring(1);
            operatorPath = "";
        } else {
            operatorName = keyPath.substring(1, index);
            operatorPath = index < keyPath.length() - 1 ? keyPath.substring(index + 1) : "";
        }
        Operator arrayOperator = NSArray.operatorForKey(operatorName);
        if (arrayOperator != null) {
            return arrayOperator.compute(this, operatorPath);
        }
        throw new IllegalArgumentException("No key operator available to compute aggregate " + keyPath);
    }

    public Object valueForKey(String key) {
        if (key != null) {
            if (key.charAt(0) == '@') {
                return this._valueForKeyPathWithOperator(key);
            }
            if (key.equals(CountOperatorName)) {
                return _NSUtilities.IntegerForInt(this.count());
            }
        }
        Object[] objects = this.objectsNoCopy();
        NSMutableArray values = new NSMutableArray(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(objects[i], key);
            values.addObject(value != null ? value : NSKeyValueCoding.NullValue);
        }
        return values;
    }

    public void takeValueForKey(Object value, String key) {
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            NSKeyValueCodingAdditions.Utility.takeValueForKeyPath(objects[i], value, key);
        }
    }

    public Object valueForKeyPath(String keyPath) {
        if (keyPath != null && keyPath.charAt(0) == '@') {
            return this._valueForKeyPathWithOperator(keyPath);
        }
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath(this, keyPath);
    }

    public void takeValueForKeyPath(Object value, String keyPath) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath(this, value, keyPath);
    }

    public Class classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        return new NSArray(coder.decodeObjects());
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObjects(this.objectsNoCopy());
    }

    public void makeObjectsPerformSelector(NSSelector selector, Object[] parameters) {
        if (selector == null) {
            throw new IllegalArgumentException("Selector cannot be null");
        }
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            NSSelector._safeInvokeSelector(selector, objects[i], parameters);
        }
    }

    public int _shallowHashCode() {
        return _NSArrayClassHashCode;
    }

    public int hashCode() {
        if (this._mustRecomputeHash()) {
            int hash = 0;
            int max = this.count() > 16 ? 16 : this.count();
            for (int i = 0; i < max; ++i) {
                Object element = this._objects[i];
                if (element instanceof _NSFoundationCollection) {
                    hash ^= ((_NSFoundationCollection)element)._shallowHashCode();
                    continue;
                }
                hash ^= element.hashCode();
            }
            this._hashCache = hash;
            this._setMustRecomputeHash(false);
        }
        return this._hashCache;
    }

    public Object clone() {
        return this;
    }

    public NSArray immutableClone() {
        return this;
    }

    public NSMutableArray mutableClone() {
        return new NSMutableArray(this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("(");
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i > 0) {
                buffer.append(", ");
            }
            if (object instanceof String) {
                buffer.append('\"');
                buffer.append((String)object);
                buffer.append('\"');
                continue;
            }
            if (object instanceof Boolean) {
                buffer.append((Boolean)object != false ? "true" : "false");
                continue;
            }
            buffer.append(object.toString());
        }
        buffer.append(")");
        return new String(buffer);
    }

    protected boolean _mustRecomputeHash() {
        return this._recomputeHashCode;
    }

    protected void _setMustRecomputeHash(boolean change) {
        this._recomputeHashCode = change;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationValuesFieldKey, this.objects());
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        values = values == null ? _NSUtilities._NoObjectArray : values;
        this.initFromObjects(values, 0, values.length, true);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptyArray;
        }
        return this;
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSArray");
    }

    public boolean add(Object element) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSArray");
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    public boolean addAll(int index, Collection collection) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    public boolean contains(Object element) {
        if (element == null) {
            throw new NullPointerException("com.webobjects.foundation.NSArray does not support null values");
        }
        return this.containsObject(element);
    }

    public Iterator iterator() {
        return new _NSJavaArrayListIterator(this._objects, this._count);
    }

    public Object[] toArray() {
        return this.objects();
    }

    public Object[] toArray(Object[] objects) {
        NSArray array = this.arrayByAddingObjectsFromArray(new NSArray(objects));
        return array.objects();
    }

    public boolean containsAll(Collection c) {
        Object[] objects = c.toArray();
        if (objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) {
                    return false;
                }
                if (this._findObjectInArray(0, this.count(), objects[i], false) != -1) continue;
                return false;
            }
        }
        return true;
    }

    public ListIterator listIterator() {
        return new _NSJavaArrayListIterator(this._objects, this._count);
    }

    public ListIterator listIterator(int index) {
        return new _NSJavaArrayListIterator(this._objects, this._count, index);
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        return this.objectAtIndex(index);
    }

    public Object set(int index, Object element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        throw new UnsupportedOperationException("Set is not a support operation in com.webobjects.foundation.NSArray");
    }

    public int indexOf(Object element) {
        if (element == null) {
            throw new NullPointerException("com.webobjects.foundation.NSArray does not support null values");
        }
        return this.indexOfObject(element);
    }

    public int lastIndexOf(Object element) {
        int lastIndex = -1;
        if (element == null) {
            throw new NullPointerException("com.webobjects.foundation.NSArray does not support null values");
        }
        for (int i = 0; i < this._objects.length; ++i) {
            if (!this._objects[i].equals(element)) continue;
            lastIndex = i;
        }
        return lastIndex;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public int size() {
        return this.count();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException("Remove is not a support operation in com.webobjects.foundation.NSArray");
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Remove is not a support operation in com.webobjects.foundation.NSArray");
    }

    public void clear() {
        throw new UnsupportedOperationException("Clear is not a supported operation in com.webobjects.foundation.NSArray");
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("RetainAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("RemoveAll is not a supported operation in com.webobjects.foundation.NSArray");
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.count() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Illegal index value (fromIndex < 0 || toIndex > size || fromIndex > toIndex)");
        }
        return this.subarrayWithRange(new NSRange(fromIndex, toIndex - fromIndex + 1));
    }

    static {
        try {
            NSArray.setOperatorForKey(CountOperatorName, new _CountOperator());
            NSArray.setOperatorForKey(MaximumOperatorName, new _MaxOperator());
            NSArray.setOperatorForKey(MinimumOperatorName, new _MinOperator());
            NSArray.setOperatorForKey(SumOperatorName, new _SumNumberOperator());
            NSArray.setOperatorForKey(AverageOperatorName, new _AvgNumberOperator());
            _NSArrayClassHashCode = _CLASS.hashCode();
        }
        catch (Throwable e) {
            NSLog.err.appendln("Exception occurred in initializer");
            if (NSLog.debugLoggingAllowedForLevel(1)) {
                NSLog.debug.appendln(e);
            }
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(SerializationValuesFieldKey, new Object[0].getClass())};
    }

    static class _AvgNumberOperator
    extends _Operator
    implements Operator {
        public Object compute(NSArray values, String keyPath) {
            int count = values.count();
            if (count != 0) {
                BigDecimal sum = this._sum(values, keyPath);
                return sum.divide(BigDecimal.valueOf(count), sum.scale() + 4, 6);
            }
            return null;
        }
    }

    static class _SumNumberOperator
    extends _Operator
    implements Operator {
        public Object compute(NSArray values, String keyPath) {
            return this._sum(values, keyPath);
        }
    }

    static class _MinOperator
    extends _Operator
    implements Operator {
        public Object compute(NSArray values, String keyPath) {
            Object min = null;
            Object[] objects = values.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                min = this._minOrMaxValue(min, this._operationValue(objects[i], keyPath), false);
            }
            return min;
        }
    }

    static class _MaxOperator
    extends _Operator
    implements Operator {
        public Object compute(NSArray values, String keyPath) {
            Object max = null;
            Object[] objects = values.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                max = this._minOrMaxValue(max, this._operationValue(objects[i], keyPath), true);
            }
            return max;
        }
    }

    static class _Operator {
        protected Object _operationValue(Object object, String keyPath) {
            return keyPath != null && keyPath.length() > 0 ? NSKeyValueCodingAdditions.Utility.valueForKeyPath(object, keyPath) : object;
        }

        private BigDecimal _bigDecimalForValue(Object object) {
            if (object != null) {
                if (_NSUtilities._isClassANumberOrABoolean(object.getClass())) {
                    return (BigDecimal)_NSUtilities.convertNumberOrBooleanIntoCompatibleValue(object, _NSUtilities._BigDecimalClass);
                }
                if (object instanceof String) {
                    return new BigDecimal((String)object);
                }
                throw new IllegalStateException("Can't convert " + object + " (class " + object.getClass().getName() + ") into number");
            }
            return null;
        }

        BigDecimal _sum(NSArray values, String keyPath) {
            BigDecimal sum = BigDecimal.valueOf(0L);
            Object[] objects = values.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                BigDecimal value = this._bigDecimalForValue(this._operationValue(objects[i], keyPath));
                if (value == null) continue;
                sum = sum.add(value);
            }
            return sum;
        }

        Object _minOrMaxValue(Object referenceValue, Object compareValue, boolean trueForMaxAndFalseForMin) {
            int comparison;
            if (referenceValue == null) {
                return compareValue;
            }
            if (compareValue == null) {
                return referenceValue;
            }
            if (_NSUtilities._isClassANumberOrABoolean(referenceValue.getClass())) {
                comparison = _NSUtilities.compareNumbersOrBooleans(referenceValue, compareValue);
            } else if (referenceValue instanceof NSTimestamp) {
                comparison = ((NSTimestamp)referenceValue).compare((NSTimestamp)compareValue);
            } else if (referenceValue instanceof Comparable) {
                comparison = ((Comparable)referenceValue).compareTo(compareValue);
            } else {
                throw new IllegalStateException("Cannot compare values " + referenceValue + " and " + compareValue + " (they are not instance of Comparable");
            }
            if (trueForMaxAndFalseForMin ? comparison >= 0 : comparison <= 0) {
                return referenceValue;
            }
            return compareValue;
        }
    }

    static class _CountOperator
    implements Operator {
        public Object compute(NSArray values, String keyPath) {
            return _NSUtilities.IntegerForInt(values.count());
        }
    }

    public static interface Operator {
        public Object compute(NSArray var1, String var2);
    }
}

