/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.util.Vector;

public class NSMutableArray
extends NSArray {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation.NSMutableArray");
    static final long serialVersionUID = -3909373569895711876L;

    public NSMutableArray() {
    }

    public NSMutableArray(int capacity) {
        this();
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableArray(Object object) {
        super(object);
    }

    public NSMutableArray(Object[] objects) {
        super(objects);
    }

    public NSMutableArray(Object[] objects, NSRange range) {
        super(objects, range);
    }

    public NSMutableArray(NSArray otherArray) {
        super(otherArray);
    }

    public NSMutableArray(Vector vector, NSRange range, boolean ignoreNull) {
        super(vector, range, ignoreNull);
    }

    public void setArray(NSArray otherArray) {
        if (otherArray != this) {
            if (otherArray == null) {
                this._count = 0;
            } else {
                Object[] objects = otherArray.objectsNoCopy();
                this._ensureCapacity(objects.length);
                if (objects.length > 0) {
                    System.arraycopy(objects, 0, this._objects, 0, objects.length);
                }
                for (int i = objects.length; i < this._count; ++i) {
                    this._objects[i] = null;
                }
                this._count = objects.length;
            }
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
        }
    }

    public void addObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an " + this.getClass().getName() + ".");
        }
        this._ensureCapacity(this._count + 1);
        this._objects[this._count++] = object;
        this._objectsCache = null;
        this._setMustRecomputeHash(true);
    }

    public void addObjects(Object[] objects) {
        if (objects != null && objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] != null) continue;
                throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
            }
            this._ensureCapacity(this._count + objects.length);
            System.arraycopy(objects, 0, this._objects, this._count, objects.length);
            this._count += objects.length;
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
        }
    }

    public Object replaceObjectAtIndex(Object object, int index) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        if (index >= 0 && index < this._count) {
            Object result = this._objects[index];
            this._objects[index] = object;
            this._setMustRecomputeHash(true);
            if (this._objectsCache != null) {
                this._objectsCache[index] = object;
            }
            return result;
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this._count - 1) + "]");
    }

    public void replaceObjectAtIndex(int index, Object object) {
        this.replaceObjectAtIndex(object, index);
    }

    public void insertObjectAtIndex(Object object, int index) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        if (index >= 0 && index <= this._count) {
            this._ensureCapacity(this._count + 1);
            if (index < this._count) {
                System.arraycopy(this._objects, index, this._objects, index + 1, this._count - index);
            }
            this._objects[index] = object;
            ++this._count;
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
            return;
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this._count - 1) + "]");
    }

    public Object removeObjectAtIndex(int index) {
        if (index >= 0 && index < this._count) {
            --this._count;
            Object result = this._objects[index];
            if (index < this._count) {
                System.arraycopy(this._objects, index + 1, this._objects, index, this._count - index);
            }
            this._objects[this._count] = null;
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
            return result;
        }
        if (this._count == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this._count - 1) + "]");
    }

    public void removeAllObjects() {
        if (this._count > 0) {
            this._objects = new Object[this._capacity];
            this._count = 0;
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
        }
    }

    public void sortUsingComparator(NSComparator comparator) throws NSComparator.ComparisonException {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator not specified");
        }
        if (this._count < 2) {
            return;
        }
        _NSCollectionPrimitives.K2SortArray(this._objects, this._count, comparator);
        this._objectsCache = null;
        this._setMustRecomputeHash(true);
    }

    public void addObjectsFromArray(NSArray otherArray) {
        if (otherArray != null) {
            this.addObjects(otherArray.objectsNoCopy());
        }
    }

    public void replaceObjectsInRange(NSRange range, NSArray otherArray, NSRange otherRange) {
        int otherRangeLength;
        if (range == null || otherRange == null) {
            throw new IllegalArgumentException("Both ranges cannot be null");
        }
        if (otherArray == null) {
            throw new IllegalArgumentException("Other array cannot be null");
        }
        int rangeLength = range.length();
        int rangeLocation = range.location();
        int otherRangeLocation = otherRange.location();
        for (otherRangeLength = otherRange.length(); 0 < rangeLength && 0 < otherRangeLength; --otherRangeLength) {
            this.replaceObjectAtIndex(otherArray.objectAtIndex(otherRangeLocation), rangeLocation);
            ++rangeLocation;
            --rangeLength;
            ++otherRangeLocation;
        }
        while (0 < otherRangeLength) {
            this.insertObjectAtIndex(otherArray.objectAtIndex(otherRangeLocation), rangeLocation);
            ++rangeLocation;
            ++otherRangeLocation;
            --otherRangeLength;
        }
        while (0 < rangeLength) {
            this.removeObjectAtIndex(rangeLocation);
            --rangeLength;
        }
    }

    public Object removeLastObject() {
        if (this.count() == 0) {
            return null;
        }
        return this.removeObjectAtIndex(this.count() - 1);
    }

    private boolean _removeObject(Object object, int index, int length, boolean identical) {
        boolean wasRemoved;
        block3: {
            Object[] objects;
            block4: {
                wasRemoved = false;
                if (object == null) {
                    throw new IllegalArgumentException("Attempt to remove null from an  " + this.getClass().getName() + ".");
                }
                if (this.count() <= 0) break block3;
                objects = this.objectsNoCopy();
                int maxIndex = index + length - 1;
                if (!identical) break block4;
                for (int i = maxIndex; i >= index; --i) {
                    if (objects[i] != object) continue;
                    this.removeObjectAtIndex(i);
                    wasRemoved = true;
                }
                break block3;
            }
            if (identical) break block3;
            for (int i = maxIndex; i >= index; --i) {
                if (objects[i] != object && !object.equals(objects[i])) continue;
                this.removeObjectAtIndex(i);
                wasRemoved = true;
            }
        }
        return wasRemoved;
    }

    public boolean removeObject(Object object) {
        return this._removeObject(object, 0, this.count(), false);
    }

    public boolean removeObject(Object object, NSRange range) {
        boolean wasRemoved = false;
        if (range != null) {
            int rangeLength;
            int count = this.count();
            int rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
                throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count - 1) + "]");
            }
            wasRemoved = this._removeObject(object, rangeLocation, rangeLength, false);
        }
        return wasRemoved;
    }

    public boolean removeIdenticalObject(Object object) {
        return this._removeObject(object, 0, this.count(), true);
    }

    public boolean removeIdenticalObject(Object object, NSRange range) {
        if (range != null) {
            int rangeLength;
            int count = this.count();
            int rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
                throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count - 1) + "]");
            }
            return this._removeObject(object, rangeLocation, rangeLength, true);
        }
        return false;
    }

    public void removeObjects(Object[] objects) {
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                this.removeObject(objects[i]);
            }
        }
    }

    public void removeObjectsInArray(NSArray otherArray) {
        if (otherArray != null) {
            this.removeObjects(otherArray.objectsNoCopy());
        }
    }

    public void removeObjectsInRange(NSRange range) {
        if (range != null) {
            int rangeLength;
            int count = this.count();
            int rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
                throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count - 1) + "]");
            }
            while (rangeLength-- > 0) {
                this.removeObjectAtIndex(rangeLocation);
            }
        }
    }

    public Object clone() {
        return new NSMutableArray(this);
    }

    public NSArray immutableClone() {
        return new NSArray(this);
    }

    public NSMutableArray mutableClone() {
        return (NSMutableArray)this.clone();
    }

    public void _moveObjectAtIndexToIndex(int sourceIndex, int destIndex) {
        boolean dstOffset;
        boolean srcOffset;
        int direction;
        int boundary;
        int index;
        if (sourceIndex == destIndex) {
            return;
        }
        if (sourceIndex < 0 || sourceIndex >= this._count || destIndex < 0 || destIndex >= this._count) {
            throw new IllegalArgumentException("Either source(" + sourceIndex + ") or destination(" + destIndex + ") is illegal.");
        }
        Object temp = this._objects[sourceIndex];
        if (sourceIndex < destIndex) {
            index = destIndex;
            boundary = sourceIndex;
            direction = 1;
            srcOffset = true;
            dstOffset = false;
        } else {
            index = sourceIndex;
            boundary = destIndex;
            direction = -1;
            srcOffset = false;
            dstOffset = true;
        }
        int count = index - boundary;
        while (index != boundary) {
            this._objects[index] = this._objects[index + direction];
            index += direction;
        }
        this._objects[destIndex] = temp;
        this._objectsCache = null;
    }
}

