/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications.filterbuilder.wrappers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.RegexFilter;
import org.htmlparser.parserapplications.filterbuilder.Filter;

public class RegexFilterWrapper
extends Filter
implements ActionListener,
DocumentListener {
    public static Object[][] mMap = new Object[3][];
    protected RegexFilter mFilter = new RegexFilter();
    protected JTextArea mPattern = new JTextArea(2, 20);
    protected JComboBox mStrategy;

    public RegexFilterWrapper() {
        this.mPattern.setBorder(new BevelBorder(1));
        this.add(this.mPattern);
        this.mPattern.getDocument().addDocumentListener(this);
        this.mPattern.setText(this.mFilter.getPattern());
        this.mStrategy = new JComboBox();
        this.mStrategy.addItem("MATCH");
        this.mStrategy.addItem("LOOKINGAT");
        this.mStrategy.addItem("FIND");
        this.add(this.mStrategy);
        this.mStrategy.addActionListener(this);
        this.mStrategy.setSelectedIndex(this.strategyToIndex(this.mFilter.getStrategy()));
    }

    public String getDescription() {
        return "Nodes containing regex";
    }

    public String getIconSpec() {
        return "images/RegexFilter.gif";
    }

    public NodeFilter getNodeFilter() {
        RegexFilter ret = new RegexFilter();
        ret.setStrategy(this.mFilter.getStrategy());
        ret.setPattern(this.mFilter.getPattern());
        return ret;
    }

    public void setNodeFilter(NodeFilter filter, Parser context) {
        this.mFilter = (RegexFilter)filter;
        this.mPattern.setText(this.mFilter.getPattern());
        this.mStrategy.setSelectedIndex(this.strategyToIndex(this.mFilter.getStrategy()));
    }

    public NodeFilter[] getSubNodeFilters() {
        return new NodeFilter[0];
    }

    public void setSubNodeFilters(NodeFilter[] filters) {
    }

    public String toJavaCode(StringBuffer out, int[] context) {
        int n = context[1];
        context[1] = n + 1;
        String ret = "filter" + n;
        RegexFilterWrapper.spaces(out, context[0]);
        out.append("RegexFilter ");
        out.append(ret);
        out.append(" = new RegexFilter ();");
        RegexFilterWrapper.newline(out);
        RegexFilterWrapper.spaces(out, context[0]);
        out.append(ret);
        out.append(".setStrategy (RegexFilter.");
        out.append(this.strategyToString(this.mFilter.getStrategy()));
        out.append(");");
        RegexFilterWrapper.newline(out);
        RegexFilterWrapper.spaces(out, context[0]);
        out.append(ret);
        out.append(".setPattern (\"");
        out.append(this.mFilter.getPattern());
        out.append("\");");
        RegexFilterWrapper.newline(out);
        return ret;
    }

    public String strategyToString(int strategy) {
        for (int i = 0; i < mMap.length; ++i) {
            if (strategy != (Integer)mMap[i][1]) continue;
            return (String)mMap[i][0];
        }
        throw new IllegalArgumentException("unknown strategy constant - " + strategy);
    }

    public int stringToStrategy(String strategy) {
        for (int i = 0; i < mMap.length; ++i) {
            if (!strategy.equalsIgnoreCase((String)mMap[i][0])) continue;
            return (Integer)mMap[i][1];
        }
        throw new IllegalArgumentException("unknown strategy constant - " + strategy);
    }

    public int strategyToIndex(int strategy) {
        for (int i = 0; i < mMap.length; ++i) {
            if (strategy != (Integer)mMap[i][1]) continue;
            return i;
        }
        throw new IllegalArgumentException("unknown strategy constant - " + strategy);
    }

    public int indexToStrategy(int index) {
        return (Integer)mMap[index][1];
    }

    public boolean accept(Node node) {
        return this.mFilter.accept(node);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mStrategy) {
            this.mFilter.setStrategy(this.indexToStrategy(this.mStrategy.getSelectedIndex()));
        }
    }

    public void insertUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.mFilter.setPattern(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.mFilter.setPattern(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    static {
        RegexFilterWrapper.mMap[0] = new Object[2];
        RegexFilterWrapper.mMap[0][0] = "MATCH";
        RegexFilterWrapper.mMap[0][1] = new Integer(1);
        RegexFilterWrapper.mMap[1] = new Object[2];
        RegexFilterWrapper.mMap[1][0] = "LOOKINGAT";
        RegexFilterWrapper.mMap[1][1] = new Integer(2);
        RegexFilterWrapper.mMap[2] = new Object[2];
        RegexFilterWrapper.mMap[2][0] = "FIND";
        RegexFilterWrapper.mMap[2][1] = new Integer(3);
    }
}

