/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOAction;
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAdaptor;
import com.webobjects.appserver.WOAdminAction;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.appserver.WODynamicElement;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOEvent;
import com.webobjects.appserver.WOPageNotFoundException;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver.WOSessionStore;
import com.webobjects.appserver.WOStatisticsStore;
import com.webobjects.appserver.WOTimer;
import com.webobjects.appserver._WORunLoop;
import com.webobjects.appserver._private.License;
import com.webobjects.appserver._private.WOActionURL;
import com.webobjects.appserver._private.WOActiveImage;
import com.webobjects.appserver._private.WOApplet;
import com.webobjects.appserver._private.WOBody;
import com.webobjects.appserver._private.WOBrowser;
import com.webobjects.appserver._private.WOBundle;
import com.webobjects.appserver._private.WOCheckBox;
import com.webobjects.appserver._private.WOComponentContent;
import com.webobjects.appserver._private.WOComponentDefinition;
import com.webobjects.appserver._private.WOComponentRequestHandler;
import com.webobjects.appserver._private.WOConditional;
import com.webobjects.appserver._private.WODefaultAdaptor;
import com.webobjects.appserver._private.WODefaultExceptions;
import com.webobjects.appserver._private.WODirectActionRequestHandler;
import com.webobjects.appserver._private.WOFileUpload;
import com.webobjects.appserver._private.WOForm;
import com.webobjects.appserver._private.WOFrame;
import com.webobjects.appserver._private.WOGenericContainer;
import com.webobjects.appserver._private.WOGenericElement;
import com.webobjects.appserver._private.WOHiddenField;
import com.webobjects.appserver._private.WOHttpIO;
import com.webobjects.appserver._private.WOHyperlink;
import com.webobjects.appserver._private.WOImage;
import com.webobjects.appserver._private.WOImageButton;
import com.webobjects.appserver._private.WOJavaScript;
import com.webobjects.appserver._private.WOParam;
import com.webobjects.appserver._private.WOPasswordField;
import com.webobjects.appserver._private.WOPopUpButton;
import com.webobjects.appserver._private.WOProjectBundle;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.appserver._private.WORadioButton;
import com.webobjects.appserver._private.WORecording;
import com.webobjects.appserver._private.WORepetition;
import com.webobjects.appserver._private.WOResetButton;
import com.webobjects.appserver._private.WOResourceRequestHandler;
import com.webobjects.appserver._private.WOResourceURL;
import com.webobjects.appserver._private.WOServerSessionStore;
import com.webobjects.appserver._private.WOStaticResourceRequestHandler;
import com.webobjects.appserver._private.WOString;
import com.webobjects.appserver._private.WOSubmitButton;
import com.webobjects.appserver._private.WOSwitchComponent;
import com.webobjects.appserver._private.WOText;
import com.webobjects.appserver._private.WOTextField;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.appserver._private.WOWebServiceRequestHandler;
import com.webobjects.appserver._private.WOXMLNode;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOEvent;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGenericRecord;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.eocontrol.EOTemporaryGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDelayedCallbackCenter;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSThreadsafeMutableSet;
import com.webobjects.foundation._NSUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class WOApplication
implements NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSKeyValueCodingAdditions {
    private final String _name;
    private volatile WOSessionStore _sessionStore;
    private volatile WOStatisticsStore _statisticsStore;
    private final _NSThreadsafeMutableDictionary _componentDefinitionCache;
    private final _NSThreadsafeMutableDictionary _requestHandlers;
    private volatile WORequestHandler _defaultRequestHandler;
    private volatile WOResourceManager _resourceManager;
    private NSTimestamp _runLoopDate;
    private long _timeOut;
    private WOTimer _timer;
    private final _WORunLoop _currentRunLoop;
    private volatile boolean _terminating;
    private final Object _globalLock;
    private final Object _recorder;
    private NSMutableArray _adaptors;
    private InetAddress _hostAddress;
    public boolean _unsetHost = true;
    public static boolean _wasMainInvoked = false;
    private volatile int _activeSessionsCount;
    private volatile int _minimumActiveSessions;
    private volatile int _permanentCacheSize;
    private volatile int _pageCacheSize;
    private volatile boolean _refusingNewClients;
    private volatile boolean _dynamicLoadingEnabled;
    private volatile boolean _pageRefreshOnBacktrackEnabled;
    private boolean _isMultiThreaded;
    private boolean _allowsConcurrentRequestHandling;
    private static _LifebeatThread _lifebeatThread;
    public static final String _adminRequestHandlerKey = "womp";
    private static WOApplication _WOApp;
    private static Class _WOAppClass;
    private static String _WOAppClassName;
    private static String _WOAppPackageName;
    private static Class _theSessionClass;
    private static String[] _argv;
    private static int TheLoadedFrameworkCount;
    private static NSMutableArray TheComponentBearingFrameworks;
    private static final String TheNotFoundMarker = "NotFoundMarker";
    private static boolean TheMultipleInstancesLicenseFlag;
    private static boolean TheMultipleThreadsLicenseFlag;
    private static long TheRequestWindowLicenseValue;
    private static int TheRequestLimitLicenseValue;
    private static final int LicenseKeyStringLength = 37;
    private static boolean _checksForSpecialHeaders;
    protected static volatile long _TheLastApplicationAccessTime;
    private static volatile boolean _IsEventLoggingEnabled;
    private static final String pageWithNameEvent = "pageWithName";
    private final boolean _inRapidTurnaroundMode;
    private final _NSThreadsafeMutableSet _expectedLanguages = new _NSThreadsafeMutableSet(new NSMutableSet(16));
    public static final String ApplicationWillFinishLaunchingNotification = "ApplicationWillFinishLaunchingNotification";
    public static final String ApplicationDidFinishLaunchingNotification = "ApplicationDidFinishLaunchingNotification";
    public static final String ApplicationWillDispatchRequestNotification = "ApplicationWillDispatchRequestNotification";
    public static final String ApplicationDidDispatchRequestNotification = "ApplicationDidDispatchRequestNotification";
    private static final String _WORecordingClassName = "com.webobjects.appserver._private.WORecording";
    private static final String _WORecordingClassNameKey = "WORecordingClassName";
    private Class[] _createContextForRequestParams = new Class[]{WORequest.class};

    public static void main(String[] stringArray) {
        WOApplication.main(stringArray, WOApplication.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray, Class clazz) {
        try {
            _wasMainInvoked = true;
            _argv = stringArray;
            if (clazz == null) {
                throw new IllegalArgumentException("No application class specified");
            }
            WOApplication wOApplication = (WOApplication)clazz.newInstance();
            wOApplication.run();
        }
        catch (Throwable throwable) {
            try {
                NSLog.err.appendln((Object)("A fatal exception occurred: " + throwable.getMessage()));
                NSLog.err.appendln(throwable);
                if (_lifebeatThread != null) {
                    _lifebeatThread.sendMessage(_lifebeatThread._willCrash);
                }
            }
            finally {
                System.exit(1);
            }
        }
        System.exit(0);
    }

    static void _setApplication(WOApplication wOApplication) {
        _WOApp = wOApplication;
        if (wOApplication != null) {
            _WOAppClass = wOApplication.getClass();
            _WOAppClassName = wOApplication.getClass().getName();
        }
    }

    public static WOApplication application() {
        return _WOApp;
    }

    public static void primeApplication(String string, String string2) {
        if (_WOApp == null) {
            NSBundle nSBundle = null;
            if (string != null) {
                nSBundle = NSBundle.bundleWithPath((String)string);
            }
            if (nSBundle == null) {
                nSBundle = NSBundle.bundleForName((String)"JavaWebObjects.framework");
            }
            NSBundle._setMainBundle((NSBundle)nSBundle);
            String string3 = NSProperties.getProperty((String)WOProperties._ApplicationNameKey);
            if (string3 == null) {
                string3 = NSBundle.mainBundle().name();
            }
            if (NSLog.out instanceof NSLog.PrintStreamLogger) {
                ((NSLog.PrintStreamLogger)NSLog.out)._setPrefixInfo(string3);
            }
            if (NSLog.err instanceof NSLog.PrintStreamLogger) {
                ((NSLog.PrintStreamLogger)NSLog.err)._setPrefixInfo(string3);
            }
            if (NSLog.debug instanceof NSLog.PrintStreamLogger) {
                ((NSLog.PrintStreamLogger)NSLog.debug)._setPrefixInfo(string3);
            }
            Class clazz = null;
            if (string2 != null) {
                clazz = _NSUtilities.classWithName((String)string2);
            }
            if (clazz == null) {
                clazz = _NSUtilities.classWithName((String)"com.webobjects.appserver.WOApplication");
            }
            WOApplication wOApplication = (WOApplication)_NSUtilities.instantiateObject((Class)clazz, null, null, (boolean)true, (boolean)true);
            _WOAppPackageName = _NSStringUtilities.stringByDeletingLastComponent((String)string2, (char)'.');
            if (_WOAppPackageName == null || _WOAppPackageName.length() == 0) {
                NSLog.err.appendln((Object)"<WOApplication>.primeApplication: Application class is not in a package. This could cause problems with some appservers.");
            }
            NSLog.debug.appendln((Object)("<WOApplication>.primeApplication: The Application name is " + wOApplication.name()));
            _WOApp.run();
        }
    }

    public static void primeApplication(String string, URL uRL, String string2) {
        String string3 = null;
        if (uRL != null && "file".equals(uRL.getProtocol())) {
            string3 = uRL.getPath();
        }
        if (string != null) {
            NSBundle nSBundle = NSBundle.bundleForName((String)string);
            if (nSBundle != null) {
                string3 = nSBundle.bundlePath();
            } else {
                nSBundle = NSBundle._appBundleForName((String)string);
                if (nSBundle != null) {
                    string3 = nSBundle.bundlePath();
                }
            }
        }
        WOApplication.primeApplication(string3, string2);
    }

    public boolean wasMainInvoked() {
        return _wasMainInvoked;
    }

    public EOSharedEditingContext sharedEditingContext() {
        return EOSharedEditingContext.defaultSharedEditingContext();
    }

    WOApplication(String string) {
        this._globalLock = new Object();
        WOApplication._initWOApp(false);
        WOApplication._setApplication(this);
        this._name = NSBundle.mainBundle().name();
        this._currentRunLoop = null;
        this._allowsConcurrentRequestHandling = false;
        this._minimumActiveSessions = 0;
        this._activeSessionsCount = 0;
        this._refusingNewClients = false;
        this._componentDefinitionCache = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(128));
        this._dynamicLoadingEnabled = true;
        this._permanentCacheSize = this._pageCacheSize = 0;
        this._pageRefreshOnBacktrackEnabled = false;
        this._resourceManager = this.createResourceManager();
        this._inRapidTurnaroundMode = this._initializeRapidTurnaroundMode();
        this.setStatisticsStore(null);
        this.setSessionStoreClassName(string);
        this._defaultRequestHandler = null;
        this._requestHandlers = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        WOComponentRequestHandler wOComponentRequestHandler = new WOComponentRequestHandler();
        this.registerRequestHandler(wOComponentRequestHandler, this.componentRequestHandlerKey());
        this.registerRequestHandler(new WODirectActionRequestHandler(), this.directActionRequestHandlerKey());
        this.setDefaultRequestHandler(wOComponentRequestHandler);
        _lifebeatThread = null;
        this._timer = null;
        this._terminating = false;
        this._recorder = null;
    }

    public WOApplication() {
        this._globalLock = new Object();
        try {
            String string;
            WOApplication._initWOApp(true);
            WOApplication._setApplication(this);
            String string2 = NSProperties.getProperty((String)WOProperties._ApplicationNameKey);
            this._name = string2 == null ? NSBundle.mainBundle().name() : string2;
            this._readLicenseParameters();
            this._currentRunLoop = _WORunLoop.currentRunLoop();
            if (!this.wasMainInvoked()) {
                this.setAdaptor("WONullAdaptor");
                this._setLifebeatEnabled(false);
            }
            this._initAdaptors();
            if (this._hostAddress == null) {
                try {
                    this._hostAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    NSLog.err.appendln((Object)"Failed to get localhost address");
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)unknownHostException);
                }
                this._setHost(this._hostAddress.getHostName());
            }
            this._allowsConcurrentRequestHandling = this.allowsConcurrentRequestHandling();
            if (this.port().intValue() != -1) {
                EOTemporaryGlobalID._setProcessIdentificationBytesFromInt((int)this.port().intValue());
            }
            EOTemporaryGlobalID._setHostIdentificationBytes((byte[])this.hostAddress().getAddress());
            this._minimumActiveSessions = 0;
            this._activeSessionsCount = 0;
            this._refusingNewClients = false;
            this._componentDefinitionCache = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(128));
            this._dynamicLoadingEnabled = true;
            this._permanentCacheSize = this._pageCacheSize = 30;
            this._pageRefreshOnBacktrackEnabled = true;
            this._resourceManager = this.createResourceManager();
            this._inRapidTurnaroundMode = this._initializeRapidTurnaroundMode();
            this.setStatisticsStore(new WOStatisticsStore());
            String string3 = NSProperties.getProperty((String)WOProperties._SessionStoreClassNameKey);
            this.setSessionStoreClassName(string3);
            this._defaultRequestHandler = null;
            this._requestHandlers = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(16));
            this._registerRequestHandlers();
            if (!this.name().equals("wotaskd") && this.lifebeatEnabled()) {
                string = NSProperties.getProperty((String)WOProperties._LifebeatIntervalKey);
                long l = 0L;
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    NSLog.err.appendln((Object)("<WOApplication> WOLifebeatInterval " + string + " specified incorrectly"));
                    NSLog._conditionallyLogPrivateException((Throwable)numberFormatException);
                }
                if (l < 1L) {
                    l = 30L;
                }
                _lifebeatThread = new _LifebeatThread(this.name(), this.port().intValue(), this.hostAddress(), this.lifebeatDestinationPort(), l *= 1000L);
                _lifebeatThread.setDaemon(true);
                _lifebeatThread.start();
            } else {
                _lifebeatThread = null;
            }
            _TheLastApplicationAccessTime = System.currentTimeMillis();
            this._timeOut = NSTimestamp.DistantFuture.getTime() - _TheLastApplicationAccessTime;
            this._timer = null;
            this._terminating = false;
            if (this.recordingPath() != null) {
                string = NSProperties.getProperty((String)_WORecordingClassNameKey);
                if (string == null) {
                    string = _WORecordingClassName;
                }
                this._recorder = this._instanceOfNamedClassAssignableFrom(string, WORecording.class, WORecording.class);
            } else {
                this._recorder = null;
            }
        }
        catch (Exception exception) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                NSLog.err.appendln((Object)("<WOApplication>: Cannot be initialized." + exception.getMessage()));
            }
            throw new NSForwardException((Throwable)exception, "<WOApplication>: Cannot be initialized.");
        }
    }

    private boolean _initializeRapidTurnaroundMode() {
        boolean bl = this._resourceManager._appProjectBundle() instanceof WOProjectBundle;
        if (!bl) {
            NSArray nSArray = this._resourceManager._frameworkProjectBundles();
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                if (!(nSArray.objectAtIndex(i) instanceof WOProjectBundle)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String toString() {
        return "<WOApplication: name=" + this._name + " adaptors=" + this._adaptors + " sessionStore=" + this._sessionStore + " pageCacheSize=" + this._pageCacheSize + " permanentCacheSize=" + this._permanentCacheSize + " pageRecreationEnabled=" + this._isPageRecreationEnabled() + " pageRefreshOnBacktrackEnabled=" + this.isPageRefreshOnBacktrackEnabled() + " componentDefinitionCache=" + this._componentDefinitionCache + " caching=" + this.isCachingEnabled() + " terminating=" + this.isTerminating() + " timeOut(sec)=" + this.timeOut() + " dynamicLoadingEnabled=" + this._isDynamicLoadingEnabled() + ">";
    }

    public String path() {
        return this._resourceManager._appProjectBundle().bundlePath();
    }

    public String baseURL() {
        return this.applicationBaseURL();
    }

    public String number() {
        return "-1";
    }

    public String name() {
        return this._name;
    }

    private boolean _runOnce() {
        if (this.isTerminating()) {
            return false;
        }
        this._currentRunLoop.runBeforeDate(this._runLoopDate);
        return true;
    }

    public _WORunLoop _runLoop() {
        return this._currentRunLoop;
    }

    public void terminate() {
        this._terminating = true;
        WOTimer.scheduledTimer(0L, this, "_quitTimer", null, null, false);
    }

    public void _quitTimer() {
    }

    public boolean isTerminating() {
        return this._terminating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeOut(double d) {
        long l = d == 0.0 ? NSTimestamp.DistantFuture.getTime() - System.currentTimeMillis() : (long)(d * 1000.0);
        WOApplication wOApplication = this;
        synchronized (wOApplication) {
            this._timeOut = l;
            this._scheduleApplicationTimerForTimeInterval(l);
        }
    }

    public double timeOut() {
        return (double)this._timeOut / 1000.0;
    }

    private synchronized void _scheduleApplicationTimerForTimeInterval(long l) {
        if (this._timer != null) {
            this._timer.invalidate();
        }
        this._timer = new WOTimer(l, this, "_terminateOrResetTimer", null, Object.class, false);
        this._timer.schedule();
    }

    public void _terminateOrResetTimer(Object object) {
        long l = System.currentTimeMillis();
        if (l - _TheLastApplicationAccessTime >= this._timeOut) {
            this.terminate();
        } else {
            this._scheduleApplicationTimerForTimeInterval(this._timeOut - (l - _TheLastApplicationAccessTime));
        }
    }

    public void run() {
        NSArray nSArray = this.adaptors();
        int n = nSArray.count();
        NSNotificationCenter.defaultCenter().postNotification(ApplicationWillFinishLaunchingNotification, (Object)this);
        for (int i = 0; i < n; ++i) {
            ((WOAdaptor)nSArray.objectAtIndex(i)).registerForEvents();
        }
        if (this.wasMainInvoked()) {
            this._runLoopDate = NSTimestamp.DistantFuture;
            this._openInitialURL();
        } else {
            this._runLoopDate = NSTimestamp.DistantPast;
            this._openInitialURL();
            this._terminating = true;
        }
        NSNotificationCenter.defaultCenter().postNotification(ApplicationDidFinishLaunchingNotification, (Object)this);
        NSLog.debug.appendln((Object)"Waiting for requests...");
        while (this._runOnce()) {
        }
        Thread[] threadArray = new Thread[n];
        final NSArray nSArray2 = nSArray;
        int n2 = 0;
        while (n2 < n) {
            final int n3 = n2++;
            Runnable runnable = new Runnable(){

                public void run() {
                    ((WOAdaptor)nSArray2.objectAtIndex(n3)).unregisterForEvents();
                }
            };
            threadArray[n3] = new Thread(runnable);
            threadArray[n3].start();
        }
        try {
            for (n2 = 0; n2 < threadArray.length; ++n2) {
                threadArray[n2].join();
            }
        }
        catch (InterruptedException interruptedException) {
            NSLog._conditionallyLogPrivateException((Throwable)interruptedException);
        }
        if (_lifebeatThread != null) {
            _lifebeatThread.sendMessage(_lifebeatThread._willStop);
        }
    }

    public WOAdaptor adaptorWithName(String string, NSDictionary nSDictionary) {
        Class clazz;
        WOAdaptor wOAdaptor = null;
        if (string != null) {
            clazz = _NSUtilities.classWithName((String)"com.webobjects.appserver._private.".concat(string));
            if (clazz == null && (clazz = _NSUtilities.classWithName((String)string)) == null) {
                throw new InstantiationError("<" + _WOAppClassName + ">: Unable to locate class named: " + string + " .");
            }
        } else {
            throw new InstantiationError("<" + _WOAppClassName + ">: Name missing for adaptor creation.");
        }
        Class[] classArray = WOAdaptor._ConstructorParametersTypes;
        Object[] objectArray = new Object[]{string, nSDictionary};
        wOAdaptor = (WOAdaptor)_NSUtilities.instantiateObject((Class)clazz, (Class[])classArray, (Object[])objectArray, (boolean)true, (boolean)this.isDebuggingEnabled());
        if (wOAdaptor.dispatchesRequestsConcurrently()) {
            this._isMultiThreaded = true;
        }
        return wOAdaptor;
    }

    public NSArray adaptors() {
        return this._adaptors;
    }

    private NSMutableDictionary _argsDictionary() {
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        nSMutableDictionary.takeValueForKey((Object)this.host(), WOProperties._HostKey);
        nSMutableDictionary.setObjectForKey((Object)this.port(), (Object)WOProperties._PortKey);
        nSMutableDictionary.setObjectForKey((Object)this.adaptor(), (Object)WOProperties._AdaptorKey);
        nSMutableDictionary.setObjectForKey((Object)this.workerThreadCount(), (Object)WOProperties._WorkerThreadCountKey);
        nSMutableDictionary.setObjectForKey((Object)this.workerThreadCountMin(), (Object)WOProperties._WorkerThreadCountMinKey);
        nSMutableDictionary.setObjectForKey((Object)this.workerThreadCountMax(), (Object)WOProperties._WorkerThreadCountMaxKey);
        nSMutableDictionary.setObjectForKey((Object)this.listenQueueSize(), (Object)WOProperties._ListenQueueSizeKey);
        nSMutableDictionary.setObjectForKey((Object)this.maxSocketIdleTime(), (Object)WOProperties._MaxSocketIdleTimeKey);
        return nSMutableDictionary;
    }

    private void _initAdaptors() {
        NSArray nSArray = this.additionalAdaptors();
        this._adaptors = new NSMutableArray(nSArray.count() + 1);
        NSMutableDictionary nSMutableDictionary = this._argsDictionary();
        String string = (String)nSMutableDictionary.objectForKey((Object)WOProperties._AdaptorKey);
        WOAdaptor wOAdaptor = this.adaptorWithName(string, (NSDictionary)nSMutableDictionary);
        this._adaptors.addObject((Object)wOAdaptor);
        Enumeration enumeration = nSArray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            nSMutableDictionary = (NSMutableDictionary)enumeration.nextElement();
            string = (String)nSMutableDictionary.objectForKey((Object)WOProperties._AdaptorKey);
            wOAdaptor = this.adaptorWithName(string, (NSDictionary)nSMutableDictionary);
            this._adaptors.addObject((Object)wOAdaptor);
        }
    }

    protected void _setAllowsCacheControlHeader(boolean bl) {
        WOProperties.TheAllowsCacheControlHeaderFlag = bl;
        WOProperties.isTheAllowsCacheControlHeaderFlagSet = true;
    }

    protected boolean _allowsCacheControlHeader() {
        if (!WOProperties.isTheAllowsCacheControlHeaderFlagSet) {
            String string = NSProperties.getProperty((String)WOProperties._AllowsCacheControlHeaderKey);
            this._setAllowsCacheControlHeader(Boolean.valueOf(string));
        }
        return WOProperties.TheAllowsCacheControlHeaderFlag;
    }

    public void setResourceManager(WOResourceManager wOResourceManager) {
        this._resourceManager = wOResourceManager;
    }

    public WOResourceManager resourceManager() {
        return this._resourceManager;
    }

    public WOResponse dispatchRequest(WORequest wORequest) {
        WOResponse wOResponse = null;
        WORequestHandler wORequestHandler = null;
        NSNotificationCenter nSNotificationCenter = NSNotificationCenter.defaultCenter();
        _TheLastApplicationAccessTime = System.currentTimeMillis();
        nSNotificationCenter.postNotification(ApplicationWillDispatchRequestNotification, (Object)wORequest);
        wORequestHandler = this.handlerForRequest(wORequest);
        if (wORequestHandler == null) {
            wORequestHandler = this.defaultRequestHandler();
        }
        if ((wOResponse = wORequestHandler.handleRequest(wORequest)) == null) {
            this.debugString("<" + _WOAppClassName + "> !!! Response is null !!!");
            wOResponse = WOApplication.application().createResponseInContext(null);
        }
        nSNotificationCenter.postNotification(ApplicationDidDispatchRequestNotification, (Object)wOResponse);
        wORequest._setContext(null);
        return wOResponse;
    }

    public void awake() {
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        WOSession wOSession = wOContext._session();
        if (wOSession != null) {
            wOSession.takeValuesFromRequest(wORequest, wOContext);
        }
    }

    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        WOSession wOSession = wOContext._session();
        WOActionResults wOActionResults = null;
        if (wOSession != null) {
            wOActionResults = wOSession.invokeAction(wORequest, wOContext);
        }
        return wOActionResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        Object object;
        WORequest wORequest = wOContext.request();
        WOSession wOSession = wOContext._session();
        if (wOContext._refuseThisRequest()) {
            NSLog.err.appendln((Object)"<WOApplication> !!! appendToResponse: called with refuseNewSessions set !!!");
            object = this;
            synchronized (object) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)4L)) {
                    NSLog.debug.appendln((Object)"!!! Request will be REDIRECTED to non-refusing instance.");
                }
                wOResponse.setStatus(301);
                wOResponse.setHeader(this._newLocationForRequest(wORequest), "Location");
                if (wOSession != null) {
                    wOSession.terminate();
                }
            }
        }
        if (wOSession != null) {
            wOSession.appendToResponse(wOResponse, wOContext);
        }
        if (wORequest != null && wORequest.headerForKey("x-webobjects-recording") != null || this.recordingPath() != null) {
            if (wOSession != null) {
                object = wOSession.sessionID();
                if (object != null) {
                    wOResponse.setHeader((String)object, "x-webobjects-session-id");
                }
                if (wOSession.storesIDsInURLs()) {
                    wOResponse.setHeader("yes", "x-webobjects-ids-url");
                }
                if (wOSession.storesIDsInCookies()) {
                    wOResponse.setHeader("yes", "x-webobjects-ids-cookie");
                }
            }
            wOResponse.setHeader(String.valueOf(wORequest.applicationNumber()), "x-webobjects-application-number");
        }
    }

    public void sleep() {
    }

    public void setSessionStore(WOSessionStore wOSessionStore) {
        if (wOSessionStore == null) {
            throw new IllegalArgumentException("<" + _WOAppClassName + ">: Session store reference must not be null");
        }
        this._sessionStore = wOSessionStore;
    }

    public WOSessionStore sessionStore() {
        return this._sessionStore;
    }

    public void saveSessionForContext(WOContext wOContext) {
        WOSession wOSession = wOContext._session();
        if (wOSession != null) {
            wOSession._sleepInContext(null);
            NSDelayedCallbackCenter.defaultCenter().eventEnded();
            this._sessionStore.checkInSessionForContext(wOContext);
        }
        wOContext._setSession(null);
    }

    public WOSession restoreSessionWithID(String string, WOContext wOContext) {
        WOSession wOSession = this._sessionStore.checkOutSessionWithID(string, wOContext.request());
        if (wOSession != null) {
            wOContext._setSession(wOSession);
            wOSession._awakeInContext(wOContext);
        }
        NSNotificationCenter.defaultCenter().postNotification("SessionDidRestoreNotification", (Object)wOSession);
        return wOSession;
    }

    protected Class _sessionClass() {
        if (_theSessionClass == null) {
            Class clazz = null;
            clazz = _NSUtilities.classWithName((String)((_WOAppPackageName == null || _WOAppPackageName.length() == 0 ? "" : _WOAppPackageName + ".") + "Session"));
            if (clazz == null) {
                clazz = WOSession.class;
            }
            if (!WOSession.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("<" + this.getClass().getName() + "> Class 'Session' exists (" + clazz + ") but is not a subclass of WOSession.");
            }
            _theSessionClass = clazz;
        }
        return _theSessionClass;
    }

    public WOSession createSessionForRequest(WORequest wORequest) {
        Class clazz = this._sessionClass();
        WOSession wOSession = (WOSession)_NSUtilities.instantiateObject((Class)clazz, null, null, (boolean)true, (boolean)this.isDebuggingEnabled());
        return wOSession;
    }

    public boolean shouldRestoreSessionOnCleanEntry(WORequest wORequest) {
        return false;
    }

    public void setContextClassName(String string) {
        if (string != null) {
            WOProperties.TheContextClassName = string;
        }
    }

    public String contextClassName() {
        if (WOProperties.TheContextClassName == null) {
            String string = NSProperties.getProperty((String)WOProperties._ContextClassNameKey);
            this.setContextClassName(string);
        }
        return WOProperties.TheContextClassName;
    }

    public WOContext createContextForRequest(WORequest wORequest) {
        WOContext wOContext = null;
        Class clazz = _NSUtilities.classWithName((String)this.contextClassName());
        if (clazz != null) {
            Object[] objectArray = new Object[]{wORequest};
            wOContext = (WOContext)_NSUtilities.instantiateObject((Class)clazz, (Class[])this._createContextForRequestParams, (Object[])objectArray, (boolean)true, (boolean)this.isDebuggingEnabled());
        }
        if (wOContext == null) {
            throw new InstantiationError("<" + _WOAppClassName + ">: Unable to create " + this.contextClassName());
        }
        return wOContext;
    }

    public WOResponse createResponseInContext(WOContext wOContext) {
        WOResponse wOResponse = new WOResponse();
        return wOResponse;
    }

    public WOResourceManager createResourceManager() {
        return new WOResourceManager();
    }

    public WORequest createRequest(String string, String string2, String string3, NSDictionary nSDictionary, NSData nSData, NSDictionary nSDictionary2) {
        WORequest wORequest = new WORequest(string, string2, string3, nSDictionary, nSData, nSDictionary2);
        return wORequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOSession _initializeSessionInContext(WOContext wOContext) {
        if (this.isRefusingNewSessions()) {
            NSLog.err.appendln((Object)"<WOApplication> !!! _initializeSessionInContext: called with refuseNewSessions set !!!");
            wOContext._set_refuseThisRequest(true);
        }
        Object object = this;
        synchronized (object) {
            ++this._activeSessionsCount;
        }
        object = this.createSessionForRequest(wOContext.request());
        if (object == null) {
            WOApplication wOApplication = this;
            synchronized (wOApplication) {
                --this._activeSessionsCount;
            }
            NSLog.debug.appendln((Object)("<" + _WOAppClassName + ": Unable to create new session."));
            return null;
        }
        wOContext._setSession((WOSession)object);
        ((WOSession)object)._awakeInContext(wOContext);
        NSNotificationCenter.defaultCenter().postNotification("SessionDidCreateNotification", object);
        return object;
    }

    public int activeSessionsCount() {
        return this._activeSessionsCount;
    }

    protected void _finishInitializingSession(WOSession wOSession) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _discountTerminatedSession() {
        int n;
        WOApplication wOApplication = this;
        synchronized (wOApplication) {
            n = --this._activeSessionsCount;
        }
        if (this.isRefusingNewSessions() && n < this._minimumActiveSessions + 1) {
            NSLog.err.appendln((Object)("<" + _WOAppClassName + ">: refusing new clients and below min active session threshold"));
            NSLog.err.appendln((Object)("<" + _WOAppClassName + ">: about to terminate..."));
            this.terminate();
        }
    }

    public void setPageCacheSize(int n) {
        this._pageCacheSize = n < 0 ? 0 : n;
    }

    public int pageCacheSize() {
        return this._pageCacheSize;
    }

    public void setPermanentPageCacheSize(int n) {
        this._permanentCacheSize = n < 0 ? 0 : n;
    }

    public int permanentPageCacheSize() {
        return this._permanentCacheSize;
    }

    public void setPageRefreshOnBacktrackEnabled(boolean bl) {
        this._pageRefreshOnBacktrackEnabled = bl;
    }

    public boolean isPageRefreshOnBacktrackEnabled() {
        return this._pageRefreshOnBacktrackEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent pageWithName(String string, WOContext wOContext) {
        WOComponentDefinition wOComponentDefinition;
        WOComponent wOComponent = null;
        if (wOContext == null) {
            throw new IllegalArgumentException("<" + _WOAppClassName + ">: Unable to create page '" + string + "'.  No context was passed.");
        }
        if (string == null) {
            string = "Main";
        }
        Object object = this;
        synchronized (object) {
            wOComponentDefinition = this._componentDefinition(string, wOContext._languages());
        }
        if (wOComponentDefinition != null) {
            object = null;
            if (_IsEventLoggingEnabled) {
                object = (WOEvent)EOEventCenter.newEventOfClass((Class)Event.class, (String)pageWithNameEvent);
                EOEventCenter.markStartOfEvent((EOEvent)object, (Object)string);
                ((WOEvent)((Object)object)).setComponentName(string);
                ((WOEvent)((Object)object)).setPageName(string);
            }
            wOComponent = wOComponentDefinition.componentInstanceInContext(wOContext);
            if (object != null) {
                if (wOComponent.isEventLoggingEnabled()) {
                    EOEventCenter.markEndOfEvent((EOEvent)object);
                } else {
                    EOEventCenter.cancelEvent((EOEvent)object);
                }
            }
            wOComponent._awakeInContext(wOContext);
            wOComponent._setIsPage(true);
        }
        if (wOComponent == null) {
            throw new WOPageNotFoundException("<" + _WOAppClassName + ">: Unable to create page '" + string + "'.");
        }
        return wOComponent;
    }

    public boolean _isPageRecreationEnabled() {
        return this._pageCacheSize == 0;
    }

    public WOElement dynamicElementWithName(String string, NSDictionary nSDictionary, WOElement wOElement, NSArray nSArray) {
        Class[] classArray;
        WOElement wOElement2 = null;
        if (string == null) {
            throw new IllegalArgumentException("<" + _WOAppClassName + ">: No name provided for dynamic element creation.");
        }
        Class clazz = _NSUtilities.classWithName((String)string);
        if (clazz != null && WODynamicElement.class.isAssignableFrom(clazz)) {
            classArray = WODynamicElement._ConstructorParameters;
            Object[] objectArray = new Object[]{string, nSDictionary, wOElement};
            wOElement2 = (WOElement)_NSUtilities.instantiateObject((Class)clazz, (Class[])classArray, (Object[])objectArray, (boolean)true, (boolean)this.isDebuggingEnabled());
        }
        if (wOElement2 == null && (classArray = this._componentDefinition(string, nSArray)) != null) {
            wOElement2 = classArray.componentReferenceWithAssociations(nSDictionary, wOElement);
        }
        return wOElement2;
    }

    private NSMutableArray _initComponentBearingFrameworksFromBundleArray(NSArray nSArray) {
        NSBundle nSBundle = null;
        Enumeration enumeration = nSArray.objectEnumerator();
        NSMutableArray nSMutableArray = new NSMutableArray(nSArray.count());
        while (enumeration.hasMoreElements()) {
            nSBundle = (NSBundle)enumeration.nextElement();
            if (!WOBundle.hasWOComponents(nSBundle)) continue;
            nSMutableArray.addObject((Object)nSBundle.name());
        }
        return nSMutableArray;
    }

    private NSMutableArray _componentBearingFrameworks() {
        NSArray nSArray = NSBundle.allFrameworks();
        int n = nSArray.count();
        if (TheLoadedFrameworkCount != n) {
            TheLoadedFrameworkCount = n;
            TheComponentBearingFrameworks = this._initComponentBearingFrameworksFromBundleArray(nSArray);
        }
        return TheComponentBearingFrameworks;
    }

    private WOComponentDefinition _loadComponentDefinition(String string, String string2, boolean bl) {
        Object object;
        WOComponentDefinition wOComponentDefinition = null;
        String string3 = null;
        String string4 = null;
        NSBundle nSBundle = null;
        Class clazz = null;
        int n = string.lastIndexOf(".");
        String string5 = n != -1 ? string.substring(n + 1) : string;
        StringBuffer stringBuffer = new StringBuffer(string5.length() + 3);
        stringBuffer.append(string5);
        stringBuffer.append('.');
        stringBuffer.append(WOComponent._Extension);
        String string6 = _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
        WOResourceManager wOResourceManager = this.resourceManager();
        URL uRL = wOResourceManager._pathURLForResourceNamed(string6, null, string2, bl);
        if (uRL == null && (object = this._componentBearingFrameworks()) != null) {
            Enumeration enumeration = object.objectEnumerator();
            while (enumeration.hasMoreElements() && (uRL = wOResourceManager._pathURLForResourceNamed(string6, string4 = (String)enumeration.nextElement(), string2, bl)) == null) {
            }
        }
        if (uRL == null && string.indexOf(".") > 0) {
            object = string6;
            try {
                clazz = _NSUtilities._classWithFullySpecifiedName((String)string);
            }
            catch (Exception exception) {
                clazz = null;
            }
            if (clazz != null) {
                nSBundle = NSBundle.bundleForClass((Class)clazz);
                if (nSBundle == null) {
                    string4 = null;
                    uRL = null;
                } else {
                    string4 = nSBundle.name();
                    uRL = nSBundle.isFramework() ? wOResourceManager._pathURLForResourceNamed((String)object, string4, string2, bl) : wOResourceManager._pathURLForResourceNamed((String)object, null, string2, bl);
                }
            }
        }
        if (uRL != null || nSBundle == null && clazz != null) {
            object = null;
            if (string2 != null) {
                object = new NSMutableArray((Object)string2);
            }
            string3 = nSBundle == null && clazz != null ? this.applicationBaseURL() + "/" + clazz.getName().replace('.', '/') : wOResourceManager.urlForResourceNamed(string6, string4, (NSArray)object, null);
            wOComponentDefinition = new WOComponentDefinition(string, uRL, string3, string4, string2);
        }
        return wOComponentDefinition;
    }

    private void _preloadAllLocalizedComponentDefinitions(String string) {
        String string2;
        NSArray nSArray = this._expectedLanguages();
        Object object = TheNotFoundMarker;
        Object object2 = null;
        Object object3 = null;
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('.');
        String string3 = null;
        int n = stringBuffer.length();
        boolean bl = false;
        Enumeration enumeration = nSArray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            stringBuffer.setLength(n);
            stringBuffer.append(string2);
            string3 = _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
            object = this._loadComponentDefinition(string, string2, true);
            if (object == null) {
                object = TheNotFoundMarker;
            } else {
                bl = true;
            }
            this._componentDefinitionCache.setObjectForKey(object, (Object)string3);
        }
        object2 = this._componentDefinitionCache.objectForKey((Object)string);
        if (object2 == null) {
            object2 = this._loadComponentDefinition(string, null, true);
            if (object2 == null) {
                object2 = TheNotFoundMarker;
            }
            this._componentDefinitionCache.setObjectForKey(object2, (Object)string);
        }
        if (!bl) {
            enumeration = nSArray.objectEnumerator();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                stringBuffer.setLength(n);
                stringBuffer.append(string2);
                string3 = _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
                if (object2 != TheNotFoundMarker) {
                    this._componentDefinitionCache.setObjectForKey(object2, (Object)string3);
                    continue;
                }
                if (object3 == null) {
                    object3 = this._componentDefinitionFromClassNamed(string);
                }
                if (object3 == null) {
                    object3 = TheNotFoundMarker;
                }
                this._componentDefinitionCache.setObjectForKey(object3, (Object)string);
            }
        }
    }

    private Object _componentDefinition(String string, String string2, String string3, boolean bl) {
        Object object = this._componentDefinitionCache.objectForKey((Object)string);
        if (object == null) {
            if (this.isCachingEnabled() && !this._inRapidTurnaroundMode && string3 != null) {
                this._preloadAllLocalizedComponentDefinitions(string2);
                object = this._componentDefinitionCache.objectForKey((Object)string);
                if (object == null) {
                    this._componentDefinitionCache.setObjectForKey((Object)TheNotFoundMarker, (Object)string);
                }
            } else {
                object = this._loadComponentDefinition(string2, string3, bl);
                if (object == null) {
                    if (bl) {
                        this._componentDefinitionCache.setObjectForKey((Object)TheNotFoundMarker, (Object)string);
                    }
                } else {
                    this._componentDefinitionCache.setObjectForKey(object, (Object)string);
                }
            }
        }
        return object;
    }

    public boolean _rapidTurnaroundActiveForAnyProject() {
        return this._inRapidTurnaroundMode;
    }

    public void _removeComponentDefinitionCacheContents() {
        this._componentDefinitionCache.removeAllObjects();
    }

    public void _addToExpectedLanguages(NSArray nSArray) {
        this._expectedLanguages.addObjectsFromArray(nSArray);
    }

    public NSArray _expectedLanguages() {
        return this._expectedLanguages.allObjects();
    }

    public WOComponentDefinition _componentDefinitionFromClassNamed(String string) {
        Object object = null;
        object = this._componentDefinitionCache.objectForKey((Object)string);
        if (object == null || object == TheNotFoundMarker && NSPathUtilities.lastPathComponent((String)string).equals(string)) {
            Class clazz = null;
            clazz = object == TheNotFoundMarker ? WOBundle.lookForClassInAllBundles(string) : _NSUtilities.classWithName((String)string);
            if (clazz != null && clazz != WOComponent.class && WOComponent.class.isAssignableFrom(clazz)) {
                NSBundle nSBundle = NSBundle.bundleForClass((Class)clazz);
                URL uRL = null;
                String string2 = null;
                if (nSBundle != null) {
                    try {
                        uRL = new URL(nSBundle._bundleURLPrefix());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string2 = nSBundle.name();
                }
                String string3 = "/ERROR/RelativeUrlsNotSupportedWhenComponentHasNoWrapper";
                object = new WOComponentDefinition(string, uRL, string3, string2, null);
            }
            if (object == null) {
                object = TheNotFoundMarker;
            }
            this._componentDefinitionCache.setObjectForKey(object, (Object)string);
            if (clazz != null) {
                this._componentDefinitionCache.setObjectForKey(object, (Object)clazz.getName());
            }
        }
        if (object == TheNotFoundMarker) {
            object = null;
        }
        return (WOComponentDefinition)object;
    }

    public WOComponentDefinition _componentDefinition(String string, NSArray nSArray) {
        String string2;
        String string3;
        int n;
        Object object = TheNotFoundMarker;
        int n2 = nSArray == null ? 0 : nSArray.count();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('.');
        int n3 = stringBuffer.length();
        for (n = 0; n < n2; ++n) {
            string3 = (String)nSArray.objectAtIndex(n);
            stringBuffer.setLength(n3);
            stringBuffer.append(string3);
            string2 = _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
            object = this._componentDefinition(string2, string, string3, false);
            if (object != TheNotFoundMarker && object != null) break;
        }
        if (object == TheNotFoundMarker || object == null) {
            object = this._componentDefinition(string, string, null, false);
        }
        if ((object == TheNotFoundMarker || object == null) && WOProjectBundle.refreshProjectBundlesOnCacheMiss()) {
            for (n = 0; n < n2; ++n) {
                string3 = (String)nSArray.objectAtIndex(n);
                stringBuffer.setLength(n3);
                stringBuffer.append(string3);
                string2 = _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
                object = this._componentDefinition(string2, string, string3, true);
                if (object != TheNotFoundMarker && object != null) break;
            }
            if (object == TheNotFoundMarker || object == null) {
                object = this._componentDefinition(string, string, null, true);
            }
        }
        if (object == TheNotFoundMarker || object == null) {
            object = this._componentDefinitionFromClassNamed(string);
        }
        return (WOComponentDefinition)object;
    }

    private void _disableDynamicLoading() {
        this._dynamicLoadingEnabled = false;
    }

    private boolean _isDynamicLoadingEnabled() {
        return this._dynamicLoadingEnabled;
    }

    public void setPrintsHTMLParserDiagnostics(boolean bl) {
    }

    public boolean printsHTMLParserDiagnostics() {
        return true;
    }

    public void setStatisticsStore(WOStatisticsStore wOStatisticsStore) {
        this._statisticsStore = wOStatisticsStore;
    }

    public WOStatisticsStore statisticsStore() {
        return this._statisticsStore;
    }

    public NSDictionary statistics() {
        WOStatisticsStore wOStatisticsStore = this._statisticsStore;
        return wOStatisticsStore != null ? wOStatisticsStore.statistics() : null;
    }

    public synchronized void refuseNewSessions(boolean bl) {
        if (bl && this.isDirectConnectEnabled()) {
            throw new IllegalStateException("Cannot refuse new sessions when in development mode (direct connect enabled)");
        }
        this._refusingNewClients = bl;
        if (this._refusingNewClients && this.activeSessionsCount() <= this.minimumActiveSessionsCount()) {
            NSLog.debug.appendln((Object)("<" + _WOAppClassName + ">: refusing new clients and below min active session threshold"));
            NSLog.debug.appendln((Object)("<" + _WOAppClassName + ">: about to terminate..."));
            this.terminate();
        }
    }

    public boolean isRefusingNewSessions() {
        return this._refusingNewClients;
    }

    public void setMinimumActiveSessionsCount(int n) {
        this._minimumActiveSessions = n;
    }

    public int minimumActiveSessionsCount() {
        return this._minimumActiveSessions;
    }

    private WOResponse _invokeDefaultException(String string, Exception exception) {
        WOResponse wOResponse;
        block6: {
            Method method;
            Object[] objectArray;
            block5: {
                wOResponse = null;
                Class[] classArray = new Class[]{Exception.class};
                objectArray = new Object[]{exception};
                objectArray[0] = exception;
                method = null;
                try {
                    method = WODefaultExceptions.class.getMethod("default" + string, classArray);
                }
                catch (Exception exception2) {
                    NSLog.err.appendln((Object)("<" + _WOAppClassName + "> Internal Error while handling Exception :" + exception2.toString()));
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) break block5;
                    NSLog.debug.appendln((Throwable)exception2);
                }
            }
            try {
                if (method != null) {
                    wOResponse = (WOResponse)method.invoke(null, objectArray);
                }
            }
            catch (Exception exception3) {
                NSLog.err.appendln((Object)("<" + _WOAppClassName + "> Internal Error while handling Exception :" + exception3.toString()));
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) break block6;
                NSLog.debug.appendln((Throwable)exception3);
                NSLog.debug.appendln((Object)"Original Exception:\n");
                NSLog.debug.appendln((Throwable)exception);
            }
        }
        return wOResponse;
    }

    private WOResponse _handleError(String string, Exception exception, WOContext wOContext) {
        WOResponse wOResponse = null;
        try {
            WOComponent wOComponent = this.pageWithName(string, wOContext);
            if (exception != null) {
                wOComponent.takeValueForKey(exception, "exception");
            }
            wOResponse = wOComponent.generateResponse();
        }
        catch (WOPageNotFoundException wOPageNotFoundException) {
            wOResponse = this._invokeDefaultException(string, exception);
        }
        catch (Throwable throwable) {
            Object object;
            String string2 = null;
            String string3 = null;
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                object = new ByteArrayOutputStream(500);
                PrintStream printStream = new PrintStream((OutputStream)object);
                throwable.printStackTrace(printStream);
                printStream.flush();
                string2 = ((ByteArrayOutputStream)object).toString();
                ((ByteArrayOutputStream)object).reset();
                exception.printStackTrace(printStream);
                printStream.flush();
                string3 = ((ByteArrayOutputStream)object).toString();
            } else {
                string2 = throwable.toString();
                string3 = exception.toString();
            }
            object = new IllegalStateException("An Exception occurred while generating the Exception page '" + string + "'. This is most likely due to an error in '" + string + "' itself or WebObjects encountered an uncaught exception while creating a Session object.\n\n\nBelow are the logs of the original Exception which occured in " + this.getClass().getName() + ", then the later Exception in " + string + ".\n\nOriginal Exception:\n" + string3 + "\n\n" + string + " Exception:\n" + string2);
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                NSLog.debug.appendln((Object)("<WOApplication> Exception occurred in " + string + ": " + throwable.toString()));
                NSLog.debug.appendln((Throwable)exception);
            }
            wOResponse = this._invokeDefaultException(string, (Exception)object);
        }
        return wOResponse;
    }

    public WOResponse handleSessionCreationErrorInContext(WOContext wOContext) {
        return this._handleError("WOSessionCreationError", null, wOContext);
    }

    public WOResponse handleSessionRestorationErrorInContext(WOContext wOContext) {
        return this._handleError("WOSessionRestorationError", null, wOContext);
    }

    public WOResponse handlePageRestorationErrorInContext(WOContext wOContext) {
        return this._handleError("WOPageRestorationError", null, wOContext);
    }

    public WOResponse handleActionRequestError(WORequest wORequest, Exception exception, String string, WORequestHandler wORequestHandler, String string2, String string3, Class clazz, WOAction wOAction) {
        return null;
    }

    public WOResponse handleException(Exception exception, WOContext wOContext) {
        Exception exception2 = exception;
        Throwable throwable = NSForwardException._originalThrowable((Throwable)exception2);
        if (throwable instanceof Exception) {
            exception2 = (Exception)throwable;
        }
        return this._handleError("WOExceptionPage", exception2, wOContext);
    }

    public NSMutableDictionary handleMalformedCookieString(RuntimeException runtimeException, String string, NSMutableDictionary nSMutableDictionary) {
        boolean bl = NSProperties.booleanForKey((String)WOProperties._TolerateMalformedCookiesKey);
        if (!bl) {
            throw runtimeException;
        }
        NSLog.err.appendln((Object)("CookieParser: Error " + runtimeException));
        NSLog.err.appendln((Object)("CookieParser: while parsing cookie header: " + string));
        NSLog.err.appendln((Object)"CookieParser: Returning the cookies parsed before error.");
        return nSMutableDictionary;
    }

    public void registerRequestHandler(WORequestHandler wORequestHandler, String string) {
        this._requestHandlers.setObjectForKey((Object)wORequestHandler, (Object)string);
    }

    public WORequestHandler removeRequestHandlerForKey(String string) {
        return (WORequestHandler)this._requestHandlers.removeObjectForKey((Object)string);
    }

    public WORequestHandler defaultRequestHandler() {
        return this._defaultRequestHandler;
    }

    public void setDefaultRequestHandler(WORequestHandler wORequestHandler) {
        this._defaultRequestHandler = wORequestHandler;
    }

    public WORequestHandler requestHandlerForKey(String string) {
        WORequestHandler wORequestHandler = null;
        if (string != null) {
            wORequestHandler = (WORequestHandler)this._requestHandlers.objectForKey((Object)string);
        }
        return wORequestHandler;
    }

    public NSArray registeredRequestHandlerKeys() {
        return this._requestHandlers.allKeys();
    }

    private WORequestHandler _staticResourceRequestHandler() {
        return this.requestHandlerForKey("_wr_");
    }

    public WORequestHandler handlerForRequest(WORequest wORequest) {
        String string;
        String string2;
        WORequestHandler wORequestHandler;
        String string3 = wORequest.requestHandlerKey();
        WORequestHandler wORequestHandler2 = this.requestHandlerForKey(string3);
        if (wORequestHandler2 == null && (wORequestHandler = this._staticResourceRequestHandler()) != null && (string2 = NSPathUtilities.pathExtension((String)(string = wORequest.uri()))) != null && string2.length() > 1) {
            String string4 = string2.toLowerCase();
            WOResourceManager wOResourceManager = this.resourceManager();
            NSDictionary nSDictionary = wOResourceManager._contentTypesDictionary();
            if (nSDictionary.objectForKey((Object)string4) != null) {
                wORequestHandler2 = wORequestHandler;
            }
        }
        if (wORequestHandler2 == null) {
            wORequestHandler2 = this.defaultRequestHandler();
        }
        return wORequestHandler2;
    }

    private void _registerRequestHandlers() {
        WORequestHandler wORequestHandler;
        WOComponentRequestHandler wOComponentRequestHandler = new WOComponentRequestHandler();
        WOResourceRequestHandler wOResourceRequestHandler = new WOResourceRequestHandler();
        WODirectActionRequestHandler wODirectActionRequestHandler = new WODirectActionRequestHandler();
        WODirectActionRequestHandler wODirectActionRequestHandler2 = new WODirectActionRequestHandler("WOAdminAction", "ping", false);
        WODirectActionRequestHandler wODirectActionRequestHandler3 = new WODirectActionRequestHandler();
        wODirectActionRequestHandler3.setAllowsContentInputStream(true);
        String string = this.componentRequestHandlerKey();
        String string2 = this.resourceRequestHandlerKey();
        String string3 = this.directActionRequestHandlerKey();
        String string4 = _adminRequestHandlerKey;
        String string5 = this.streamActionRequestHandlerKey();
        WORequestHandler wORequestHandler2 = null;
        this.registerRequestHandler(wOComponentRequestHandler, string);
        this.registerRequestHandler(wOResourceRequestHandler, string2);
        this.registerRequestHandler(wODirectActionRequestHandler, string3);
        this.registerRequestHandler(wODirectActionRequestHandler2, string4);
        this.registerRequestHandler(wODirectActionRequestHandler3, string5);
        if (this.isDirectConnectEnabled()) {
            wORequestHandler = new WOStaticResourceRequestHandler();
            this.registerRequestHandler(wORequestHandler, "_wr_");
        }
        try {
            Class.forName("org.apache.axis.Message");
            wORequestHandler = new WOWebServiceRequestHandler();
            String string6 = this.webServiceRequestHandlerKey();
            this.registerRequestHandler(wORequestHandler, string6);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string7 = this.defaultRequestHandlerClassName();
        try {
            Class clazz = _NSUtilities.classWithName((String)string7);
            if (clazz != null) {
                wORequestHandler2 = (WORequestHandler)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            wORequestHandler2 = null;
            this.debugString("<WOApplication> Exception during creation of defaultRequestHandler : " + exception.toString());
        }
        if (wORequestHandler2 != null) {
            this.setDefaultRequestHandler(wORequestHandler2);
        } else {
            this.setDefaultRequestHandler(wOComponentRequestHandler);
        }
    }

    public String defaultRequestHandlerClassName() {
        return "com.webobjects.appserver._private.WOComponentRequestHandler";
    }

    public void debugString(String string) {
        WOApplication._debugString(string);
    }

    public static void _debugString(String string) {
        if (WOApplication._isDebuggingEnabled()) {
            NSLog.debug.appendln((Object)string);
        }
    }

    public void logString(String string) {
        NSLog.err.appendln((Object)string);
    }

    public void logTakeValueForDeclarationNamed(String string, String string2, String string3, String string4, Object object) {
        if (object instanceof String) {
            StringBuffer stringBuffer = new StringBuffer(((String)object).length() + 2);
            stringBuffer.append('\"');
            stringBuffer.append(object);
            stringBuffer.append('\"');
            object = stringBuffer;
        }
        NSLog.debug.appendln((Object)("[" + string + ":" + string2 + "] " + string3 + " <== (" + string4 + ": " + (object == null ? "null" : object.toString()) + ")"));
    }

    public void logSetValueForDeclarationNamed(String string, String string2, String string3, String string4, Object object) {
        if (object instanceof String) {
            StringBuffer stringBuffer = new StringBuffer(((String)object).length() + 2);
            stringBuffer.append('\"');
            stringBuffer.append(object);
            stringBuffer.append('\"');
            object = stringBuffer;
        }
        NSLog.debug.appendln((Object)("[" + string + ":" + string2 + "] (" + string3 + ": " + (object == null ? "null" : object.toString()) + ") ==> " + string4));
    }

    public boolean monitoringEnabled() {
        return this.isMonitorEnabled();
    }

    public void terminateAfterTimeInterval(double d) {
        this.setTimeOut(d);
    }

    protected void _terminateFromMonitor() {
        this.terminate();
    }

    public String _newLocationForRequest(WORequest wORequest) {
        String string = null;
        if (string == null && wORequest != null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(wORequest.adaptorPrefix());
            stringBuffer.append('/');
            stringBuffer.append(wORequest.applicationName());
            string = new String(stringBuffer);
        }
        return string;
    }

    public String directConnectURL() {
        String string = null;
        String string2 = this.cgiAdaptorURL();
        if (string2 != null) {
            int n;
            int n2 = n = this.adaptors().count() != 0 ? ((WOAdaptor)this.adaptors().objectAtIndex(0)).port() : 0;
            if (n != 0) {
                int n3 = string2.length();
                int n4 = string2.indexOf("//");
                if (n4 != -1 && n3 - n4 > 2) {
                    StringBuffer stringBuffer = new StringBuffer(64);
                    int n5 = string2.indexOf(47, n4 + 2);
                    int n6 = string2.indexOf(58, n4 + 2);
                    if (n6 != -1) {
                        stringBuffer.append(string2.substring(0, n6));
                        stringBuffer.append(':');
                        stringBuffer.append(n);
                        if (n5 != -1) {
                            stringBuffer.append(string2.substring(n5));
                        }
                        stringBuffer.append('/');
                        stringBuffer.append(this.name());
                        stringBuffer.append(".woa");
                        string = new String(stringBuffer);
                    } else {
                        if (n5 != -1 && n3 - n5 > 1) {
                            stringBuffer.append(string2.substring(0, n5));
                            stringBuffer.append(':');
                            stringBuffer.append(n);
                            stringBuffer.append(string2.substring(n5));
                        } else {
                            stringBuffer.append(string2);
                            stringBuffer.append(':');
                            stringBuffer.append(n);
                        }
                        stringBuffer.append('/');
                        stringBuffer.append(this.name());
                        stringBuffer.append(".woa");
                        string = new String(stringBuffer);
                    }
                }
            }
        } else {
            this.debugString("No user default provided for key \"" + WOProperties._CGIAdaptorURLKey + "\"");
        }
        return string;
    }

    public String webserverConnectURL() {
        String string = null;
        String string2 = this.cgiAdaptorURL();
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(string2);
            stringBuffer.append('/');
            stringBuffer.append(this.name());
            stringBuffer.append(".woa/-");
            stringBuffer.append(this.adaptors().count() != 0 ? ((WOAdaptor)this.adaptors().objectAtIndex(0)).port() : 1);
            string = new String(stringBuffer);
        } else {
            this.debugString("No user default provided for key \"" + WOProperties._CGIAdaptorURLKey + "\"");
        }
        return string;
    }

    public String servletConnectURL() {
        String string = null;
        String string2 = this.cgiAdaptorURL();
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(string2);
            stringBuffer.append('/');
            stringBuffer.append(this.name());
            stringBuffer.append(".woa");
            string = new String(stringBuffer);
        } else {
            this.debugString("No user default provided for key \"" + WOProperties._CGIAdaptorURLKey + "\"");
        }
        return string;
    }

    private boolean _openClientApplication(String string, String string2) {
        if (_NSUtilities.classWithName((String)"com.webobjects.eodistribution.WOJavaClientComponent") == null) {
            return false;
        }
        NSBundle nSBundle = NSBundle.mainBundle();
        if (nSBundle != null) {
            String string3 = nSBundle.bundlePath();
            String string4 = nSBundle.name();
            if (string3 != null) {
                string3 = NSPathUtilities.stringByAppendingPathComponent((String)string3, (String)"Contents");
                String string5 = string2.toLowerCase();
                if (string5.startsWith("mac")) {
                    string3 = NSPathUtilities.stringByAppendingPathComponent((String)string3, (String)"MacOS");
                    string3 = NSPathUtilities.stringByAppendingPathComponent((String)string3, (String)(string4 + "_Client"));
                } else if (string5.startsWith("win")) {
                    string3 = NSPathUtilities.stringByAppendingPathComponent((String)string3, (String)"Windows");
                    string3 = NSPathUtilities.stringByAppendingPathComponent((String)string3, (String)(string4 + "_Client.cmd"));
                } else {
                    return false;
                }
                File file = new File(string3);
                if (file.exists() && file.isFile()) {
                    try {
                        String string6 = string3 + " " + string;
                        NSLog.debug.appendln((Object)("Opening client application with script:\n" + string6));
                        Runtime.getRuntime().exec(string6 + " 1>>/dev/console 2>&1");
                    }
                    catch (IOException iOException) {
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)iOException);
                    }
                    return true;
                }
            }
        }
        if (this.autoOpenInBrowser()) {
            this.debugString("Unable to locate client launch script in your application, using the Auto Open In Browser feature instead of the Auto Open Client Application feature.");
        } else {
            this.debugString("Unable to locate client launch script in your application, auto opening client application launch will not work. You may use the Auto Open In Browser feature instead of the Auto Open Client Application feature when starting the application.");
        }
        return false;
    }

    private void _openURL(String string, String string2) {
        String string3 = null;
        File file = null;
        String string4 = "/Library/WebObjects/Executables/WOOpenURL";
        String string5 = NSProperties.getProperty((String)"WORootDirectory");
        if (string2.toLowerCase().startsWith("win")) {
            if (string5 == null) {
                this.debugString("Unable to locate WOOpenURL on your computer, AutoOpen launch will not work. In order to use the Auto Open In Browser feature, please specify the property WOROOT (example : -DWORootDirectory=C:/Apple) when starting the application.");
                return;
            }
            string3 = string5 + string4 + ".exe";
        } else {
            string3 = (string5 != null ? string5 : "/System") + string4;
        }
        file = new File(string3);
        if (file.exists() && file.isFile()) {
            try {
                Process process = Runtime.getRuntime().exec(string3 + " " + string);
            }
            catch (IOException iOException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)iOException);
            }
        } else {
            this.debugString("Unable to locate WOOpenURL on your computer, AutoOpen launch will not work");
            return;
        }
    }

    private static void _openWebServicesAssistantUrl(String string) throws Exception {
        File file = File.createTempFile("openWebServicesAssistantURL", null);
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
        Runtime.getRuntime().exec("open -a WebServicesAssistant.app " + file).waitFor();
    }

    /*
     * Unable to fully structure code
     */
    protected void _openInitialURL() {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var1_1 = this.wasMainInvoked() == false ? this.servletConnectURL() : (this.isDirectConnectEnabled() != false ? this.directConnectURL() : this.webserverConnectURL());
        if (var1_1 != null) {
            var4_4 = System.getProperty("os.name");
            var5_5 = this.autoOpenClientApplication() ? !this._openClientApplication(var1_1, var4_4) : true;
            var6_6 = false;
            if (NSProperties.getProperty((String)"WSAssistantEnabled") != null) {
                var6_6 = NSProperties.booleanForKey((String)"WSAssistantEnabled") == false;
            }
            v0 = var7_7 = _NSUtilities.classWithName((String)"com.webobjects.webservices.generation._WSDirectAction") != null;
            if (var5_5 && !var6_6 && var7_7) {
                try {
                    WOApplication._openWebServicesAssistantUrl(var1_1);
                    var2_2 = "The URL for webserver connect is:\n" + this.webserverConnectURL();
                    if (!this.isDirectConnectEnabled()) ** GOTO lbl36
                    var2_2 = var2_2 + "\nThe URL for direct connect is:\n" + var1_1;
                }
                catch (Exception var8_8) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)var8_8);
                }
            } else if (var5_5 && this.autoOpenInBrowser()) {
                if (this._isSupportedDevelopmentPlatform()) {
                    var2_2 = "Opening application's URL in browser:\n" + var1_1;
                    this._openURL(var1_1, var4_4);
                } else {
                    var3_3 = "Your application is not running on a supported development platform. AutoLaunch will not work.\nYour application's URL is:\n" + var1_1;
                }
            } else if (this.wasMainInvoked()) {
                var2_2 = "The URL for webserver connect is:\n" + this.webserverConnectURL();
                if (this.isDirectConnectEnabled()) {
                    var2_2 = var2_2 + "\nThe URL for direct connect is:\n" + var1_1;
                }
            } else {
                var2_2 = "The URL for webserver connect through Servlet Container is:\n" + var1_1;
            }
        } else {
            var3_3 = "Unable to compute your application's URL.";
        }
lbl36:
        // 7 sources

        NSLog.debug.appendln(var2_2);
        NSLog.err.appendln((Object)var3_3);
    }

    public final boolean adaptorsDispatchRequestsConcurrently() {
        return this._isMultiThreaded;
    }

    public final boolean isConcurrentRequestHandlingEnabled() {
        return this._isMultiThreaded && this._allowsConcurrentRequestHandling;
    }

    public Object requestHandlingLock() {
        if (this._isMultiThreaded && !this._allowsConcurrentRequestHandling) {
            return this._globalLock;
        }
        return null;
    }

    private void _readLicenseParameters() {
        Object object;
        NSBundle nSBundle = NSBundle.bundleForName((String)"JavaWebObjects");
        String string = nSBundle.resourcePathForLocalizedResourceNamed("License.key", "");
        String string2 = null;
        if (string != null) {
            object = nSBundle.inputStreamForResourcePath(string);
            string2 = _NSStringUtilities.stringFromInputStream((InputStream)object);
        }
        if (string2 == null) {
            NSLog.err.appendln((Object)"Unable to locate a License key !");
            throw new IllegalStateException("Unable to locate a License key !");
        }
        if (string2.length() > 37) {
            string2 = string2.substring(0, 37);
        }
        object = null;
        try {
            object = new License(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NSLog.err.appendln((Object)("<WOApplication> The License key " + string2 + " is invalid."));
            throw new IllegalStateException("<WOApplication> The License key " + string2 + " is invalid.");
        }
        if (((License)object).majorVersion() != 5 || ((License)object).minorVersion() != 3) {
            NSLog.err.appendln((Object)("<WOApplication> The License key " + string2 + " is not for this product version."));
            throw new IllegalStateException("<WOApplication> The License key " + string2 + " is not for this product version.");
        }
        TheMultipleInstancesLicenseFlag = ((License)object).loadBalancingEnabled();
        TheRequestLimitLicenseValue = ((License)object).maxReqPerMin() == 0 ? 0 : ((License)object).maxReqPerMin();
    }

    public static final boolean licensingAllowsMultipleInstances() {
        return TheMultipleInstancesLicenseFlag;
    }

    public static final boolean licensingAllowsMultipleThreads() {
        return TheMultipleThreadsLicenseFlag;
    }

    public static final long licensedRequestWindow() {
        return TheRequestWindowLicenseValue;
    }

    public static final int licensedRequestLimit() {
        return TheRequestLimitLicenseValue;
    }

    public static final void _setChecksForSpecialHeaders(boolean bl) {
        _checksForSpecialHeaders = bl;
    }

    public static final boolean _checksForSpecialHeaders() {
        return _checksForSpecialHeaders;
    }

    public void setLoadFrameworks(NSArray nSArray) {
        WOProperties.TheLoadFrameworks = nSArray;
    }

    public NSArray loadFrameworks() {
        if (WOProperties.TheLoadFrameworks == null) {
            String string = NSProperties.getProperty((String)WOProperties._LoadFrameworksKey);
            NSArray nSArray = null;
            try {
                nSArray = (NSArray)NSPropertyListSerialization._Utilities.propertyListFromString((String)string);
            }
            catch (Exception exception) {
                String string2 = "<WOApplication> Exception occurred while reading Properties for '" + WOProperties._LoadFrameworksKey + "'. ";
                string2 = exception instanceof NullPointerException ? string2 + "The field is missing from the Properties files. " : string2 + "You have a format error in your Properties or WODefaultProperties file. ";
                throw new NSForwardException((Throwable)exception, string2);
            }
            this.setLoadFrameworks(nSArray);
        }
        return WOProperties.TheLoadFrameworks;
    }

    public void setProjectSearchPath(NSArray nSArray) {
        WOProperties.setProjectSearchPath(nSArray);
    }

    public NSArray projectSearchPath() {
        return WOProperties.projectSearchPath();
    }

    public void setAdditionalAdaptors(NSArray nSArray) {
        WOProperties.TheAdditionalAdaptors = nSArray;
    }

    public NSArray additionalAdaptors() {
        if (WOProperties.TheAdditionalAdaptors == null) {
            String string = NSProperties.getProperty((String)WOProperties._AdditionalAdaptorsKey);
            NSArray nSArray = null;
            try {
                nSArray = (NSArray)NSPropertyListSerialization._Utilities.propertyListFromString((String)string);
            }
            catch (Exception exception) {
                String string2 = "<WOApplication> Exception occurred while reading WOProperties for '" + WOProperties._AdditionalAdaptorsKey + "'. ";
                string2 = exception instanceof NullPointerException ? string2 + "The field is missing from the WOProperties files. " : string2 + "You have a format error in your WOProperties or WODefaultProperties file. ";
                throw new NSForwardException((Throwable)exception, string2);
            }
            this.setAdditionalAdaptors(nSArray);
        }
        return WOProperties.TheAdditionalAdaptors;
    }

    private static void _setDebuggingEnabled(boolean bl) {
        if (bl) {
            if (NSLog.allowedDebugLevel() < 2) {
                NSLog.setAllowedDebugLevel((int)2);
            }
            NSLog.allowDebugLoggingForGroups((long)4L);
        } else {
            NSLog.refuseDebugLoggingForGroups((long)4L);
        }
    }

    public static boolean _isDebuggingEnabled() {
        return NSLog.debugLoggingAllowedForLevel((int)1);
    }

    public boolean isDebuggingEnabled() {
        return WOApplication._isDebuggingEnabled();
    }

    public void setDirectConnectEnabled(boolean bl) {
        WOProperties.TheDirectConnectEnabledFlag = bl;
        WOProperties.isTheDirectConnectEnabledFlagSet = true;
    }

    public boolean isDirectConnectEnabled() {
        if (!WOProperties.isTheDirectConnectEnabledFlagSet) {
            boolean bl = Boolean.valueOf(NSProperties.getProperty((String)WOProperties._DirectConnectEnabledKey));
            this.setDirectConnectEnabled(bl);
        }
        return WOProperties.TheDirectConnectEnabledFlag;
    }

    private static void _setCachingEnabled(boolean bl) {
        WOProperties.TheCachingFlag = bl;
        WOProperties.isTheCachingFlagSet = true;
    }

    private static boolean _isCachingEnabled() {
        if (!WOProperties.isTheCachingFlagSet) {
            boolean bl = Boolean.valueOf(NSProperties.getProperty((String)WOProperties._CachingEnabledKey));
            WOApplication._setCachingEnabled(bl);
        }
        return WOProperties.TheCachingFlag;
    }

    public void setCachingEnabled(boolean bl) {
        WOApplication._setCachingEnabled(bl);
    }

    public boolean isCachingEnabled() {
        return WOApplication._isCachingEnabled();
    }

    public void setMonitorEnabled(boolean bl) {
        WOProperties.TheMonitorEnabledFlag = bl;
        WOProperties.isTheMonitorEnabledFlagSet = true;
    }

    public boolean isMonitorEnabled() {
        if (!WOProperties.isTheMonitorEnabledFlagSet) {
            boolean bl = Boolean.valueOf(NSProperties.getProperty((String)WOProperties._MonitorEnabledKey));
            this.setMonitorEnabled(bl);
        }
        return WOProperties.TheMonitorEnabledFlag;
    }

    public void setIncludeCommentsInResponses(boolean bl) {
        WOProperties.TheIncludeCommentsInResponseFlag = bl;
        WOProperties.isTheIncludeCommentsInResponseFlagSet = true;
    }

    public boolean includeCommentsInResponses() {
        if (!WOProperties.isTheIncludeCommentsInResponseFlagSet) {
            boolean bl = Boolean.valueOf(NSProperties.getProperty((String)WOProperties._IncludeCommentsInResponseKey));
            this.setIncludeCommentsInResponses(bl);
        }
        return WOProperties.TheIncludeCommentsInResponseFlag;
    }

    public void setPort(Number number) {
        WOProperties.ThePrimaryPort = number;
    }

    public Number port() {
        if (WOProperties.ThePrimaryPort == null) {
            Integer n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._PortKey));
            this.setPort(n);
        }
        return WOProperties.ThePrimaryPort;
    }

    public void _setHost(String string) {
        WOProperties.TheHost = string;
        try {
            this._hostAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String host() {
        if (WOProperties.TheHost == null) {
            WOProperties.TheHost = NSProperties.getProperty((String)WOProperties._HostKey);
        }
        return WOProperties.TheHost;
    }

    public void _setHostAddress(InetAddress inetAddress) {
        this._hostAddress = inetAddress;
        WOProperties.TheHost = this._hostAddress.getHostName();
    }

    public InetAddress hostAddress() {
        String string;
        if (this._hostAddress == null && (string = this.host()) != null) {
            try {
                this._hostAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this._hostAddress;
    }

    public void setWorkerThreadCount(Number number) {
        WOProperties.TheWorkerThreadCount = number.intValue();
    }

    public Number workerThreadCount() {
        if (WOProperties.TheWorkerThreadCount == -1) {
            Integer n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._WorkerThreadCountKey));
            this.setWorkerThreadCount(n);
        }
        return _NSUtilities.IntegerForInt((int)WOProperties.TheWorkerThreadCount);
    }

    public void setWorkerThreadCountMin(Number number) {
        WOProperties.TheWorkerThreadCountMin = number.intValue();
    }

    public Number workerThreadCountMin() {
        if (WOProperties.TheWorkerThreadCountMin == -1) {
            Integer n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._WorkerThreadCountMinKey));
            this.setWorkerThreadCountMin(n);
        }
        return _NSUtilities.IntegerForInt((int)WOProperties.TheWorkerThreadCountMin);
    }

    public void setWorkerThreadCountMax(Number number) {
        WOProperties.TheWorkerThreadCountMax = number.intValue();
    }

    public Number workerThreadCountMax() {
        if (WOProperties.TheWorkerThreadCountMax == -1) {
            Integer n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._WorkerThreadCountMaxKey));
            this.setWorkerThreadCountMax(n);
        }
        return _NSUtilities.IntegerForInt((int)WOProperties.TheWorkerThreadCountMax);
    }

    public void setSocketCacheSize(Number number) {
        WOProperties.TheSocketCacheSize = number.intValue();
    }

    public Number socketCacheSize() {
        if (WOProperties.TheSocketCacheSize == -1) {
            Integer n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._SocketCacheSizeKey));
            this.setSocketCacheSize(n);
        }
        return _NSUtilities.IntegerForInt((int)WOProperties.TheSocketCacheSize);
    }

    public void setSocketMonitorSleepTime(Number number) {
        WOProperties.TheSocketMonitorSleepTime = number.intValue();
    }

    public Number socketMonitorSleepTime() {
        if (WOProperties.TheSocketMonitorSleepTime == -1) {
            Integer n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._SocketMonitorSleepTimeKey));
            this.setSocketMonitorSleepTime(n);
        }
        return _NSUtilities.IntegerForInt((int)WOProperties.TheSocketMonitorSleepTime);
    }

    public void setMaxSocketIdleTime(Number number) {
        WOProperties.TheMaxSocketIdleTime = number.intValue();
    }

    public Number maxSocketIdleTime() {
        if (WOProperties.TheMaxSocketIdleTime == -1) {
            Integer n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._MaxSocketIdleTimeKey));
            this.setMaxSocketIdleTime(n);
        }
        return new Integer(WOProperties.TheMaxSocketIdleTime);
    }

    public void setListenQueueSize(Number number) {
        WOProperties.TheListenQueueSize = number;
    }

    public Number listenQueueSize() {
        if (WOProperties.TheListenQueueSize == null) {
            Integer n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._ListenQueueSizeKey));
            this.setListenQueueSize(n);
        }
        return WOProperties.TheListenQueueSize;
    }

    private void _setLifebeatEnabled(boolean bl) {
        WOProperties.TheLifebeatEnabledFlag = bl;
        WOProperties.isTheLifebeatEnabledFlagSet = true;
    }

    public boolean lifebeatEnabled() {
        if (!WOProperties.isTheLifebeatEnabledFlagSet) {
            String string = NSProperties.getProperty((String)WOProperties._LifebeatEnabledKey);
            this._setLifebeatEnabled(Boolean.valueOf(string));
        }
        return WOProperties.TheLifebeatEnabledFlag;
    }

    public boolean monitorEnabled() {
        return this.isMonitorEnabled();
    }

    private void _setOutputPath(String string) {
        WOProperties.TheOutputPath = string;
    }

    public String outputPath() {
        if (WOProperties.TheOutputPath == null) {
            String string = NSProperties.getProperty((String)WOProperties._OutputPathKey);
            this._setOutputPath(string);
        }
        return WOProperties.TheOutputPath;
    }

    protected void _setLifebeatDestinationPort(int n) {
        WOProperties.TheLifebeatDestinationPort = n;
    }

    public int lifebeatDestinationPort() {
        if (WOProperties.TheLifebeatDestinationPort == -1) {
            int n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._LifebeatDestinationPortKey));
            this._setLifebeatDestinationPort(n);
        }
        return WOProperties.TheLifebeatDestinationPort;
    }

    private void _setLifebeatInterval(int n) {
        WOProperties.TheLifebeatInterval = n;
    }

    public int lifebeatInterval() {
        if (WOProperties.TheLifebeatInterval == -1) {
            int n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._LifebeatIntervalKey));
            this._setLifebeatInterval(n);
        }
        return WOProperties.TheLifebeatInterval;
    }

    public void setMonitorHost(String string) {
    }

    public String monitorHost() {
        return "localhost";
    }

    public void setRecordingPath(String string) {
        WOProperties.TheRecordingPath = string;
    }

    public String recordingPath() {
        if (WOProperties.TheRecordingPath == null) {
            String string = NSProperties.getProperty((String)WOProperties._RecordingPathKey);
            this.setRecordingPath(string);
        }
        return WOProperties.TheRecordingPath;
    }

    public void setAutoOpenInBrowser(boolean bl) {
        WOProperties.TheAutoOpenBrowserFlag = bl;
        WOProperties.isTheAutoOpenBrowserFlagSet = true;
    }

    public boolean autoOpenInBrowser() {
        if (!WOProperties.isTheAutoOpenBrowserFlagSet) {
            String string = NSProperties.getProperty((String)WOProperties._AutoOpenBrowserKey);
            this.setAutoOpenInBrowser(Boolean.valueOf(string));
        }
        return WOProperties.TheAutoOpenBrowserFlag;
    }

    public void setAutoOpenClientApplication(boolean bl) {
        WOProperties.TheAutoOpenClientApplicationFlag = bl;
        WOProperties.isTheAutoOpenClientApplicationFlagSet = true;
    }

    public boolean autoOpenClientApplication() {
        if (!WOProperties.isTheAutoOpenClientApplicationFlagSet) {
            String string = NSProperties.getProperty((String)WOProperties._AutoOpenClientApplicationKey);
            this.setAutoOpenClientApplication(Boolean.valueOf(string));
        }
        return WOProperties.TheAutoOpenClientApplicationFlag;
    }

    public void setSMTPHost(String string) {
        WOProperties.TheSMTPHost = string;
    }

    public String SMTPHost() {
        if (WOProperties.TheSMTPHost == null) {
            String string = NSProperties.getProperty((String)WOProperties._SMTPHostKey);
            this.setSMTPHost(string);
        }
        return WOProperties.TheSMTPHost;
    }

    public void setAdaptor(String string) {
        WOProperties.ThePrimaryAdaptorName = string;
    }

    public String adaptor() {
        if (WOProperties.ThePrimaryAdaptorName == null) {
            String string = NSProperties.getProperty((String)WOProperties._AdaptorKey);
            this.setAdaptor(string);
        }
        return WOProperties.ThePrimaryAdaptorName;
    }

    public void setComponentRequestHandlerKey(String string) {
        WOProperties.TheComponentRequestHandlerKey = string;
    }

    public String componentRequestHandlerKey() {
        if (WOProperties.TheComponentRequestHandlerKey == null) {
            String string = NSProperties.getProperty((String)WOProperties._ComponentRequestHandlerKey);
            this.setComponentRequestHandlerKey(string);
        }
        return WOProperties.TheComponentRequestHandlerKey;
    }

    public void setDirectActionRequestHandlerKey(String string) {
        WOProperties.TheDirectActionRequestHandlerKey = string;
    }

    public String directActionRequestHandlerKey() {
        if (WOProperties.TheDirectActionRequestHandlerKey == null) {
            String string = NSProperties.getProperty((String)WOProperties._DirectActionRequestHandlerKey);
            this.setDirectActionRequestHandlerKey(string);
        }
        return WOProperties.TheDirectActionRequestHandlerKey;
    }

    public String streamActionRequestHandlerKey() {
        return NSProperties.getProperty((String)WOProperties.TheStreamActionRequestHandlerKey);
    }

    public void setResourceRequestHandlerKey(String string) {
        WOProperties.TheResourceRequestHandlerKey = string;
    }

    public String resourceRequestHandlerKey() {
        if (WOProperties.TheResourceRequestHandlerKey == null) {
            String string = NSProperties.getProperty((String)WOProperties._ResourceRequestHandlerKey);
            this.setResourceRequestHandlerKey(string);
        }
        return WOProperties.TheResourceRequestHandlerKey;
    }

    public void setWebServiceRequestHandlerKey(String string) {
        WOProperties.TheWebServiceRequestHandlerKey = string;
    }

    public String webServiceRequestHandlerKey() {
        if (WOProperties.TheWebServiceRequestHandlerKey == null) {
            String string = NSProperties.getProperty((String)WOProperties._WebServiceRequestHandlerKey);
            this.setWebServiceRequestHandlerKey(string);
        }
        return WOProperties.TheWebServiceRequestHandlerKey;
    }

    public void setSessionStoreClassName(String string) {
        if (string != null) {
            WOSessionStore wOSessionStore = (WOSessionStore)this._instanceOfNamedClassAssignableFrom(string, WOSessionStore.class, WOServerSessionStore.class);
            WOProperties.TheSessionStoreClassName = wOSessionStore.getClass().getName();
            this.setSessionStore(wOSessionStore);
        }
    }

    public String sessionStoreClassName() {
        return WOProperties.TheSessionStoreClassName;
    }

    public void setFrameworksBaseURL(String string) {
        WOProperties.TheFrameworksBaseURL = string;
    }

    public String frameworksBaseURL() {
        if (WOProperties.TheFrameworksBaseURL == null) {
            String string = NSProperties.getProperty((String)WOProperties._FrameworksBaseURLKey);
            if (string.equals("Undefined")) {
                string = "/Undefined";
            }
            this.setFrameworksBaseURL(string);
        }
        return WOProperties.TheFrameworksBaseURL;
    }

    public void setCGIAdaptorURL(String string) {
        WOProperties.TheCGIAdaptorURL = string;
    }

    public String cgiAdaptorURL() {
        if (WOProperties.TheCGIAdaptorURL == null) {
            String string = NSProperties.getProperty((String)WOProperties._CGIAdaptorURLKey);
            String string2 = "localhost";
            String string3 = "127.0.0.1";
            int n = string.indexOf(string2);
            try {
                if (n != -1) {
                    string = string.substring(0, n) + this.host() + string.substring(n + string2.length());
                } else {
                    n = string.indexOf(string3);
                    if (n != -1) {
                        string = string.substring(0, n) + this.hostAddress().getHostAddress() + string.substring(n + string3.length());
                    }
                }
            }
            catch (Exception exception) {
                string = "http://localhost/cgi-bin/WebObjects";
                NSProperties._setProperty((String)WOProperties._CGIAdaptorURLKey, (String)string);
                NSLog.err.appendln((Object)("The " + WOProperties._CGIAdaptorURLKey + " has the wrong format. The application will use the default value " + string));
            }
            this.setCGIAdaptorURL(string);
        }
        return WOProperties.TheCGIAdaptorURL;
    }

    public void setApplicationBaseURL(String string) {
        WOProperties.TheApplicationBaseURL = string;
    }

    public String applicationBaseURL() {
        if (WOProperties.TheApplicationBaseURL == null) {
            String string = NSProperties.getProperty((String)WOProperties._ApplicationBaseURLKey);
            if (string.equals("Undefined")) {
                string = "/Undefined";
            }
            this.setApplicationBaseURL(string);
        }
        return WOProperties.TheApplicationBaseURL;
    }

    public void setAllowsConcurrentRequestHandling(boolean bl) {
        WOProperties.TheAllowsConcurrentRequestHandlingFlag = bl;
        WOProperties.isTheAllowsConcurrentRequestHandlingFlagSet = true;
        this._allowsConcurrentRequestHandling = bl;
        EOObjectStore._resetAssertLock();
        if (!this._allowsConcurrentRequestHandling) {
            EOObjectStore._suppressAssertLock();
        }
    }

    public boolean allowsConcurrentRequestHandling() {
        if (!WOProperties.isTheAllowsConcurrentRequestHandlingFlagSet) {
            boolean bl = Boolean.valueOf(NSProperties.getProperty((String)WOProperties._AllowsConcurrentRequestHandlingKey));
            this.setAllowsConcurrentRequestHandling(bl);
        }
        return WOProperties.TheAllowsConcurrentRequestHandlingFlag;
    }

    public void setSessionTimeOut(Number number) {
        int n = number.intValue();
        if (n < 0) {
            n = 0;
        }
        WOProperties.TheSessionTimeOut = new Double(n);
    }

    public void setDefaultUndoStackLimit(int n) {
        if (n < 0) {
            n = 10;
        }
        WOProperties.TheDefaultUndoStackLimit = n;
    }

    public Number sessionTimeOut() {
        if (WOProperties.TheSessionTimeOut == null) {
            int n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._SessionTimeOutKey));
            if (n < 0) {
                n = 0;
            }
            this.setSessionTimeOut(new Double(n));
        }
        return WOProperties.TheSessionTimeOut;
    }

    public Number defaultUndoStackLimit() {
        if (WOProperties.TheDefaultUndoStackLimit == -1) {
            int n = Integer.valueOf(NSProperties.getProperty((String)WOProperties._DefaultUndoStackLimitKey));
            this.setDefaultUndoStackLimit(n);
            if (n < 0) {
                n = 10;
            }
            this.setDefaultUndoStackLimit(n);
        }
        return _NSUtilities.IntegerForInt((int)WOProperties.TheDefaultUndoStackLimit);
    }

    protected void _setLockDefaultEditingContext(boolean bl) {
        WOProperties.TheLockDefaultEditingContextFlag = bl;
        WOProperties.isTheLockDefaultEditingContextFlagSet = true;
    }

    protected boolean _lockDefaultEditingContext() {
        if (!WOProperties.isTheLockDefaultEditingContextFlagSet) {
            boolean bl = true;
            String string = NSProperties.getProperty((String)WOProperties._LockDefaultEditingContextKey);
            if (string != null) {
                bl = Boolean.valueOf(string);
            }
            this._setLockDefaultEditingContext(bl);
        }
        return WOProperties.TheLockDefaultEditingContextFlag;
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)object, (String)string);
    }

    public void unableToSetNullForKey(String string) {
        NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)string);
    }

    public Object valueForKeyPath(String string) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)string);
    }

    public void takeValueForKeyPath(Object object, String string) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)object, (String)string);
    }

    public void validationFailedWithException(Throwable throwable, Object object, String string, WOComponent wOComponent, WOSession wOSession) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)132L)) {
            NSLog.debug.appendln((Object)("Validation failed on an object [" + (object == null ? "null" : object.getClass().getName()) + "] with keypath = " + string + " and exception: " + throwable.getMessage()));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)132L)) {
                if (wOComponent != null) {
                    NSLog.debug.appendln((Object)wOComponent.toString());
                }
                if (wOSession != null) {
                    NSLog.debug.appendln((Object)wOSession.toString());
                }
                NSLog.debug.appendln(throwable);
            }
        }
    }

    public void lock() {
    }

    public void unlock() {
    }

    public boolean _isSupportedDevelopmentPlatform() {
        return this._isDomesticSupportedDevelopmentPlatform() || this._isForeignSupportedDevelopmentPlatform();
    }

    public boolean _isDomesticSupportedDevelopmentPlatform() {
        String string = System.getProperty("os.name");
        return string != null && (string.startsWith("Mac OS") || string.equals("Darwin") || string.equals("Rhapsody"));
    }

    public boolean _isForeignSupportedDevelopmentPlatform() {
        String string = System.getProperty("os.name");
        return string != null && (string.equals("Windows 2000") || string.equals("Windows NT"));
    }

    private static void _initWOApp(boolean bl) {
        WOProperties.initUserDefaultsKeys();
        WOProperties.initPropertiesFromWebServerConfig();
        WOProperties.initProgrammaticWODefaults();
        NSProperties.setPropertiesFromArgv((String[])_argv);
        NSLog._setInInitPhase((boolean)true);
        WOApplication._initWOOuputPath();
        WOProperties.initLanguageDictionary();
        NSLog._setInInitPhase((boolean)false);
        if (bl) {
            WOProperties.printWODefaults();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _initWOOuputPath() {
        Object object;
        String string = NSProperties.getProperty((String)WOProperties._OutputPathKey);
        if (string == null) return;
        if (string.equals("/dev/null")) {
            System.setOut((PrintStream)new NSLog._DevNullPrintStream((OutputStream)System.out));
            System.setErr((PrintStream)new NSLog._DevNullPrintStream((OutputStream)System.err));
            ((NSLog.PrintStreamLogger)NSLog.debug).setPrintStream(System.err);
            ((NSLog.PrintStreamLogger)NSLog.out).setPrintStream(System.out);
            ((NSLog.PrintStreamLogger)NSLog.err).setPrintStream(System.err);
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                NSLog.err.appendln((Object)("WOApplication Error: WOOutputPath " + string + " is a directory."));
                return;
            }
            object = new NSTimestampFormatter("%Y%m%d%H%M%S%F");
            File file2 = new File(string + "." + object.format((Object)new NSTimestamp()));
            boolean bl = file.renameTo(file2);
            if (!bl) {
                NSLog.err.appendln((Object)("WOApplication Error: Failed to rename previously existing WOOutputPath file: " + string));
                return;
            }
            NSLog.err.appendln((Object)("WOApplication: Renamed previous WOOutputPath file to " + file2.getPath()));
        } else {
            try {
                object = file.getParentFile();
                if (!((File)object).exists() && !((File)object).mkdirs()) {
                    NSLog.err.appendln((Object)("WOApplication Error: WOOutputPath directory " + ((File)object).getPath() + " could not be created."));
                    return;
                }
                boolean bl = file.createNewFile();
                if (!bl) {
                    NSLog.err.appendln((Object)("WOApplication Error: WOOutputPath " + string + " could not be created."));
                    return;
                }
            }
            catch (IOException iOException) {
                NSLog.err.appendln((Object)("WOApplication Error: WOOutputPath " + string + " could not be created: " + iOException));
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) return;
                NSLog.err.appendln((Throwable)iOException);
                return;
            }
        }
        object = NSLog.printStreamForPath((String)string);
        if (object == null) return;
        System.setOut((PrintStream)object);
        System.setErr((PrintStream)object);
        ((NSLog.PrintStreamLogger)NSLog.debug).setPrintStream((PrintStream)object);
        ((NSLog.PrintStreamLogger)NSLog.out).setPrintStream((PrintStream)object);
        ((NSLog.PrintStreamLogger)NSLog.err).setPrintStream((PrintStream)object);
    }

    private Object _instanceOfNamedClassAssignableFrom(String string, Class clazz, Class clazz2) {
        Class clazz3 = _NSUtilities.classWithName((String)string);
        Object object = null;
        if (clazz3 != null) {
            if (clazz.isAssignableFrom(clazz3)) {
                object = _NSUtilities.instantiateObject((Class)clazz3, null, null, (boolean)true, (boolean)this.isDebuggingEnabled());
            } else {
                NSLog.err.appendln((Object)("<WOApplication> " + string + " is not a valid (" + clazz2 + ") class. Using default (" + clazz2 + ")."));
                object = _NSUtilities.instantiateObject((Class)clazz2, null, null, (boolean)true, (boolean)this.isDebuggingEnabled());
            }
        } else {
            NSLog.err.appendln((Object)("<WOApplication> " + string + " is an unknown class. Using default (" + clazz2 + ")."));
            object = _NSUtilities.instantiateObject((Class)clazz2, null, null, (boolean)true, (boolean)this.isDebuggingEnabled());
        }
        return object;
    }

    Number _refuseNewSessionsTime() {
        int n;
        int n2 = this.sessionTimeOut().intValue();
        int n3 = this.activeSessionsCount();
        if (n3 > 0) {
            int n4 = this.minimumActiveSessionsCount();
            n = n2 * (n3 - n4) / n3;
            if (n > n2 / 4) {
                n = n2 / 4;
            }
        } else {
            n = n2 / 4;
        }
        if (n < 15) {
            n = 15;
        }
        return new Integer(n);
    }

    public WOResponse responseForComponentWithName(String string, NSDictionary nSDictionary, NSDictionary nSDictionary2, NSDictionary nSDictionary3, String string2, String string3) {
        NSMutableDictionary nSMutableDictionary = null;
        if (nSDictionary3 != null) {
            nSMutableDictionary = new NSMutableDictionary(nSDictionary3);
        }
        if (nSMutableDictionary == null) {
            nSMutableDictionary = new NSMutableDictionary(2);
        }
        nSMutableDictionary.setObjectForKey((Object)string, (Object)"Component");
        if (nSDictionary != null) {
            nSMutableDictionary.setObjectForKey((Object)nSDictionary, (Object)"Bindings");
        }
        if (string2 == null && (string2 = this.cgiAdaptorURL()) == null) {
            string2 = "/cgi-bin/WebObjects";
        }
        if (string3 == null) {
            string3 = this.name();
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append('/');
        stringBuffer.append(string3);
        if (string3.indexOf(".woa") == -1) {
            stringBuffer.append(".woa");
        }
        stringBuffer.append('/');
        stringBuffer.append(this.directActionRequestHandlerKey());
        stringBuffer.append("/_component");
        String string4 = new String(stringBuffer);
        WORequest wORequest = WOApplication.application().createRequest("GET", string4, "HTTP/1.0", nSDictionary2, null, (NSDictionary)nSMutableDictionary);
        return this.dispatchRequest(wORequest);
    }

    public WOResponse responseForDirectActionWithNameAndClass(String string, String string2, NSDictionary nSDictionary, InputStream inputStream, NSDictionary nSDictionary2, NSDictionary nSDictionary3, String string3, String string4) {
        String string5 = "POST";
        if (string3 == null && (string3 = this.cgiAdaptorURL()) == null) {
            string3 = "/cgi-bin/WebObjects";
        }
        if (string4 == null) {
            string4 = this.name();
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        stringBuffer.append('/');
        stringBuffer.append(string4);
        stringBuffer.append('/');
        stringBuffer.append(this.directActionRequestHandlerKey());
        stringBuffer.append('/');
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append('/');
        if (string != null) {
            stringBuffer.append(string);
        }
        if (nSDictionary != null) {
            stringBuffer.append('?');
            stringBuffer.append(WOURLEncoder.encodeAsCGIFormValues(nSDictionary));
            string5 = "GET";
        }
        String string6 = new String(stringBuffer);
        NSData nSData = null;
        if (inputStream != null) {
            int n = 1;
            String string7 = (String)nSDictionary2.valueForKey("content-length");
            if (string7 != null) {
                try {
                    n = Integer.parseInt(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    NSLog.err.appendln((Object)("<WOApplication> responseForDirectActionWithNameAndClass: illegal content-length header: " + string7));
                }
            }
            try {
                nSData = new NSData(inputStream, n);
            }
            catch (IOException iOException) {
                NSLog.err.appendln((Object)("<WOApplication> responseForDirectActionWithNameAndClass: exception getting content: " + iOException));
            }
        }
        WORequest wORequest = WOApplication.application().createRequest(string5, string6, "HTTP/1.0", nSDictionary2, nSData, nSDictionary3);
        return this.dispatchRequest(wORequest);
    }

    static {
        _WOAppPackageName = "";
        _theSessionClass = null;
        _argv = null;
        TheLoadedFrameworkCount = 0;
        TheComponentBearingFrameworks = null;
        TheMultipleInstancesLicenseFlag = false;
        TheMultipleThreadsLicenseFlag = true;
        TheRequestWindowLicenseValue = 60000L;
        TheRequestLimitLicenseValue = -1;
        _checksForSpecialHeaders = false;
        _IsEventLoggingEnabled = false;
        try {
            _NSUtilities.registerPackage((String)"com.webobjects.appserver._private");
            _NSUtilities.registerPackage((String)"com.webobjects.appserver");
            _NSUtilities.registerPackage((String)"com.webobjects.eoaccess");
            _NSUtilities.registerPackage((String)"com.webobjects.eocontrol");
            _NSUtilities.registerPackage((String)"com.webobjects.woextensions");
            _NSUtilities.registerPackage((String)"com.webobjects.examples.woexamples");
            try {
                Class<?> clazz = Class.forName("KeyValueCodingProtectedAccessor");
                if (clazz != null) {
                    _NSUtilities.setClassForName(clazz, (String)"KeyValueCodingProtectedAccessor");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            _NSUtilities.setClassForName((Class)EOGenericRecord.class, (String)"EOGenericRecord");
            _NSUtilities.setClassForName((Class)EOFetchSpecification.class, (String)"EOFetchSpecification");
            _NSUtilities.setClassForName((Class)EOGlobalID.class, (String)"EOGlobalID");
            _NSUtilities.setClassForName((Class)EOKeyGlobalID.class, (String)"EOKeyGlobalID");
            _NSUtilities.setClassForName((Class)EOSortOrdering.class, (String)"EOSortOrdering");
            _NSUtilities.setClassForName((Class)EOAndQualifier.class, (String)"EOAndQualifier");
            _NSUtilities.setClassForName((Class)EOKeyValueQualifier.class, (String)"EOKeyValueQualifier");
            _NSUtilities.setClassForName((Class)EONotQualifier.class, (String)"EONotQualifier");
            _NSUtilities.setClassForName((Class)EOOrQualifier.class, (String)"EOOrQualifier");
            _NSUtilities.setClassForName((Class)EOKeyComparisonQualifier.class, (String)"EOKeyComparisonQualifier");
            _NSUtilities.setClassForName((Class)EOQualifierVariable.class, (String)"EOQualifierVariable");
            _NSUtilities.setClassForName((Class)WOApplication.class, (String)"WOApplication");
            _NSUtilities.setClassForName((Class)WODefaultAdaptor.class, (String)"WODefaultAdaptor");
            _NSUtilities.setClassForName((Class)WOComponentRequestHandler.class, (String)"WOComponentRequestHandler");
            _NSUtilities.setClassForName((Class)WODirectActionRequestHandler.class, (String)"WODirectActionRequestHandler");
            _NSUtilities.setClassForName((Class)WODisplayGroup.class, (String)"WODisplayGroup");
            _NSUtilities.setClassForName((Class)WOAdminAction.class, (String)"WOAdminAction");
            _NSUtilities.setClassForName((Class)WOServerSessionStore.class, (String)"WOServerSessionStore");
            _NSUtilities.setClassForName((Class)WOContext.class, (String)"WOContext");
            _NSUtilities.setClassForName((Class)WOActionURL.class, (String)"WOActionURL");
            _NSUtilities.setClassForName((Class)WOActiveImage.class, (String)"WOActiveImage");
            _NSUtilities.setClassForName((Class)WOApplet.class, (String)"WOApplet");
            _NSUtilities.setClassForName((Class)WOBody.class, (String)"WOBody");
            _NSUtilities.setClassForName((Class)WOBrowser.class, (String)"WOBrowser");
            _NSUtilities.setClassForName((Class)WOCheckBox.class, (String)"WOCheckBox");
            _NSUtilities.setClassForName((Class)WOComponentContent.class, (String)"WOComponentContent");
            _NSUtilities.setClassForName((Class)WOConditional.class, (String)"WOConditional");
            _NSUtilities.setClassForName((Class)WOFileUpload.class, (String)"WOFileUpload");
            _NSUtilities.setClassForName((Class)WOForm.class, (String)"WOForm");
            _NSUtilities.setClassForName((Class)WOFrame.class, (String)"WOFrame");
            _NSUtilities.setClassForName((Class)WOGenericContainer.class, (String)"WOGenericContainer");
            _NSUtilities.setClassForName((Class)WOGenericElement.class, (String)"WOGenericElement");
            _NSUtilities.setClassForName((Class)WOHiddenField.class, (String)"WOHiddenField");
            _NSUtilities.setClassForName((Class)WOHyperlink.class, (String)"WOHyperlink");
            _NSUtilities.setClassForName((Class)WOImage.class, (String)"WOImage");
            _NSUtilities.setClassForName((Class)WOImageButton.class, (String)"WOImageButton");
            _NSUtilities.setClassForName((Class)WOJavaScript.class, (String)"WOJavaScript");
            _NSUtilities.setClassForName((Class)WOParam.class, (String)"WOParam");
            _NSUtilities.setClassForName((Class)WOPasswordField.class, (String)"WOPasswordField");
            _NSUtilities.setClassForName((Class)WOPopUpButton.class, (String)"WOPopUpButton");
            _NSUtilities.setClassForName((Class)WORadioButton.class, (String)"WORadioButton");
            _NSUtilities.setClassForName((Class)WORepetition.class, (String)"WORepetition");
            _NSUtilities.setClassForName((Class)WOResetButton.class, (String)"WOResetButton");
            _NSUtilities.setClassForName((Class)WOResourceURL.class, (String)"WOResourceURL");
            _NSUtilities.setClassForName((Class)WOString.class, (String)"WOString");
            _NSUtilities.setClassForName((Class)WOSubmitButton.class, (String)"WOSubmitButton");
            _NSUtilities.setClassForName((Class)WOSwitchComponent.class, (String)"WOSwitchComponent");
            _NSUtilities.setClassForName((Class)WOText.class, (String)"WOText");
            _NSUtilities.setClassForName((Class)WOTextField.class, (String)"WOTextField");
            _NSUtilities.setClassForName((Class)WOXMLNode.class, (String)"WOXMLNode");
            _NSUtilities.setClassForName((Class)WOServerSessionStore.class, (String)"WOServerSessionStore");
            EOEventCenter.registerEventClass((Class)Event.class, (EOEventCenter.EventRecordingHandler)new _EventLoggingEnabler());
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<WOApplication> Exception during static initialization: " + exception.toString()));
            if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                NSLog.debug.appendln((Throwable)exception);
            }
            System.exit(1);
        }
    }

    public static class _EventLoggingEnabler
    implements EOEventCenter.EventRecordingHandler {
        public void setLoggingEnabled(boolean bl, Class clazz) {
            _IsEventLoggingEnabled = bl;
        }
    }

    class _LifebeatThread
    extends Thread {
        private InetAddress _localAddress = null;
        private String _localhostName;
        private int _lifebeatDestinationPort;
        private long _lifebeatInterval;
        private String _appName = null;
        private int _appPort = -1;
        private String _appHost = null;
        private int _deathCounter = 0;
        private Socket lifebeatSocket = null;
        private OutputStream lifebeatOS = null;
        private InputStream lifebeatIS = null;
        private byte[] lifebeatResponseBuffer = new byte["HTTP/1.X XXX".length() + WOHttpIO.URIResponseString.length() + "\r\n\r\n".length()];
        private DatagramSocket datagramSocket = null;
        private byte[] _versionRequest = null;
        byte[] _mbuffer = new byte[1000];
        DatagramPacket incomingPacket;
        DatagramPacket outgoingPacket;
        private byte[] _hasStarted = null;
        private byte[] _lifebeat = null;
        private byte[] _willStop = null;
        private byte[] _willCrash = null;

        _LifebeatThread(String string, int n, InetAddress inetAddress, int n2, long l) {
            NSLog.debug.appendln((Object)("Creating LifebeatThread now with: " + string + " " + n + " " + inetAddress + " " + n2 + " " + l));
            this._lifebeatDestinationPort = n2;
            this._lifebeatInterval = l;
            this._appName = string;
            this._appPort = n;
            this._localAddress = inetAddress;
            this._localhostName = inetAddress.getHostName();
        }

        private void initMessages() {
            String string = "GET /cgi-bin/WebObjects/wotaskd.woa/wlb?";
            String string2 = "&" + this._appName + "&" + this._localhostName + "&" + this._appPort + " HTTP/1.1\r\n\r\n";
            String string3 = "womp://queryVersion";
            try {
                this._hasStarted = (string + "hasStarted" + string2).getBytes("UTF8");
                this._lifebeat = (string + "lifebeat" + string2).getBytes("UTF8");
                this._willStop = (string + "willStop" + string2).getBytes("UTF8");
                this._willCrash = (string + "willCrash" + string2).getBytes("UTF8");
                this._versionRequest = string3.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                NSLog._conditionallyLogPrivateException((Throwable)unsupportedEncodingException);
                this._hasStarted = (string + "hasStarted" + string2).getBytes();
                this._lifebeat = (string + "lifebeat" + string2).getBytes();
                this._willStop = (string + "willStop" + string2).getBytes();
                this._willCrash = (string + "willCrash" + string2).getBytes();
                this._versionRequest = string3.getBytes();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMessage(byte[] byArray) {
            block12: {
                if (byArray == null) {
                    return;
                }
                try {
                    if (this.lifebeatSocket == null) {
                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                            NSLog.debug.appendln((Object)"Creating new lifebeat socket");
                        }
                        this.lifebeatSocket = new Socket(this._localAddress, this._lifebeatDestinationPort, this._localAddress, 0);
                        this.lifebeatSocket.setTcpNoDelay(true);
                        this.lifebeatSocket.setSoLinger(false, 0);
                        this.lifebeatIS = this.lifebeatSocket.getInputStream();
                        this.lifebeatOS = this.lifebeatSocket.getOutputStream();
                    }
                    this.lifebeatOS.write(byArray);
                    this.lifebeatOS.flush();
                    int n = -1;
                    for (int i = 0; i < this.lifebeatResponseBuffer.length && (n = this.lifebeatIS.read(this.lifebeatResponseBuffer, i, this.lifebeatResponseBuffer.length - i)) != -1; i += n) {
                    }
                    if (n == -1 || this.lifebeatResponseBuffer[9] == 52) {
                        this._closeLifebeatSocket();
                        break block12;
                    }
                    if (this.lifebeatResponseBuffer[9] == 53) {
                        try {
                            NSLog.err.appendln((Object)"Force Quit received. Exiting now...");
                            this.lifebeatSocket = new Socket(this._localAddress, this._lifebeatDestinationPort, this._localAddress, 0);
                            this.lifebeatOS = this.lifebeatSocket.getOutputStream();
                            this.lifebeatOS.write(_lifebeatThread._willCrash);
                            this.lifebeatOS.flush();
                            this._closeLifebeatSocket();
                            break block12;
                        }
                        finally {
                            System.exit(1);
                        }
                    }
                    this._deathCounter = 0;
                }
                catch (IOException iOException) {
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                        NSLog.debug.appendln((Object)("Exception sending lifebeat to wotaskd: " + iOException));
                    }
                    this._closeLifebeatSocket();
                }
            }
        }

        private void _closeLifebeatSocket() {
            this.lifebeatOS = null;
            this.lifebeatIS = null;
            if (this.lifebeatSocket != null) {
                block3: {
                    try {
                        this.lifebeatSocket.close();
                    }
                    catch (IOException iOException) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) break block3;
                        NSLog.debug.appendln((Object)("Exception closing lifebeat socket: " + iOException));
                    }
                }
                this.lifebeatSocket = null;
            }
            ++this._deathCounter;
        }

        void udpMessage() {
            block3: {
                try {
                    this.datagramSocket.send(this.outgoingPacket);
                    this.incomingPacket.setLength(this._mbuffer.length);
                    this.datagramSocket.receive(this.incomingPacket);
                    String string = _NSStringUtilities.stringForBytes((byte[])this.incomingPacket.getData(), (String)"UTF-8");
                    if (string.startsWith(WOApplication._adminRequestHandlerKey)) {
                        this._deathCounter = 0;
                    }
                }
                catch (Throwable throwable) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) break block3;
                    NSLog.debug.appendln((Object)("Exception checking for wotaskd using UDP: " + throwable));
                }
            }
        }

        public void run() {
            if (this._localAddress == null) {
                return;
            }
            while (this._appPort == -1 && WOApplication.this.adaptors().count() != 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    NSLog._conditionallyLogPrivateException((Throwable)interruptedException);
                }
                this._appPort = ((WOAdaptor)WOApplication.this.adaptors().objectAtIndex(0)).port();
            }
            this.initMessages();
            boolean bl = false;
            try {
                this.datagramSocket = new DatagramSocket(0, this._localAddress);
                this.datagramSocket.setSoTimeout(5000);
                this.outgoingPacket = new DatagramPacket(this._versionRequest, this._versionRequest.length, this._localAddress, this._lifebeatDestinationPort);
                this.incomingPacket = new DatagramPacket(this._mbuffer, this._mbuffer.length);
            }
            catch (SocketException socketException) {
                NSLog.err.appendln((Object)("<_LifebeatThread> Exception creating datagramSocket: " + socketException));
                bl = true;
            }
            this.sendMessage(this._hasStarted);
            try {
                Thread.sleep(this._lifebeatInterval);
            }
            catch (InterruptedException interruptedException) {
                NSLog._conditionallyLogPrivateException((Throwable)interruptedException);
            }
            while (true) {
                if (this._deathCounter < 10 || bl) {
                    this.sendMessage(this._lifebeat);
                } else {
                    this.udpMessage();
                }
                try {
                    Thread.sleep(this._lifebeatInterval);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    NSLog._conditionallyLogPrivateException((Throwable)interruptedException);
                    continue;
                }
                break;
            }
        }
    }

    public static class Event
    extends WOEvent {
        public String displayComponentName() {
            return "WOEventRow";
        }

        public String comment() {
            Object object = this.info();
            return object instanceof String ? (String)object : super.comment();
        }
    }
}

