/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOEvent;
import com.webobjects.appserver._private.WOBindingNameAssociation;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WOKeyValueAssociation;
import com.webobjects.appserver._private.WOReadOnlyKeyValueAssociation;
import com.webobjects.eocontrol.EOEvent;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;

public abstract class WOAssociation
implements Cloneable {
    protected boolean _debugEnabled;
    private String _bindingName;
    private String _declarationName;
    private String _declarationType;
    protected static char _BINDING_KEYPATH_PREFIX;
    protected static boolean _IsEventLoggingEnabled;
    public static final String ValueForKeyPathEvent = "valueForKeyPath";
    public static final String TakeValueForKeyPathEvent = "takeValueForKeyPath";
    private static Class[] parameterTypes;

    protected WOAssociation() {
    }

    public Object valueInComponent(WOComponent wOComponent) {
        if (this._debugEnabled) {
            this._logPullValue(null, wOComponent);
        }
        return null;
    }

    public boolean booleanValueInComponent(WOComponent wOComponent) {
        Object object = null;
        boolean bl = true;
        object = this.valueInComponent(wOComponent);
        if (object != null) {
            if (object instanceof Number) {
                if (((Number)object).intValue() == 0) {
                    bl = false;
                }
            } else if (object instanceof String) {
                String string;
                String string2 = (String)object;
                int n = string2.length();
                if (n >= 2 && n <= 5 && ((string = string2.toLowerCase()).equals("no") || string.equals("false") || string.equals("nil") || string.equals("null"))) {
                    bl = false;
                }
                if (bl && _NSStringUtilities.isNumber((String)string2)) {
                    try {
                        if (Integer.parseInt(string2) == 0) {
                            bl = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)524292L)) {
                            NSLog.debug.appendln((Object)("<WOAssociation> Exception while evaluating value in component: " + numberFormatException.toString()));
                            NSLog.debug.appendln((Throwable)numberFormatException);
                        }
                    }
                }
            } else if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void setValue(Object object, WOComponent wOComponent) {
    }

    public void _setValueNoValidation(Object object, WOComponent wOComponent) {
        this.setValue(object, wOComponent);
    }

    public boolean isValueSettable() {
        return false;
    }

    public boolean isValueConstant() {
        return true;
    }

    public boolean isValueSettableInComponent(WOComponent wOComponent) {
        return this.isValueSettable();
    }

    public boolean isValueConstantInComponent(WOComponent wOComponent) {
        return this.isValueConstant();
    }

    public void setDebugEnabledForBinding(String string, String string2, String string3) {
        this._debugEnabled = true;
        this._bindingName = string;
        this._declarationName = string2;
        this._declarationType = string3;
    }

    protected String _debugDescription() {
        return this.getClass().getName();
    }

    protected void _logPullValue(Object object, WOComponent wOComponent) {
        WOApplication.application().logTakeValueForDeclarationNamed(this._declarationName, this._declarationType, this._bindingName, this._debugDescription(), object);
    }

    protected void _logPushValue(Object object, WOComponent wOComponent) {
        WOApplication.application().logSetValueForDeclarationNamed(this._declarationName, this._declarationType, this._bindingName, this._debugDescription(), object);
    }

    public abstract String keyPath();

    public abstract String bindingInComponent(WOComponent var1);

    public static WOAssociation associationWithValue(Object object) {
        return new WOConstantValueAssociation(object);
    }

    private static boolean _keyPathIsReadOnly(String string) {
        return string.startsWith("@") || string.indexOf(".@") > 0;
    }

    private static Class _associationClassForKeyPath(String string) {
        Class clazz = string.charAt(0) == _BINDING_KEYPATH_PREFIX ? WOBindingNameAssociation.class : (WOAssociation._keyPathIsReadOnly(string) ? WOReadOnlyKeyValueAssociation.class : WOKeyValueAssociation.class);
        return clazz;
    }

    public static WOAssociation associationWithKeyPath(String string) {
        Class clazz = WOAssociation._associationClassForKeyPath(string);
        Object[] objectArray = new Object[]{string};
        WOAssociation wOAssociation = (WOAssociation)_NSUtilities.instantiateObject((Class)clazz, (Class[])parameterTypes, (Object[])objectArray, (boolean)true, (boolean)true);
        return wOAssociation;
    }

    public boolean _isImplementedForComponent(WOComponent wOComponent) {
        return true;
    }

    protected boolean _hasBindingInParent(WOComponent wOComponent) {
        return true;
    }

    public void _setDebuggingEnabled(boolean bl) {
        this._debugEnabled = bl;
    }

    public String _bindingName() {
        return this._bindingName;
    }

    public String _declarationName() {
        return this._declarationName;
    }

    public String _declarationType() {
        return this._declarationType;
    }

    protected Event _markStartOfEventIfNeeded(String string, String string2, WOComponent wOComponent) {
        Event event = null;
        if (_IsEventLoggingEnabled && wOComponent.isEventLoggingEnabled()) {
            event = (Event)EOEventCenter.newEventOfClass((Class)Event.class, (String)string);
            EOEventCenter.markStartOfEvent((EOEvent)event, (Object)this);
            event.setComponentName(wOComponent.name());
            event.setKeyPath(string2);
            event.setPageName(wOComponent.context().page().name());
            event.setBindingNameWithComponent(wOComponent, this);
        }
        return event;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" bindingName=" + this._bindingName);
        stringBuffer.append(" declarationName=" + this._declarationName);
        stringBuffer.append(" declarationType=" + this._declarationType);
        stringBuffer.append(" parameterTypes=");
        if (parameterTypes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("(");
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(parameterTypes[i]);
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    static {
        block2: {
            _BINDING_KEYPATH_PREFIX = (char)94;
            _IsEventLoggingEnabled = false;
            try {
                parameterTypes = new Class[]{String.class};
                EOEventCenter.registerEventClass((Class)Event.class, (EOEventCenter.EventRecordingHandler)new _EventLoggingEnabler());
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<WOAssociation> Exception during static initialization: " + exception.toString()));
                if (!NSLog.debugLoggingAllowedForLevel((int)1)) break block2;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
    }

    public static class _EventLoggingEnabler
    implements EOEventCenter.EventRecordingHandler {
        public void setLoggingEnabled(boolean bl, Class clazz) {
            _IsEventLoggingEnabled = bl;
        }
    }

    public static class Event
    extends WOEvent {
        private String _keyPath = "";
        private String _defaultBindingName = "";
        static String desc = null;

        public String displayComponentName() {
            return "WOAssociationEventRow";
        }

        public String bindingName() {
            String string;
            String string2 = this._defaultBindingName;
            WOAssociation wOAssociation = (WOAssociation)this.info();
            if (wOAssociation != null && (string = wOAssociation._bindingName()) != null && string.length() > 0) {
                string2 = string;
            }
            return string2;
        }

        public void setBindingNameWithComponent(WOComponent wOComponent, WOAssociation wOAssociation) {
            this._defaultBindingName = wOAssociation.bindingInComponent(wOComponent);
        }

        public String declarationName() {
            String string;
            WOAssociation wOAssociation = (WOAssociation)this.info();
            String string2 = this.keyPath();
            if (wOAssociation != null && (string = wOAssociation._declarationName()) != null && string.length() > 0) {
                string2 = string;
            }
            return string2;
        }

        public boolean isPush() {
            if (null == desc) {
                Object object = WOEvent.eventTypeDescriptions(((Object)((Object)this)).getClass()).objectForKey((Object)WOAssociation.TakeValueForKeyPathEvent);
                desc = object != null ? object.toString() : "";
            }
            return desc.equals(this.type());
        }

        public String keyPath() {
            return this._keyPath;
        }

        public void setKeyPath(String string) {
            this._keyPath = string;
        }

        public String comment() {
            return this.declarationName() + this.bindingName();
        }
    }
}

