/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOEvent;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WOComponentDefinition;
import com.webobjects.appserver._private.WODeclarationFormatException;
import com.webobjects.appserver._private.WOHTMLFormatException;
import com.webobjects.appserver._private.WOParser;
import com.webobjects.eocontrol.EOEvent;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSValidation;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;

public class WOComponent
extends WOElement
implements NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSKeyValueCodingAdditions,
NSValidation,
WOActionResults,
Cloneable,
Serializable {
    static final long serialVersionUID = 9030800440407384426L;
    private String _name;
    private NSMutableDictionary _subcomponents;
    private String _templateName;
    private transient WOElement _template;
    private transient WOComponentDefinition _componentDefinition;
    private transient WOComponent _parent;
    public transient NSMutableDictionary _keyAssociations;
    private transient WOElement _childTemplate;
    private transient WOContext _context;
    private transient WOSession _session;
    private boolean _isPage;
    private boolean _caching;
    private boolean _isSynchronized;
    private static NSMutableDictionary TheTemplateNameDictionary;
    protected static String _Extension;
    private static final Class[] _ContextParameter;
    protected static boolean _IsEventLoggingEnabled;
    private static final String TakeValuesFromRequestEvent = "takeValuesFromRequest";
    private static final String InvokeActionForRequestEvent = "invokeActionForRequest";
    private static final String AppendToResponseEvent = "appendToResponse";
    private static final String AwakeEvent = "awake";
    private static final String SleepEvent = "sleep";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _templateNameForClass(Class clazz) {
        int n;
        String string = null;
        String string2 = null;
        int n2 = this._name.lastIndexOf(46);
        int n3 = n2 > (n = this._name.lastIndexOf(47)) ? n2 : n;
        string2 = n3 != -1 && n3 < this._name.length() - 1 ? this._name.substring(n3 + 1) : this._name;
        if (WOComponent.class.isAssignableFrom(clazz)) {
            string = string2;
        } else {
            NSMutableDictionary nSMutableDictionary = TheTemplateNameDictionary;
            synchronized (nSMutableDictionary) {
                string = (String)TheTemplateNameDictionary.objectForKey((Object)clazz);
                if (string == null) {
                    string = string2;
                    TheTemplateNameDictionary.setObjectForKey((Object)string, (Object)clazz);
                }
            }
        }
        return string;
    }

    public WOComponent() {
        this(WOComponentDefinition.TheTemporaryContext);
    }

    public WOComponent(WOContext wOContext) {
        if (wOContext == null) {
            throw new IllegalArgumentException("Cannot create a component with a null context");
        }
        WOApplication wOApplication = WOApplication.application();
        Class<?> clazz = this.getClass();
        this._setContext(wOContext);
        this._name = clazz == WOComponent.class ? wOContext._componentName() : clazz.getName();
        this._templateName = this._templateNameForClass(clazz);
        this._isPage = false;
        this._subcomponents = null;
        this.setCachingEnabled(wOApplication.isCachingEnabled());
        this._componentDefinition = wOContext._tempComponentDefinition();
        WOComponentDefinition wOComponentDefinition = this._componentDefinition();
        if (wOComponentDefinition != null) {
            wOComponentDefinition.finishInitializingComponent(this);
        }
        this._isSynchronized = this.synchronizesVariablesWithBindings();
    }

    public Object clone() throws CloneNotSupportedException {
        WOComponent wOComponent;
        String string = this._context._componentName();
        this._context._setComponentName(this._name);
        Class<?> clazz = this.getClass();
        try {
            wOComponent = clazz == WOComponent.class ? new WOComponent(this._context) : (WOComponent)_NSUtilities.instantiateObject(clazz, (Class[])_ContextParameter, (Object[])new Object[]{this._context}, (boolean)true, (boolean)false);
        }
        catch (Exception exception) {
            try {
                wOComponent = new WOComponent(this._context);
            }
            catch (Exception exception2) {
                throw new NSForwardException((Throwable)exception2, "<" + this.getClass().getName() + "> Exception occurred while initializing component copy: " + exception2.toString());
            }
        }
        this._context._setComponentName(string);
        wOComponent._setIsPage(this._isPage);
        if (this._subcomponents != null) {
            Enumeration enumeration = this._subcomponents.keyEnumerator();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                WOComponent wOComponent2 = (WOComponent)this._subcomponents.objectForKey((Object)string2);
                try {
                    wOComponent._setSubcomponent((WOComponent)wOComponent2.clone(), string2);
                }
                catch (Exception exception) {
                    throw new NSForwardException((Throwable)exception, "<" + this.getClass().getName() + "> Exception occurred while copying subcomponents: " + exception.toString());
                }
            }
        }
        return wOComponent;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this._name);
        objectOutputStream.writeUTF(this._templateName);
        objectOutputStream.writeBoolean(this._isPage);
        objectOutputStream.writeBoolean(this._caching);
        objectOutputStream.writeBoolean(this._isSynchronized);
        objectOutputStream.writeObject(this._subcomponents);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._name = objectInputStream.readUTF();
        this._templateName = objectInputStream.readUTF();
        this._isPage = objectInputStream.readBoolean();
        this._caching = objectInputStream.readBoolean();
        this._isSynchronized = objectInputStream.readBoolean();
        this._subcomponents = (NSMutableDictionary)objectInputStream.readObject();
    }

    public String toString() {
        return "<" + this.getClass().getName() + " name: " + this._name + " subcomponents: " + (this._subcomponents != null ? this._subcomponents.toString() : "null") + " >";
    }

    public String name() {
        return this._name;
    }

    public String path() {
        String string = null;
        WOComponentDefinition wOComponentDefinition = this._componentDefinition();
        if (wOComponentDefinition != null) {
            string = wOComponentDefinition.pathURL().getPath();
        }
        return string;
    }

    public URL pathURL() {
        URL uRL = null;
        WOComponentDefinition wOComponentDefinition = this._componentDefinition();
        if (wOComponentDefinition != null) {
            uRL = wOComponentDefinition.pathURL();
        }
        return uRL;
    }

    public String baseURL() {
        String string = null;
        WOComponentDefinition wOComponentDefinition = this._componentDefinition();
        if (wOComponentDefinition != null) {
            string = wOComponentDefinition.baseURL();
        }
        return string;
    }

    public String frameworkName() {
        String string = null;
        WOComponentDefinition wOComponentDefinition = this._componentDefinition();
        if (wOComponentDefinition != null) {
            string = wOComponentDefinition.frameworkName();
        }
        return string;
    }

    public void setCachingEnabled(boolean bl) {
        this._caching = bl;
    }

    public boolean isCachingEnabled() {
        return this._caching;
    }

    public void _setContext(WOContext wOContext) {
        this._context = wOContext;
    }

    public void _setIsPage(boolean bl) {
        this._isPage = bl;
    }

    public boolean _isPage() {
        return this._isPage;
    }

    public WOComponentDefinition _componentDefinition() {
        WOComponentDefinition wOComponentDefinition = null;
        if (this._componentDefinition != null) {
            wOComponentDefinition = this._componentDefinition;
        } else {
            NSArray nSArray = null;
            if (this._context != null) {
                nSArray = this._context._languages();
            }
            wOComponentDefinition = WOApplication.application()._componentDefinition(this._name, nSArray);
            if (this.isCachingEnabled()) {
                this._componentDefinition = wOComponentDefinition;
            }
        }
        return wOComponentDefinition;
    }

    public WOElement template() {
        WOElement wOElement = null;
        if (this._template != null) {
            wOElement = this._template;
        } else {
            wOElement = this.templateWithName(null);
            if (this.isCachingEnabled()) {
                this._template = wOElement;
            }
        }
        return wOElement;
    }

    public WOElement _childTemplate() {
        return this._childTemplate;
    }

    public void pullValuesFromParent() {
        if (this._isSynchronized && this._keyAssociations != null) {
            Enumeration enumeration = this._keyAssociations.keyEnumerator();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                WOAssociation wOAssociation = (WOAssociation)this._keyAssociations.objectForKey((Object)string);
                Object object = wOAssociation.valueInComponent(this._parent);
                this.takeValueForKey(object, string);
            }
        }
    }

    public void pushValuesToParent() {
        WOComponentDefinition wOComponentDefinition;
        if (this._isSynchronized) {
            this._doPushValuesUp();
        }
        if ((wOComponentDefinition = this._componentDefinition()).isStateless()) {
            this.reset();
            this._parent = null;
            this._session = null;
            this._context = null;
            wOComponentDefinition._checkInComponentInstance(this);
        }
    }

    private void _doPushValuesUp() {
        if (this._isSynchronized && this._keyAssociations != null) {
            Enumeration enumeration = this._keyAssociations.keyEnumerator();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                WOAssociation wOAssociation = (WOAssociation)this._keyAssociations.objectForKey((Object)string);
                if (!wOAssociation.isValueSettableInComponent(this)) continue;
                Object object = this.valueForKey(string);
                wOAssociation.setValue(object, this._parent);
            }
        }
    }

    public void _setParent(WOComponent wOComponent, NSMutableDictionary nSMutableDictionary, WOElement wOElement) {
        if (wOComponent != this._parent) {
            this._parent = wOComponent;
        }
        if (nSMutableDictionary != this._keyAssociations) {
            this._keyAssociations = nSMutableDictionary;
        }
        if (wOElement != this._childTemplate) {
            this._childTemplate = wOElement;
        }
    }

    public WOElement templateWithName(String string) {
        return this._componentDefinition().template();
    }

    private void _doSetSubcomponent(WOComponent wOComponent, String string) {
        if (wOComponent != null && string != null && string.length() != 0) {
            if (this._subcomponents == null) {
                this._subcomponents = new NSMutableDictionary();
            }
            this._subcomponents.setObjectForKey((Object)wOComponent, (Object)string);
        }
    }

    public void _setSubcomponent(WOComponent wOComponent, String string) {
        boolean bl = wOComponent._componentDefinition().isStateless();
        if (!bl) {
            boolean bl2 = this._componentDefinition().isStateless();
            if (bl2) {
                throw new IllegalStateException("<" + this.toString() + ">: A stateless component can not have a stateful child (" + wOComponent + ").");
            }
            this._doSetSubcomponent(wOComponent, string);
        }
    }

    public WOComponent _subcomponentForElementWithID(String string) {
        if (this._subcomponents != null && string != null) {
            return (WOComponent)this._subcomponents.objectForKey((Object)string);
        }
        return null;
    }

    public NSArray bindingKeys() {
        return this._keyAssociations.allKeys();
    }

    public WOAssociation _associationWithName(String string) {
        WOAssociation wOAssociation = null;
        if (this._keyAssociations != null) {
            wOAssociation = (WOAssociation)this._keyAssociations.objectForKey((Object)string);
        }
        return wOAssociation;
    }

    public boolean isStateless() {
        return false;
    }

    public void reset() {
    }

    public boolean synchronizesVariablesWithBindings() {
        boolean bl = !this.isStateless();
        return bl;
    }

    public Object valueForBinding(String string) {
        Object object = null;
        WOAssociation wOAssociation = this._associationWithName(string);
        object = wOAssociation == null ? null : wOAssociation.valueInComponent(this._parent);
        return object;
    }

    public void setValueForBinding(Object object, String string) {
        WOAssociation wOAssociation = this._associationWithName(string);
        if (wOAssociation == null) {
            return;
        }
        if (!wOAssociation.isValueSettableInComponent(this._parent)) {
            throw new IllegalStateException(this.toString() + ": Cannot set value for binding '" + string + "' -- corresponding association " + wOAssociation.toString() + " is not settable.");
        }
        wOAssociation.setValue(object, this._parent);
    }

    public boolean hasBinding(String string) {
        boolean bl;
        WOAssociation wOAssociation = this._associationWithName(string);
        boolean bl2 = bl = wOAssociation != null;
        if (bl) {
            bl = wOAssociation._hasBindingInParent(this._parent);
        }
        return bl;
    }

    public boolean canGetValueForBinding(String string) {
        return this.hasBinding(string);
    }

    public boolean canSetValueForBinding(String string) {
        WOAssociation wOAssociation = this._associationWithName(string);
        return wOAssociation != null && wOAssociation.isValueSettableInComponent(this._parent);
    }

    public void awake() {
    }

    public void _awakeInContext(WOContext wOContext) {
        Event event = null;
        Object var4_3 = null;
        Object var5_4 = null;
        this._setContext(wOContext);
        WOComponentDefinition wOComponentDefinition = this._componentDefinition();
        wOComponentDefinition.setCachingEnabled(this.isCachingEnabled());
        wOComponentDefinition.awake();
        if (this._subcomponents != null) {
            Enumeration enumeration = this._subcomponents.objectEnumerator();
            while (enumeration.hasMoreElements()) {
                WOComponent wOComponent = (WOComponent)enumeration.nextElement();
                wOComponent._awakeInContext(wOContext);
            }
        }
        this._session = null;
        event = this._markStartOfEventIfNeeded(AwakeEvent);
        this.awake();
        if (event != null) {
            EOEventCenter.markEndOfEvent((EOEvent)event);
        }
    }

    public void ensureAwakeInContext(WOContext wOContext) {
        if (this.context() != wOContext) {
            this._awakeInContext(wOContext);
        }
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        Event event = this._markStartOfEventIfNeeded(TakeValuesFromRequestEvent);
        WOElement wOElement = this.template();
        if (wOElement != null) {
            wOElement.takeValuesFromRequest(wORequest, wOContext);
        }
        if (event != null) {
            EOEventCenter.markEndOfEvent((EOEvent)event);
        }
    }

    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        Event event = this._markStartOfEventIfNeeded(InvokeActionForRequestEvent);
        WOElement wOElement = this.template();
        WOActionResults wOActionResults = null;
        if (wOElement != null) {
            wOActionResults = wOElement.invokeAction(wORequest, wOContext);
        }
        if (event != null) {
            EOEventCenter.markEndOfEvent((EOEvent)event);
        }
        return wOActionResults;
    }

    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        Event event = this._markStartOfEventIfNeeded(AppendToResponseEvent);
        WOComponent wOComponent = null;
        wOContext._setResponse(wOResponse);
        WOElement wOElement = this.template();
        if (wOElement != null) {
            if (this.parent() == null && wOContext.page() != this) {
                wOComponent = wOContext.component();
                wOContext._setCurrentComponent(this);
            }
            wOElement.appendToResponse(wOResponse, wOContext);
            if (wOComponent != null) {
                wOContext._setCurrentComponent(wOComponent);
            }
        }
        if (event != null) {
            EOEventCenter.markEndOfEvent((EOEvent)event);
        }
    }

    public void _sleepInContext(WOContext wOContext) {
        if (wOContext != null) {
            this._session = wOContext._session();
            WOComponentDefinition wOComponentDefinition = this._componentDefinition();
            if (wOComponentDefinition != null) {
                wOComponentDefinition.sleep();
            }
            Event event = this._markStartOfEventIfNeeded(SleepEvent);
            this.sleep();
            if (event != null) {
                EOEventCenter.markEndOfEvent((EOEvent)event);
            }
            this._setContext(null);
            if (this._subcomponents != null) {
                Enumeration enumeration = this._subcomponents.objectEnumerator();
                while (enumeration.hasMoreElements()) {
                    WOComponent wOComponent = (WOComponent)enumeration.nextElement();
                    wOComponent._sleepInContext(wOContext);
                }
            }
        }
    }

    public void sleep() {
    }

    public WOComponent parent() {
        return this._parent;
    }

    public WOActionResults performParentAction(String string) {
        WOActionResults wOActionResults;
        WOContext wOContext = this.context();
        wOContext._setCurrentComponent(this._parent);
        WOComponent wOComponent = this._parent;
        this.pushValuesToParent();
        this._parent = wOComponent;
        try {
            wOActionResults = (WOActionResults)this._parent.valueForKey(string);
        }
        catch (Exception exception) {
            throw new NSForwardException((Throwable)exception, this.toString() + "\n Exception in 'performParentAction(" + string + ")'. Parent: '" + this._parent.toString() + "'.\nOne of the following errors may have occurred:\n1. The parent does not have a method named '" + string + "'.\n2. An error occurred while executing the method '" + string + "'.\nPlease, read the following logs carefully and advise.\n" + exception.toString());
        }
        this.pullValuesFromParent();
        wOContext._setCurrentComponent(this);
        return wOActionResults;
    }

    public WOApplication application() {
        return WOApplication.application();
    }

    public WOContext context() {
        if (this._context == null && this._session != null && this._session.context() != null) {
            this._awakeInContext(this._session.context());
            this._context._takeAwakeComponent(this);
        }
        return this._context;
    }

    public boolean hasSession() {
        return this.context().hasSession();
    }

    public WOSession session() {
        WOSession wOSession = null;
        WOContext wOContext = this.context();
        if (wOContext != null) {
            wOSession = wOContext.session();
        }
        if (wOSession != null) {
            return wOSession;
        }
        return this._session;
    }

    public WOComponent pageWithName(String string) {
        return WOApplication.application().pageWithName(string, this.context());
    }

    public static void logString(String string) {
        NSLog.debug.appendln((Object)string);
    }

    public static void debugString(String string) {
        WOApplication.application().debugString(string);
    }

    public void validationFailedWithException(Throwable throwable, Object object, String string) {
        if (this.hasSession()) {
            this.session().validationFailedWithException(throwable, object, string, this);
        } else {
            WOApplication.application().validationFailedWithException(throwable, object, string, this, null);
        }
    }

    public Object validateValueForKey(Object object, String string) throws NSValidation.ValidationException {
        return NSValidation.DefaultImplementation.validateValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object validateTakeValueForKeyPath(Object object, String string) throws NSValidation.ValidationException {
        return NSValidation.DefaultImplementation.validateTakeValueForKeyPath((Object)this, (Object)object, (String)string);
    }

    public static WOElement templateWithHTMLString(String string, String string2, NSArray nSArray) {
        WOElement wOElement = null;
        Exception exception = null;
        try {
            wOElement = WOParser.templateWithHTMLAndDeclaration(string, string2, nSArray);
        }
        catch (WODeclarationFormatException wODeclarationFormatException) {
            exception = wODeclarationFormatException;
        }
        catch (WOHTMLFormatException wOHTMLFormatException) {
            exception = wOHTMLFormatException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        if (exception != null) {
            throw new NSForwardException((Throwable)exception, "Errors parsing template from HTML string '" + string + "', declarations string: '" + string2 + "':\n" + exception.toString());
        }
        return wOElement;
    }

    public String descriptionForResponse(WOResponse wOResponse, WOContext wOContext) {
        return this.name();
    }

    public WOResponse generateResponse() {
        return this._generateResponseInContext(this.context());
    }

    private WOResponse _generateResponseInContext(WOContext wOContext) {
        WOResponse wOResponse = WOApplication.application().createResponseInContext(wOContext);
        this._appendPageToResponse(wOResponse, wOContext);
        return wOResponse;
    }

    private void _appendPageToResponse(WOResponse wOResponse, WOContext wOContext) {
        WORequest wORequest = wOContext.request();
        if (wOContext == null) {
            throw new IllegalArgumentException(this.toString() + ": unable to generate a response with no context.");
        }
        wOContext.deleteAllElementIDComponents();
        wOResponse.setHTTPVersion(wORequest != null ? wORequest.httpVersion() : "HTTP/1.0");
        wOResponse.setHeader("text/html", "content-type");
        boolean bl = this != wOContext._pageElement();
        wOContext._setPageChanged(bl);
        if (bl) {
            wOContext._setPageElement(this);
        }
        wOContext._setCurrentComponent(this);
        this.appendToResponse(wOResponse, wOContext);
        WOSession wOSession = wOContext._session();
        if (wOSession != null) {
            wOSession._appendCookieToResponse(wOResponse);
            wOSession._saveCurrentPage();
        }
        wOContext._incrementContextID();
        wOContext.deleteAllElementIDComponents();
        wOContext._setPageChanged(true);
    }

    public Object _unroll() {
        return null;
    }

    public void set_unroll(Object object) {
    }

    public Object _componentUnroll() {
        return null;
    }

    public void set_componentUnroll(Object object) {
    }

    public boolean isEventLoggingEnabled() {
        WOComponent wOComponent = this.parent();
        return wOComponent == null || wOComponent.isEventLoggingEnabled();
    }

    private Event _markStartOfEventIfNeeded(String string) {
        Event event = null;
        if (_IsEventLoggingEnabled && this.isEventLoggingEnabled()) {
            event = (Event)EOEventCenter.newEventOfClass((Class)Event.class, (String)string);
            EOEventCenter.markStartOfEvent((EOEvent)event, (Object)this.name());
            event.setComponentName(this._name);
            if (this.context().page() != null) {
                if (this._isPage) {
                    event.setPageName(this._name);
                } else {
                    event.setPageName(this.context().page().name());
                }
            } else {
                WOComponent wOComponent;
                WOComponent wOComponent2 = null;
                if (wOComponent == null) {
                    event.setPageName(this._name);
                } else {
                    for (wOComponent = this.parent(); wOComponent != null; wOComponent = wOComponent.parent()) {
                        wOComponent2 = wOComponent;
                    }
                    event.setPageName(wOComponent2.name());
                }
            }
        }
        return event;
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        String string2 = _NSStringUtilities.capitalizedString((String)string);
        throw new NSKeyValueCoding.UnknownKeyException("[" + this.toString() + " valueForKey()]: lookup of unknown key: '" + string + "'.\nThis WOComponent does not have an instance variable of the name " + string + " or _" + string + ", nor a method of the name " + string + ", _" + string + ", get" + string2 + ", or _get" + string2, (Object)this, string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        String string2 = _NSStringUtilities.capitalizedString((String)string);
        throw new NSKeyValueCoding.UnknownKeyException("[" + this.toString() + " takeValueForKey()]: attempt to assign value to unknown key: '" + string + "'.\nThis WOComponent does not have an instance variable of the name " + string + " or _" + string + ", nor a method of the name set" + string2 + " or _set" + string2, (Object)this, string);
    }

    public void unableToSetNullForKey(String string) {
        throw new IllegalArgumentException("[" + this.toString() + " takeValueForKey()]: Failed to assign null to key '" + string + ".");
    }

    public Object valueForKeyPath(String string) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)string);
    }

    public void takeValueForKeyPath(Object object, String string) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)object, (String)string);
    }

    NSArray _subcomponents() {
        return this._subcomponents == null ? NSArray.EmptyArray : this._subcomponents.allValues();
    }

    static {
        block5: {
            block4: {
                _Extension = "wo";
                _ContextParameter = new Class[]{WOContext.class};
                try {
                    TheTemplateNameDictionary = new NSMutableDictionary();
                }
                catch (Exception exception) {
                    NSLog.err.appendln((Object)("<WOComponent> Exception during static initialization: " + exception.toString()));
                    if (!NSLog.debugLoggingAllowedForLevel((int)1)) break block4;
                    NSLog.debug.appendln((Throwable)exception);
                }
            }
            _IsEventLoggingEnabled = false;
            try {
                EOEventCenter.registerEventClass((Class)Event.class, (EOEventCenter.EventRecordingHandler)new _EventLoggingEnabler());
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<WOComponent> Exception during static initialization - registering WOComponent.Event: " + exception.toString()));
                if (!NSLog.debugLoggingAllowedForLevel((int)1)) break block5;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
    }

    public static class _EventLoggingEnabler
    implements EOEventCenter.EventRecordingHandler {
        public void setLoggingEnabled(boolean bl, Class clazz) {
            _IsEventLoggingEnabled = bl;
        }
    }

    public static class Event
    extends WOEvent {
        public String displayComponentName() {
            return super.displayComponentName();
        }

        public String comment() {
            return super.comment();
        }
    }
}

