/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOHttpIO;
import com.webobjects.appserver._private.WOLowercaseCharArray;
import com.webobjects.appserver._private.WOUrlConnection;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSSocketUtilities;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class WOHTTPConnection
implements NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSKeyValueCodingAdditions {
    private String _host;
    private int _port;
    protected WOHttpIO _httpIO;
    protected Socket _socket;
    private boolean _useUrlConnection;
    private WOUrlConnection _woUrlConnection;
    private int _responseCode = -1;
    private String _httpVersion;
    private boolean _followRedirects;
    private int _receiveTimeout = 30000;
    private int _sendTimeout = 10000;
    private int _readTimeout = 0;
    private boolean _keepAlive = true;
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_SEND_TIMEOUT = 10000;
    private static final int DEFAULT_RECEIVE_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 0;
    private static final String HTTP = "http";

    private void resetSendRequest() {
        this._responseCode = -1;
        this._httpVersion = null;
        this._followRedirects = true;
    }

    private void status() throws IOException {
        this._woUrlConnection.connect(5000000L);
        String string = this._woUrlConnection.httpUrlConnection().getHeaderField(0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 0;
        String[] stringArray = new String[2];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
            if (n != 2) continue;
        }
        try {
            this._httpVersion = stringArray[0];
            this._responseCode = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int responseCode() throws IOException {
        if (this._responseCode != -1) {
            return this._responseCode;
        }
        this.status();
        return this._responseCode;
    }

    private String httpVersion() throws IOException {
        if (this._httpVersion != null) {
            return this._httpVersion;
        }
        this.status();
        return this._httpVersion;
    }

    private void setResponseHeaders(WOResponse wOResponse, NSDictionary nSDictionary) {
        NSArray nSArray = nSDictionary.allKeys();
        for (int i = 0; i < nSArray.count(); ++i) {
            String string = (String)nSArray.objectAtIndex(i);
            wOResponse.appendHeaders((NSArray)nSDictionary.objectForKey((Object)string), string);
        }
    }

    private void getRequestProperties(WORequest wORequest) throws ProtocolException {
        HttpURLConnection httpURLConnection = this._woUrlConnection.httpUrlConnection();
        httpURLConnection.setRequestMethod(wORequest.method());
        HttpURLConnection.setFollowRedirects(this._followRedirects);
        NSDictionary nSDictionary = wORequest.headers();
        if (nSDictionary != null) {
            NSArray nSArray = nSDictionary.allKeys();
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                Object object = nSArray.objectAtIndex(i);
                NSArray nSArray2 = wORequest.headersForKey(object);
                int n2 = nSArray2.count();
                String string = null;
                string = object instanceof WOLowercaseCharArray ? ((WOLowercaseCharArray)object).toString() : (String)object;
                StringBuffer stringBuffer = new StringBuffer(100);
                if (n2 > 0) {
                    stringBuffer.append((String)nSArray2.objectAtIndex(0));
                    for (int j = 1; j < n2; ++j) {
                        stringBuffer.append(" , ");
                        stringBuffer.append((String)nSArray2.objectAtIndex(j));
                    }
                }
                httpURLConnection.setRequestProperty(string, stringBuffer.toString());
            }
        }
        httpURLConnection.setRequestProperty("connection", this._keepAlive ? "keep-alive" : "close");
    }

    public static void expectContentLengthHeader(boolean bl, int n) {
        WOHttpIO.expectContentLengthHeader(bl, n);
    }

    public WOHTTPConnection(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("WOHTTPConnection: host not specified during initialization.");
        }
        this._host = string;
        this._port = n;
        this.resetSendRequest();
    }

    public WOHTTPConnection(String string, int n, int n2) {
        this(string, n);
        this._sendTimeout = n2;
    }

    public void setReceiveTimeout(int n) {
        this._receiveTimeout = n;
    }

    public int receiveTimeout() {
        return this._receiveTimeout;
    }

    public boolean isConnected() {
        return true;
    }

    public void setReadTimeout(int n) {
        this._readTimeout = n;
    }

    public long readTimeout() {
        return this._readTimeout;
    }

    public void setSendTimeout(int n) {
        this._sendTimeout = n;
    }

    public int sendTimeout() {
        return this._sendTimeout;
    }

    public void setConnectTimeout(int n) {
        this._sendTimeout = n;
    }

    public int connectTimeout() {
        return this._sendTimeout;
    }

    public void setKeepAliveEnabled(boolean bl) {
        this._keepAlive = bl;
    }

    public boolean keepAliveEnabled() {
        return this._keepAlive;
    }

    public void setFollowRedirects(boolean bl) {
        this._followRedirects = bl;
    }

    public boolean followRedirects(boolean bl) {
        return this._followRedirects;
    }

    protected static Socket socketForHostAndPortAndTimeout(String string, int n, int n2) {
        Socket socket;
        try {
            socket = NSSocketUtilities.getSocketWithTimeout((String)string, (int)n, (int)n2);
        }
        catch (UnknownHostException unknownHostException) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)unknownHostException);
        }
        catch (IOException iOException) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)iOException);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean oldSendRequest(WORequest wORequest) {
        boolean bl = true;
        if (this._socket == null) {
            this._socket = WOHTTPConnection.socketForHostAndPortAndTimeout(this._host, this._port, this._sendTimeout);
            if (this._socket == null) {
                return false;
            }
        }
        this._httpIO = new WOHttpIO();
        try {
            this._httpIO.sendRequest(wORequest, this._socket);
        }
        catch (IOException iOException) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                    NSLog.err.appendln((Object)("<WOHTTPConnection>: Unable to close the socket:" + exception.getMessage()));
                    if (NSLog.allowedDebugLevel() > 1) {
                        NSLog.err.appendln((Throwable)exception);
                    }
                }
            }
            finally {
                bl = false;
            }
        }
        return bl;
    }

    public boolean sendRequest(WORequest wORequest) {
        String string = wORequest.httpVersion();
        wORequest._finalizeCookies();
        if ("HTTP/1.0".equals(string)) {
            this._useUrlConnection = false;
            return this.oldSendRequest(wORequest);
        }
        this._useUrlConnection = true;
        try {
            URL uRL = new URL(HTTP, this._host, this._port, wORequest.uri());
            this._woUrlConnection = new WOUrlConnection(uRL);
            this.getRequestProperties(wORequest);
            NSData nSData = wORequest.content();
            if (nSData == null || nSData.length() == 0) {
                this._woUrlConnection.send(this._sendTimeout, null);
            } else {
                this._woUrlConnection.send(this._sendTimeout, nSData.bytesNoCopy(new NSMutableRange()));
            }
        }
        catch (Exception exception) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                NSLog.err.appendln((Object)("<WOHTTPConnection>: send request failed : " + exception.getMessage()));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WOResponse oldReadResponse() {
        WOResponse wOResponse = null;
        if (this._httpIO == null) {
            this._httpIO = new WOHttpIO();
        }
        try {
            this._socket.setSoTimeout(this._receiveTimeout);
        }
        catch (SocketException socketException) {
            NSLog.err.appendln((Object)("<WOHTTPConnection>: Failed to setSoTimeout on Socket:" + socketException.getMessage()));
            throw new NSForwardException((Throwable)socketException);
        }
        try {
            wOResponse = this._httpIO.readResponseFromSocket(this._socket);
        }
        catch (IOException iOException) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                    NSLog.err.appendln((Object)("<WOHTTPConnection>: Unable to close the socket:" + exception.getMessage()));
                    if (NSLog.allowedDebugLevel() > 1) {
                        NSLog.err.appendln((Throwable)exception);
                    }
                }
            }
            finally {
                wOResponse = null;
            }
        }
        if (this._httpIO._socketClosed) {
            this._socket = null;
        }
        return wOResponse;
    }

    public WOResponse readResponse() {
        if (!this._useUrlConnection) {
            return this.oldReadResponse();
        }
        WOResponse wOResponse = null;
        try {
            NSData nSData = this._woUrlConnection.receive(this._receiveTimeout, this._readTimeout);
            WOApplication wOApplication = WOApplication.application();
            wOResponse = wOApplication != null ? wOApplication.createResponseInContext(null) : new WOResponse();
            wOResponse.setHTTPVersion(this.httpVersion());
            wOResponse.setStatus(this.responseCode());
            this.setResponseHeaders(wOResponse, this._woUrlConnection.responseHeaders());
            wOResponse.setContent(nSData);
        }
        catch (IOException iOException) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                NSLog.err.appendln((Object)("<WOHTTPConnection>: read response failed : " + iOException.getMessage()));
            }
            wOResponse = null;
        }
        return wOResponse;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" keepAliveEnabled=" + this._keepAlive);
        stringBuffer.append(" connectTimeout=" + this._sendTimeout);
        stringBuffer.append(" sendTimeout=" + this._sendTimeout);
        stringBuffer.append(" receiveTimeout=" + this._receiveTimeout);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)object, (String)string);
    }

    public void unableToSetNullForKey(String string) {
        NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)string);
    }

    public Object valueForKeyPath(String string) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)string);
    }

    public void takeValueForKeyPath(Object object, String string) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)object, (String)string);
    }
}

