/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOCookie;
import com.webobjects.appserver.WODOMParserException;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver._WOMessageHelper;
import com.webobjects.appserver._private.WOCaseInsensitiveDictionary;
import com.webobjects.appserver._private.WOHTTPHeadersDictionary;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class WOMessage
implements NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSKeyValueCodingAdditions {
    protected String _httpVersion = "HTTP/1.0";
    protected WOCaseInsensitiveDictionary _headers = null;
    protected NSMutableArray _cookies = null;
    protected String _contentEncoding = WOMessage.defaultEncoding();
    protected NSDictionary _userInfo = null;
    protected StringBuffer _content;
    protected NSMutableData _contentData;
    private static char[] TheHTMLAttributeReservedCharactersString = new char[]{'&', '\"', '\t', '\n', '\r', '<', '>'};
    private static String[] TheHTMLAttributeReservedEscapeSequences = new String[]{"&amp;", "&quot;", "&#9;", "&#10;", "&#13;", "&lt;", "&gt;"};
    private static char[] TheHTMLStringReservedCharactersString = new char[]{'&', '\"', '<', '>'};
    private static String[] TheHTMLStringReservedEscapeSequences = new String[]{"&amp;", "&quot;", "&lt;", "&gt;"};
    protected static String TheDefaultResponseEncoding = _NSUtilities.ISOLatin1StringEncoding;
    protected static String _TheSetCookieKey = "set-cookie";
    protected static String _TheCookieKey = "cookie";
    public static final int HTTP_STATUS_OK = 200;
    public static final int HTTP_STATUS_NO_CONTENT = 204;
    public static final int HTTP_STATUS_MOVED_PERMANENTLY = 301;
    public static final int HTTP_STATUS_FOUND = 302;
    public static final int HTTP_STATUS_FORBIDDEN = 403;
    public static final int HTTP_STATUS_NOT_FOUND = 404;
    public static final int HTTP_STATUS_INTERNAL_ERROR = 500;
    private int INIT_DATA_CAPACITY = 4096;

    public WOMessage() {
        this._initContent();
    }

    public static String defaultEncoding() {
        return TheDefaultResponseEncoding;
    }

    public static void setDefaultEncoding(String string) {
        if (string != null && !string.equals(TheDefaultResponseEncoding)) {
            try {
                byte[] byArray = "test".getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)unsupportedEncodingException);
            }
            TheDefaultResponseEncoding = string;
        }
    }

    public static void setDefaultURLEncoding(String string) {
        if (string != null && string != WOURLEncoder.WO_URL_ENCODING) {
            WOURLEncoder.WO_URL_ENCODING = string;
        }
    }

    public static String defaultURLEncoding() {
        return WOURLEncoder.WO_URL_ENCODING;
    }

    public Object clone() {
        WOMessage wOMessage = null;
        try {
            wOMessage = (WOMessage)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new NSForwardException((Throwable)exception, "<" + this.getClass().getName() + " Exception occurred while cloning: " + exception);
        }
        wOMessage.setHTTPVersion(this._httpVersion);
        wOMessage.setContentEncoding(this._contentEncoding);
        WOCaseInsensitiveDictionary wOCaseInsensitiveDictionary = wOMessage._headers = this._headers == null ? null : (WOCaseInsensitiveDictionary)((Object)this._headers.clone());
        if (this._content.length() != 0) {
            wOMessage.appendContentString(this._content.toString());
        } else if (this._contentData.length() != 0) {
            wOMessage.appendContentData((NSData)this._contentData);
        }
        wOMessage.setUserInfo(this._userInfo);
        return wOMessage;
    }

    public void setHTTPVersion(String string) {
        this._httpVersion = string;
    }

    public String httpVersion() {
        return this._httpVersion;
    }

    public void setUserInfo(NSDictionary nSDictionary) {
        this._userInfo = nSDictionary;
    }

    public NSDictionary userInfo() {
        return this._userInfo;
    }

    public void setHeaders(NSArray nSArray, String string) {
        this._setHeaders(string, nSArray);
    }

    public void setHeader(String string, String string2) {
        this._setHeader(string2, string);
    }

    public void appendHeader(String string, String string2) {
        NSMutableArray nSMutableArray = new NSMutableArray((Object)string);
        this.appendHeaders((NSArray)nSMutableArray, string2);
    }

    protected void _setHeaders(String string, NSArray nSArray) {
        this._initHeadersIfNull();
        if (nSArray instanceof NSMutableArray) {
            this._headers.setObjectForKey(nSArray, string);
        } else {
            this._headers.setObjectForKey(nSArray.mutableClone(), string);
        }
    }

    protected void _setHeader(String string, String string2) {
        NSMutableArray nSMutableArray = new NSMutableArray((Object)string2);
        this._setHeaders(string, (NSArray)nSMutableArray);
    }

    public void removeHeadersForKey(Object object) {
        if (this._headers != null) {
            this._headers.removeObjectForKey(object);
        }
    }

    public NSArray headerKeys() {
        return this._headers != null ? this._headers.allKeys() : null;
    }

    public NSArray headersForKey(Object object) {
        if (object == null || this._headers == null) {
            return null;
        }
        return (NSArray)this._headers.objectForKey(object);
    }

    public String headerForKey(Object object) {
        NSArray nSArray = this.headersForKey(object);
        if (nSArray != null && nSArray.count() != 0) {
            return nSArray.objectAtIndex(0).toString();
        }
        return null;
    }

    public NSDictionary headers() {
        return this._headers;
    }

    private void _initHeadersIfNull() {
        if (this._headers == null) {
            this.setHeaders(null);
        }
    }

    public void _finalizeCookies() {
        String string;
        boolean bl = this instanceof WORequest;
        String string2 = string = bl ? _TheCookieKey : _TheSetCookieKey;
        if (this.headersForKey(string) == null) {
            NSArray nSArray = this.cookies();
            int n = nSArray.count();
            NSMutableArray nSMutableArray = new NSMutableArray(n);
            for (int i = 0; i < n; ++i) {
                String string3 = ((WOCookie)nSArray.objectAtIndex(i))._headerString(bl);
                if (string3 != null) {
                    nSMutableArray.addObject((Object)string3);
                    continue;
                }
                nSMutableArray.addObject((Object)"Bozos live here!");
            }
            if (bl) {
                String string4 = nSMutableArray.componentsJoinedByString(";");
                nSMutableArray = new NSMutableArray((Object)string4);
            }
            this._setHeaders(string, (NSArray)nSMutableArray);
        }
    }

    public void setHeaders(NSDictionary nSDictionary) {
        if (nSDictionary == null) {
            this._headers = new WOCaseInsensitiveDictionary();
        } else if (nSDictionary instanceof WOHTTPHeadersDictionary) {
            this._headers = (WOHTTPHeadersDictionary)nSDictionary;
        } else {
            NSArray nSArray = nSDictionary.allKeys();
            int n = nSArray.count();
            this._headers = new WOCaseInsensitiveDictionary(n);
            for (int i = 0; i < n; ++i) {
                Object object = nSArray.objectAtIndex(i);
                Object object2 = nSDictionary.objectForKey(object);
                if (!(object2 instanceof NSMutableArray)) {
                    NSMutableArray nSMutableArray;
                    if (object2 instanceof NSArray) {
                        nSMutableArray = ((NSArray)object2).mutableClone();
                        this._headers.setObjectForKey(nSMutableArray, object);
                        continue;
                    }
                    nSMutableArray = new NSMutableArray((Object)object2.toString());
                    this._headers.setObjectForKey(nSMutableArray, object);
                    continue;
                }
                this._headers.setObjectForKey(object2, object);
            }
        }
    }

    public void appendHeaders(NSArray nSArray, String string) {
        this._initHeadersIfNull();
        Object object = this._headers.objectForKey(string);
        if (object != null) {
            if (!(object instanceof NSMutableArray)) {
                object = ((NSArray)object).mutableClone();
                this._headers.setObjectForKey(object, string);
            }
            NSMutableArray nSMutableArray = (NSMutableArray)object;
            for (int i = 0; i < nSArray.count(); ++i) {
                Object object2 = nSArray.objectAtIndex(i);
                if (nSMutableArray.containsObject(object2)) continue;
                nSMutableArray.addObject(object2);
            }
            object = nSMutableArray;
        } else if (nSArray instanceof NSMutableArray) {
            this._headers.setObjectForKey(nSArray, string);
        } else {
            NSMutableArray nSMutableArray = nSArray.mutableClone();
            this._headers.setObjectForKey(nSMutableArray, string);
        }
    }

    public void setContent(char[] cArray) {
        this._initContent();
        if (cArray != null) {
            this._content.append(cArray);
        }
    }

    public void setContent(NSData nSData) {
        this._initContent();
        this.appendContentData(nSData);
    }

    public void setContent(String string) {
        this._initContent();
        if (string != null) {
            this._content.append(string);
        }
    }

    public String contentString() {
        if (this._content == null || this._content.length() == 0) {
            return _NSStringUtilities.stringForBytes((byte[])this._contentData._bytesNoCopy(), (int)this._contentData._offset(), (int)this._contentData.length(), (String)this.contentEncoding());
        }
        return new String(this._content);
    }

    public NSData content() {
        byte[] byArray;
        if (this._content.length() == 0) {
            return this._contentData;
        }
        try {
            byArray = new String(this._content).getBytes(this.contentEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)unsupportedEncodingException);
        }
        return new NSData(byArray, new NSRange(0, byArray.length), true);
    }

    public String contentEncoding() {
        return this._contentEncoding;
    }

    public void setContentEncoding(String string) {
        if (string != null && !string.equals(this._contentEncoding)) {
            try {
                byte[] byArray = "test".getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)unsupportedEncodingException);
            }
            this._contentEncoding = string;
        }
    }

    private void _initContent() {
        this._content = new StringBuffer(this.INIT_DATA_CAPACITY);
        this._contentData = new NSMutableData(this.INIT_DATA_CAPACITY);
    }

    public void appendContentData(NSData nSData) {
        if (nSData != null && nSData.length() != 0) {
            if (this._content.length() == 0) {
                if (this._contentData.length() == 0) {
                    NSMutableRange nSMutableRange = new NSMutableRange();
                    byte[] byArray = nSData.bytesNoCopy(nSMutableRange);
                    this._contentData = new NSMutableData(byArray, (NSRange)nSMutableRange, true);
                } else {
                    this._contentData.appendData(nSData);
                }
            } else {
                this._content.append(_NSStringUtilities.stringForBytes((byte[])nSData._bytesNoCopy(), (int)nSData._offset(), (int)nSData.length(), (String)this.contentEncoding()));
            }
        }
    }

    public void _appendContentAsciiString(String string) {
        this._content.append(string);
    }

    public void appendContentCharacter(char c) {
        this._content.append(c);
    }

    public void appendContentString(String string) {
        this._content.append(string);
    }

    protected static boolean requiresHTMLEscaping(String string, char[] cArray) {
        int n = cArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (string.indexOf(cArray[i]) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void appendContentHTMLString(String string) {
        this._content.append(WOMessage.stringByEscapingHTMLString(string));
    }

    public void appendContentHTMLAttributeValue(String string) {
        this._content.append(WOMessage.stringByEscapingHTMLAttributeValue(string));
    }

    protected int _contentLength() {
        return this._content.length() == 0 ? this._contentData.length() : this._content.length();
    }

    public String toString() {
        return "<" + this.getClass().getName() + " httpVersion=" + this._httpVersion + " headers=" + (this._headers == null ? "null" : this._headers.toString()) + " content-length=" + (this._content.length() != 0 ? this._content.length() : this._contentData.length()) + " cookies=" + (this._cookies == null ? "null" : this._cookies.toString()) + " userInfo=" + (this._userInfo == null ? "null" : this._userInfo.toString()) + ">";
    }

    protected NSMutableArray _initCookies() {
        if (this._cookies == null) {
            this._cookies = new NSMutableArray();
        }
        return this._cookies;
    }

    public void addCookie(WOCookie wOCookie) {
        NSMutableArray nSMutableArray = this._initCookies();
        if (wOCookie != null) {
            nSMutableArray.addObject((Object)wOCookie);
        }
    }

    public void removeCookie(WOCookie wOCookie) {
        NSMutableArray nSMutableArray = this._initCookies();
        if (wOCookie != null) {
            nSMutableArray.removeObject((Object)wOCookie);
        }
    }

    public NSArray cookies() {
        NSMutableArray nSMutableArray = this._initCookies();
        return nSMutableArray;
    }

    protected static String _stringByEscapingString(String string, char[] cArray, String[] stringArray) {
        StringBuffer stringBuffer = null;
        if (string != null) {
            int n = string.length();
            int n2 = cArray.length;
            stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                int n3;
                char c = string.charAt(i);
                for (n3 = 0; n3 < n2 && c != cArray[n3]; ++n3) {
                }
                if (n3 < n2) {
                    stringBuffer.append(stringArray[n3]);
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        return new String(stringBuffer);
    }

    public static String stringByEscapingHTMLString(String string) {
        boolean bl;
        String string2 = string;
        if (string != null && string.length() != 0 && (bl = WOMessage.requiresHTMLEscaping(string, TheHTMLStringReservedCharactersString))) {
            string2 = WOMessage._stringByEscapingString(string, TheHTMLStringReservedCharactersString, TheHTMLStringReservedEscapeSequences);
        }
        return string2;
    }

    public static String stringByEscapingHTMLAttributeValue(String string) {
        boolean bl;
        String string2 = string;
        if (string != null && string.length() != 0 && (bl = WOMessage.requiresHTMLEscaping(string, TheHTMLAttributeReservedCharactersString))) {
            string2 = WOMessage._stringByEscapingString(string, TheHTMLAttributeReservedCharactersString, TheHTMLAttributeReservedEscapeSequences);
        }
        return string2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof WOMessage && (this._headers == null && ((WOMessage)object)._headers == null || this._headers.equals((Object)((WOMessage)object)._headers)) && this._contentData.equals((Object)((WOMessage)object)._contentData) && this._content.equals(((WOMessage)object)._content)) {
            bl = true;
        }
        return bl;
    }

    public Document contentAsDOMDocument() throws WODOMParserException {
        _WOMessageHelper _WOMessageHelper2 = new _WOMessageHelper(this);
        return _WOMessageHelper2.contentAsDOMDocument();
    }

    public void appendContentDOMDocumentFragment(DocumentFragment documentFragment) {
        _WOMessageHelper _WOMessageHelper2 = new _WOMessageHelper(this);
        _WOMessageHelper2.appendContentDOMDocumentFragment(documentFragment);
    }

    public void setContentDOMDocument(Document document) {
        _WOMessageHelper _WOMessageHelper2 = new _WOMessageHelper(this);
        _WOMessageHelper2.setContentDOMDocument(document);
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)object, (String)string);
    }

    public void unableToSetNullForKey(String string) {
        NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)string);
    }

    public Object valueForKeyPath(String string) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)string);
    }

    public void takeValueForKeyPath(Object object, String string) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)object, (String)string);
    }
}

