/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WORequest;
import com.webobjects.appserver._private.WOCaseInsensitiveDictionary;
import com.webobjects.appserver._private.WOFileUploadSupport;
import com.webobjects.appserver._private.WOHTTPHeaderValue;
import com.webobjects.appserver._private.WOHTTPHeadersDictionary;
import com.webobjects.appserver._private.WOHttpIO;
import com.webobjects.appserver._private.WOInputStreamData;
import com.webobjects.appserver._private.WONoCopyPushbackInputStream;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.LinkedList;

public class WOMultipartIterator {
    private LinkedList _formDataList;
    private LinkedList _formDataStack;
    private int _formDataIndex = 0;
    private int _nextFormDataIndex = 0;
    private boolean _closed = false;
    private boolean _isFirstFormData = true;
    boolean _prematureTermination = false;
    private String _boundary;
    private byte[] _separator;
    private WOCaseInsensitiveDictionary _multipartHeaders = new WOCaseInsensitiveDictionary();
    private WORequest _request;
    private WONoCopyPushbackInputStream _bis;
    static byte[] dashDash = WOFileUploadSupport._bytesWithAsciiString("--");
    static byte[] CRLF = WOFileUploadSupport._bytesWithAsciiString("\r\n");

    public WOMultipartIterator(WORequest wORequest) {
        WOInputStreamData wOInputStreamData;
        InputStream inputStream;
        this._request = wORequest;
        this._formDataList = new LinkedList();
        this._formDataStack = new LinkedList();
        NSArray nSArray = wORequest.headersForKey("content-type");
        int n = nSArray.count();
        for (int i = 0; i < n; ++i) {
            WOCaseInsensitiveDictionary wOCaseInsensitiveDictionary = WOFileUploadSupport._parseOneHeader((String)nSArray.objectAtIndex(i));
            this._multipartHeaders.addEntriesFromDictionary((NSDictionary)wOCaseInsensitiveDictionary);
        }
        this._boundary = (String)this._multipartHeaders.objectForKey("boundary");
        if (wORequest.content() instanceof WOInputStreamData && (inputStream = (wOInputStreamData = (WOInputStreamData)wORequest.content()).inputStream()) != null && inputStream instanceof WONoCopyPushbackInputStream) {
            this._bis = (WONoCopyPushbackInputStream)inputStream;
        }
        if (this._bis == null) {
            this._bis = new WONoCopyPushbackInputStream(wORequest.content().stream(), wORequest._contentLengthHeader());
        }
        this._initSeparator();
    }

    public String boundary() {
        return this._boundary;
    }

    public NSDictionary multipartHeaders() {
        return this._multipartHeaders;
    }

    protected void _initSeparator() {
        block8: {
            if (this._boundary == null) {
                try {
                    byte[] byArray = new byte[4];
                    int n = this._bis.read(byArray);
                    if (n == 4) {
                        int n2;
                        byte[] byArray2;
                        NSData nSData;
                        NSRange nSRange;
                        int n3 = 0;
                        if (byArray[0] == CRLF[0] && byArray[1] == CRLF[1]) {
                            n3 = 2;
                        }
                        if (byArray[n3] == dashDash[n3] && byArray[n3 + 1] == dashDash[n3 + 1] && (nSRange = WOFileUploadSupport._rangeOfData(nSData = new NSData(byArray2 = new byte[1024], new NSRange(0, n2 = this._bis.read(byArray2)), true), new NSData(CRLF))).length() > 0) {
                            this._boundary = _NSStringUtilities.stringForBytes((byte[])byArray2, (int)0, (int)nSRange.location(), (String)"US-ASCII");
                            this._bis.unread(byArray2, 0, n2);
                            NSLog.err.appendln((Object)("Missing multipart boundary parameter; using \"" + this._boundary + "\""));
                        }
                    }
                }
                catch (Exception exception) {
                    NSLog.err.appendln((Object)("Exception while attempting to find missing boundary string: " + exception));
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)4L)) break block8;
                    NSLog.err.appendln((Throwable)exception);
                }
            }
        }
        if (this._boundary != null) {
            this._separator = WOFileUploadSupport._bytesWithAsciiString("\r\n--" + this._boundary);
        }
        if (this._separator == null) {
            this._closed = true;
        }
    }

    public boolean didContentTerminatePrematurely() {
        return this._prematureTermination;
    }

    public int contentLengthRemaining() {
        return this._bis.theoreticallyAvailable();
    }

    public int _estimatedContentLength(int n, int n2) {
        int n3 = this._bis.originalReadMax();
        int n4 = this._separator.length + 4;
        int n5 = n * (n4 + 150) + n2 * (n4 + 50 + 10) + n4;
        return n3 - n5;
    }

    public WOFormData nextFormData() {
        WOFormData wOFormData = null;
        wOFormData = this._nextFormDataInList();
        if (wOFormData == null) {
            if (this._closed) {
                return null;
            }
            this._invalidateFormData(this._currentFormData());
            wOFormData = this._nextFormData();
            this._addFormData(wOFormData);
            ++this._nextFormDataIndex;
        }
        return wOFormData;
    }

    protected void _invalidateFormData(WOFormData wOFormData) {
        if (wOFormData != null) {
            wOFormData._invalidate();
        }
    }

    protected WOFormData _currentFormData() {
        WOFormData wOFormData;
        if (this._formDataList.size() > 0 && (wOFormData = (WOFormData)this._formDataList.getLast()) != null) {
            return wOFormData;
        }
        return null;
    }

    protected WOFormData _nextFormData() {
        if (this._closed) {
            return null;
        }
        WOFormData wOFormData = null;
        if (this._formDataStack.size() > 0) {
            wOFormData = (WOFormData)this._formDataStack.getFirst();
            this._formDataStack.removeFirst();
        } else {
            wOFormData = new WOFormData();
            if (wOFormData._isTheLast) {
                this._closed = true;
                wOFormData = null;
            } else {
                try {
                    if (wOFormData.isFileUpload()) {
                        wOFormData._legacyFormValues(this._request._formValues());
                    } else {
                        wOFormData._addToFormValues(this._request._formValues());
                    }
                }
                catch (IOException iOException) {
                    NSLog.err.appendln((Object)("Failed to create WOFormData: " + iOException));
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                        NSLog.err.appendln((Throwable)iOException);
                    }
                    this._closed = true;
                    wOFormData = null;
                }
            }
        }
        return wOFormData;
    }

    private WOFormData _nextFormDataInList() {
        int n = this._formDataList.size();
        if (n > 0 && n > this._nextFormDataIndex) {
            return (WOFormData)this._formDataList.get(this._nextFormDataIndex++);
        }
        return null;
    }

    protected void _pushFormData(WOFormData wOFormData) {
        if (wOFormData != null) {
            this._formDataStack.addFirst(wOFormData);
        }
    }

    protected void _addFormData(WOFormData wOFormData) {
        if (wOFormData != null) {
            this._formDataList.addLast(wOFormData);
        }
    }

    protected class _WOFormDataInputStream
    extends InputStream {
        private boolean _streamClosed = false;
        private int _offset = 0;
        private byte[] _oneByteArray = new byte[1];
        private byte[] _drainBuffer;
        private int _drainBufferLength = 4096;

        protected _WOFormDataInputStream() {
        }

        public int available() {
            if (this._streamClosed) {
                return -1;
            }
            return 0;
        }

        public void close() throws IOException {
            while (!this._streamClosed) {
                this.skip(Long.MAX_VALUE);
            }
        }

        public int read() throws IOException {
            int n = this.read(this._oneByteArray);
            if (n == -1) {
                return n;
            }
            return this._oneByteArray[0];
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new IllegalArgumentException("<" + this.getClass().getName() + ">: buffer passed is null!");
            }
            if (n2 == 0) {
                return 0;
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException("<" + this.getClass().getName() + ">: attempted to read " + n2 + " bytes into buffer of length " + byArray.length + " at offset " + n);
            }
            if (this._streamClosed) {
                return -1;
            }
            int n3 = 0;
            try {
                int n4 = 0;
                int n5 = WOMultipartIterator.this._separator.length;
                boolean bl = false;
                n3 = WOMultipartIterator.this._bis.read(byArray, n, n2);
                for (int i = 0; i < n3; ++i) {
                    int n6;
                    for (n4 = 0; i + n4 < n3 && n4 < n5 && byArray[n + i + n4] == WOMultipartIterator.this._separator[n4]; ++n4) {
                    }
                    if (n4 == n5) {
                        this._streamClosed = true;
                        int n7 = n3 - i - n5;
                        if (n7 > 0) {
                            byte[] byArray2 = new byte[n7];
                            System.arraycopy(byArray, i + n + n5, byArray2, 0, n7);
                            WOMultipartIterator.this._bis.unread(byArray2);
                        }
                        return i;
                    }
                    if (i + n4 != n3) continue;
                    byte[] byArray3 = new byte[n5 - n4];
                    int n8 = 0;
                    while ((n6 = WOMultipartIterator.this._bis.read(byArray3, n8, byArray3.length - n8)) != -1 && (n8 += n6) < byArray3.length) {
                    }
                    n6 = WOMultipartIterator.this._separator[n4];
                    int n9 = 0;
                    while (n9 < n8 && n4 < n5) {
                        if (byArray3[n9++] == WOMultipartIterator.this._separator[n4++]) continue;
                        WOMultipartIterator.this._bis.unread(byArray3, 0, n8);
                        return n3;
                    }
                    this._streamClosed = true;
                    if (n4 == n5) {
                        return i;
                    }
                    if (n9 != n8) continue;
                    return n3;
                }
            }
            catch (IOException iOException) {
                if (WOMultipartIterator.this._bis.wasPrematurelyTerminated()) {
                    WOMultipartIterator.this._closed = true;
                    WOMultipartIterator.this._prematureTermination = true;
                }
                throw iOException;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            if (this._drainBuffer == null) {
                this._drainBuffer = new byte[this._drainBufferLength];
            }
            int n = 0;
            try {
                for (long i = l; i > 0L; i -= (long)n) {
                    n = this.read(this._drainBuffer, 0, (int)(i > (long)this._drainBufferLength ? (long)this._drainBufferLength : i));
                    if (n != -1) continue;
                    this._streamClosed = true;
                    return l - i;
                }
            }
            catch (IOException iOException) {
                if (WOMultipartIterator.this._bis.wasPrematurelyTerminated()) {
                    WOMultipartIterator.this._closed = true;
                    WOMultipartIterator.this._prematureTermination = true;
                }
                throw iOException;
            }
            return l;
        }

        public boolean isClosed() {
            return this._streamClosed;
        }
    }

    public class WOFormData {
        NSDictionary _headers = null;
        _WOFormDataInputStream _fdstream;
        NSData _data;
        NSDictionary _cdHeaders = null;
        NSData _cdData;
        int _index = 0;
        boolean _isTheLast = false;
        boolean _isFileUpload = false;
        boolean _streamWasCalled = false;
        boolean _dataWasCalled = false;
        String _formValueString = null;

        protected WOFormData() {
            this._index = WOMultipartIterator.this._formDataIndex;
            WOMultipartIterator.this._formDataIndex++;
            this._initHeaders();
            WOMultipartIterator.this._isFirstFormData = false;
        }

        private void _initHeaders() {
            block13: {
                try {
                    int n;
                    WOHttpIO wOHttpIO = new WOHttpIO();
                    if (WOMultipartIterator.this._isFirstFormData) {
                        int n2 = 0;
                        for (n = 0; n2 == 0 && n < 5; ++n) {
                            n2 = wOHttpIO.readLine(WOMultipartIterator.this._bis);
                        }
                        if (n == 5) {
                            this._isTheLast = true;
                            return;
                        }
                    } else {
                        byte[] byArray = new byte[2];
                        n = WOMultipartIterator.this._bis.read(byArray);
                        if (n < 2 || byArray[0] == dashDash[0] && byArray[1] == dashDash[1]) {
                            this._isTheLast = true;
                            return;
                        }
                        if (byArray[0] != CRLF[0] || byArray[1] != CRLF[1]) {
                            if (byArray[0] == CRLF[1]) {
                                WOMultipartIterator.this._bis.unread(byArray, 1, 1);
                            } else {
                                WOMultipartIterator.this._bis.unread(byArray);
                            }
                        }
                    }
                    wOHttpIO._readHeaders(WOMultipartIterator.this._bis, false, false, true);
                    this._headers = wOHttpIO.headers();
                    WOHTTPHeadersDictionary wOHTTPHeadersDictionary = (WOHTTPHeadersDictionary)this._headers;
                    WOCaseInsensitiveDictionary wOCaseInsensitiveDictionary = null;
                    NSArray nSArray = (NSArray)wOHTTPHeadersDictionary._realObjectForKey("content-disposition");
                    NSMutableArray nSMutableArray = new NSMutableArray(1);
                    if (nSArray != null && nSArray.count() > 0) {
                        if (nSArray.objectAtIndex(0) instanceof WOHTTPHeaderValue) {
                            NSData nSData = ((WOHTTPHeaderValue)nSArray.objectAtIndex(0))._data();
                            wOCaseInsensitiveDictionary = WOFileUploadSupport._parseContentDispositionHeader(WOMultipartIterator.this._request, null, wOHTTPHeadersDictionary, null, nSData);
                        }
                        nSArray = (NSArray)wOHTTPHeadersDictionary.objectForKey("content-disposition");
                        if (wOCaseInsensitiveDictionary == null) {
                            wOCaseInsensitiveDictionary = WOFileUploadSupport._parseOneHeader((String)nSArray.objectAtIndex(0));
                        }
                        this._cdHeaders = wOCaseInsensitiveDictionary;
                        wOHTTPHeadersDictionary.setObjectForKey(new NSArray((Object)wOCaseInsensitiveDictionary), "content-disposition");
                        this._isFileUpload = this._cdHeaders.objectForKey((Object)"filename") != null;
                    }
                }
                catch (IOException iOException) {
                    NSLog.err.appendln((Object)("Failed to create WOFormData " + iOException));
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) break block13;
                    NSLog.err.appendln((Throwable)iOException);
                }
            }
        }

        public boolean isFileUpload() {
            return this._isFileUpload;
        }

        public NSDictionary headers() {
            return this._headers;
        }

        public NSDictionary contentDispositionHeaders() {
            return this._cdHeaders;
        }

        public String name() {
            return (String)this._cdHeaders.objectForKey((Object)"name");
        }

        public InputStream formDataInputStream() {
            if (this._isTheLast) {
                return null;
            }
            if (this._dataWasCalled) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
                    NSLog.debug.appendln((Object)"<WOFormData>: formDataInputStream() called after accessing formData()");
                }
                return null;
            }
            this._streamWasCalled = true;
            if (this._fdstream == null) {
                this._fdstream = new _WOFormDataInputStream();
            }
            return this._fdstream;
        }

        public NSData formData() throws IOException {
            return this.formData(4096);
        }

        public NSData formData(int n) throws IOException {
            if (this._isTheLast) {
                return null;
            }
            if (this._streamWasCalled) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
                    NSLog.debug.appendln((Object)"<WOFormData>: formData() called after accessing formDataInputStream()");
                }
                return null;
            }
            this._dataWasCalled = true;
            if (this._data == null) {
                this._fdstream = new _WOFormDataInputStream();
                this._data = new NSData((InputStream)this._fdstream, n);
            }
            return this._data;
        }

        public boolean isStreamAvailable() {
            return !this._dataWasCalled;
        }

        public String formValue() throws IOException {
            if (this._formValueString == null) {
                this._formValueString = WOFileUploadSupport._getFormValuesFromData(WOMultipartIterator.this._request, null, this.formData(), this.name());
            }
            return this._formValueString;
        }

        protected void _addToFormValues(NSMutableDictionary nSMutableDictionary) throws IOException {
            WOFileUploadSupport._getFormValuesFromData(WOMultipartIterator.this._request, nSMutableDictionary, this.formData(), this.name());
        }

        protected void _legacyFormValues(NSMutableDictionary nSMutableDictionary) throws IOException {
            String string = (String)this._cdHeaders.objectForKey((Object)"name");
            if (string != null) {
                NSMutableArray nSMutableArray;
                String string2;
                String string3 = (String)this._cdHeaders.objectForKey((Object)"filename");
                if (string3 != null) {
                    string2 = string + "." + "filename";
                    nSMutableArray = (NSMutableArray)nSMutableDictionary.objectForKey((Object)string2);
                    if (nSMutableArray != null) {
                        nSMutableArray.addObject((Object)string3);
                    } else {
                        nSMutableDictionary.setObjectForKey((Object)new NSMutableArray((Object)string3), (Object)string2);
                    }
                }
                String string4 = null;
                NSArray nSArray = (NSArray)this._headers.objectForKey((Object)"content-type");
                if (nSArray != null && nSArray.count() > 0) {
                    string4 = (String)nSArray.objectAtIndex(0);
                }
                if (string4 != null) {
                    string2 = string + "." + "mimetype";
                    nSMutableArray = (NSMutableArray)nSMutableDictionary.objectForKey((Object)string2);
                    if (nSMutableArray != null) {
                        nSMutableArray.addObject((Object)string4);
                    } else {
                        nSMutableDictionary.setObjectForKey((Object)new NSMutableArray((Object)string4), (Object)string2);
                    }
                }
                nSMutableArray = (NSMutableArray)nSMutableDictionary.objectForKey((Object)string);
                InputStream inputStream = this.formDataInputStream();
                WOInputStreamData wOInputStreamData = new WOInputStreamData(inputStream, 0);
                if (nSMutableArray != null) {
                    nSMutableArray.addObject((Object)wOInputStreamData);
                } else {
                    nSMutableDictionary.setObjectForKey((Object)new NSMutableArray((Object)wOInputStreamData), (Object)string);
                }
            }
        }

        public Number numericFormValue(NSNumberFormatter nSNumberFormatter) throws IOException {
            Number number;
            block3: {
                String string = this.formValue();
                number = null;
                if (string != null && nSNumberFormatter != null) {
                    try {
                        number = (Number)nSNumberFormatter.parseObject(string);
                    }
                    catch (ParseException parseException) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)128L)) break block3;
                        NSLog.err.appendln((Throwable)parseException);
                    }
                }
            }
            return number;
        }

        public NSTimestamp dateFormValue(NSTimestampFormatter nSTimestampFormatter) throws IOException {
            NSTimestamp nSTimestamp;
            block3: {
                String string = this.formValue();
                nSTimestamp = null;
                if (string != null && nSTimestampFormatter != null) {
                    try {
                        nSTimestamp = (NSTimestamp)nSTimestampFormatter.parseObject(string);
                    }
                    catch (ParseException parseException) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)128L)) break block3;
                        NSLog.err.appendln((Throwable)parseException);
                    }
                }
            }
            return nSTimestamp;
        }

        private void _invalidate() {
            block7: {
                if (this._isFileUpload || this._streamWasCalled) {
                    if (this._fdstream == null) {
                        this._fdstream = new _WOFormDataInputStream();
                    }
                    try {
                        this._fdstream.close();
                    }
                    catch (IOException iOException) {
                        NSLog.err.appendln((Object)("WOFormData failed to skip past data: " + iOException));
                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                            NSLog.err.appendln((Throwable)iOException);
                        }
                        break block7;
                    }
                }
                try {
                    this.formData();
                }
                catch (IOException iOException) {
                    NSLog.err.appendln((Object)("WOFormData failed to read data: " + iOException));
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) break block7;
                    NSLog.err.appendln((Throwable)iOException);
                }
            }
        }

        public boolean isStreamValid() {
            if (this._fdstream != null) {
                return !this._fdstream.isClosed();
            }
            return false;
        }

        public String toString() {
            if (this._isTheLast) {
                return "<WOFormData>: This WOFormData represents the end of the multipart form data";
            }
            return "WOFormData " + this._index + " isStreamValid " + this.isStreamValid() + " headers: " + this._headers;
        }
    }
}

