/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOCookie;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver._private.WOShared;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;
import java.io.InputStream;

public class WOResponse
extends WOMessage
implements WOActionResults,
Cloneable {
    protected InputStream _contentInputStream;
    protected int _contentInputStreamBufferSize;
    protected int _contentInputStreamLength;
    private int _status = 200;
    private boolean _isClientCachingDisabled = false;
    private static NSMutableArray cacheControlHeaders;
    private static NSTimestamp _disableCacheDate;
    private static String _disableCacheDateString;
    static String TheLoadAverageKey;
    static String TheRefuseSessionsKey;

    public void disableClientCaching() {
        if (!this._isClientCachingDisabled) {
            this.setHeader(_disableCacheDateString, "date");
            this.setHeader(_disableCacheDateString, "expires");
            this.setHeader("no-cache", "pragma");
            if (WOApplication.application()._allowsCacheControlHeader()) {
                this.setHeaders((NSArray)cacheControlHeaders, "cache-control");
            }
            this._isClientCachingDisabled = true;
        }
    }

    public boolean _isClientCachingDisabled() {
        return this._isClientCachingDisabled;
    }

    public Object clone() {
        WOResponse wOResponse = (WOResponse)super.clone();
        wOResponse.setStatus(this._status);
        return wOResponse;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " (" + super.toString() + ") status=" + this._status + ">";
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public int status() {
        return this._status;
    }

    public void _finalizeInContext(WOContext wOContext) {
        NSArray nSArray;
        String string;
        int n;
        WOApplication wOApplication = WOApplication.application();
        this._finalizeCookies();
        NSArray nSArray2 = this.headersForKey(TheLoadAverageKey);
        if (nSArray2 == null) {
            n = wOApplication.activeSessionsCount();
            string = WOShared.unsignedIntString(n);
            nSArray2 = new NSArray((Object)string);
            this.setHeaders(nSArray2, TheLoadAverageKey);
        }
        if (wOApplication.isRefusingNewSessions() && (nSArray = this.headersForKey(TheRefuseSessionsKey)) == null) {
            nSArray = new NSArray((Object)wOApplication._refuseNewSessionsTime().toString());
            this.setHeaders(nSArray, TheRefuseSessionsKey);
        }
        if (wOContext != null) {
            WORequest wORequest;
            if (!wOApplication.licensingAllowsMultipleInstances() && (wORequest = wOContext.request()) != null && wORequest.applicationNumber() > 1) {
                string = "Attempt to access application in a way not permitted by licensing (instance id is greater than 1).";
                NSLog.err.appendln((Object)string);
                this.setContent("<html><body><strong>" + string + "</strong></body></html>");
            }
        }
        n = 0;
        n = this._content != null ? this._content.length() : this._contentData.length();
        if (n != 0) {
            this._setHeader("content-length", WOShared.unsignedIntString(n));
        }
    }

    public void _appendTagAttributeAndValue(String string, String string2, boolean bl) {
        this._content.append(' ');
        this._content.append(string);
        this._content.append("=\"");
        if (bl) {
            this._content.append(WOResponse.stringByEscapingHTMLAttributeValue(string2));
        } else {
            this._content.append(string2);
        }
        this._content.append('\"');
    }

    public static void _redirectResponse(WOResponse wOResponse, String string, String string2) {
        WOApplication wOApplication = WOApplication.application();
        wOApplication.debugString("!!! Request will be REDIRECTED to non-refusing instance <" + string + ">");
        wOResponse.appendContentString(string2);
        wOResponse.setStatus(302);
        wOResponse.setHeader(string, "Location");
        wOResponse.setHeader("YES", "x-webobjects-refusing-redirection");
    }

    public WOResponse generateResponse() {
        return this;
    }

    public static WOResponse _redirectionResponseForAbsoluteURL(String string, boolean bl) {
        WOApplication wOApplication = WOApplication.application();
        WOResponse wOResponse = wOApplication.createResponseInContext(null);
        String string2 = null;
        wOResponse.setHeader(string, "location");
        wOResponse.setHeader("text/html", "content-type");
        if (bl) {
            wOResponse.setStatus(301);
        } else {
            wOResponse.setStatus(302);
        }
        string2 = bl ? "This URL has been moved to <a HREF=\"" + string + "\">" + string + "</a>" : "This URL has been moved temporarily to <a HREF=\"" + string + "\">" + string + "</a>";
        wOResponse.appendContentHTMLString(string2);
        return wOResponse;
    }

    public void setContentStream(InputStream inputStream, int n, int n2) {
        this._contentInputStream = inputStream;
        if (n < 1) {
            n = 4096;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this._contentInputStreamBufferSize = n;
        this._contentInputStreamLength = n2;
    }

    public InputStream contentInputStream() {
        return this._contentInputStream;
    }

    public int contentInputStreamBufferSize() {
        return this._contentInputStreamBufferSize;
    }

    public int contentInputStreamLength() {
        return this._contentInputStreamLength;
    }

    static {
        block2: {
            TheLoadAverageKey = "x-webobjects-loadaverage";
            TheRefuseSessionsKey = "x-webobjects-refusenewsessions";
            try {
                cacheControlHeaders = new NSMutableArray(new Object[]{"private", "no-cache", "no-store", "must-revalidate", "max-age=0"});
                _disableCacheDateString = WOCookie.TheDateFormat.format((Object)new NSTimestamp());
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<WOResponse> Exception during static initialization: " + exception.toString()));
                if (!NSLog.debugLoggingAllowedForLevel((int)1)) break block2;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
    }
}

