/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAction;
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver.WOStatisticsStore;
import com.webobjects.appserver._private.WOBundle;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation._NSUtilities;
import java.lang.reflect.InvocationTargetException;

public abstract class WOActionRequestHandler
extends WORequestHandler {
    protected String actionClassName = this.defaultActionClassName();
    protected String defaultActionName = this.defaultDefaultActionName();
    protected boolean shouldAddToStatistics = this.defaultShouldAddToStatistics();
    protected Class actionClassClass;
    public static final String INSTANTIATION = "InstantiationError";
    public static final String INVOCATION = "InvocationError";
    public static final String CLASS_NOT_FOUND = "ClassNotFoundError";
    public static final String INVALID_PATH = "InvalidPathError";

    protected abstract String defaultActionClassName();

    protected String defaultDefaultActionName() {
        return "default";
    }

    protected boolean defaultShouldAddToStatistics() {
        return true;
    }

    public static Class _actionClassForName(String string) {
        Class clazz = WOBundle.lookForClassInAllBundles(string);
        if (clazz == null) {
            return clazz;
        }
        if (clazz == WOAction.class || clazz == WODirectAction.class || !WOAction.class.isAssignableFrom(clazz)) {
            clazz = null;
        }
        return clazz;
    }

    public static WORequestHandler handler() {
        throw new UnsupportedOperationException("handler must be called on a subclass of WOActionRequestHandler");
    }

    protected WOActionRequestHandler() {
    }

    public WOActionRequestHandler(String string, String string2, boolean bl) {
        this();
        if (string != null) {
            this.actionClassName = string;
            this.actionClassClass = WOActionRequestHandler._actionClassForName(string);
        }
        if (string2 != null) {
            this.defaultActionName = string2;
        }
        this.shouldAddToStatistics = bl;
    }

    public abstract WOResponse nullResponse();

    public abstract void registerWillHandleActionRequest();

    public abstract void registerDidHandleActionRequestWithActionNamed(String var1);

    protected boolean isSessionIDInRequest(WORequest wORequest) {
        return wORequest.isSessionIDInRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse handleRequest(WORequest wORequest) {
        WOResponse wOResponse = null;
        WOApplication wOApplication = WOApplication.application();
        if (wOApplication.isRefusingNewSessions() && !this.isSessionIDInRequest(wORequest) && wORequest.isUsingWebServer()) {
            wOResponse = this.generateRequestRefusal(wORequest);
        } else {
            Object object = wOApplication.requestHandlingLock();
            if (object != null) {
                Object object2 = object;
                synchronized (object2) {
                    wOResponse = this._handleRequest(wORequest);
                }
            } else {
                wOResponse = this._handleRequest(wORequest);
            }
        }
        if (wOResponse == null) {
            wOResponse = this.nullResponse();
        }
        return wOResponse;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" actionClassName=" + this.actionClassName);
        stringBuffer.append(" defaultActionName=" + this.defaultActionName);
        stringBuffer.append(" shouldAddToStatistics=" + this.shouldAddToStatistics);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public WOAction getActionInstance(Class clazz, Class[] classArray, Object[] objectArray) {
        return (WOAction)_NSUtilities.instantiateObject((Class)clazz, (Class[])classArray, (Object[])objectArray, (boolean)true, (boolean)WOApplication.application().isDebuggingEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse _handleRequest(WORequest wORequest) {
        WOApplication wOApplication = WOApplication.application();
        WOResponse wOResponse = null;
        String string = null;
        String string2 = null;
        Class clazz = null;
        WOContext wOContext = null;
        WOAction wOAction = null;
        WOActionResults wOActionResults = null;
        WOStatisticsStore wOStatisticsStore = wOApplication.statisticsStore();
        boolean bl = false;
        Class[] classArray = new Class[]{WORequest.class};
        Object[] objectArray = new Object[]{wORequest};
        if (wOStatisticsStore != null && this.shouldAddToStatistics) {
            this.registerWillHandleActionRequest();
        }
        try {
            wOApplication.awake();
            NSArray nSArray = this.getRequestHandlerPathForRequest(wORequest);
            int n = 0;
            if (nSArray != null) {
                n = nSArray.count();
            }
            Object[] objectArray2 = null;
            try {
                objectArray2 = this.getRequestActionClassAndNameForPath(nSArray);
            }
            catch (Exception exception) {
                wOResponse = wOApplication.handleActionRequestError(wORequest, exception, INVALID_PATH, this, string, string2, clazz, wOAction);
                throw exception;
            }
            string = (String)objectArray2[0];
            string2 = (String)objectArray2[1];
            clazz = (Class)objectArray2[2];
            if (clazz != null) {
                try {
                    wOAction = this.getActionInstance(clazz, classArray, objectArray);
                }
                catch (Exception exception) {
                    wOResponse = wOApplication.handleActionRequestError(wORequest, exception, INSTANTIATION, this, string, string2, clazz, wOAction);
                    throw exception;
                }
                try {
                    wOActionResults = wOAction.performActionNamed(string2);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = NSForwardException._originalThrowable((Throwable)throwable);
                    InvocationTargetException invocationTargetException = null;
                    invocationTargetException = throwable2 instanceof InvocationTargetException ? (InvocationTargetException)throwable2 : new InvocationTargetException(throwable2);
                    wOResponse = wOApplication.handleActionRequestError(wORequest, invocationTargetException, INVOCATION, this, string, string2, clazz, wOAction);
                    throw invocationTargetException;
                }
                if (wOActionResults != null) {
                    wOResponse = wOActionResults.generateResponse();
                }
            } else {
                IllegalStateException illegalStateException = new IllegalStateException("<" + this.getClass().getName() + "> Couldn't locate action class named '" + string + "'.");
                wOResponse = wOApplication.handleActionRequestError(wORequest, illegalStateException, CLASS_NOT_FOUND, this, string, string2, clazz, wOAction);
                throw illegalStateException;
            }
            wOContext = wOAction.context();
            NSNotificationCenter.defaultCenter().postNotification(WORequestHandler.DidHandleRequestNotification, (Object)wOContext);
            this._setRecordingHeadersForRequestInContext(wORequest, wOResponse, wOContext);
            if (wOContext != null) {
                this._putComponentsToSleepInContext(wOContext);
                bl = wOContext.hasSession();
                wOApplication.saveSessionForContext(wOContext);
            }
            wOApplication.sleep();
        }
        catch (Exception exception) {
            try {
                if (wOResponse == null) {
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                        NSLog.err.appendln((Object)("<" + this.getClass().getName() + ">: Exception while handling action named \"" + string2 + "\" on action class \"" + string + "\" :" + exception.toString()));
                        if (NSLog.allowedDebugLevel() > 1) {
                            NSLog.debug.appendln((Throwable)exception);
                        }
                    }
                    try {
                        if (wOAction != null) {
                            wOContext = wOAction.context();
                        }
                        if (wOContext == null) {
                            wOContext = wOApplication.createContextForRequest(wORequest);
                            if (wOAction != null) {
                                wOAction.initializeRequestSessionIDInContext(wOContext);
                            }
                        }
                        wOResponse = this.generateErrorResponse(exception, wOContext);
                    }
                    catch (Exception exception2) {
                        throw new NSForwardException((Throwable)exception2, "<" + this.getClass().getName() + ">: Exception while trying to generate an error response: " + exception2.toString());
                    }
                }
                if (wOContext != null) {
                    this._putComponentsToSleepInContext(wOContext);
                    bl = wOContext.hasSession();
                    wOApplication.saveSessionForContext(wOContext);
                }
                wOApplication.sleep();
            }
            catch (Throwable throwable) {
                if (wOContext != null) {
                    this._putComponentsToSleepInContext(wOContext);
                    bl = wOContext.hasSession();
                    wOApplication.saveSessionForContext(wOContext);
                }
                wOApplication.sleep();
                throw throwable;
            }
        }
        if (wOStatisticsStore != null && this.shouldAddToStatistics) {
            this.registerDidHandleActionRequestWithActionNamed(string2);
        }
        if (wOResponse != null) {
            wOResponse._finalizeInContext(wOContext);
            if (bl && wOApplication.isPageRefreshOnBacktrackEnabled()) {
                wOResponse.disableClientCaching();
            }
        }
        return wOResponse;
    }

    public abstract NSArray getRequestHandlerPathForRequest(WORequest var1);

    public Object[] getRequestActionClassAndNameForPath(NSArray nSArray) {
        Object[] objectArray = new Object[3];
        String string = null;
        String string2 = null;
        Class clazz = null;
        NSMutableArray nSMutableArray = null;
        nSMutableArray = nSArray == null ? new NSMutableArray() : new NSMutableArray(nSArray);
        while ("".equals(nSMutableArray.lastObject())) {
            nSMutableArray.removeLastObject();
        }
        int n = nSMutableArray.count();
        if (n == 2) {
            string = (String)nSMutableArray.objectAtIndex(0);
            string2 = (String)nSMutableArray.lastObject();
            clazz = string.equals(this.actionClassName) ? this.actionClassClass : WOActionRequestHandler._actionClassForName(string);
        } else if (n == 1) {
            String string3 = (String)nSMutableArray.objectAtIndex(0);
            if (WODirectAction._isActionOnClass(string3, this.actionClassClass)) {
                string2 = string3;
                clazz = this.actionClassClass;
            } else {
                clazz = WOActionRequestHandler._actionClassForName(string3);
                if (clazz != null) {
                    string2 = this.defaultActionName;
                } else {
                    string2 = string3;
                    clazz = this.actionClassClass;
                }
            }
        } else if (n == 0) {
            clazz = this.actionClassClass;
            string2 = this.defaultActionName;
        } else {
            throw new IllegalStateException("<" + this.getClass().getName() + "> Direct Action type URL '" + nSMutableArray + "' doesn't contain direct action class and/or action name.");
        }
        objectArray[0] = string;
        objectArray[1] = string2;
        objectArray[2] = clazz;
        return objectArray;
    }

    public void _putComponentsToSleepInContext(WOContext wOContext) {
        wOContext._putAwakeComponentsToSleep();
    }

    private void _setRecordingHeadersForRequestInContext(WORequest wORequest, WOResponse wOResponse, WOContext wOContext) {
        if (wORequest.headerForKey("x-webobjects-recording") != null || WOApplication.application().recordingPath() != null) {
            String string = null;
            WOSession wOSession = null;
            if (wOContext.hasSession()) {
                wOSession = wOContext.session();
                string = wOSession.sessionID();
            } else {
                string = wORequest.sessionID();
            }
            if (string != null) {
                wOResponse.setHeader(string, "x-webobjects-session-id");
            }
            if (wOSession != null) {
                if (wOSession.storesIDsInURLs()) {
                    wOResponse.setHeader("yes", "x-webobjects-ids-url");
                }
                if (wOSession.storesIDsInCookies()) {
                    wOResponse.setHeader("yes", "x-webobjects-ids-cookie");
                }
            }
            wOResponse.setHeader(Integer.toString(wORequest.applicationNumber()), "x-webobjects-application-number");
        }
    }

    public abstract WOResponse generateRequestRefusal(WORequest var1);

    public abstract WOResponse generateErrorResponse(Exception var1, WOContext var2);
}

