/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver._private.WOGeometricRegion;
import com.webobjects.appserver._private.WOPoint;
import com.webobjects.foundation.NSMutableArray;

public class WOCircularRegion
extends WOGeometricRegion {
    WOPoint _origin;
    WOPoint _edgePoint;

    public WOCircularRegion(String string, NSMutableArray nSMutableArray, String string2) {
        super(string, nSMutableArray, string2);
        if (null == nSMutableArray) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + ">: The coordinates received are in an invalid state. There might be a problem with the imagemap file.");
        }
        if (nSMutableArray.count() != 2) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + ">: Expected 2 coordinates for defining the circular region. Received: " + nSMutableArray.toString());
        }
        this._origin = new WOPoint((String)nSMutableArray.objectAtIndex(0));
        this._edgePoint = new WOPoint((String)nSMutableArray.lastObject());
    }

    public boolean hitTest(int n, int n2) {
        int n3 = this._origin.y - n2;
        int n4 = this._origin.x - n;
        int n5 = n3 * n3 + n4 * n4;
        int n6 = this._origin.y - this._edgePoint.y;
        int n7 = this._origin.x - this._edgePoint.x;
        int n8 = n6 * n6 + n7 * n7;
        return n5 <= n8;
    }

    protected String _subclassDescription() {
        return "[circular region origin=(" + this._origin.x + "," + this._origin.y + ") edgePoint=(" + this._edgePoint.x + "," + this._edgePoint.y + ")]";
    }
}

