/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOHTMLDynamicElement;
import com.webobjects.appserver._private.WOStaticURLUtilities;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSStringUtilities;
import java.net.URL;

public abstract class WOClientSideScript
extends WOHTMLDynamicElement {
    WOAssociation _scriptFile;
    WOAssociation _scriptString;
    WOAssociation _scriptSource;
    WOAssociation _hideInComment;
    WOAssociation _language;

    public WOClientSideScript(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super("SCRIPT", nSDictionary, (WOElement)null);
        this._scriptFile = (WOAssociation)this._associations.removeObjectForKey((Object)"scriptFile");
        this._scriptString = (WOAssociation)this._associations.removeObjectForKey((Object)"scriptString");
        this._scriptSource = (WOAssociation)this._associations.removeObjectForKey((Object)"scriptSource");
        this._language = (WOAssociation)this._associations.removeObjectForKey((Object)"language");
        this._hideInComment = (WOAssociation)this._associations.removeObjectForKey((Object)"hideInComment");
        if (this._scriptFile == null && this._scriptString == null && this._scriptSource == null || this._scriptFile != null && this._scriptString != null || this._scriptFile != null && this._scriptSource != null || this._scriptString != null && this._scriptSource != null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> Only one of 'scriptFile' or 'scriptString' or 'scriptSource' attributes can be specified.");
        }
    }

    protected void setLanguage(String string) {
        if (string != null) {
            this._language = WOAssociation.associationWithValue(string);
        }
    }

    protected String language() {
        return this._language != null ? this._language.toString() : null;
    }

    public void appendAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        String string;
        WOComponent wOComponent = wOContext.component();
        Object object = null;
        if (this._language != null) {
            object = this._language.valueInComponent(wOComponent);
        }
        if (object == null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : language binding evaluated to null");
        }
        wOResponse._appendContentAsciiString(" language=");
        wOResponse.appendContentHTMLAttributeValue(object.toString());
        if (this._scriptSource != null && (string = (String)this._scriptSource.valueInComponent(wOComponent)) != null) {
            String string2 = string.toString();
            String string3 = null;
            if (!WOStaticURLUtilities.isRelativeURL(string2)) {
                string3 = string2;
            } else if (!WOStaticURLUtilities.isFragmentURL(string2)) {
                WOComponent wOComponent2 = wOContext.component();
                string3 = wOContext._urlForResourceNamed(string2, null, true);
                if (string3 == null) {
                    string3 = wOComponent2.baseURL() + "/" + string2;
                }
            } else {
                NSLog.err.appendln((Object)("warning: relative fragment URL" + string2));
            }
            if (string3 != null) {
                wOResponse._appendContentAsciiString(" src=\"");
                wOResponse.appendContentString(string3);
                wOResponse.appendContentCharacter('\"');
            }
        }
        super.appendAttributesToResponse(wOResponse, wOContext);
    }

    public void appendChildrenToResponse(WOResponse wOResponse, WOContext wOContext) {
        if (this._scriptSource == null) {
            String string = null;
            boolean bl = false;
            WOComponent wOComponent = wOContext.component();
            if (this._hideInComment != null && this._hideInComment.booleanValueInComponent(wOComponent)) {
                bl = true;
            }
            if (bl) {
                wOResponse._appendContentAsciiString("<!-- Dynamic client side script from WebObjects");
            }
            wOResponse.appendContentCharacter('\n');
            if (this._scriptFile != null) {
                Object object = this._scriptFile.valueInComponent(wOComponent);
                if (object != null) {
                    String string2 = object.toString();
                    URL uRL = WOApplication.application().resourceManager().pathURLForResourceNamed(string2, null, wOContext._languages());
                    if (uRL == null) {
                        uRL = wOContext.component()._componentDefinition().pathURLForResourceNamed(string2, null, wOContext._languages());
                    }
                    if (uRL == null) {
                        throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : cannot find script file '" + string2 + "'");
                    }
                    string = _NSStringUtilities.stringFromPathURL((URL)uRL);
                }
                if (string == null) {
                    throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : script string is null");
                }
            } else if (this._scriptString != null) {
                Object object = this._scriptString.valueInComponent(wOComponent);
                if (object != null) {
                    string = object.toString();
                }
                if (string == null) {
                    throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> : script string is null");
                }
            }
            wOResponse.appendContentString(string);
            wOResponse.appendContentCharacter('\n');
            if (bl) {
                wOResponse._appendContentAsciiString("//-->");
                wOResponse.appendContentCharacter('\n');
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" scriptFile=" + this._scriptFile);
        stringBuffer.append(" scriptString=" + this._scriptString);
        stringBuffer.append(" scriptSource=" + this._scriptSource);
        stringBuffer.append(" hideInComment=" + this._hideInComment);
        stringBuffer.append(" language=" + this._language);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

